/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.version.token;

import com.metaeffekt.artifact.analysis.version.VersionModifier;
import com.metaeffekt.artifact.analysis.version.token.VersionToken;
import com.metaeffekt.artifact.analysis.version.token.VersionTokenType;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class VersionTokenizer {
    private static final int TOKENIZER_STATE_NONE = 0;
    private static final int TOKENIZER_STATE_NUMBER = 1;
    private static final int TOKENIZER_STATE_LETTER = 2;
    private static final Pattern GIT_HASH_PATTERN = Pattern.compile("[-_ ](?=.*[a-fA-F])(?=.*[0-9])[a-fA-F0-9]{7,40}$");
    private static final char[] VERSION_SEPARATORS = new char[]{'.', '-', '_', ' ', '/', '\\', ':', '+', '~', '(', ')', '[', ']', '{', '}'};

    public static String buildEffectiveVersionString(String version, String update) {
        String effectiveUpdate;
        String effectiveVersion = "*".equals(version) || "-".equals(version) ? null : version;
        String string = effectiveUpdate = "*".equals(update) || "-".equals(update) ? null : update;
        return effectiveVersion != null && effectiveUpdate != null ? effectiveVersion + "_" + effectiveUpdate : (effectiveVersion != null ? effectiveVersion : effectiveUpdate);
    }

    public static List<VersionToken> tokenize(String version, String update) {
        String versionString = VersionTokenizer.buildEffectiveVersionString(version, update);
        return VersionTokenizer.tokenize(versionString);
    }

    public static List<VersionToken> tokenize(String versionString) {
        int i;
        String versionModifiersPreprocessed;
        ArrayList<VersionToken> tokens = new ArrayList<VersionToken>();
        if (versionString == null) {
            return tokens;
        }
        String gitHashRemovedVersionString = VersionTokenizer.containsGitHash(versionString) ? GIT_HASH_PATTERN.matcher(versionString).replaceAll("") : versionString;
        String effectiveVersionString = versionModifiersPreprocessed = gitHashRemovedVersionString.replace("release-candidate", "rc");
        StringBuilder buffer = new StringBuilder();
        int state = 0;
        VersionTokenType currentTokenType = VersionTokenType.OTHER;
        for (int i2 = 0; i2 < effectiveVersionString.length(); ++i2) {
            char currentChar = effectiveVersionString.charAt(i2);
            char previousChar = i2 > 0 ? (char)effectiveVersionString.charAt(i2 - 1) : (char)'\uffff';
            char nextChar = i2 + 1 < effectiveVersionString.length() ? (char)effectiveVersionString.charAt(i2 + 1) : (char)'\uffff';
            int bufferLength = buffer.length();
            if (VersionTokenizer.tokenizerIsValidNumberCharacterForSemVer(bufferLength, state, bufferLength > 0 && buffer.charAt(bufferLength - 1) == '.', currentChar) || currentChar == '.' && VersionTokenizer.tokenizerIsValidNumberCharacterForSemVer(bufferLength, state, true, previousChar) && VersionTokenizer.tokenizerIsValidNumberCharacterForSemVer(bufferLength, state, true, nextChar)) {
                if (state == 1) {
                    buffer.append(currentChar);
                } else {
                    VersionTokenizer.appendBufferToTokens(buffer, currentTokenType, tokens);
                    buffer.append(currentChar);
                    state = 1;
                }
                currentTokenType = VersionTokenType.NUMBER_OR_SEMVER;
                continue;
            }
            if (Character.isLetter(currentChar)) {
                if (state == 2) {
                    buffer.append(currentChar);
                } else {
                    VersionTokenizer.appendBufferToTokens(buffer, currentTokenType, tokens);
                    buffer.append(currentChar);
                    state = 2;
                }
                currentTokenType = VersionTokenType.STRING;
                continue;
            }
            VersionTokenizer.appendBufferToTokens(buffer, currentTokenType, tokens);
            buffer.append(currentChar);
            state = 0;
            currentTokenType = VersionTokenizer.tokenizerIsSeparator(currentChar) ? VersionTokenType.SEPARATOR : VersionTokenType.OTHER;
        }
        VersionTokenizer.appendBufferToTokens(buffer, currentTokenType, tokens);
        ArrayList<VersionToken> effectiveTokens = new ArrayList<VersionToken>();
        for (i = 0; i < tokens.size(); ++i) {
            String tokenValue;
            VersionToken token = (VersionToken)tokens.get(i);
            if (token.getType() == VersionTokenType.STRING) {
                VersionModifier versionModifier;
                VersionToken latestEffectiveToken;
                tokenValue = token.getValue();
                String lowercaseTokenValue = tokenValue.toLowerCase();
                VersionToken nextToken = i + 1 < tokens.size() ? (VersionToken)tokens.get(i + 1) : null;
                VersionToken nextNonSeparatorToken = VersionTokenizer.findNextNonSeparatorToken(tokens, i);
                VersionToken versionToken = latestEffectiveToken = effectiveTokens.isEmpty() ? null : (VersionToken)effectiveTokens.get(effectiveTokens.size() - 1);
                if (lowercaseTokenValue.equals("r") || lowercaseTokenValue.equals("u") || lowercaseTokenValue.equals("t") || lowercaseTokenValue.equals("p") || lowercaseTokenValue.equals("m")) {
                    boolean isNextNumberOrDate;
                    boolean bl = isNextNumberOrDate = nextNonSeparatorToken != null && (nextNonSeparatorToken.getType() == VersionTokenType.NUMBER_OR_SEMVER || nextNonSeparatorToken.getType() == VersionTokenType.DATE);
                    if (isNextNumberOrDate) {
                        tokens.remove(i);
                        if (lowercaseTokenValue.equals("r")) {
                            tokens.add(i, new VersionToken("rev", VersionTokenType.STRING));
                        } else if (lowercaseTokenValue.equals("t")) {
                            tokens.add(i, new VersionToken("trial", VersionTokenType.STRING));
                        } else if (lowercaseTokenValue.equals("p")) {
                            tokens.add(i, new VersionToken("patch", VersionTokenType.STRING));
                        } else if (lowercaseTokenValue.equals("m")) {
                            tokens.add(i, new VersionToken("milestone", VersionTokenType.STRING));
                        } else {
                            tokens.add(i, new VersionToken("update", VersionTokenType.STRING));
                        }
                        --i;
                        continue;
                    }
                }
                if ((versionModifier = VersionModifier.fromStringName(lowercaseTokenValue)) != null) {
                    if (nextNonSeparatorToken != null && nextNonSeparatorToken.getType() == VersionTokenType.NUMBER_OR_SEMVER) {
                        effectiveTokens.add(new VersionToken(versionModifier.getNames()[0], VersionTokenType.VERSION_MODIFIER, nextNonSeparatorToken));
                        tokens.remove(nextNonSeparatorToken);
                        continue;
                    }
                    effectiveTokens.add(new VersionToken(lowercaseTokenValue, VersionTokenType.VERSION_MODIFIER));
                    continue;
                }
                if (lowercaseTokenValue.equals("v") && nextToken != null && nextToken.getType() == VersionTokenType.NUMBER_OR_SEMVER) continue;
                if (latestEffectiveToken != null && latestEffectiveToken.getType() == VersionTokenType.VERSION_MODIFIER) {
                    latestEffectiveToken.addSubToken(token);
                    continue;
                }
            }
            if (token.getType() == VersionTokenType.NUMBER_OR_SEMVER && (tokenValue = token.getValue()).length() >= 8) {
                String datePart = tokenValue.substring(0, 8);
                try {
                    LocalDate.parse(datePart, DateTimeFormatter.BASIC_ISO_DATE);
                    effectiveTokens.add(new VersionToken(tokenValue, VersionTokenType.DATE));
                    continue;
                }
                catch (DateTimeParseException dateTimeParseException) {
                    // empty catch block
                }
            }
            if (token.getType() == VersionTokenType.SEPARATOR) continue;
            effectiveTokens.add(token);
        }
        for (i = effectiveTokens.size() - 1; i >= 0; --i) {
            VersionToken previousToken;
            VersionToken token = (VersionToken)effectiveTokens.get(i);
            VersionToken versionToken = previousToken = i > 0 ? (VersionToken)effectiveTokens.get(i - 1) : null;
            if (token.getType() != VersionTokenType.VERSION_MODIFIER || previousToken == null || previousToken.getType() != VersionTokenType.VERSION_MODIFIER) continue;
            previousToken.addSubToken(token);
            effectiveTokens.remove(i);
        }
        return effectiveTokens;
    }

    private static boolean containsGitHash(String version) {
        return GIT_HASH_PATTERN.matcher(version).find();
    }

    private static VersionToken findNextNonSeparatorToken(List<VersionToken> tokens, int startIndex) {
        for (int i = startIndex + 1; i < tokens.size(); ++i) {
            VersionToken token = tokens.get(i);
            if (token.getType() == VersionTokenType.SEPARATOR) continue;
            return token;
        }
        return null;
    }

    private static boolean tokenizerIsSeparator(char currentChar) {
        for (char separator : VERSION_SEPARATORS) {
            if (currentChar != separator) continue;
            return true;
        }
        return false;
    }

    private static boolean tokenizerIsValidNumberCharacterForSemVer(int bufferLength, int state, boolean allowXtoMatch, char character) {
        return Character.isDigit(character) || bufferLength > 0 && state == 1 && allowXtoMatch && character == 'x';
    }

    private static void appendBufferToTokens(StringBuilder buffer, VersionTokenType type, List<VersionToken> tokens) {
        String trimmedBuffer = buffer.toString().trim();
        if (!trimmedBuffer.isEmpty()) {
            tokens.add(new VersionToken(trimmedBuffer, type));
            buffer.setLength(0);
        }
    }
}

