/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.artifact.enrichment.other.timeline.VulnerabilityTimeline;
import com.metaeffekt.mirror.contents.vulnerability.VulnerableSoftwareVersionRangeCpe;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.CpeParser;
import us.springett.parsers.cpe.exceptions.CpeEncodingException;
import us.springett.parsers.cpe.exceptions.CpeParsingException;
import us.springett.parsers.cpe.exceptions.CpeValidationException;
import us.springett.parsers.cpe.values.Part;

public class CommonEnumerationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CommonEnumerationUtil.class);
    private static final Map<String, Cpe> CORRECTION_CPE_MAP = new HashMap<String, Cpe>();
    private static final Function<String, String> DISTINCT_AND_SORTED_WITH_WILDCARDS_MAPPER = old -> CommonEnumerationUtil.toCpe22UriOrFallbackToCpe23FS(CommonEnumerationUtil.distinctAndSortedWithWildcards(CommonEnumerationUtil.parseCpes(old)));
    private static final String[] ESCAPE_CPE_22_CHARS = new String[]{"_", "\\+", "\\.", "/", "-"};

    public static String reduceCPEUri(String uri) {
        int colonIndex1 = uri.indexOf(":");
        if (colonIndex1 == -1) {
            return uri;
        }
        int colonIndex2 = uri.substring(colonIndex1 + 1).indexOf(":");
        if (colonIndex2 == -1) {
            return uri;
        }
        int colonIndex3 = uri.substring(colonIndex1 + colonIndex2 + 2).indexOf(":");
        if (colonIndex3 == -1) {
            return uri;
        }
        int colonIndex4 = uri.substring(colonIndex1 + colonIndex2 + colonIndex3 + 3).indexOf(":");
        if (colonIndex4 == -1) {
            return uri;
        }
        return uri.substring(0, colonIndex1 + colonIndex2 + colonIndex3 + colonIndex4 + 3);
    }

    public static List<Cpe> reduceCpeUrisToCommonParts(String ... uris) throws CpeValidationException {
        if (uris == null) {
            return Collections.emptyList();
        }
        List cpeUris = Arrays.stream(uris).map(CommonEnumerationUtil::parseCpe).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        ArrayList<Cpe> commonCpeUris = new ArrayList<Cpe>();
        for (Cpe uri : cpeUris) {
            boolean found = false;
            for (Cpe knownCpe : commonCpeUris) {
                if (!CommonEnumerationUtil.compareCpePartWithoutWildcards(uri.getPart().getAbbreviation(), knownCpe.getPart().getAbbreviation()) || !CommonEnumerationUtil.compareCpePartWithoutWildcards(uri.getVendor(), knownCpe.getVendor()) || !CommonEnumerationUtil.compareCpePartWithoutWildcards(uri.getProduct(), knownCpe.getProduct())) continue;
                CpeBuilder commonCpePartsBuilder = CommonEnumerationUtil.builder().from(knownCpe);
                if (!CommonEnumerationUtil.compareCpePartWithoutWildcards(uri.getVersion(), knownCpe.getVersion())) {
                    commonCpePartsBuilder.version("*");
                }
                if (!CommonEnumerationUtil.compareCpePartWithoutWildcards(uri.getUpdate(), knownCpe.getUpdate())) {
                    commonCpePartsBuilder.update("*");
                }
                if (!CommonEnumerationUtil.compareCpePartWithoutWildcards(uri.getEdition(), knownCpe.getEdition())) {
                    commonCpePartsBuilder.edition("*");
                }
                if (!CommonEnumerationUtil.compareCpePartWithoutWildcards(uri.getLanguage(), knownCpe.getLanguage())) {
                    commonCpePartsBuilder.language("*");
                }
                if (!CommonEnumerationUtil.compareCpePartWithoutWildcards(uri.getSwEdition(), knownCpe.getSwEdition())) {
                    commonCpePartsBuilder.swEdition("*");
                }
                if (!CommonEnumerationUtil.compareCpePartWithoutWildcards(uri.getTargetSw(), knownCpe.getTargetSw())) {
                    commonCpePartsBuilder.targetSw("*");
                }
                if (!CommonEnumerationUtil.compareCpePartWithoutWildcards(uri.getTargetHw(), knownCpe.getTargetHw())) {
                    commonCpePartsBuilder.targetHw("*");
                }
                if (!CommonEnumerationUtil.compareCpePartWithoutWildcards(uri.getOther(), knownCpe.getOther())) {
                    commonCpePartsBuilder.other("*");
                }
                commonCpeUris.remove(knownCpe);
                commonCpeUris.add(commonCpePartsBuilder.build());
                found = true;
                break;
            }
            if (found) continue;
            commonCpeUris.add(uri);
        }
        return commonCpeUris;
    }

    public static void distinctAndSortedWithWildcards(Inventory inventory) {
        inventory.getArtifacts().forEach(CommonEnumerationUtil::distinctAndSortedWithWildcards);
        inventory.getVulnerabilityMetaData().forEach(CommonEnumerationUtil::distinctAndSortedWithWildcards);
    }

    public static void distinctAndSortedWithWildcards(Artifact artifact) {
        CommonEnumerationUtil.transformAbstractModelBaseAttribute((AbstractModelBase)artifact, InventoryAttribute.INITIAL_CPE_URIS.getKey(), DISTINCT_AND_SORTED_WITH_WILDCARDS_MAPPER);
        CommonEnumerationUtil.transformAbstractModelBaseAttribute((AbstractModelBase)artifact, InventoryAttribute.ADDITIONAL_CPE.getKey(), DISTINCT_AND_SORTED_WITH_WILDCARDS_MAPPER);
        CommonEnumerationUtil.transformAbstractModelBaseAttribute((AbstractModelBase)artifact, InventoryAttribute.INAPPLICABLE_CPE.getKey(), DISTINCT_AND_SORTED_WITH_WILDCARDS_MAPPER);
        CommonEnumerationUtil.transformAbstractModelBaseAttribute((AbstractModelBase)artifact, InventoryAttribute.DERIVED_CPE_URIS.getKey(), DISTINCT_AND_SORTED_WITH_WILDCARDS_MAPPER);
    }

    public static void distinctAndSortedWithWildcards(VulnerabilityMetaData vmd) {
        CommonEnumerationUtil.transformAbstractModelBaseAttribute((AbstractModelBase)vmd, VulnerabilityMetaData.Attribute.PRODUCT_URIS.getKey(), DISTINCT_AND_SORTED_WITH_WILDCARDS_MAPPER);
    }

    private static void transformAbstractModelBaseAttribute(AbstractModelBase element, String attributeKey, Function<String, String> transformation) {
        if (StringUtils.hasText(element.get(attributeKey))) {
            element.set(attributeKey, transformation.apply(element.get(attributeKey)));
        }
    }

    public static List<Cpe> parseCpe(Collection<String> cpe) {
        return cpe.stream().map(CommonEnumerationUtil::parseCpe).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public static List<Cpe> parseCpe(AbstractModelBase vmd, String attribute) {
        String value = vmd.getComplete(attribute);
        if (value != null) {
            return CommonEnumerationUtil.parseCpe(Arrays.asList(value.split(", ")));
        }
        return Collections.emptyList();
    }

    public static List<Cpe> parseEffectiveCpe(Artifact artifact) {
        List<Cpe> initialCpes = CommonEnumerationUtil.parseCpe((AbstractModelBase)artifact, InventoryAttribute.INITIAL_CPE_URIS.getKey());
        if (initialCpes.size() > 0) {
            return initialCpes;
        }
        List<Cpe> derivedCpes = CommonEnumerationUtil.parseCpe((AbstractModelBase)artifact, InventoryAttribute.DERIVED_CPE_URIS.getKey());
        List<Cpe> additionalCpes = CommonEnumerationUtil.parseCpe((AbstractModelBase)artifact, InventoryAttribute.ADDITIONAL_CPE.getKey());
        List<Cpe> inapplicableCpes = CommonEnumerationUtil.parseCpe((AbstractModelBase)artifact, InventoryAttribute.INAPPLICABLE_CPE.getKey());
        ArrayList<Cpe> resultingCpes = new ArrayList<Cpe>(derivedCpes);
        for (Cpe cpe2 : additionalCpes) {
            CommonEnumerationUtil.addCpeIfExactMatchAbsent(resultingCpes, cpe2);
        }
        for (Cpe remove : inapplicableCpes) {
            resultingCpes.removeIf(cpe -> CommonEnumerationUtil.compareCpeUsingWildcardsOneWay(cpe, remove));
        }
        return CommonEnumerationUtil.distinctAndSortedWithoutWildcards(resultingCpes);
    }

    public static List<Cpe> distinctAndSortedWithoutWildcards(Collection<Cpe> cpe) {
        return cpe.stream().distinct().sorted(Cpe::compareTo).collect(Collectors.toList());
    }

    public static List<Cpe> distinctAndSortedWithWildcards(Collection<Cpe> cpe) {
        ArrayList<Cpe> list = new ArrayList<Cpe>();
        HashSet<Cpe> uniqueValues = new HashSet<Cpe>();
        for (Cpe c : cpe) {
            if (!uniqueValues.add(c) || !list.stream().noneMatch(c2 -> c != c2 && CommonEnumerationUtil.compareCpeUsingWildcards(c, c2))) continue;
            list.add(c);
        }
        list.sort(Cpe::compareTo);
        return list;
    }

    @SafeVarargs
    public static List<Cpe> distinctAndSortedWithWildcards(Collection<Cpe> ... cpe) {
        return CommonEnumerationUtil.distinctAndSortedWithWildcards((Collection<Cpe>)Arrays.stream(cpe).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    public static List<Cpe> parseEffectiveCpe(VulnerabilityMetaData vulnerability) {
        if (vulnerability == null) {
            return Collections.emptyList();
        }
        if (vulnerability.has(InventoryAttribute.ADDITIONAL_CPE.getKey())) {
            LOG.warn("Key '{}' should only be used on artifacts, not on vulnerabilities", (Object)InventoryAttribute.ADDITIONAL_CPE.getKey());
        } else if (vulnerability.has(InventoryAttribute.INAPPLICABLE_CPE.getKey())) {
            LOG.warn("Key '{}' should only be used on artifacts, not on vulnerabilities", (Object)InventoryAttribute.INAPPLICABLE_CPE.getKey());
        } else if (vulnerability.has(InventoryAttribute.INITIAL_CPE_URIS.getKey())) {
            LOG.warn("Key '{}' should only be used on artifacts, not on vulnerabilities", (Object)InventoryAttribute.INITIAL_CPE_URIS.getKey());
        } else if (vulnerability.has(InventoryAttribute.DERIVED_CPE_URIS.getKey())) {
            LOG.warn("Key '{}' should only be used on artifacts, not on vulnerabilities", (Object)InventoryAttribute.DERIVED_CPE_URIS.getKey());
        }
        List<Cpe> cpes = CommonEnumerationUtil.parseCpe((AbstractModelBase)vulnerability, VulnerabilityMetaData.Attribute.PRODUCT_URIS.getKey());
        cpes.sort(Cpe::compareTo);
        return cpes;
    }

    public static void addCpeIfExactMatchAbsent(Collection<Cpe> cpes, Cpe add) {
        if (cpes.stream().noneMatch(c -> CommonEnumerationUtil.compareCpeWithoutWildcards(c, add))) {
            cpes.add(add);
        }
    }

    public static List<Pair<String, String>> getVendorProducts(Collection<Cpe> cpes) {
        return cpes.stream().map(e -> Pair.of((Object)e.getVendor(), (Object)e.getProduct())).distinct().collect(Collectors.toList());
    }

    public static List<Pair<String, String>> getVendorProductsFromVersionRanges(Collection<VulnerableSoftwareVersionRangeCpe> cpes) {
        return cpes.stream().map(e -> Pair.of((Object)e.getCpe().getVendor(), (Object)e.getCpe().getProduct())).distinct().collect(Collectors.toList());
    }

    public static List<Pair<String, String>> getVendorProductsFromTimelines(Collection<VulnerabilityTimeline> timelines) {
        return timelines.stream().map(e -> Pair.of((Object)e.getVendor(), (Object)e.getProduct())).distinct().collect(Collectors.toList());
    }

    public static Optional<Cpe> parseCPESilent(String cpe) {
        return CommonEnumerationUtil.parseCpe(cpe, true);
    }

    public static Optional<Cpe> parseCpe(String cpe) {
        return CommonEnumerationUtil.parseCpe(cpe, false);
    }

    public static List<Cpe> parseCpes(String cpe) {
        if (cpe == null) {
            return new ArrayList<Cpe>();
        }
        return CommonEnumerationUtil.parseCpe(Arrays.stream(cpe.split(", ")).map(String::trim).filter(StringUtils::hasText).collect(Collectors.toList()));
    }

    private static Optional<Cpe> parseCpe(String cpe, boolean silent) {
        if (cpe == null) {
            return Optional.empty();
        }
        String trimmedCpe = cpe.trim();
        try {
            return Optional.ofNullable(CpeParser.parse((String)trimmedCpe));
        }
        catch (CpeParsingException e) {
            Cpe correctCpe;
            try {
                if (trimmedCpe.startsWith("cpe:/")) {
                    String[] parts = trimmedCpe.substring(5).split(":");
                    StringJoiner sb = new StringJoiner(":");
                    for (String part : parts) {
                        if (part.equals("*")) {
                            sb.add("*");
                            continue;
                        }
                        sb.add(URLEncoder.encode(part, "UTF-8"));
                    }
                    String encodedCpe = "cpe:/" + sb;
                    return Optional.ofNullable(CpeParser.parse((String)encodedCpe));
                }
                if (trimmedCpe.startsWith("cpe:2.3")) {
                    return Optional.ofNullable(CpeParser.parse((String)CommonEnumerationUtil.fillCpeComponents(trimmedCpe)));
                }
            }
            catch (UnsupportedEncodingException | CpeParsingException parts) {
                // empty catch block
            }
            if (!silent) {
                LOG.warn("Could not parse CPE [{}], due to {}; checking correction config...", (Object)e.getMessage(), (Object)trimmedCpe);
            }
            if ((correctCpe = CORRECTION_CPE_MAP.get(trimmedCpe)) != null) {
                if (!silent) {
                    LOG.info("Correcting [{}] to [{}] ", (Object)trimmedCpe, (Object)correctCpe);
                }
                return Optional.of(correctCpe);
            }
            return Optional.empty();
        }
    }

    public static String fillCpeComponents(String cpe) {
        String[] parts;
        if (cpe.startsWith("cpe:2.3:")) {
            String[] parts2 = cpe.substring(8).split("(?<!\\\\):");
            if (parts2.length < 11) {
                StringJoiner sb = new StringJoiner(":");
                for (String part : parts2) {
                    sb.add(part);
                }
                for (int i = parts2.length; i <= 10; ++i) {
                    sb.add("*");
                }
                return "cpe:2.3:" + sb;
            }
        } else if (cpe.startsWith("cpe:/") && (parts = cpe.substring(5).split("(?<!\\\\):")).length < 7) {
            StringJoiner sb = new StringJoiner(":");
            for (String part : parts) {
                sb.add(part);
            }
            for (int i = parts.length; i < 7; ++i) {
                sb.add("*");
            }
            return "cpe:/" + sb;
        }
        return cpe;
    }

    public static boolean compareCpeWithoutWildcards(Cpe cpe1, Cpe cpe2) {
        if (cpe1 == null && cpe2 == null) {
            return true;
        }
        if (cpe1 == null || cpe2 == null) {
            return false;
        }
        return Objects.equals(String.valueOf(cpe1.getPart()), String.valueOf(cpe2.getPart())) && Objects.equals(cpe1.getVendor(), cpe2.getVendor()) && Objects.equals(cpe1.getProduct(), cpe2.getProduct()) && Objects.equals(cpe1.getVersion(), cpe2.getVersion()) && Objects.equals(cpe1.getUpdate(), cpe2.getUpdate()) && Objects.equals(cpe1.getEdition(), cpe2.getEdition()) && Objects.equals(cpe1.getLanguage(), cpe2.getLanguage()) && Objects.equals(cpe1.getSwEdition(), cpe2.getSwEdition());
    }

    public static boolean compareCpeUsingWildcards(Cpe cpe1, Cpe cpe2) {
        if (cpe1 == null && cpe2 == null) {
            return true;
        }
        if (cpe1 == null || cpe2 == null) {
            return false;
        }
        return CommonEnumerationUtil.compareCpePart(cpe1.getPart() == null ? null : cpe1.getPart().getAbbreviation(), cpe2.getPart() == null ? null : cpe2.getPart().getAbbreviation()) && CommonEnumerationUtil.compareCpePart(cpe1.getVendor(), cpe2.getVendor()) && CommonEnumerationUtil.compareCpePart(cpe1.getProduct(), cpe2.getProduct()) && CommonEnumerationUtil.compareCpePart(cpe1.getVersion(), cpe2.getVersion()) && CommonEnumerationUtil.compareCpePart(cpe1.getUpdate(), cpe2.getUpdate()) && CommonEnumerationUtil.compareCpePart(cpe1.getEdition(), cpe2.getEdition()) && CommonEnumerationUtil.compareCpePart(cpe1.getLanguage(), cpe2.getLanguage()) && CommonEnumerationUtil.compareCpePart(cpe1.getSwEdition(), cpe2.getSwEdition());
    }

    public static boolean compareCpeUsingWildcardsOneWay(Cpe from, Cpe to) {
        if (from == null && to == null) {
            return true;
        }
        if (from == null || to == null) {
            return false;
        }
        return CommonEnumerationUtil.compareCpePartOneWay(from.getPart() == null ? null : from.getPart().getAbbreviation(), to.getPart() == null ? null : to.getPart().getAbbreviation()) && CommonEnumerationUtil.compareCpePartOneWay(from.getVendor(), to.getVendor()) && CommonEnumerationUtil.compareCpePartOneWay(from.getProduct(), to.getProduct()) && CommonEnumerationUtil.compareCpePartOneWay(from.getVersion(), to.getVersion()) && CommonEnumerationUtil.compareCpePartOneWay(from.getUpdate(), to.getUpdate()) && CommonEnumerationUtil.compareCpePartOneWay(from.getEdition(), to.getEdition()) && CommonEnumerationUtil.compareCpePartOneWay(from.getLanguage(), to.getLanguage()) && CommonEnumerationUtil.compareCpePartOneWay(from.getSwEdition(), to.getSwEdition());
    }

    public static boolean compareCpeUsingWildcardsIgnoreVersionUpdate(Cpe cpe1, Cpe cpe2) {
        if (cpe1 == null && cpe2 == null) {
            return true;
        }
        if (cpe1 == null || cpe2 == null) {
            return false;
        }
        return CommonEnumerationUtil.compareCpePart(cpe1.getPart() == null ? null : cpe1.getPart().getAbbreviation(), cpe2.getPart() == null ? null : cpe2.getPart().getAbbreviation()) && CommonEnumerationUtil.compareCpePart(cpe1.getVendor(), cpe2.getVendor()) && CommonEnumerationUtil.compareCpePart(cpe1.getProduct(), cpe2.getProduct()) && CommonEnumerationUtil.compareCpePart(cpe1.getEdition(), cpe2.getEdition()) && CommonEnumerationUtil.compareCpePart(cpe1.getLanguage(), cpe2.getLanguage()) && CommonEnumerationUtil.compareCpePart(cpe1.getSwEdition(), cpe2.getSwEdition());
    }

    private static boolean compareCpePart(String part1, String part2) {
        boolean part1IsEmpty = StringUtils.isEmpty(part1);
        boolean part2IsEmpty = StringUtils.isEmpty(part2);
        if (part1IsEmpty && part2IsEmpty) {
            return true;
        }
        if (part1IsEmpty || part2IsEmpty) {
            return false;
        }
        if (part1.equals("*") || part2.equals("*")) {
            return true;
        }
        return part1.equals(part2);
    }

    private static boolean compareCpePartOneWay(String from, String to) {
        boolean fromIsEmpty = StringUtils.isEmpty(from);
        boolean toIsEmpty = StringUtils.isEmpty(to);
        if (fromIsEmpty && toIsEmpty) {
            return true;
        }
        if (toIsEmpty) {
            return false;
        }
        if (to.equals("*")) {
            return true;
        }
        return from.equals(to);
    }

    private static boolean compareCpePartWithoutWildcards(String part1, String part2) {
        boolean part1IsEmpty = StringUtils.isEmpty(part1);
        boolean part2IsEmpty = StringUtils.isEmpty(part2);
        if (part1IsEmpty && part2IsEmpty) {
            return true;
        }
        if (part1IsEmpty || part2IsEmpty) {
            return false;
        }
        return part1.equals(part2);
    }

    public static String toCpe22UriOrFallbackToCpe23FS(Cpe cpe) {
        if (cpe == null) {
            return null;
        }
        try {
            return cpe.toCpe22Uri();
        }
        catch (CpeEncodingException cpeEncodingException) {
            try {
                Cpe modifiedCpe = CommonEnumerationUtil.builder().part(cpe.getPart()).vendor(CommonEnumerationUtil.encodeValidCpe22Part(cpe.getVendor())).product(CommonEnumerationUtil.encodeValidCpe22Part(cpe.getProduct())).version(CommonEnumerationUtil.encodeValidCpe22Part(cpe.getVersion())).update(CommonEnumerationUtil.encodeValidCpe22Part(cpe.getUpdate())).edition(CommonEnumerationUtil.encodeValidCpe22Part(cpe.getEdition())).language(CommonEnumerationUtil.encodeValidCpe22Part(cpe.getLanguage())).swEdition(CommonEnumerationUtil.encodeValidCpe22Part(cpe.getSwEdition())).targetSw(CommonEnumerationUtil.encodeValidCpe22Part(cpe.getTargetSw())).targetHw(CommonEnumerationUtil.encodeValidCpe22Part(cpe.getTargetHw())).other(CommonEnumerationUtil.encodeValidCpe22Part(cpe.getOther())).build();
                return modifiedCpe.toCpe22Uri();
            }
            catch (UnsupportedEncodingException | CpeEncodingException | CpeValidationException throwable) {
                return cpe.toCpe23FS().replaceAll("(:\\*)+$", "");
            }
        }
    }

    public static String toCpe22UriOrFallbackToCpe23FS(Collection<Cpe> cpes) {
        if (cpes == null || cpes.isEmpty()) {
            return null;
        }
        return cpes.stream().map(CommonEnumerationUtil::toCpe22UriOrFallbackToCpe23FS).collect(Collectors.joining(", "));
    }

    private static String encodeValidCpe22Part(String part) throws UnsupportedEncodingException {
        if (StringUtils.isEmpty(part) || part.equals("*")) {
            return "*";
        }
        for (String character : ESCAPE_CPE_22_CHARS) {
            part = part.replaceAll("(?<!\\\\)" + character, "\\\\" + character);
        }
        return part;
    }

    public static Optional<Cpe> keepOnlyPartVendorProduct(Cpe cpe) {
        try {
            return Optional.of(CommonEnumerationUtil.builder().from(cpe).keepOnlyPartVendorProduct().build());
        }
        catch (CpeValidationException e) {
            LOG.error("Unable to parse CPE [{}] provided by vendor/product: {}", (Object)CommonEnumerationUtil.toCpe22UriOrFallbackToCpe23FS(cpe), (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public static void putCorrectionConfig(Map<String, String> correctionCpeMap) {
        LOG.info("Setting up CPE correction config to {}", correctionCpeMap);
        for (Map.Entry<String, String> entry : correctionCpeMap.entrySet()) {
            try {
                CORRECTION_CPE_MAP.put(entry.getKey(), CpeParser.parse((String)entry.getValue()));
            }
            catch (CpeParsingException e) {
                LOG.error("Failed to set up CPE correction: contains invalid CPE [{}]: {}", (Object)entry.getValue(), (Object)e.getMessage());
                throw new RuntimeException("Failed to set up CPE correction: contains invalid CPE [" + entry.getValue() + "]: " + e.getMessage(), e);
            }
        }
        LOG.info("Finished setting up CPE correction config with [{}] entries", (Object)correctionCpeMap.size());
    }

    public static CpeBuilder builder() {
        return new CpeBuilder();
    }

    public static class CpeBuilder {
        private Part part;
        private String vendor = "*";
        private String product = "*";
        private String version = "*";
        private String update = "*";
        private String edition = "*";
        private String language = "*";
        private String swEdition = "*";
        private String targetSw = "*";
        private String targetHw = "*";
        private String other = "*";

        private CpeBuilder() {
        }

        public CpeBuilder from(Cpe cpe) {
            this.part = cpe.getPart();
            this.vendor = cpe.getVendor();
            this.product = cpe.getProduct();
            this.version = cpe.getVersion();
            this.update = cpe.getUpdate();
            this.edition = cpe.getEdition();
            this.language = cpe.getLanguage();
            this.swEdition = cpe.getSwEdition();
            this.targetSw = cpe.getTargetSw();
            this.targetHw = cpe.getTargetHw();
            this.other = cpe.getOther();
            return this;
        }

        public CpeBuilder from(String cpe) throws CpeValidationException {
            return this.from(CommonEnumerationUtil.parseCpe(cpe).orElseThrow(() -> new CpeValidationException("Failed to parse CPE: " + cpe)));
        }

        public CpeBuilder part(Part part) {
            if (part == null) {
                part = Part.ANY;
            }
            this.part = part;
            return this;
        }

        public CpeBuilder vendor(String vendor) {
            this.vendor = this.transformNullToAny(vendor);
            return this;
        }

        public CpeBuilder product(String product) {
            this.product = this.transformNullToAny(product);
            return this;
        }

        public CpeBuilder version(String version) {
            this.version = this.transformNullToAny(version);
            return this;
        }

        public CpeBuilder update(String update) {
            this.update = this.transformNullToAny(update);
            return this;
        }

        public CpeBuilder edition(String edition) {
            this.edition = this.transformNullToAny(edition);
            return this;
        }

        public CpeBuilder language(String language) {
            this.language = this.transformNullToAny(language);
            return this;
        }

        public CpeBuilder swEdition(String swEdition) {
            this.swEdition = this.transformNullToAny(swEdition);
            return this;
        }

        public CpeBuilder targetSw(String targetSw) {
            this.targetSw = this.transformNullToAny(targetSw);
            return this;
        }

        public CpeBuilder targetHw(String targetHw) {
            this.targetHw = this.transformNullToAny(targetHw);
            return this;
        }

        public CpeBuilder other(String other) {
            this.other = this.transformNullToAny(other);
            return this;
        }

        public CpeBuilder keepOnlyPartVendorProduct() {
            this.version = "*";
            this.update = "*";
            this.edition = "*";
            this.language = "*";
            this.swEdition = "*";
            this.targetSw = "*";
            this.targetHw = "*";
            this.other = "*";
            return this;
        }

        private String transformNullToAny(String s) {
            if (s == null) {
                return "*";
            }
            return s;
        }

        public Cpe build() throws CpeValidationException {
            return new Cpe(this.part, this.vendor, this.product, this.version, this.update, this.edition, this.language, this.swEdition, this.targetSw, this.targetHw, this.other);
        }
    }
}

