/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.correlation.transformation;

import com.metaeffekt.artifact.analysis.vulnerability.correlation.ArtifactCorrelationEntry;
import com.metaeffekt.artifact.analysis.vulnerability.correlation.transformation.TransformationInstruction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactCorrelationEntryTransformer {
    private static final Logger log = LoggerFactory.getLogger(ArtifactCorrelationEntryTransformer.class);
    private final List<TransformationInstruction> instructions = new ArrayList<TransformationInstruction>();
    private boolean verbose = false;

    public ArtifactCorrelationEntryTransformer addInstruction(TransformationInstruction ... instruction) {
        this.instructions.addAll(Arrays.asList(instruction));
        return this;
    }

    public ArtifactCorrelationEntryTransformer addInstructions(Collection<TransformationInstruction> instruction) {
        this.instructions.addAll(instruction);
        return this;
    }

    public void transformInPlace(ArtifactCorrelationEntry entry) {
        if (this.verbose) {
            log.info("Transforming entry: {}", entry.toYamlMap());
        }
        for (TransformationInstruction instruction : this.instructions) {
            this.applyInstruction(entry, instruction);
        }
    }

    private void applyInstruction(ArtifactCorrelationEntry entry, TransformationInstruction instruction) {
        List<Artifact> filterArtifacts;
        if (this.verbose) {
            log.info(" - {}", (Object)instruction);
        }
        if (!(filterArtifacts = instruction.getArtifacts()).isEmpty() && !this.filterMatches(entry, filterArtifacts)) {
            if (this.verbose) {
                log.info("   - Skipping instruction, filter does not match: {}", instruction.getArtifactFilter());
            }
            return;
        }
        if (instruction instanceof TransformationInstruction.RenameOperation) {
            TransformationInstruction.RenameOperation renameInstruction = (TransformationInstruction.RenameOperation)instruction;
            this.renameField(entry, renameInstruction);
        } else if (instruction instanceof TransformationInstruction.SetFieldOperation) {
            TransformationInstruction.SetFieldOperation setFieldInstruction = (TransformationInstruction.SetFieldOperation)instruction;
            this.setField(entry, setFieldInstruction);
        } else if (instruction instanceof TransformationInstruction.RemoveFieldOperation) {
            TransformationInstruction.RemoveFieldOperation removeFieldInstruction = (TransformationInstruction.RemoveFieldOperation)instruction;
            this.removeField(entry, removeFieldInstruction);
        } else if (instruction instanceof TransformationInstruction.ReplaceFieldOperation) {
            TransformationInstruction.ReplaceFieldOperation replaceFieldInstruction = (TransformationInstruction.ReplaceFieldOperation)instruction;
            this.replaceField(entry, replaceFieldInstruction);
        } else {
            throw new IllegalArgumentException("Unknown operation: " + instruction.getClass().getSimpleName());
        }
    }

    private boolean filterMatches(ArtifactCorrelationEntry entry, List<Artifact> filterArtifacts) {
        return filterArtifacts.stream().anyMatch(entry::affects);
    }

    private void renameField(ArtifactCorrelationEntry entry, TransformationInstruction.RenameOperation instruction) {
        PathResolver pathResolver = new PathResolver(instruction.getSelectionPath());
        if (this.verbose) {
            log.info("   - Renaming field: {} -> [{}]", (Object)pathResolver, (Object)instruction.getNewName());
        }
        List<Object> dataSections = pathResolver.resolveBasePath(entry);
        if (this.verbose) {
            log.info("     Data sections ([{}]): {}", (Object)dataSections.size(), dataSections);
        }
        List<Object> fieldValues = pathResolver.accessField(dataSections);
        if (this.verbose) {
            log.info("     Field values ([{}]): {}", (Object)fieldValues.size(), fieldValues);
        }
        if (fieldValues.isEmpty()) {
            if (this.verbose) {
                log.info("     No field values found for renaming");
            }
            return;
        }
        for (Object dataSection : dataSections) {
            if (!(dataSection instanceof Map)) continue;
            Map map = (Map)dataSection;
            if (!map.containsKey(pathResolver.getFieldName())) {
                if (!this.verbose) continue;
                log.info("     Field not found in map, skipping: {}", (Object)pathResolver.getFieldName());
                continue;
            }
            Object value = map.remove(pathResolver.getFieldName());
            map.put(instruction.getNewName(), value);
            if (!this.verbose) continue;
            log.info("     -> Renamed field in map [{}] -> [{}]: {}", new Object[]{pathResolver.getFieldName(), instruction.getNewName(), map});
        }
    }

    private void setField(ArtifactCorrelationEntry entry, TransformationInstruction.SetFieldOperation instruction) {
        PathResolver pathResolver = new PathResolver(instruction.getSelectionPath());
        if (this.verbose) {
            log.info("   - Setting field: {} -> [{}]", (Object)pathResolver, (Object)instruction.getFieldValue());
        }
        List<Object> dataSections = pathResolver.resolveBasePath(entry);
        if (this.verbose) {
            log.info("     Data sections ([{}]): {}", (Object)dataSections.size(), dataSections);
        }
        if (dataSections.isEmpty()) {
            if (!instruction.isAddIfNotPresent()) {
                if (this.verbose) {
                    log.info("     No data sections found for setting field");
                }
                return;
            }
            if (this.verbose) {
                log.info("     No data sections found for setting field, appending own");
            }
            dataSections.add(new HashMap());
        }
        for (Object dataSection : dataSections) {
            if (!(dataSection instanceof Map)) continue;
            Map map = (Map)dataSection;
            if (!map.containsKey(pathResolver.getFieldName()) && !instruction.isAddIfNotPresent()) {
                if (!this.verbose) continue;
                log.info("     Field not found in map, skipping: {}", (Object)pathResolver.getFieldName());
                continue;
            }
            map.put(pathResolver.getFieldName(), instruction.getFieldValue());
            if (!this.verbose) continue;
            log.info("     -> Set field in map [{}]: {}", (Object)pathResolver.getFieldName(), (Object)map);
        }
    }

    private void removeField(ArtifactCorrelationEntry entry, TransformationInstruction.RemoveFieldOperation instruction) {
        PathResolver pathResolver = new PathResolver(instruction.getSelectionPath());
        if (this.verbose) {
            log.info("   - Removing field: {}", (Object)pathResolver);
        }
        List<Object> dataSections = pathResolver.resolveBasePath(entry);
        if (this.verbose) {
            log.info("     Data sections ([{}]): {}", (Object)dataSections.size(), dataSections);
        }
        if (dataSections.isEmpty()) {
            if (this.verbose) {
                log.info("     No data sections found for removing field");
            }
            return;
        }
        for (Object dataSection : dataSections) {
            if (!(dataSection instanceof Map)) continue;
            Map map = (Map)dataSection;
            if (!map.containsKey(pathResolver.getFieldName())) {
                if (!this.verbose) continue;
                log.info("     Field not found in map, skipping: {}", (Object)pathResolver.getFieldName());
                continue;
            }
            map.remove(pathResolver.getFieldName());
            if (!this.verbose) continue;
            log.info("     -> Removed field in map [{}]: {}", (Object)pathResolver.getFieldName(), (Object)map);
        }
    }

    private void replaceField(ArtifactCorrelationEntry entry, TransformationInstruction.ReplaceFieldOperation instruction) {
        PathResolver pathResolver = new PathResolver(instruction.getSelectionPath());
        if (this.verbose) {
            log.info("   - Replacing field: {} -> [{}] -> [{}]", new Object[]{pathResolver, instruction.getPattern(), instruction.getReplacement()});
        }
        List<Object> dataSections = pathResolver.resolveBasePath(entry);
        if (this.verbose) {
            log.info("     Data sections ([{}]): {}", (Object)dataSections.size(), dataSections);
        }
        if (dataSections.isEmpty()) {
            if (this.verbose) {
                log.info("     No data sections found for replacing field");
            }
            return;
        }
        for (Object dataSection : dataSections) {
            if (!(dataSection instanceof Map)) continue;
            Map map = (Map)dataSection;
            if (!map.containsKey(pathResolver.getFieldName())) {
                if (!this.verbose) continue;
                log.info("     Field not found in map, skipping: {}", (Object)pathResolver.getFieldName());
                continue;
            }
            Object value = map.get(pathResolver.getFieldName());
            if (value instanceof String) {
                String strValue = (String)value;
                String replaced = strValue.replaceAll(instruction.getPattern(), instruction.getReplacement());
                map.put(pathResolver.getFieldName(), replaced);
                if (!this.verbose) continue;
                log.info("     -> Replaced field in map [{}]: {}", (Object)pathResolver.getFieldName(), (Object)map);
                continue;
            }
            if (!this.verbose) continue;
            log.info("     Field value is not a string, skipping: {}", value);
        }
    }

    public JSONArray toJson() {
        return new JSONArray((Object)this.instructions.stream().map(TransformationInstruction::toJson).toArray());
    }

    public static ArtifactCorrelationEntryTransformer fromJson(JSONArray json) {
        ArtifactCorrelationEntryTransformer transformer = new ArtifactCorrelationEntryTransformer();
        for (int i = 0; i < json.length(); ++i) {
            transformer.addInstruction(TransformationInstruction.fromJson(json.getJSONObject(i)));
        }
        return transformer;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public static class PathResolver {
        private final String path;
        private final String[] basePath;
        private final String fieldName;
        private final String[] postName;

        public PathResolver(String path) {
            this.path = path;
            String[] tokens = path.split("/");
            ArrayList<String> pathTokens = new ArrayList<String>(Arrays.asList(tokens));
            String lastToken = tokens[tokens.length - 1];
            pathTokens.remove(pathTokens.size() - 1);
            String[] fieldTokens = lastToken.split("\\.");
            String fieldName = fieldTokens[0];
            ArrayList<String> postName = new ArrayList<String>();
            for (int i = 1; i < fieldTokens.length; ++i) {
                postName.add(fieldTokens[i]);
            }
            this.basePath = pathTokens.toArray(new String[0]);
            this.fieldName = fieldName;
            this.postName = postName.toArray(new String[0]);
        }

        public List<Object> accessField(List<Object> dataSections) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object dataSection : dataSections) {
                if (dataSection instanceof Map) {
                    Map map = (Map)dataSection;
                    if (!map.containsKey(this.fieldName)) continue;
                    result.add(map.get(this.fieldName));
                    continue;
                }
                if (!(dataSection instanceof List)) continue;
                List list = (List)dataSection;
                for (Object item : list) {
                    Map map;
                    if (!(item instanceof Map) || !(map = (Map)item).containsKey(this.fieldName)) continue;
                    result.add(map.get(this.fieldName));
                }
            }
            return result;
        }

        public List<Object> resolveBasePath(ArtifactCorrelationEntry entry) {
            String basePath = String.join((CharSequence)"/", this.basePath);
            Object dataSection = this.getDataSection(entry, basePath);
            if (dataSection instanceof List) {
                return (List)dataSection;
            }
            return Collections.singletonList(dataSection);
        }

        private Object getDataSection(ArtifactCorrelationEntry entry, String section) {
            switch (section) {
                case "matcher/affects": {
                    return entry.getMatcher().getAffects();
                }
                case "matcher/ignores": {
                    return entry.getMatcher().getIgnores();
                }
                case "matcher/affectsFn": {
                    return entry.getMatcher().getAffectsFn();
                }
                case "matcher/ignoresFn": {
                    return entry.getMatcher().getIgnoresFn();
                }
                case "apply/append": {
                    return entry.getAppendData();
                }
                case "apply/remove": {
                    return entry.getRemoveData();
                }
                case "apply/overwrite": {
                    return entry.getOverwriteData();
                }
                case "apply/clear": {
                    return entry.getClearData();
                }
            }
            throw new IllegalArgumentException("Unknown section: " + section);
        }

        public String getPath() {
            return this.path;
        }

        public String[] getBasePath() {
            return this.basePath;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String[] getPostName() {
            return this.postName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PathResolver)) {
                return false;
            }
            PathResolver other = (PathResolver)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getBasePath(), other.getBasePath())) {
                return false;
            }
            String this$fieldName = this.getFieldName();
            String other$fieldName = other.getFieldName();
            if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
                return false;
            }
            return Arrays.deepEquals(this.getPostName(), other.getPostName());
        }

        protected boolean canEqual(Object other) {
            return other instanceof PathResolver;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getBasePath());
            String $fieldName = this.getFieldName();
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getPostName());
            return result;
        }

        public String toString() {
            return "ArtifactCorrelationEntryTransformer.PathResolver(path=" + this.getPath() + ", basePath=" + Arrays.deepToString(this.getBasePath()) + ", fieldName=" + this.getFieldName() + ", postName=" + Arrays.deepToString(this.getPostName()) + ")";
        }
    }
}

