/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter;

import com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter.BooleanFilterAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter.CalculationFilterAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter.ComparisonFilterAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter.FunctionCallFilterAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter.RightSideFilterAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter.ValueProviderFilterAttribute;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;

public abstract class FilterAttribute {
    public boolean matches(Vulnerability vulnerability) {
        return this.evaluate(vulnerability).equals(true);
    }

    @Deprecated
    public boolean matches(VulnerabilityMetaData vulnerability) {
        return this.evaluate(vulnerability).equals(true);
    }

    public abstract Object evaluate(Vulnerability var1);

    @Deprecated
    public abstract Object evaluate(VulnerabilityMetaData var1);

    private static List<String> tokenize(String input) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder token = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == ' ') {
                if (token.length() <= 0) continue;
                tokens.add(token.toString());
                token.setLength(0);
                continue;
            }
            if (c == '[' || c == ']') {
                if (token.length() > 0) {
                    tokens.add(token.toString());
                    token.setLength(0);
                }
                tokens.add(String.valueOf(c));
                continue;
            }
            if (c == '\"') {
                char c2;
                if (token.length() > 0) {
                    tokens.add(token.toString());
                    token.setLength(0);
                }
                ++i;
                while (i < input.length() && (c2 = input.charAt(i)) != '\"') {
                    token.append(c2);
                    ++i;
                }
                tokens.add("\"" + token + "\"");
                token.setLength(0);
                continue;
            }
            token.append(c);
        }
        if (token.length() > 0) {
            tokens.add(token.toString());
        }
        return tokens;
    }

    public static FilterAttribute fromString(String input) {
        String normalizedInput = FilterAttribute.normalizeInput(input);
        List<String> tokens = FilterAttribute.tokenize(normalizedInput);
        ArrayList<Object> values = new ArrayList<Object>(tokens);
        return FilterAttribute.fromTokens(values);
    }

    public static FilterAttribute fromTokens(List<Object> tokens) {
        boolean found;
        do {
            int i;
            found = false;
            int start = -1;
            int end = -1;
            int depth = 0;
            for (int i2 = 0; i2 < tokens.size(); ++i2) {
                Object value = tokens.get(i2);
                if (value.equals("[")) {
                    if (depth == 0) {
                        start = i2;
                    }
                    ++depth;
                    continue;
                }
                if (!value.equals("]") || --depth != 0) continue;
                end = i2;
                break;
            }
            if (start == -1 || end == -1) continue;
            ArrayList<Object> nestedValues = new ArrayList<Object>();
            for (i = start + 1; i < end; ++i) {
                nestedValues.add(tokens.get(i));
            }
            for (i = start + 1; i <= end; ++i) {
                if (start + 1 >= tokens.size()) continue;
                tokens.remove(start + 1);
            }
            FilterAttribute nestedFilter = FilterAttribute.fromTokens(nestedValues);
            tokens.set(start, nestedFilter);
            found = true;
        } while (found);
        if (!tokens.isEmpty() && Arrays.stream(FunctionCallFilterAttribute.FUNCTIONS).anyMatch(function -> function.name.equals(tokens.get(0)) && tokens.size() - 1 == function.arity)) {
            return new FunctionCallFilterAttribute(tokens);
        }
        if (tokens.size() == 1) {
            return new ValueProviderFilterAttribute(tokens);
        }
        for (int i = 0; i < tokens.size(); ++i) {
            Object value = tokens.get(i);
            if (value.equals(">") || value.equals(">=") || value.equals("<") || value.equals("<=") || value.equals("==") || value.equals("!=") || value.equals("contains") || value.equals("matches")) {
                return new ComparisonFilterAttribute(tokens);
            }
            if (value.equals("or") || value.equals("and") || value.equals("xor") || value.equals("nand") || value.equals("nor") || value.equals("xnor") || value.equals("implies")) {
                return new BooleanFilterAttribute(tokens);
            }
            if (value.equals("+") || value.equals("-") || value.equals("*") || value.equals("/") || value.equals("%") || value.equals("^")) {
                return new CalculationFilterAttribute(tokens);
            }
            if (!value.equals("not")) continue;
            return new RightSideFilterAttribute(tokens);
        }
        throw new IllegalArgumentException("Could not parse filter attribute: " + tokens + "\nCheck if your keywords are properly named (or, and, contains, ...).");
    }

    private static String normalizeInput(String input) {
        input = input.replace("is not empty", "matches \".+\"");
        input = input.replace("is empty", "matches \"^$\"");
        if (!(input = input.trim()).startsWith("[") && !input.endsWith("]")) {
            input = "[" + input + "]";
        }
        return input;
    }

    protected FilterAttribute getFilterAttributeOrParse(List<Object> tokens) {
        if (tokens.size() == 1 && tokens.get(0) instanceof FilterAttribute) {
            return (FilterAttribute)tokens.get(0);
        }
        return FilterAttribute.fromTokens(tokens);
    }

    protected List<FilterAttribute> getFilterAttributesOrParse(List<Object> tokens) {
        ArrayList<FilterAttribute> filterAttributes = new ArrayList<FilterAttribute>();
        for (int i = 0; i < tokens.size(); ++i) {
            Object token = tokens.get(i);
            if (token instanceof FilterAttribute) {
                filterAttributes.add((FilterAttribute)token);
                continue;
            }
            filterAttributes.add(FilterAttribute.fromTokens(Collections.singletonList(token)));
        }
        return filterAttributes;
    }

    protected double parseDouble(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        throw new IllegalArgumentException("Could not parse double: " + value);
    }

    protected boolean parseBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        throw new IllegalArgumentException("Could not parse boolean: " + value);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

