/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter;

import com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter.FilterAttribute;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import java.util.List;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;

public class RightSideFilterAttribute
extends FilterAttribute {
    private final String operator;
    private final FilterAttribute rightOperand;

    public RightSideFilterAttribute(List<Object> tokens) {
        int operatorIndex = -1;
        for (int i = 0; i < tokens.size(); ++i) {
            if (!(tokens.get(i) instanceof String) || !((String)tokens.get(i)).matches("^(not)$")) continue;
            operatorIndex = i;
            break;
        }
        if (operatorIndex == -1) {
            throw new IllegalArgumentException("No right side operator found in " + tokens);
        }
        this.operator = (String)tokens.get(operatorIndex);
        this.rightOperand = super.getFilterAttributeOrParse(tokens.subList(operatorIndex + 1, tokens.size()));
    }

    @Override
    public Object evaluate(Vulnerability vulnerability) {
        Object rightValue = this.rightOperand.evaluate(vulnerability);
        return this.evaluate(rightValue);
    }

    @Override
    @Deprecated
    public Object evaluate(VulnerabilityMetaData vulnerability) {
        Object rightValue = this.rightOperand.evaluate(vulnerability);
        return this.evaluate(rightValue);
    }

    private Object evaluate(Object right) {
        switch (this.operator) {
            case "not": {
                return !this.parseBoolean(right);
            }
        }
        throw new IllegalArgumentException("Unknown right side operator " + this.operator);
    }

    @Override
    public String toString() {
        return "<" + this.operator + " " + this.rightOperand + ">";
    }
}

