/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter;

import com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter.FilterAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter.FunctionCallFilterAttribute;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;

public class ValueProviderFilterAttribute
extends FilterAttribute {
    private final Object token;

    public ValueProviderFilterAttribute(Object token) {
        this.token = token instanceof List && ((List)token).size() == 1 ? ((List)token).get(0) : token;
    }

    @Override
    public Object evaluate(Vulnerability vulnerability) {
        if (this.token instanceof FilterAttribute) {
            return ((FilterAttribute)this.token).evaluate(vulnerability);
        }
        return this.evaluate();
    }

    @Override
    @Deprecated
    public Object evaluate(VulnerabilityMetaData vulnerability) {
        if (this.token instanceof FilterAttribute) {
            return ((FilterAttribute)this.token).evaluate(vulnerability);
        }
        return this.evaluate();
    }

    private Object evaluate() {
        if (this.token instanceof String) {
            boolean isEnclosedInQuotes;
            String stringToken = (String)this.token;
            boolean bl = isEnclosedInQuotes = stringToken.startsWith("\"") && stringToken.endsWith("\"");
            if (isEnclosedInQuotes) {
                String trimmedToken = stringToken.substring(1, stringToken.length() - 1);
                if (trimmedToken.matches("\\d{4}-\\d{2}-\\d{2}")) {
                    try {
                        return new SimpleDateFormat("yyyy-MM-dd").parse(trimmedToken).getTime();
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (trimmedToken.equals("true")) {
                    return true;
                }
                if (trimmedToken.equals("false")) {
                    return false;
                }
                if (trimmedToken.equals("now")) {
                    return System.currentTimeMillis();
                }
                return trimmedToken;
            }
            if (stringToken.equals("true")) {
                return true;
            }
            if (stringToken.equals("false")) {
                return false;
            }
            if (stringToken.matches("-?\\d+")) {
                return Double.parseDouble(stringToken);
            }
            if (stringToken.matches("-?\\d+\\.\\d+")) {
                return Double.parseDouble(stringToken);
            }
            if (stringToken.matches("\\d{4}-\\d{2}-\\d{2}")) {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd").parse(stringToken).getTime();
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
            if (stringToken.equals("now")) {
                return System.currentTimeMillis();
            }
            if (Arrays.stream(FunctionCallFilterAttribute.FUNCTIONS).anyMatch(fun -> fun.name.equals(stringToken))) {
                return stringToken;
            }
            if (Arrays.asList("and", "or", "xor", "nand", "nor", "xnor", "implies", ">", ">=", "<", "<=", "==", "!=", "contains", "matches", "+", "-", "*", "/", "%", "^", "score", "unmodified", "modified", "overall", "base", "temporal", "environmental", "v2", "v3", "max", "min", "latest", "attribute", "name", "description", "updated", "created", "cwe", "source", "cvss-v3-unmodified", "cvss-v2-unmodified", "cvss-v3-modified", "cvss-v2-modified", "time", "days", "weeks", "months", "years", "minutes", "hours", "providers", "ids", "types").contains(stringToken)) {
                return stringToken;
            }
        } else {
            if (this.token instanceof Number) {
                return this.token;
            }
            if (this.token instanceof Boolean) {
                return this.token;
            }
            if (this.token instanceof List) {
                return this.token;
            }
            if (this.token == null) {
                return null;
            }
        }
        throw new RuntimeException("Unsupported token: " + this.token);
    }

    @Override
    public String toString() {
        try {
            return "<" + this.token.toString() + ">";
        }
        catch (Exception e) {
            return "<exception>";
        }
    }
}

