/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.enrichment.score;

import com.metaeffekt.artifact.analysis.vulnerability.enrichment.keywords.KeywordSet;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.keywords.VulnerabilityKeywords;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatus;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatusHistoryEntry;
import com.metaeffekt.mirror.contents.eol.EolCycle;
import com.metaeffekt.mirror.contents.eol.export.CycleStateExtendedSupportInformationNotPresent;
import com.metaeffekt.mirror.contents.eol.export.CycleStateExtendedSupportInformationPresent;
import com.metaeffekt.mirror.contents.eol.export.CycleStateScenario;
import com.metaeffekt.mirror.contents.eol.export.ExportedCycleState;
import com.metaeffekt.mirror.contents.epss.EpssData;
import com.metaeffekt.mirror.contents.kev.KevData;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.report.configuration.CentralSecurityPolicyConfiguration;
import org.metaeffekt.core.inventory.processor.report.configuration.VulnerabilityPriorityScoreConfiguration;
import org.metaeffekt.core.security.cvss.CvssVector;
import org.metaeffekt.core.security.cvss.processor.CvssSelectionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VulnerabilityPriorityCalculator {
    private static final Logger log = LoggerFactory.getLogger(VulnerabilityPriorityCalculator.class);
    private CvssVector baseCvssVector;
    private EpssData epssData;
    private KevData kevData;
    private List<ExportedCycleState> eolData;
    private VulnerabilityKeywords keywords;
    private VulnerabilityStatusHistoryEntry vulnerabilityStatus;

    public void contribute(CvssVector initialCvss, CvssVector contextCvss) {
        this.baseCvssVector = (CvssVector)ObjectUtils.firstNonNull((Object[])new CvssVector[]{contextCvss, initialCvss});
    }

    public void contribute(CvssVector fixedCvss) {
        this.baseCvssVector = fixedCvss;
    }

    public void contribute(EpssData epssData) {
        this.epssData = epssData;
    }

    public void contribute(KevData kevData) {
        this.kevData = kevData;
    }

    public void contribute(List<ExportedCycleState> eolData) {
        this.eolData = eolData;
    }

    public void contribute(ExportedCycleState eolData) {
        this.eolData = new ArrayList<ExportedCycleState>();
        this.eolData.add(eolData);
    }

    public void contribute(VulnerabilityKeywords keywords) {
        this.keywords = keywords;
    }

    public void contribute(VulnerabilityStatusHistoryEntry vulnerabilityStatus) {
        this.vulnerabilityStatus = vulnerabilityStatus;
    }

    public void contribute(VulnerabilityStatus vulnerabilityStatus) {
        this.vulnerabilityStatus = vulnerabilityStatus.getLatestActiveStatusHistoryEntry();
    }

    public VulnerabilityPriorityCalculator contribute(Vulnerability vulnerability) {
        CvssSelectionResult cvssSelectionResult = vulnerability.getCvssSelectionResult();
        if (cvssSelectionResult != null) {
            this.contribute(cvssSelectionResult.getSelectedInitialCvss(), cvssSelectionResult.getSelectedContextCvss());
        } else {
            log.warn("No CVSS selection result found for vulnerability [{}] when contributing to priority score", (Object)vulnerability.getId());
        }
        this.epssData = vulnerability.getEpssData();
        this.kevData = vulnerability.getKevData();
        this.eolData = vulnerability.getAffectedArtifactsByDefaultKey().stream().map(ExportedCycleState::fromArtifact).filter(Optional::isPresent).map(Optional::get).flatMap(Collection::stream).collect(Collectors.toList());
        List<KeywordSet> keywordSets = vulnerability.parseKeywords();
        this.keywords = new VulnerabilityKeywords();
        this.keywords.addKeywords(keywordSets);
        VulnerabilityStatus vulnerabilityStatus = vulnerability.getOrCreateNewVulnerabilityStatus();
        this.vulnerabilityStatus = vulnerabilityStatus.getLatestActiveStatusHistoryEntry();
        return this;
    }

    public PriorityScoreResult calculatePriorityScore(CentralSecurityPolicyConfiguration securityPolicy) {
        return new PriorityScoreResult(this, securityPolicy);
    }

    public CvssVector getBaseCvssVector() {
        return this.baseCvssVector;
    }

    public EpssData getEpssData() {
        return this.epssData;
    }

    public KevData getKevData() {
        return this.kevData;
    }

    public List<ExportedCycleState> getEolData() {
        return this.eolData;
    }

    public VulnerabilityKeywords getKeywords() {
        return this.keywords;
    }

    public VulnerabilityStatusHistoryEntry getVulnerabilityStatus() {
        return this.vulnerabilityStatus;
    }

    public static class PriorityScoreResult {
        private final VulnerabilityPriorityCalculator calculator;
        private final double resultingScore;
        private final ScoreContributor cvssScore;
        private final ScoreContributor keywordScore;
        private final ScoreContributor epssScore;
        private final ScoreContributor kevScore;
        private final ScoreContributor eolScore;
        private final ScoreContributor vulnerabilityStatusScore;
        private String keywordReasoning;
        private String epssReasoning;
        private String kevReasoning;
        private String eolReasoning;
        private String vulnerabilityStatusReasoning;
        private ExportedCycleState selectedEolData;

        public PriorityScoreResult(VulnerabilityPriorityCalculator calculator, CentralSecurityPolicyConfiguration securityPolicy) {
            this.calculator = calculator;
            this.cvssScore = this.calculateCvssScore(securityPolicy);
            this.keywordScore = this.calculateKeywordScore(securityPolicy);
            this.epssScore = this.calculateEpssScore(securityPolicy);
            this.kevScore = this.calculateKevScore(securityPolicy);
            this.eolScore = this.calculateEolScore(securityPolicy);
            this.vulnerabilityStatusScore = this.calculateVulnerabilityStatusScore(securityPolicy);
            this.resultingScore = this.round(ScoreContributor.apply(0.0, this.cvssScore, this.keywordScore, this.epssScore, this.kevScore, this.eolScore, this.vulnerabilityStatusScore));
        }

        public boolean isElevated() {
            boolean resultingIsZero;
            boolean resultingIsHigherThanBase = this.cvssScore.getScore() < this.resultingScore;
            boolean bl = resultingIsZero = this.resultingScore == 0.0;
            if (resultingIsZero) {
                return false;
            }
            return resultingIsHigherThanBase;
        }

        public JSONObject toJson() {
            return new JSONObject().put("cvssScore", (Object)this.cvssScore.toJson()).put("keywordScore", (Object)this.keywordScore.toJson()).put("epssScore", (Object)this.epssScore.toJson()).put("kevScore", (Object)this.kevScore.toJson()).put("eolScore", (Object)this.eolScore.toJson()).put("resultingScore", Double.isNaN(this.resultingScore) ? 0.0 : this.resultingScore).put("vulnerabilityStatusScore", (Object)this.vulnerabilityStatusScore.toJson()).put("eolReasoning", (Object)this.eolReasoning).put("epssReasoning", (Object)this.epssReasoning).put("kevReasoning", (Object)this.kevReasoning).put("keywordReasoning", (Object)this.keywordReasoning).put("vulnerabilityStatusReasoning", (Object)this.vulnerabilityStatusReasoning);
        }

        public List<String> toPrintTable() {
            ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>();
            rows.add(this.constructMap("Type", "CVSS", "Score", String.valueOf(this.cvssScore)));
            rows.add(this.constructMap("Type", "Keyword", "Score", String.valueOf(this.keywordScore), "Reasoning", this.keywordReasoning));
            rows.add(this.constructMap("Type", "EPSS", "Score", String.valueOf(this.epssScore), "Reasoning", this.epssReasoning));
            rows.add(this.constructMap("Type", "KEV", "Score", String.valueOf(this.kevScore), "Reasoning", this.kevReasoning));
            rows.add(this.constructMap("Type", "EOL", "Score", String.valueOf(this.eolScore), "Reasoning", this.eolReasoning));
            rows.add(this.constructMap("Type", "Vulnerability Status", "Score", String.valueOf(this.vulnerabilityStatusScore), "Reasoning", this.vulnerabilityStatusReasoning));
            rows.add(this.constructMap("Type", "Sum", "Score", String.valueOf(this.resultingScore)));
            return Inventory.mapAttributesToHorizontalTable(rows);
        }

        private Map<String, String> constructMap(String ... keyValues) {
            if (keyValues.length % 2 != 0) {
                throw new IllegalArgumentException("The keyValues array must have an even number of elements.");
            }
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (int i = 0; i < keyValues.length; i += 2) {
                map.put(keyValues[i], keyValues[i + 1]);
            }
            return map;
        }

        private ScoreContributor calculateCvssScore(CentralSecurityPolicyConfiguration securityPolicy) {
            return this.applyOrDefault(this.calculator.getBaseCvssVector(), cvssVector -> ScoreContributor.ContributionMode.ADD.create(cvssVector.getOverallScore()), ScoreContributor.ContributionMode.empty());
        }

        private ScoreContributor calculateKeywordScore(CentralSecurityPolicyConfiguration securityPolicy) {
            return this.applyOrDefault(this.calculator.getKeywords(), keywords -> {
                this.keywordReasoning = keywords.getKeywordSets().stream().filter(set -> set.getScore() != null).map(set -> {
                    String title = (String)ObjectUtils.firstNonNull((Object[])new String[]{set.getName(), set.getCategory(), "untitled"});
                    return set.getScore() + " (" + title + ")";
                }).collect(Collectors.joining(" + "));
                double score = keywords.getKeywordSets().stream().filter(set -> set.getScore() != null).mapToDouble(KeywordSet::getScore).sum();
                return ScoreContributor.ContributionMode.ADD.create(score);
            }, ScoreContributor.ContributionMode.empty());
        }

        private ScoreContributor calculateEpssScore(CentralSecurityPolicyConfiguration securityPolicy) {
            return this.applyOrDefault(this.calculator.getEpssData(), epss -> {
                VulnerabilityPriorityScoreConfiguration.EpssConfiguration epssConfig;
                double p = epss.getEpssScore();
                if (p < (epssConfig = securityPolicy.getPriorityScoreConfiguration().getEpss()).getMin()) {
                    this.epssReasoning = "The EPSS score is below the minimum threshold (" + epssConfig.getMin() + ")";
                    return ScoreContributor.ContributionMode.empty();
                }
                double min = epssConfig.getMin();
                double f = epssConfig.getf();
                double F = epssConfig.getF();
                this.epssReasoning = "The EPSS score " + p + " (with min: " + min + ", f: " + f + ", F: " + F + ") is used in [" + f + " + ((" + p + " - " + min + ") / (1.0 - " + min + ")) * (" + F + " - " + f + ")]";
                return ScoreContributor.ContributionMode.ADD.create(f + (p - min) / (1.0 - min) * (F - f));
            }, ScoreContributor.ContributionMode.empty());
        }

        public static String getEpssFormula() {
            return "f + ((p - min) / (1.0 - min)) * (F - f)";
        }

        private ScoreContributor calculateKevScore(CentralSecurityPolicyConfiguration securityPolicy) {
            return this.applyOrDefault(this.calculator.getKevData(), kev -> {
                VulnerabilityPriorityScoreConfiguration.KevConfiguration kevConfig = securityPolicy.getPriorityScoreConfiguration().getKev();
                this.kevReasoning = "An exploit is known (" + kevConfig.getExploit() + ")" + (kev.getRansomwareState() == KevData.RansomwareState.KNOWN ? " + a ransomware campaign is known (" + kevConfig.getRansomware() + ")" : "");
                double score = kevConfig.getExploit() + (kev.getRansomwareState() == KevData.RansomwareState.KNOWN ? kevConfig.getRansomware() : 0.0);
                return ScoreContributor.ContributionMode.ADD.create(score);
            }, ScoreContributor.ContributionMode.empty());
        }

        private ScoreContributor calculateEolScore(CentralSecurityPolicyConfiguration securityPolicy) {
            return this.applyOrDefault(this.calculator.getEolData(), eolData -> {
                VulnerabilityPriorityScoreConfiguration.EolConfiguration eolConfig = securityPolicy.getPriorityScoreConfiguration().getEol();
                VulnerabilityPriorityScoreConfiguration.EolConfiguration.NoExtendedSupportConfiguration noExtendedSupportConfig = eolConfig.getNoExtendedSupport();
                VulnerabilityPriorityScoreConfiguration.EolConfiguration.ExtendedSupportConfiguration extendedSupportConfig = eolConfig.getExtendedSupport();
                double worseCaseState = -1.7976931348623157E308;
                for (ExportedCycleState eol : eolData) {
                    Enum info;
                    double stateValue = 0.0;
                    String reasoning = "";
                    if (eol.getCycleStateScenario() == CycleStateScenario.EXTENDED_SUPPORT_NOT_PRESENT) {
                        info = eol.getCycleStateExtendedSupportInformationNotPresent();
                        reasoning = reasoning + "Extended support is not available for " + eol.getCycle().getProduct() + " (ver. " + eol.getCycle().getCycle() + "), ";
                        switch (1.$SwitchMap$com$metaeffekt$mirror$contents$eol$export$CycleStateExtendedSupportInformationNotPresent[info.ordinal()]) {
                            case 1: {
                                stateValue = noExtendedSupportConfig.getSupportValid();
                                reasoning = reasoning + "currently support is still valid";
                                break;
                            }
                            case 2: {
                                stateValue = noExtendedSupportConfig.getSupportEndingSoon();
                                reasoning = reasoning + "support is ending soon";
                                break;
                            }
                            case 3: {
                                stateValue = noExtendedSupportConfig.getSupportExpired();
                                reasoning = reasoning + "support has expired";
                            }
                        }
                        reasoning = reasoning + " (rating " + ((CycleStateExtendedSupportInformationNotPresent)info).getRating().getRating() + ")";
                        reasoning = eol.getSupportMillis() > 0L ? reasoning + ", which ends " + EolCycle.formatTimeUntilOrAgo(eol.getSupportMillis()) : reasoning + ", which ended " + EolCycle.formatTimeUntilOrAgo(eol.getSupportMillis());
                    } else {
                        info = eol.getCycleStateExtendedSupportInformationPresent();
                        reasoning = reasoning + "Extended support is available for " + eol.getCycle().getProduct() + " (ver. " + eol.getCycle().getCycle() + "), ";
                        switch (1.$SwitchMap$com$metaeffekt$mirror$contents$eol$export$CycleStateExtendedSupportInformationPresent[info.ordinal()]) {
                            case 1: {
                                stateValue = extendedSupportConfig.getSupportValid();
                                reasoning = reasoning + "currently in regular support (rating " + ((CycleStateExtendedSupportInformationPresent)info).getRating().getRating() + ")";
                                reasoning = reasoning + ", which ends " + EolCycle.formatTimeUntilOrAgo(eol.getSupportMillis());
                                break;
                            }
                            case 2: {
                                stateValue = extendedSupportConfig.getSupportEndingSoon();
                                reasoning = reasoning + "regular support is ending soon (rating " + ((CycleStateExtendedSupportInformationPresent)info).getRating().getRating() + ")";
                                reasoning = reasoning + ", which ends " + EolCycle.formatTimeUntilOrAgo(eol.getSupportMillis());
                                break;
                            }
                            case 3: {
                                stateValue = extendedSupportConfig.getExtendedSupportValid();
                                reasoning = reasoning + "currently in extended support (rating " + ((CycleStateExtendedSupportInformationPresent)info).getRating().getRating() + ")";
                                reasoning = reasoning + ", which ends " + EolCycle.formatTimeUntilOrAgo(eol.getExtendedSupportMillis());
                                break;
                            }
                            case 4: {
                                stateValue = extendedSupportConfig.getExtendedSupportEndingSoon();
                                reasoning = reasoning + "extended support is ending soon (rating " + ((CycleStateExtendedSupportInformationPresent)info).getRating().getRating() + ")";
                                reasoning = reasoning + ", which ends " + EolCycle.formatTimeUntilOrAgo(eol.getExtendedSupportMillis());
                                break;
                            }
                            case 5: {
                                stateValue = extendedSupportConfig.getExtendedSupportExpired();
                                reasoning = reasoning + "extended support has expired (rating " + ((CycleStateExtendedSupportInformationPresent)info).getRating().getRating() + ")";
                                reasoning = reasoning + ", which ended " + EolCycle.formatTimeUntilOrAgo(eol.getExtendedSupportMillis());
                            }
                        }
                    }
                    if (!(stateValue > worseCaseState)) continue;
                    worseCaseState = stateValue;
                    this.eolReasoning = reasoning;
                    this.selectedEolData = eol;
                }
                if (worseCaseState < 0.0) {
                    this.eolReasoning = "No EOL data available";
                    return ScoreContributor.ContributionMode.empty();
                }
                return ScoreContributor.ContributionMode.ADD.create(worseCaseState);
            }, ScoreContributor.ContributionMode.empty());
        }

        private ScoreContributor calculateVulnerabilityStatusScore(CentralSecurityPolicyConfiguration securityPolicy) {
            return this.applyOrDefault(this.calculator.getVulnerabilityStatus(), status -> {
                VulnerabilityPriorityScoreConfiguration.VulnerabilityStatusConfiguration statusConfig = securityPolicy.getPriorityScoreConfiguration().getVulnerabilityStatus();
                String statusName = status.getStatus();
                Double add = statusConfig.getAdd().getValue(statusName);
                Double set = statusConfig.getSet().getValue(statusName);
                if (set != null) {
                    this.vulnerabilityStatusReasoning = "The status is set to " + statusName + " (" + set + ")";
                    return ScoreContributor.ContributionMode.SET.create(this.round(set));
                }
                if (add != null) {
                    this.vulnerabilityStatusReasoning = "The status is " + statusName + " (" + add + ")";
                    return ScoreContributor.ContributionMode.ADD.create(this.round(add));
                }
                this.vulnerabilityStatusReasoning = "The status is " + statusName + " (no score)";
                return ScoreContributor.ContributionMode.ADD.create(0.0);
            }, ScoreContributor.ContributionMode.ADD.create(Double.NaN));
        }

        private <T, R> R applyOrDefault(T value, Function<T, R> function, R defaultValue) {
            Collection collection;
            if (value == null) {
                return defaultValue;
            }
            if (value instanceof Collection && (collection = (Collection)value).isEmpty()) {
                return defaultValue;
            }
            return function.apply(value);
        }

        private double round(double d) {
            return (double)Math.round(d * 10.0) / 10.0;
        }

        private static double toJsonNum(ScoreContributor num) {
            return num.isEmpty() ? 0.0 : num.getScore();
        }

        private static double toJsonNum(Double num) {
            return Double.isNaN(num) ? 0.0 : num;
        }

        private double sumIfNotNan(Double ... values) {
            double sum = 0.0;
            for (Double value : values) {
                if (Double.isNaN(value)) continue;
                sum += value.doubleValue();
            }
            return sum;
        }

        public VulnerabilityPriorityCalculator getCalculator() {
            return this.calculator;
        }

        public double getResultingScore() {
            return this.resultingScore;
        }

        public ScoreContributor getCvssScore() {
            return this.cvssScore;
        }

        public ScoreContributor getKeywordScore() {
            return this.keywordScore;
        }

        public ScoreContributor getEpssScore() {
            return this.epssScore;
        }

        public ScoreContributor getKevScore() {
            return this.kevScore;
        }

        public ScoreContributor getEolScore() {
            return this.eolScore;
        }

        public ScoreContributor getVulnerabilityStatusScore() {
            return this.vulnerabilityStatusScore;
        }

        public String getKeywordReasoning() {
            return this.keywordReasoning;
        }

        public String getEpssReasoning() {
            return this.epssReasoning;
        }

        public String getKevReasoning() {
            return this.kevReasoning;
        }

        public String getEolReasoning() {
            return this.eolReasoning;
        }

        public String getVulnerabilityStatusReasoning() {
            return this.vulnerabilityStatusReasoning;
        }

        public ExportedCycleState getSelectedEolData() {
            return this.selectedEolData;
        }

        public static class ScoreContributor {
            private final Double score;
            private final ContributionMode mode;

            public Double apply(Double score) {
                if (this.score != null && !Double.isNaN(this.score)) {
                    switch (this.mode) {
                        case ADD: {
                            return score + this.score;
                        }
                        case SUBTRACT: {
                            return score - this.score;
                        }
                        case SET: {
                            return this.score;
                        }
                    }
                }
                return score;
            }

            public boolean isEmpty() {
                return Double.isNaN(this.score) || this.score == 0.0;
            }

            public boolean hasEffect() {
                return !this.isEmpty() || this.mode == ContributionMode.SET;
            }

            public JSONObject toJson() {
                return new JSONObject().put("score", PriorityScoreResult.toJsonNum(this.score)).put("mode", (Object)this.mode.name());
            }

            public static ScoreContributor fromJson(JSONObject json) {
                return new ScoreContributor(json.getDouble("score"), ContributionMode.valueOf(json.getString("mode")));
            }

            public static Double apply(double score, ScoreContributor ... contributors) {
                double result = score;
                for (ScoreContributor contributor : contributors) {
                    result = contributor.apply(result);
                }
                return result;
            }

            public String toString() {
                String value = this.isEmpty() ? "0.0" : String.format("%.1f", this.score);
                switch (this.mode) {
                    case ADD: {
                        return value;
                    }
                    case SUBTRACT: {
                        return "-" + value;
                    }
                    case SET: {
                        return "=" + value;
                    }
                }
                return value;
            }

            public ScoreContributor(Double score, ContributionMode mode) {
                this.score = score;
                this.mode = mode;
            }

            public Double getScore() {
                return this.score;
            }

            public ContributionMode getMode() {
                return this.mode;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ScoreContributor)) {
                    return false;
                }
                ScoreContributor other = (ScoreContributor)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Double this$score = this.getScore();
                Double other$score = other.getScore();
                if (this$score == null ? other$score != null : !((Object)this$score).equals(other$score)) {
                    return false;
                }
                ContributionMode this$mode = this.getMode();
                ContributionMode other$mode = other.getMode();
                return !(this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ScoreContributor;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Double $score = this.getScore();
                result = result * 59 + ($score == null ? 43 : ((Object)$score).hashCode());
                ContributionMode $mode = this.getMode();
                result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
                return result;
            }

            public static enum ContributionMode {
                ADD,
                SUBTRACT,
                SET;


                public ScoreContributor create(double score) {
                    return new ScoreContributor(score, this);
                }

                public static ScoreContributor empty() {
                    return new ScoreContributor(Double.NaN, ADD);
                }
            }
        }
    }
}

