/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.SnakeYamlParser;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter.FilterAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatus;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatusHistoryEntry;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatusReviewedEntry;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.validation.VulnerabilityStatusValidation;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;
import org.metaeffekt.core.inventory.processor.report.configuration.CentralSecurityPolicyConfiguration;
import org.metaeffekt.core.security.cvss.CvssVector;
import org.metaeffekt.core.security.cvss.v2.Cvss2;
import org.metaeffekt.core.security.cvss.v3.Cvss3P1;
import org.metaeffekt.core.security.cvss.v4P0.Cvss4P0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class VulnerabilityStatusConverter {
    private static final Logger LOG = LoggerFactory.getLogger(VulnerabilityStatusConverter.class);

    @Deprecated
    public static VulnerabilityStatus fromVulnerabilityMetaData(VulnerabilityMetaData vmd) {
        String statusTitle;
        Matcher matcher;
        String reviewedAdvisoriesString;
        VulnerabilityStatus parsedStatus = new VulnerabilityStatus();
        String statusHistoryString = vmd.get(InventoryAttribute.STATUS_HISTORY.getKey());
        if (statusHistoryString != null && statusHistoryString.startsWith("[")) {
            JSONArray historyJson = new JSONArray(statusHistoryString);
            List<VulnerabilityStatusHistoryEntry> entries = VulnerabilityStatusHistoryEntry.parseEntries(historyJson);
            parsedStatus.addHistoryEntries(entries);
        }
        if (StringUtils.hasText(vmd.get(VulnerabilityMetaData.Attribute.NAME))) {
            parsedStatus.addAffectedVulnerability(vmd.get(VulnerabilityMetaData.Attribute.NAME));
        }
        if ((reviewedAdvisoriesString = vmd.get(InventoryAttribute.REVIEWED_ADVISORIES.getKey())) != null && reviewedAdvisoriesString.startsWith("[")) {
            JSONArray reviewedJson = new JSONArray(reviewedAdvisoriesString);
            List<VulnerabilityStatusReviewedEntry> entries = VulnerabilityStatusReviewedEntry.fromMultipleFormattedStringOrMapEntries(reviewedJson.toList());
            parsedStatus.addReviewedAdvisoryEntries(entries);
        }
        Pattern valueWithOptionalParenthesisPattern = Pattern.compile("^([^(]+)(?: \\(([^)]+)\\))?$");
        String acceptedBy = vmd.get(InventoryAttribute.STATUS_ACCEPTED.getKey());
        String reportedBy = vmd.get(InventoryAttribute.STATUS_REPORTED.getKey());
        if (StringUtils.hasText(acceptedBy) && (matcher = valueWithOptionalParenthesisPattern.matcher(acceptedBy)).matches()) {
            parsedStatus.setAcceptedBy(matcher.group(1));
            parsedStatus.setAcceptedDate(matcher.groupCount() == 2 ? matcher.group(2) : null);
        }
        if (StringUtils.hasText(reportedBy) && (matcher = valueWithOptionalParenthesisPattern.matcher(reportedBy)).matches()) {
            parsedStatus.setReportedBy(matcher.group(1));
            parsedStatus.setReportedDate(matcher.groupCount() == 2 ? matcher.group(2) : null);
        }
        parsedStatus.setTitle(StringUtils.hasText(statusTitle = vmd.get(InventoryAttribute.STATUS_TITLE.getKey())) ? statusTitle : null);
        return parsedStatus;
    }

    public static VulnerabilityStatus fromLegacyFormatFromVulnerabilityMetaData(VulnerabilityMetaData vulnerabilityMetaData) {
        VulnerabilityStatus status = new VulnerabilityStatus();
        status.addAffectedVulnerability(vulnerabilityMetaData.get(VulnerabilityMetaData.Attribute.NAME));
        status.addHistoryEntry(new VulnerabilityStatusHistoryEntry(vulnerabilityMetaData.get(VulnerabilityMetaData.Attribute.STATUS), vulnerabilityMetaData.get(VulnerabilityMetaData.Attribute.RATIONALE), vulnerabilityMetaData.get(VulnerabilityMetaData.Attribute.RISK), vulnerabilityMetaData.get(InventoryAttribute.MEASURES.getKey()), "Reference Inventory", new SimpleDateFormat("yyyy-MM-dd").format(new Date()), 0.0, null, null));
        return status;
    }

    public static Set<VulnerabilityStatus> fromStatusFileOrDirectory(File fileOrDir) {
        return VulnerabilityStatusConverter.fromStatusFileOrDirectory(fileOrDir, CentralSecurityPolicyConfiguration.JSON_SCHEMA_VALIDATION_ERRORS_DEFAULT);
    }

    public static Set<VulnerabilityStatus> fromStatusFileOrDirectory(File fileOrDir, CentralSecurityPolicyConfiguration.JsonSchemaValidationErrorsHandling jsonSchemaValidationErrorsHandling) {
        HashSet<VulnerabilityStatus> parsedStatuses = new HashSet<VulnerabilityStatus>();
        for (File file : VulnerabilityStatusConverter.extractVulnerabilityStatusFilesFromDirectory(fileOrDir)) {
            LOG.debug("Parsing vulnerability status from YAML file {}.", (Object)file.getAbsolutePath());
            try {
                VulnerabilityStatus.assertVulnerabilityStatusFileValid(file, jsonSchemaValidationErrorsHandling);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to parse vulnerability status file from " + file.getAbsolutePath(), e);
            }
            try {
                Object yamlRoot = SnakeYamlParser.parseYaml(SnakeYamlParser.createNoTimestampYaml(), file);
                if (yamlRoot instanceof LinkedHashMap) {
                    LinkedHashMap yamlRootMap = (LinkedHashMap)yamlRoot;
                    VulnerabilityStatus parsedStatus = VulnerabilityStatusConverter.fromYaml(yamlRootMap);
                    parsedStatus.originYamlFile = file;
                    parsedStatuses.add(parsedStatus);
                    continue;
                }
                if (!(yamlRoot instanceof List)) continue;
                List yamlRootList = (List)yamlRoot;
                for (LinkedHashMap yamlRootMap : yamlRootList) {
                    VulnerabilityStatus parsedStatus = VulnerabilityStatusConverter.fromYaml(yamlRootMap);
                    parsedStatus.originYamlFile = file;
                    parsedStatuses.add(parsedStatus);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeException("Failed to read status file " + file.getAbsolutePath(), fileNotFoundException);
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to parse status file, even though validation passed previously from " + file.getAbsolutePath(), exception);
            }
        }
        return parsedStatuses;
    }

    public static Set<File> extractVulnerabilityStatusFilesFromDirectory(File cveStatusDir) {
        HashSet<File> files = new HashSet<File>();
        if (cveStatusDir.exists() && cveStatusDir.isDirectory()) {
            for (File file : FileUtils.listFiles((File)cveStatusDir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)DirectoryFileFilter.DIRECTORY)) {
                if (!file.isFile() || !file.getName().endsWith(".yaml")) continue;
                files.add(file);
            }
        } else if (cveStatusDir.exists() && cveStatusDir.isFile()) {
            files.add(cveStatusDir);
        } else {
            LOG.warn("Status file directory does not exist: [{}]", (Object)cveStatusDir.getAbsolutePath());
        }
        return files;
    }

    public static VulnerabilityStatus fromYaml(LinkedHashMap<String, Object> yamlRoot) {
        Date parsed;
        ArrayList steps;
        VulnerabilityStatus parsedStatus = new VulnerabilityStatus();
        if (VulnerabilityStatusConverter.validateEntryType(yamlRoot, "history", ArrayList.class)) {
            steps = (ArrayList)yamlRoot.get("history");
            for (Object step : steps) {
                if (!(step instanceof LinkedHashMap)) continue;
                VulnerabilityStatusHistoryEntry entry = VulnerabilityStatusHistoryEntry.fromMap((LinkedHashMap)step);
                parsedStatus.addHistoryEntry(entry);
            }
        }
        if (VulnerabilityStatusConverter.validateEntryType(yamlRoot, "reviewed", ArrayList.class)) {
            steps = (ArrayList)yamlRoot.get("reviewed");
            List<VulnerabilityStatusReviewedEntry> reviewedEntries = VulnerabilityStatusReviewedEntry.fromMultipleFormattedStringOrMapEntries(steps);
            parsedStatus.addReviewedAdvisoryEntries(reviewedEntries);
        }
        if (VulnerabilityStatusConverter.validateEntryType(yamlRoot, "affects", LinkedHashMap.class)) {
            LinkedHashMap affectedIds = (LinkedHashMap)yamlRoot.get("affects");
            if (VulnerabilityStatusConverter.validateEntryType(affectedIds, "cve", ArrayList.class)) {
                ((List)affectedIds.get("cve")).forEach(parsedStatus::addAffectedVulnerability);
            }
            if (VulnerabilityStatusConverter.validateEntryType(affectedIds, "cpe", ArrayList.class)) {
                ((List)affectedIds.get("cpe")).forEach(parsedStatus::addAffectedCpe);
            }
            if (VulnerabilityStatusConverter.validateEntryType(affectedIds, "cwe", ArrayList.class)) {
                ((List)affectedIds.get("cwe")).forEach(parsedStatus::addAffectedCwe);
            }
            if (VulnerabilityStatusConverter.validateEntryType(affectedIds, "condition", String.class)) {
                FilterAttribute conditionAttribute = FilterAttribute.fromString(String.valueOf(affectedIds.get("condition")));
                parsedStatus.addAffectedVulnerabilitiesFilter(conditionAttribute);
            }
        }
        if (VulnerabilityStatusConverter.validateEntryType(yamlRoot, "accepted", LinkedHashMap.class)) {
            LinkedHashMap accepted = (LinkedHashMap)yamlRoot.get("accepted");
            if (VulnerabilityStatusConverter.validateEntryType(accepted, "by", String.class)) {
                parsedStatus.setAcceptedBy(accepted.get("by").toString());
            }
            if (VulnerabilityStatusConverter.validateEntryType(accepted, "date", Date.class, String.class)) {
                if (accepted.get("date") instanceof String) {
                    parsed = TimeUtils.tryParse(accepted.get("date").toString());
                    parsedStatus.setAcceptedDate(TimeUtils.formatNormalizedDate(parsed));
                } else {
                    parsedStatus.setAcceptedDate(TimeUtils.formatNormalizedDate((Date)accepted.get("date")));
                }
            }
        }
        if (VulnerabilityStatusConverter.validateEntryType(yamlRoot, "reported", LinkedHashMap.class)) {
            LinkedHashMap reported = (LinkedHashMap)yamlRoot.get("reported");
            if (reported.containsKey("by")) {
                parsedStatus.setReportedBy(reported.get("by").toString());
            }
            if (VulnerabilityStatusConverter.validateEntryType(reported, "date", Date.class, String.class)) {
                if (reported.get("date") instanceof String) {
                    parsed = TimeUtils.tryParse(reported.get("date").toString());
                    parsedStatus.setReportedDate(TimeUtils.formatNormalizedDate(parsed));
                } else {
                    parsedStatus.setReportedDate(TimeUtils.formatNormalizedDate((Date)reported.get("date")));
                }
            }
        }
        if (VulnerabilityStatusConverter.validateEntryType(yamlRoot, "cvssV2", String.class, LinkedHashMap.class)) {
            if (yamlRoot.get("cvssV2") instanceof LinkedHashMap) {
                LinkedHashMap cvssV2Map = (LinkedHashMap)yamlRoot.get("cvssV2");
                if (VulnerabilityStatusConverter.validateEntryType(cvssV2Map, "all", String.class)) {
                    parsedStatus.setCvss2(new Cvss2(cvssV2Map.get("all").toString()));
                }
                if (VulnerabilityStatusConverter.validateEntryType(cvssV2Map, "higher", String.class)) {
                    parsedStatus.setCvss2Higher(new Cvss2(cvssV2Map.get("higher").toString()));
                }
                if (VulnerabilityStatusConverter.validateEntryType(cvssV2Map, "lower", String.class)) {
                    parsedStatus.setCvss2Lower(new Cvss2(cvssV2Map.get("lower").toString()));
                }
            } else {
                parsedStatus.setCvss2(new Cvss2(yamlRoot.get("cvssV2").toString()));
            }
        }
        if (VulnerabilityStatusConverter.validateEntryType(yamlRoot, "cvssV3", String.class, LinkedHashMap.class)) {
            if (yamlRoot.get("cvssV3") instanceof LinkedHashMap) {
                LinkedHashMap cvssV3Map = (LinkedHashMap)yamlRoot.get("cvssV3");
                if (VulnerabilityStatusConverter.validateEntryType(cvssV3Map, "all", String.class)) {
                    parsedStatus.setCvss3P1(new Cvss3P1(cvssV3Map.get("all").toString()));
                }
                if (VulnerabilityStatusConverter.validateEntryType(cvssV3Map, "higher", String.class)) {
                    parsedStatus.setCvss3P1Higher(new Cvss3P1(cvssV3Map.get("higher").toString()));
                }
                if (VulnerabilityStatusConverter.validateEntryType(cvssV3Map, "lower", String.class)) {
                    parsedStatus.setCvss3P1Lower(new Cvss3P1(cvssV3Map.get("lower").toString()));
                }
            } else {
                parsedStatus.setCvss3P1(new Cvss3P1(yamlRoot.get("cvssV3").toString()));
            }
        }
        if (VulnerabilityStatusConverter.validateEntryType(yamlRoot, "cvssV4", String.class, LinkedHashMap.class)) {
            if (yamlRoot.get("cvssV4") instanceof LinkedHashMap) {
                LinkedHashMap cvssV4Map = (LinkedHashMap)yamlRoot.get("cvssV4");
                if (VulnerabilityStatusConverter.validateEntryType(cvssV4Map, "all", String.class)) {
                    parsedStatus.setCvss4(new Cvss4P0(cvssV4Map.get("all").toString()));
                }
                if (VulnerabilityStatusConverter.validateEntryType(cvssV4Map, "higher", String.class)) {
                    parsedStatus.setCvss4Higher(new Cvss4P0(cvssV4Map.get("higher").toString()));
                }
                if (VulnerabilityStatusConverter.validateEntryType(cvssV4Map, "lower", String.class)) {
                    parsedStatus.setCvss4Lower(new Cvss4P0(cvssV4Map.get("lower").toString()));
                }
            } else {
                parsedStatus.setCvss4(new Cvss4P0(yamlRoot.get("cvssV4").toString()));
            }
        }
        if (VulnerabilityStatusConverter.validateEntryType(yamlRoot, "title", String.class)) {
            parsedStatus.setTitle(yamlRoot.get("title").toString());
        }
        if (VulnerabilityStatusConverter.validateEntryType(yamlRoot, "scope", String.class)) {
            parsedStatus.setScope(VulnerabilityStatus.Scope.fromString(yamlRoot.get("scope").toString()));
            for (VulnerabilityStatusHistoryEntry entry : parsedStatus.getStatusHistory()) {
                entry.setScope(parsedStatus.getScope());
            }
        }
        if (VulnerabilityStatusConverter.validateEntryType(yamlRoot, "validation", LinkedHashMap.class)) {
            Map validationMap = (Map)yamlRoot.get("validation");
            parsedStatus.setValidation(VulnerabilityStatusValidation.fromYamlMap(validationMap));
        }
        return parsedStatus;
    }

    private static boolean validateEntryType(Map<String, ?> map, String key, Class<?> ... anyOfType) {
        if (map == null || !map.containsKey(key)) {
            return false;
        }
        boolean noneMatches = Arrays.stream(anyOfType).noneMatch(allowedClass -> map.get(key).getClass().equals(allowedClass));
        if (noneMatches) {
            List expectedType = Arrays.stream(anyOfType).map(Class::getSimpleName).collect(Collectors.toList());
            String effectiveType = map.get(key).getClass().getSimpleName();
            throw new IllegalArgumentException(String.format("Expected %s on element [%s] but got [%s]", expectedType, key, effectiveType));
        }
        return true;
    }

    public static List<VulnerabilityStatus> fromJson(JSONArray json) {
        ArrayList<VulnerabilityStatus> statusList = new ArrayList<VulnerabilityStatus>();
        for (int i = 0; i < json.length(); ++i) {
            JSONObject statusJson = json.getJSONObject(i);
            statusList.add(VulnerabilityStatusConverter.fromJson(statusJson));
        }
        return statusList;
    }

    public static VulnerabilityStatus fromJson(JSONObject json) {
        VulnerabilityStatus status = new VulnerabilityStatus();
        status.appendFromJson(json);
        return status;
    }

    public static void exportYaml(VulnerabilityStatus status, File file) throws IOException {
        LinkedHashMap<String, Object> rootMap = new LinkedHashMap<String, Object>();
        VulnerabilityStatusConverter.exportCvssInformationToYaml(rootMap, (CvssVector)status.getCvss2(), (CvssVector)status.getCvss2Higher(), (CvssVector)status.getCvss2Lower(), "cvssV2");
        VulnerabilityStatusConverter.exportCvssInformationToYaml(rootMap, (CvssVector)status.getCvss3P1(), (CvssVector)status.getCvss3P1Higher(), (CvssVector)status.getCvss3P1Lower(), "cvssV3");
        VulnerabilityStatusConverter.exportCvssInformationToYaml(rootMap, (CvssVector)status.getCvss4(), (CvssVector)status.getCvss4Higher(), (CvssVector)status.getCvss4Lower(), "cvssV4");
        if (status.getTitle() != null) {
            rootMap.put("title", status.getTitle());
        }
        LinkedHashMap<String, ArrayList<String>> affectedIds = new LinkedHashMap<String, ArrayList<String>>();
        if (!status.getAffectedVulnerabilities().isEmpty()) {
            affectedIds.put("cve", new ArrayList<String>(status.getAffectedVulnerabilities()));
        }
        if (!status.getAffectedCpe().isEmpty()) {
            affectedIds.put("cpe", new ArrayList<String>(status.getAffectedCpe()));
        }
        if (!status.getAffectedCwe().isEmpty()) {
            affectedIds.put("cwe", new ArrayList<String>(status.getAffectedCwe()));
        }
        rootMap.put("affects", affectedIds);
        HashSet<String> reviewedEntries = new HashSet<String>();
        for (VulnerabilityStatusReviewedEntry entry : status.getReviewedAdvisories()) {
            reviewedEntries.add(entry.toString());
        }
        if (!reviewedEntries.isEmpty()) {
            rootMap.put("reviewed", reviewedEntries);
        }
        LinkedHashMap<String, String> reportedByMap = new LinkedHashMap<String, String>();
        if (status.getReportedDate() != null) {
            reportedByMap.put("date", status.getReportedDate());
        }
        if (status.getReportedBy() != null) {
            reportedByMap.put("by", status.getReportedBy());
        }
        if (!reportedByMap.isEmpty()) {
            rootMap.put("reported", reportedByMap);
        }
        LinkedHashMap<String, String> acceptedByMap = new LinkedHashMap<String, String>();
        if (status.getAcceptedDate() != null) {
            acceptedByMap.put("date", status.getAcceptedDate());
        }
        if (status.getAcceptedBy() != null) {
            acceptedByMap.put("by", status.getAcceptedBy());
        }
        if (acceptedByMap.size() > 0) {
            rootMap.put("accepted", acceptedByMap);
        }
        if (status.getScope() != null) {
            rootMap.put("scope", (Object)status.getScope());
        }
        ArrayList history = new ArrayList();
        for (VulnerabilityStatusHistoryEntry historyEntry : status.getStatusHistory()) {
            LinkedHashMap<String, Object> historyEntryYaml = new LinkedHashMap<String, Object>();
            if (historyEntry.getStatus() != null) {
                historyEntryYaml.put("status", historyEntry.getStatus());
            }
            if (historyEntry.getAuthor() != null) {
                historyEntryYaml.put("author", historyEntry.getAuthor());
            }
            if (historyEntry.getDate() != null) {
                historyEntryYaml.put("date", historyEntry.getDate());
            }
            if (historyEntry.getRationale() != null) {
                historyEntryYaml.put("rationale", historyEntry.getRationale());
            }
            if (historyEntry.getRisk() != null) {
                historyEntryYaml.put("risk", historyEntry.getRisk());
            }
            if (historyEntry.getScore() != -1.0) {
                historyEntryYaml.put("score", historyEntry.getScore());
            }
            history.add(historyEntryYaml);
        }
        if (history.size() > 0) {
            rootMap.put("history", history);
        }
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        FileWriter writer = new FileWriter(file);
        new Yaml(dumperOptions).dump(rootMap, (Writer)writer);
    }

    private static void exportCvssInformationToYaml(Map<String, Object> rootMap, CvssVector vectorBase, CvssVector vectorHigher, CvssVector vectorLower, String cvssVersion) {
        LinkedHashMap<String, String> cvss2Map = new LinkedHashMap<String, String>();
        if (vectorBase != null) {
            cvss2Map.put("all", vectorBase.toString());
        }
        if (vectorHigher != null) {
            cvss2Map.put("higher", vectorHigher.toString());
        }
        if (vectorLower != null) {
            cvss2Map.put("lower", vectorLower.toString());
        }
        if (!cvss2Map.isEmpty()) {
            rootMap.put(cvssVersion, cvss2Map);
        }
    }
}

