/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.validation;

import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.validation.VulnerabilityStatusValidationEntry;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.validation.VulnerabilityStatusValidationException;
import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;

public class VulnerabilityStatusValidation {
    private final List<VulnerabilityStatusValidationEntry> anyArtifactExists = new ArrayList<VulnerabilityStatusValidationEntry>();
    private final List<VulnerabilityStatusValidationEntry> matchingArtifactExists = new ArrayList<VulnerabilityStatusValidationEntry>();
    private final List<VulnerabilityStatusValidationEntry> anyVulnerabilityExists = new ArrayList<VulnerabilityStatusValidationEntry>();
    private final List<VulnerabilityStatusValidationEntry> matchingVulnerabilityExists = new ArrayList<VulnerabilityStatusValidationEntry>();
    private final List<VulnerabilityStatusValidationEntry> anyArtifactNotExists = new ArrayList<VulnerabilityStatusValidationEntry>();
    private final List<VulnerabilityStatusValidationEntry> matchingArtifactNotExists = new ArrayList<VulnerabilityStatusValidationEntry>();
    private final List<VulnerabilityStatusValidationEntry> anyVulnerabilityNotExists = new ArrayList<VulnerabilityStatusValidationEntry>();
    private final List<VulnerabilityStatusValidationEntry> matchingVulnerabilityNotExists = new ArrayList<VulnerabilityStatusValidationEntry>();

    public void validateInventory(Inventory inventory, String onVulnerability) throws VulnerabilityStatusValidationException {
        boolean matches;
        if (inventory == null) {
            throw new VulnerabilityStatusValidationException("Inventory must not be null.");
        }
        if (onVulnerability == null) {
            throw new VulnerabilityStatusValidationException("Vulnerability must not be null.");
        }
        if (!this.anyArtifactExists.isEmpty()) {
            matches = false;
            for (Artifact artifact : inventory.getArtifacts()) {
                if (!this.matchesAny(this.anyArtifactExists, (AbstractModelBase)artifact)) continue;
                matches = true;
                break;
            }
            if (!matches) {
                throw new VulnerabilityStatusValidationException("Validation failed on [any artifact exists]");
            }
        }
        if (!this.matchingArtifactExists.isEmpty()) {
            matches = false;
            for (Artifact artifact : inventory.getArtifacts()) {
                if (!InventoryEnricher.splitVulnerabilitiesCsv(artifact.getVulnerability()).contains(onVulnerability) || !this.matchesAny(this.matchingArtifactExists, (AbstractModelBase)artifact)) continue;
                matches = true;
                break;
            }
            if (!matches) {
                throw new VulnerabilityStatusValidationException("Validation failed on [matching artifact exists]");
            }
        }
        if (!this.anyVulnerabilityExists.isEmpty()) {
            matches = false;
            for (VulnerabilityMetaData vulnerabilityMetaData : inventory.getVulnerabilityMetaData()) {
                if (!this.matchesAny(this.anyVulnerabilityExists, (AbstractModelBase)vulnerabilityMetaData)) continue;
                matches = true;
                break;
            }
            if (!matches) {
                throw new VulnerabilityStatusValidationException("Validation failed on [any vulnerability exists]");
            }
        }
        if (!this.matchingVulnerabilityExists.isEmpty()) {
            matches = false;
            for (VulnerabilityMetaData vulnerabilityMetaData : inventory.getVulnerabilityMetaData()) {
                if (!onVulnerability.equals(vulnerabilityMetaData.get(VulnerabilityMetaData.Attribute.NAME)) || !this.matchesAny(this.matchingVulnerabilityExists, (AbstractModelBase)vulnerabilityMetaData)) continue;
                matches = true;
                break;
            }
            if (!matches) {
                throw new VulnerabilityStatusValidationException("Validation failed on [matching vulnerability exists]");
            }
        }
        if (!this.anyArtifactNotExists.isEmpty()) {
            matches = false;
            for (Artifact artifact : inventory.getArtifacts()) {
                if (!this.matchesAny(this.anyArtifactNotExists, (AbstractModelBase)artifact)) continue;
                matches = true;
                break;
            }
            if (matches) {
                throw new VulnerabilityStatusValidationException("Validation failed on [any artifact not exists]");
            }
        }
        if (!this.matchingArtifactNotExists.isEmpty()) {
            matches = false;
            for (Artifact artifact : inventory.getArtifacts()) {
                if (!InventoryEnricher.splitVulnerabilitiesCsv(artifact.getVulnerability()).contains(onVulnerability) || !this.matchesAny(this.matchingArtifactNotExists, (AbstractModelBase)artifact)) continue;
                matches = true;
                break;
            }
            if (matches) {
                throw new VulnerabilityStatusValidationException("Validation failed on [matching artifact not exists]");
            }
        }
        if (!this.anyVulnerabilityNotExists.isEmpty()) {
            matches = false;
            for (VulnerabilityMetaData vulnerabilityMetaData : inventory.getVulnerabilityMetaData()) {
                if (!this.matchesAny(this.anyVulnerabilityNotExists, (AbstractModelBase)vulnerabilityMetaData)) continue;
                matches = true;
                break;
            }
            if (matches) {
                throw new VulnerabilityStatusValidationException("Validation failed on [any vulnerability not exists]");
            }
        }
        if (!this.matchingVulnerabilityNotExists.isEmpty()) {
            matches = false;
            for (VulnerabilityMetaData vulnerabilityMetaData : inventory.getVulnerabilityMetaData()) {
                if (!onVulnerability.equals(vulnerabilityMetaData.get(VulnerabilityMetaData.Attribute.NAME)) || !this.matchesAny(this.matchingVulnerabilityNotExists, (AbstractModelBase)vulnerabilityMetaData)) continue;
                matches = true;
                break;
            }
            if (matches) {
                throw new VulnerabilityStatusValidationException("Validation failed on [matching vulnerability not exists]");
            }
        }
    }

    public boolean matchesAny(List<VulnerabilityStatusValidationEntry> validationEntries, AbstractModelBase model) {
        for (VulnerabilityStatusValidationEntry validationEntry : validationEntries) {
            if (validationEntry.validate(model)) continue;
            return false;
        }
        return true;
    }

    public static VulnerabilityStatusValidation fromYamlMap(Map<String, Object> yamlMap) {
        VulnerabilityStatusValidation validation = new VulnerabilityStatusValidation();
        VulnerabilityStatusValidation.createValidationEntries(validation.getAnyArtifactExists(), yamlMap, "any artifact", "exists");
        VulnerabilityStatusValidation.createValidationEntries(validation.getMatchingArtifactExists(), yamlMap, "matching artifact", "exists");
        VulnerabilityStatusValidation.createValidationEntries(validation.getAnyVulnerabilityExists(), yamlMap, "any vulnerability", "exists");
        VulnerabilityStatusValidation.createValidationEntries(validation.getMatchingVulnerabilityExists(), yamlMap, "matching vulnerability", "exists");
        VulnerabilityStatusValidation.createValidationEntries(validation.getAnyArtifactNotExists(), yamlMap, "any artifact", "not exists");
        VulnerabilityStatusValidation.createValidationEntries(validation.getMatchingArtifactNotExists(), yamlMap, "matching artifact", "not exists");
        VulnerabilityStatusValidation.createValidationEntries(validation.getAnyVulnerabilityNotExists(), yamlMap, "any vulnerability", "not exists");
        VulnerabilityStatusValidation.createValidationEntries(validation.getMatchingVulnerabilityNotExists(), yamlMap, "matching vulnerability", "not exists");
        return validation;
    }

    private static void createValidationEntries(List<VulnerabilityStatusValidationEntry> validation, Map<String, Object> yamlMap, String type, String exists) {
        if (yamlMap.containsKey(type) && ((Map)yamlMap.get(type)).containsKey(exists)) {
            validation.addAll(VulnerabilityStatusValidationEntry.fromYamlList((List)((Map)yamlMap.get(type)).get(exists)));
        }
    }

    public String toString() {
        return "VulnerabilityStatusValidation{anyArtifactExists=" + this.anyArtifactExists.size() + ", matchingArtifactExists=" + this.matchingArtifactExists.size() + ", anyVulnerabilityExists=" + this.anyVulnerabilityExists.size() + ", matchingVulnerabilityExists=" + this.matchingVulnerabilityExists.size() + ", anyArtifactNotExists=" + this.anyArtifactNotExists.size() + ", matchingArtifactNotExists=" + this.matchingArtifactNotExists.size() + ", anyVulnerabilityNotExists=" + this.anyVulnerabilityNotExists.size() + ", matchingVulnerabilityNotExists=" + this.matchingVulnerabilityNotExists.size() + '}';
    }

    public List<VulnerabilityStatusValidationEntry> getAnyArtifactExists() {
        return this.anyArtifactExists;
    }

    public List<VulnerabilityStatusValidationEntry> getMatchingArtifactExists() {
        return this.matchingArtifactExists;
    }

    public List<VulnerabilityStatusValidationEntry> getAnyVulnerabilityExists() {
        return this.anyVulnerabilityExists;
    }

    public List<VulnerabilityStatusValidationEntry> getMatchingVulnerabilityExists() {
        return this.matchingVulnerabilityExists;
    }

    public List<VulnerabilityStatusValidationEntry> getAnyArtifactNotExists() {
        return this.anyArtifactNotExists;
    }

    public List<VulnerabilityStatusValidationEntry> getMatchingArtifactNotExists() {
        return this.matchingArtifactNotExists;
    }

    public List<VulnerabilityStatusValidationEntry> getAnyVulnerabilityNotExists() {
        return this.anyVulnerabilityNotExists;
    }

    public List<VulnerabilityStatusValidationEntry> getMatchingVulnerabilityNotExists() {
        return this.matchingVulnerabilityNotExists;
    }
}

