/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.enrichment.warnings;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.warnings.InventoryWarningEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.InventoryInfo;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryWarnings {
    private static final Logger LOG = LoggerFactory.getLogger(InventoryWarnings.class);
    public static final String CORRELATION_WARNINGS_INVENTORY_INFO_ROW_KEY = "correlation-warnings";
    public static final String CORRELATION_WARNINGS_INVENTORY_INFO_COL_WARNINGS_KEY = "Warnings";
    private final Inventory inventory;
    private final InventoryInfo inventoryInfo;
    private final List<String> sourcelessWarnings = new ArrayList<String>();
    private final List<InventoryWarningEntry<Artifact>> artifactWarnings = new ArrayList<InventoryWarningEntry<Artifact>>();
    private final List<InventoryWarningEntry<VulnerabilityMetaData>> vulnerabilityWarnings = new ArrayList<InventoryWarningEntry<VulnerabilityMetaData>>();
    private static final Map<Inventory, InventoryWarnings> CACHE = new WeakHashMap<Inventory, InventoryWarnings>();

    public static InventoryWarnings fromInventory(Inventory inventory) {
        if (CACHE.containsKey(inventory)) {
            return CACHE.get(inventory);
        }
        InventoryWarnings warnings = new InventoryWarnings(inventory);
        CACHE.put(inventory, warnings);
        return warnings;
    }

    public InventoryWarnings(Inventory inventory) {
        if (CACHE.containsKey(inventory)) {
            LOG.warn("InventoryWarnings already initialized on inventory [{}]. Consider using fromInventory(Inventory) instead.", (Object)inventory);
        }
        this.inventory = inventory;
        this.inventoryInfo = inventory.findOrCreateInventoryInfo(CORRELATION_WARNINGS_INVENTORY_INFO_ROW_KEY);
        this.parse();
        this.applyChanges();
    }

    public boolean hasData() {
        return !this.artifactWarnings.isEmpty() || !this.vulnerabilityWarnings.isEmpty() || !this.sourcelessWarnings.isEmpty();
    }

    private void parse() {
        if (StringUtils.isEmpty(this.inventoryInfo.get(CORRELATION_WARNINGS_INVENTORY_INFO_COL_WARNINGS_KEY))) {
            this.applyChanges();
            return;
        }
        try {
            InventoryWarningEntry<Artifact> entry;
            int i;
            JSONObject json = new JSONObject(this.inventoryInfo.get(CORRELATION_WARNINGS_INVENTORY_INFO_COL_WARNINGS_KEY));
            if (json.optJSONArray("artifactWarnings") != null) {
                JSONArray artifactWarnings = json.getJSONArray("artifactWarnings");
                for (i = 0; i < artifactWarnings.length(); ++i) {
                    JSONObject artifactWarning = artifactWarnings.getJSONObject(i);
                    entry = InventoryWarningEntry.fromToJson(artifactWarning, this.inventory, InventoryWarningEntry.ARTIFACT_FINDABLE);
                    this.artifactWarnings.add(entry);
                }
            } else if (json.optJSONObject("artifactWarnings") != null) {
                LOG.warn("Artifact warnings are not an array. You cannot parse the legacy format. Please re-run enrichment pipeline for this inventory.");
            }
            if (json.optJSONArray("vulnerabilityWarnings") != null) {
                JSONArray vulnerabilityWarnings = json.optJSONArray("vulnerabilityWarnings");
                for (i = 0; i < vulnerabilityWarnings.length(); ++i) {
                    JSONObject vulnerabilityWarning = vulnerabilityWarnings.getJSONObject(i);
                    entry = InventoryWarningEntry.fromToJson(vulnerabilityWarning, this.inventory, InventoryWarningEntry.VULNERABILITY_META_DATA_FINDABLE);
                    this.vulnerabilityWarnings.add(entry);
                }
            } else if (json.optJSONObject("vulnerabilityWarnings") != null) {
                LOG.warn("Vulnerability warnings are not an array. You cannot parse the legacy format. Please re-run enrichment pipeline for this inventory.");
            }
            if (json.optJSONArray("sourcelessWarnings") != null) {
                JSONArray sourcelessWarnings = json.getJSONArray("sourcelessWarnings");
                for (i = 0; i < sourcelessWarnings.length(); ++i) {
                    String warning = sourcelessWarnings.getString(i);
                    this.sourcelessWarnings.add(warning);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to parse correlation warnings.", (Throwable)e);
            throw new RuntimeException("Failed to parse correlation warnings from inventory: " + e.getMessage() + "\n" + this.inventoryInfo.get(CORRELATION_WARNINGS_INVENTORY_INFO_COL_WARNINGS_KEY), e);
        }
    }

    private void applyChanges() {
        if (!this.hasData()) {
            this.inventory.getInventoryInfo().remove(this.inventoryInfo);
            this.inventory.getInventoryInfo().removeIf(i -> i.get(InventoryInfo.Attribute.ID).equals(CORRELATION_WARNINGS_INVENTORY_INFO_ROW_KEY));
            return;
        }
        if (!this.inventory.getInventoryInfo().contains(this.inventoryInfo)) {
            this.inventory.getInventoryInfo().add(this.inventoryInfo);
        }
        JSONObject json = new JSONObject();
        JSONArray artifactWarnings = new JSONArray();
        for (InventoryWarningEntry<Artifact> entry : this.artifactWarnings) {
            artifactWarnings.put((Object)entry.toJson());
        }
        json.put("artifactWarnings", (Object)artifactWarnings);
        JSONArray vulnerabilityWarnings = new JSONArray();
        for (InventoryWarningEntry<VulnerabilityMetaData> entry : this.vulnerabilityWarnings) {
            vulnerabilityWarnings.put((Object)entry.toJson());
        }
        json.put("vulnerabilityWarnings", (Object)vulnerabilityWarnings);
        json.put("sourcelessWarnings", this.sourcelessWarnings);
        this.inventoryInfo.set(CORRELATION_WARNINGS_INVENTORY_INFO_COL_WARNINGS_KEY, json.toString());
    }

    public void addSourcelessWarning(String warning) {
        this.sourcelessWarnings.add(warning);
        this.applyChanges();
    }

    public void addArtifactWarning(InventoryWarningEntry<Artifact> warning) {
        this.artifactWarnings.add(warning);
        this.applyChanges();
    }

    public void addVulnerabilityWarning(InventoryWarningEntry<VulnerabilityMetaData> warning) {
        this.vulnerabilityWarnings.add(warning);
        this.applyChanges();
    }

    public List<InventoryWarningEntry<Artifact>> getArtifactWarnings() {
        return this.artifactWarnings;
    }

    public List<InventoryWarningEntry<VulnerabilityMetaData>> getVulnerabilityWarnings() {
        return this.vulnerabilityWarnings;
    }

    public List<String> getSourcelessWarnings() {
        return this.sourcelessWarnings;
    }
}

