/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment;

import com.metaeffekt.artifact.analysis.utils.BuildProperties;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import com.metaeffekt.artifact.enrichment.configurations.VulnerabilityAssessmentDashboardEnrichmentConfiguration;
import com.metaeffekt.artifact.enrichment.other.vad.VulnerabilityAssessmentDashboard;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.configuration.ProcessConfiguration;
import org.metaeffekt.core.inventory.processor.configuration.ProcessMisconfiguration;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.InventoryInfo;
import org.metaeffekt.core.inventory.processor.reader.InventoryReader;
import org.metaeffekt.core.inventory.processor.writer.InventoryWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnricherMetadata(name="Inventory Enrichment Pipeline", phase=InventoryEnrichmentPhase.STANDALONE, intermediateFileSuffix="result", mavenPropertyName="")
public class InventoryEnrichmentPipeline
extends InventoryEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(InventoryEnrichmentPipeline.class);
    private final List<InventoryEnricher> enrichers = new ArrayList<InventoryEnricher>();
    private final File baseMirrorDirectory;
    private File inventorySourceFile;
    private boolean writeIntermediateInventories = true;
    private boolean storeIntermediateStepsInInventoryInfo = true;
    private File intermediateInventoriesDirectory;
    private File inventoryResultFile;
    private Inventory inventory;
    private InventoryEnricher resumeAtEnricher;
    private List<BiConsumer<InventoryEnricher, Inventory>> progressListeners = new ArrayList<BiConsumer<InventoryEnricher, Inventory>>();
    public static final String INVENTORY_INFO_KEY_INVENTORY_ENRICHMENT = "inventory-enrichment";
    public static final String INVENTORY_INFO_KEY_INVENTORY_ENRICHMENT_STEPS = "Steps";
    public static final String INVENTORY_INFO_KEY_ARTIFACT_ANALYSIS_VERSION = "Artifact Analysis Version";
    public static final String INVENTORY_INFO_KEY_VAD_VERSION = "VAD Version";

    public InventoryEnrichmentPipeline(Inventory inventory, File baseMirrorDirectory) {
        this.inventory = inventory;
        this.baseMirrorDirectory = baseMirrorDirectory;
    }

    public InventoryEnrichmentPipeline(File inventorySourceFile, File baseMirrorDirectory) throws IOException {
        this.inventory = new InventoryReader().readInventory(inventorySourceFile);
        this.baseMirrorDirectory = baseMirrorDirectory;
        this.setInventorySourceFile(inventorySourceFile);
    }

    public void setInventorySourceFile(File inventorySourceFile) {
        this.inventorySourceFile = inventorySourceFile;
        if (inventorySourceFile != null) {
            this.intermediateInventoriesDirectory = new File(inventorySourceFile.getParentFile(), "intermediate-inventories");
        }
    }

    public void setWriteIntermediateInventories(boolean writeIntermediateInventories) {
        this.writeIntermediateInventories = writeIntermediateInventories;
    }

    public void setStoreIntermediateStepsInInventoryInfo(boolean storeIntermediateStepsInInventoryInfo) {
        this.storeIntermediateStepsInInventoryInfo = storeIntermediateStepsInInventoryInfo;
    }

    public void setIntermediateInventoriesDirectory(File intermediateInventoriesDirectory) {
        this.intermediateInventoriesDirectory = intermediateInventoriesDirectory;
    }

    public void setInventoryResultFile(File inventoryResultFile) {
        this.inventoryResultFile = inventoryResultFile;
    }

    public void addEnrichment(InventoryEnricher enricher) {
        if (enricher == this) {
            throw new RuntimeException("Cannot add self as enrichment.");
        }
        this.enrichers.add(enricher);
    }

    public <T extends InventoryEnricher> T addEnrichment(Class<T> type) {
        InventoryEnricher enricher = this.constructEnricher(type);
        this.enrichers.add(enricher);
        return (T)enricher;
    }

    public void addProgressListener(BiConsumer<InventoryEnricher, Inventory> progressListener) {
        this.progressListeners.add(progressListener);
    }

    public void removeProgressListener(BiConsumer<InventoryEnricher, Inventory> progressListener) {
        this.progressListeners.remove(progressListener);
    }

    public void clearProgressListeners() {
        this.progressListeners.clear();
    }

    public void resumeAt(String id) {
        if (id == null) {
            throw new RuntimeException("Inventory Enricher ID must not be null");
        }
        if (this.inventorySourceFile == null) {
            throw new RuntimeException("Inventory source file must be set to resume at enricher");
        }
        this.assignEffectiveIdsToEnrichers();
        for (int i = 0; i < this.enrichers.size(); ++i) {
            InventoryEnricher previousEnricher;
            InventoryEnricher enricher = this.enrichers.get(i);
            InventoryEnricher inventoryEnricher = previousEnricher = i > 0 ? this.enrichers.get(i - 1) : null;
            if (previousEnricher == null || !id.equals(enricher.getConfiguration().getId())) continue;
            File file = this.getInventoryFileForEnricher(previousEnricher);
            if (!file.exists()) {
                throw new RuntimeException("Cannot resume at enricher " + id + " as the inventory file " + file.getAbsolutePath() + " does not exist. Make sure that the process has run before with [writeIntermediateInventories = true] and [inventorySourceFile != null].");
            }
            try {
                this.inventory = new InventoryReader().readInventory(file);
            }
            catch (IOException e2) {
                throw new RuntimeException("Failed to read inventory from " + file, e2);
            }
            this.resumeAtEnricher = enricher;
            LOG.info("Resuming at enricher [{}], using inventory from previous step [{}] {}", new Object[]{this.resumeAtEnricher.getConfiguration().getId(), previousEnricher.getConfiguration().getId(), file.getAbsolutePath()});
            return;
        }
        throw new RuntimeException("Specified enrichment step ID [" + id + "] does not exist, pick one of:\n" + this.enrichers.stream().map(e -> e.getConfiguration().getId()).collect(Collectors.joining("\n")));
    }

    public void performEnrichmentIfActive() {
        this.performEnrichmentIfActive(this.inventory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performEnrichment(Inventory inventory) {
        this.assignEffectiveIdsToEnrichers();
        if (super.isSecurityPolicyConfigurationDefined()) {
            for (InventoryEnricher enricher : this.enrichers) {
                if (enricher.isSecurityPolicyConfigurationDefined()) continue;
                enricher.setSecurityPolicyConfiguration(super.getSecurityPolicyConfiguration());
            }
        }
        LOG.info("Enrichment order:");
        for (InventoryEnricher inventoryEnricher : this.enrichers) {
            LOG.info(this.formatEnrichmentListEntry(inventoryEnricher, -1L));
        }
        this.assertCorrectlyConfigured();
        this.logCentralSecurityConfiguration();
        Throwable enrichmentException = null;
        InventoryEnricher failedEnricher = null;
        boolean resumeAtEnricherFound = this.resumeAtEnricher == null;
        LinkedHashMap<InventoryEnricher, Long> enrichmentDurations = new LinkedHashMap<InventoryEnricher, Long>();
        for (InventoryEnricher enricher : this.enrichers) {
            if (!resumeAtEnricherFound) {
                if (enricher != this.resumeAtEnricher) continue;
                resumeAtEnricherFound = true;
            }
            if (this.storeIntermediateStepsInInventoryInfo) {
                this.appendInventoryInfoStep(inventory, enricher);
            }
            long startTime = TimeUtils.utcNow();
            try {
                enricher.performEnrichmentIfActive(inventory);
                this.progressListeners.forEach(l -> l.accept(enricher, inventory));
                if (!this.writeIntermediateInventories || !enricher.shouldWriteIntermediateInventory()) continue;
                this.writeInventoryToFileAsEnricher(enricher);
            }
            catch (Exception e) {
                LOG.error("Failed to enrich inventory on step [{}], see stack trace below for more information.\n{}", (Object)enricher.getEnrichmentName(), (Object)e.getMessage());
                try {
                    if (this.writeIntermediateInventories && enricher.shouldWriteIntermediateInventory()) {
                        this.writeInventoryToFileAsEnricher(enricher);
                    }
                }
                catch (Exception inventoryWriteException) {
                    LOG.error("Failed to write intermediate inventory", (Throwable)e);
                }
                LOG.error(InventoryEnrichmentPipeline.formatLogHeader("FAILED: " + enricher.getEnrichmentName()));
                enrichmentException = new RuntimeException("Failed to enrich inventory on step " + enricher.getEnrichmentName() + "\n" + e.getMessage(), e);
                failedEnricher = enricher;
                break;
            }
            finally {
                enrichmentDurations.put(enricher, TimeUtils.utcNow() - startTime);
            }
        }
        if (enrichmentException == null) {
            LOG.info("All enrichment steps have been applied successfully:");
        } else {
            LOG.info("To resume from failed step, use id [{}]", (Object)failedEnricher.getConfiguration().getId());
        }
        for (InventoryEnricher enricher : this.enrichers) {
            if (enricher == failedEnricher) {
                LOG.info("Failed at:");
            }
            LOG.info(this.formatEnrichmentListEntry(enricher, enrichmentDurations.getOrDefault(enricher, 0L)));
        }
        LOG.info("");
        if (enrichmentException != null) {
            LOG.error("Failed to enrich inventory: {}", (Object)enrichmentException.getMessage(), (Object)enrichmentException);
            throw enrichmentException;
        }
        VulnerabilityContextInventory vInventory = VulnerabilityContextInventory.fromInventory(inventory);
        vInventory.calculateEffectiveCvssVectorsForVulnerabilities(super.getSecurityPolicyConfiguration());
        vInventory.writeBack();
        vInventory.writeAdditionalInformationBack(super.getSecurityPolicyConfiguration());
        if (this.writeIntermediateInventories) {
            this.writeInventoryToFileAsEnricher(this);
        }
        if (this.inventoryResultFile != null) {
            try {
                if (!this.inventoryResultFile.getParentFile().exists()) {
                    this.inventoryResultFile.getParentFile().mkdirs();
                }
                new InventoryWriter().writeInventory(inventory, this.inventoryResultFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write inventory to " + this.inventoryResultFile, e);
            }
        }
        this.logInventoryResultStatistics(inventory);
    }

    private void logCentralSecurityConfiguration() {
        LOG.info("");
        LOG.info(InventoryEnrichmentPipeline.formatLogHeader("Security Policy Configuration"));
        super.getSecurityPolicyConfiguration().logConfiguration();
    }

    private void logInventoryResultStatistics(Inventory inventory) {
        int artifactCount = inventory.getArtifacts().size();
        int vulnerabilityCount = inventory.getVulnerabilityMetaData().size();
        int securityAdvisoriesCount = inventory.getAdvisoryMetaData().size();
        int licenseCount = inventory.getLicenseMetaData().size();
        LOG.info("Pipeline result:");
        if (artifactCount > 0) {
            LOG.info("  Artifacts: {}", (Object)artifactCount);
        }
        if (vulnerabilityCount > 0) {
            LOG.info("  Vulnerabilities: {}", (Object)vulnerabilityCount);
        }
        if (securityAdvisoriesCount > 0) {
            LOG.info("  Security Advisories: {}", (Object)securityAdvisoriesCount);
        }
        if (licenseCount > 0) {
            LOG.info("  Licenses: {}", (Object)licenseCount);
        }
        if (this.inventoryResultFile != null) {
            LOG.info("  Result inventory: file://{}", (Object)this.inventoryResultFile.getAbsolutePath());
        }
        if (this.intermediateInventoriesDirectory != null) {
            LOG.info("  Intermediate inventories: file://{}", (Object)this.intermediateInventoriesDirectory.getAbsolutePath());
        }
        this.enrichers.stream().filter(e -> e instanceof VulnerabilityAssessmentDashboard).map(e -> (VulnerabilityAssessmentDashboard)e).findFirst().map(VulnerabilityAssessmentDashboard::getConfiguration).map(VulnerabilityAssessmentDashboardEnrichmentConfiguration::getOutputDashboardFile).ifPresent(file -> LOG.info("  Vulnerability Assessment Dashboard: file://{}", (Object)file.getAbsolutePath()));
    }

    private void assertCorrectlyConfigured() {
        LinkedHashMap<InventoryEnricher, List<ProcessMisconfiguration>> misconfigurations = new LinkedHashMap<InventoryEnricher, List<ProcessMisconfiguration>>();
        LinkedHashMap<InventoryEnricher, List<ProcessMisconfiguration>> misconfigurationsWarnings = new LinkedHashMap<InventoryEnricher, List<ProcessMisconfiguration>>();
        for (InventoryEnricher inventoryEnricher : this.enrichers) {
            List<ProcessMisconfiguration> misconfiguration = inventoryEnricher.collectMisconfigurations();
            if (misconfiguration.isEmpty()) continue;
            if (inventoryEnricher.getConfiguration().isActive()) {
                misconfigurations.put(inventoryEnricher, misconfiguration);
                continue;
            }
            misconfigurationsWarnings.put(inventoryEnricher, misconfiguration);
        }
        if (!misconfigurationsWarnings.isEmpty()) {
            LOG.info("");
            LOG.warn("Found misconfigurations in inactive enrichers:");
            for (Map.Entry entry : misconfigurationsWarnings.entrySet()) {
                LOG.warn("  Enricher [{}] [{}]:", (Object)((InventoryEnricher)entry.getKey()).getConfiguration().getId(), (Object)((InventoryEnricher)entry.getKey()).getEnrichmentName());
                for (ProcessMisconfiguration misconfiguration : (List)entry.getValue()) {
                    LOG.warn("    - [{}] {}", (Object)misconfiguration.getField(), (Object)misconfiguration.getMessage());
                }
            }
        }
        if (!misconfigurations.isEmpty()) {
            LOG.info("");
            LOG.warn("Found misconfigurations in active enrichers:");
            for (Map.Entry entry : misconfigurations.entrySet()) {
                LOG.warn("  Enricher [{}] [{}]:", (Object)((InventoryEnricher)entry.getKey()).getConfiguration().getId(), (Object)((InventoryEnricher)entry.getKey()).getEnrichmentName());
                for (ProcessMisconfiguration misconfiguration : (List)entry.getValue()) {
                    LOG.error("      - [{}] {}", (Object)misconfiguration.getField(), (Object)misconfiguration.getMessage());
                }
            }
            throw new RuntimeException("Found misconfigurations in " + misconfigurations.size() + " enricher(s), see log for details");
        }
    }

    private void appendInventoryInfoStep(Inventory inventory, InventoryEnricher enricher) {
        InventoryInfo info = inventory.findOrCreateInventoryInfo(INVENTORY_INFO_KEY_INVENTORY_ENRICHMENT);
        JSONArray enrichmentInformation = InventoryEnrichmentPipeline.findExistingOrCreateInventoryInfoStoredSteps(info);
        JSONObject step = new JSONObject().put("name", (Object)enricher.getEnrichmentName()).put("id", (Object)enricher.getConfiguration().getId()).put("active", enricher.getConfiguration().isActive()).put("index", this.getEnricherIndex(enricher)).put("configuration", (Map)enricher.getConfiguration().getProperties()).put("time", TimeUtils.utcNow());
        enrichmentInformation.put((Object)step);
        info.set(INVENTORY_INFO_KEY_INVENTORY_ENRICHMENT_STEPS, enrichmentInformation.toString());
        info.set(INVENTORY_INFO_KEY_ARTIFACT_ANALYSIS_VERSION, BuildProperties.getProjectVersion());
        info.set(INVENTORY_INFO_KEY_VAD_VERSION, BuildProperties.getVulnerabilityAssessmentDashboardVersion());
    }

    private static JSONArray findExistingOrCreateInventoryInfoStoredSteps(InventoryInfo info) {
        if (info.has(INVENTORY_INFO_KEY_INVENTORY_ENRICHMENT_STEPS) && info.get(INVENTORY_INFO_KEY_INVENTORY_ENRICHMENT_STEPS).startsWith("[")) {
            return new JSONArray(info.get(INVENTORY_INFO_KEY_INVENTORY_ENRICHMENT_STEPS));
        }
        return new JSONArray();
    }

    private int getEnricherIndex(InventoryEnricher enricher) {
        return IntStream.range(0, this.enrichers.size()).filter(i -> this.enrichers.get(i) == enricher).findFirst().orElse(-1);
    }

    private String formatEnrichmentListEntry(InventoryEnricher enricher, long duration) {
        boolean hasDuplicateIndex;
        StringBuilder sb = new StringBuilder();
        int digitCount = (int)Math.ceil(Math.log10(this.enrichers.size() + 1));
        sb.append(" ").append(String.format("%" + digitCount + "d", this.getEnricherIndex(enricher) + 1)).append(". ");
        sb.append(this.resumeAtEnricher != null && this.isBefore(this.resumeAtEnricher, enricher) ? "(skipped) " : "");
        if (enricher.getConfiguration() == null) {
            throw new RuntimeException("Missing configuration on " + enricher.getEnrichmentName());
        }
        sb.append(enricher.getConfiguration().isActive() ? "" : "(inactive) ");
        sb.append(enricher.getEnrichmentName());
        String duplicateIndex = enricher.getConfiguration().getId().replaceAll(".+?(\\d+)$", "$1");
        boolean bl = hasDuplicateIndex = StringUtils.hasText(duplicateIndex) && !duplicateIndex.equals(enricher.getConfiguration().getId());
        if (hasDuplicateIndex) {
            sb.append(" (").append(duplicateIndex).append(")");
        } else {
            String initialId = enricher.getConfiguration().buildInitialId();
            if (StringUtils.hasText(initialId) && !initialId.equals(enricher.getConfiguration().getId())) {
                sb.append(" (").append(enricher.getConfiguration().getId()).append(")");
            }
        }
        if (duration >= 0L) {
            if (sb.length() < 59 && sb.length() % 2 == 0) {
                sb.append(" ");
            }
            while (sb.length() < 59) {
                sb.append(" .");
            }
            sb.append(String.format(" [%9s]", TimeUtils.formatTimeDiff(duration)));
        }
        return sb.toString();
    }

    private boolean isBefore(InventoryEnricher pivot, InventoryEnricher checkBefore) {
        return this.getEnricherIndex(pivot) > this.getEnricherIndex(checkBefore);
    }

    private void writeInventoryToFileAsEnricher(InventoryEnricher enricher) {
        if (this.inventorySourceFile != null && this.intermediateInventoriesDirectory != null) {
            boolean isFinalStep = enricher instanceof InventoryEnrichmentPipeline;
            File destinationFile = this.getInventoryFileForEnricher(enricher);
            if (!destinationFile.getParentFile().exists()) {
                destinationFile.getParentFile().mkdirs();
            }
            try {
                new InventoryWriter().writeInventory(this.inventory, destinationFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write " + (isFinalStep ? "resulting" : "intermediate") + " inventory to file: " + destinationFile.getAbsolutePath(), e);
            }
        }
    }

    private File getInventoryFileForEnricher(InventoryEnricher enricher) {
        return new File(this.intermediateInventoriesDirectory, String.format("%s-%s-%s.xls", this.inventorySourceFile.getName().replace(".xls", ""), enricher.getInventoryFileNameSuffix(), enricher.getConfiguration().getId()));
    }

    private Map<String, InventoryEnricher> deriveEffectiveEnrichmentIds() {
        LinkedHashMap<String, Integer> enrichmentIdDuplicateCount = new LinkedHashMap<String, Integer>();
        for (InventoryEnricher enricher : this.enrichers) {
            String id = enricher.getConfiguration().getId();
            enrichmentIdDuplicateCount.compute(id, (k, v) -> v == null ? 1 : v + 1);
        }
        Set duplicates = enrichmentIdDuplicateCount.entrySet().stream().filter(e -> (Integer)e.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
        LinkedHashMap<String, InventoryEnricher> effectiveEnrichmentIds = new LinkedHashMap<String, InventoryEnricher>();
        enrichmentIdDuplicateCount.clear();
        for (InventoryEnricher enricher : this.enrichers) {
            String id = enricher.getConfiguration().getId();
            int occurrenceCount = enrichmentIdDuplicateCount.compute(id, (k, v) -> v == null ? 1 : v + 1);
            String effectiveId = occurrenceCount > 1 || duplicates.contains(id) ? id + "-" + occurrenceCount : id;
            effectiveEnrichmentIds.put(effectiveId, enricher);
        }
        return effectiveEnrichmentIds;
    }

    private void assignEffectiveIdsToEnrichers() {
        for (Map.Entry<String, InventoryEnricher> entry : this.deriveEffectiveEnrichmentIds().entrySet()) {
            entry.getValue().getConfiguration().setId(entry.getKey());
        }
    }

    @Override
    public ProcessConfiguration getConfiguration() {
        return new ProcessConfiguration(){

            public LinkedHashMap<String, Object> getProperties() {
                return new LinkedHashMap<String, Object>();
            }

            public void setProperties(LinkedHashMap<String, Object> properties) {
            }

            protected void collectMisconfigurations(List<ProcessMisconfiguration> misconfigurations) {
            }
        };
    }

    private InventoryEnricher constructEnricher(Class<? extends InventoryEnricher> clazz) {
        return InventoryEnrichmentPipeline.constructEnricher(clazz, this.baseMirrorDirectory);
    }

    public static InventoryEnricher constructEnricher(Class<? extends InventoryEnricher> clazz, File baseMirrorDirectory) {
        try {
            return clazz.getConstructor(File.class).newInstance(baseMirrorDirectory);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException reflectiveOperationException) {
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate enricher class due to constructor failing: " + clazz.getName(), e);
        }
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new RuntimeException("Failed to instantiate enrichment class: " + clazz + ". (File baseMirrorDirectory) or () constructor must exist", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate enrichment class due to constructor failing: " + clazz, e);
        }
    }

    public File getBaseMirrorDirectory() {
        return this.baseMirrorDirectory;
    }

    public File getIntermediateInventoriesDirectory() {
        return this.intermediateInventoriesDirectory;
    }

    public File getInventoryResultFile() {
        return this.inventoryResultFile;
    }

    public File getInventorySourceFile() {
        return this.inventorySourceFile;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public InventoryEnricher getResumeAtEnricher() {
        return this.resumeAtEnricher;
    }

    public List<InventoryEnricher> getEnrichers() {
        return this.enrichers;
    }

    public boolean isStoreIntermediateStepsInInventoryInfo() {
        return this.storeIntermediateStepsInInventoryInfo;
    }

    public boolean isWriteIntermediateInventories() {
        return this.writeIntermediateInventories;
    }
}

