/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.configurations;

import com.metaeffekt.mirror.query.NvdCpeApiVendorProductIndexQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.configuration.ProcessConfiguration;
import org.metaeffekt.core.inventory.processor.configuration.ProcessMisconfiguration;

public class CpeDerivationEnrichmentConfiguration
extends ProcessConfiguration {
    private int maxCorrelatedCpePerArtifact = Integer.MAX_VALUE;
    private List<Map<String, Object>> requireSecondaryIndicationTermsLimiters = new ArrayList<Map>(Collections.singletonList(new NvdCpeApiVendorProductIndexQuery.MinTermsLimiter(60).toJson().toMap()));
    private boolean addDetailedMatchingInformation = false;

    public CpeDerivationEnrichmentConfiguration setMaxCorrelatedCpePerArtifact(int maxCorrelatedCpePerArtifact) {
        this.maxCorrelatedCpePerArtifact = maxCorrelatedCpePerArtifact;
        return this;
    }

    public CpeDerivationEnrichmentConfiguration setRequireSecondaryIndicationTermsLimitersBySerialized(List<Map<String, Object>> requireSecondaryIndicationTermsLimiters) {
        this.requireSecondaryIndicationTermsLimiters = requireSecondaryIndicationTermsLimiters;
        return this;
    }

    public CpeDerivationEnrichmentConfiguration setRequireSecondaryIndicationTermsLimiters(List<NvdCpeApiVendorProductIndexQuery.TermsLimiter> limiters) {
        this.requireSecondaryIndicationTermsLimiters = limiters.stream().map(NvdCpeApiVendorProductIndexQuery.TermsLimiter::toJson).map(JSONObject::toMap).collect(Collectors.toList());
        return this;
    }

    public List<NvdCpeApiVendorProductIndexQuery.TermsLimiter> getRequireSecondaryIndicationTermsLimiters() {
        return NvdCpeApiVendorProductIndexQuery.TermsLimiter.fromJson(new JSONArray(this.requireSecondaryIndicationTermsLimiters));
    }

    public CpeDerivationEnrichmentConfiguration setAddDetailedMatchingInformation(boolean addDetailedMatchingInformation) {
        this.addDetailedMatchingInformation = addDetailedMatchingInformation;
        return this;
    }

    public LinkedHashMap<String, Object> getProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("maxCorrelatedCpePerArtifact", this.maxCorrelatedCpePerArtifact);
        properties.put("requireSecondaryIndicationTermsLimiters", this.requireSecondaryIndicationTermsLimiters);
        properties.put("addDetailedMatchingInformation", this.addDetailedMatchingInformation);
        return properties;
    }

    public void setProperties(LinkedHashMap<String, Object> properties) {
        super.loadIntegerProperty(properties, "maxCorrelatedCpePerArtifact", this::setMaxCorrelatedCpePerArtifact);
        if (properties.containsKey("requireSecondaryIndicationTermsLimiters") && properties.get("requireSecondaryIndicationTermsLimiters") instanceof List && ((List)properties.get("requireSecondaryIndicationTermsLimiters")).stream().allMatch(o -> o instanceof Map)) {
            this.requireSecondaryIndicationTermsLimiters = (List)properties.get("requireSecondaryIndicationTermsLimiters");
        }
        super.loadBooleanProperty(properties, "addDetailedMatchingInformation", this::setAddDetailedMatchingInformation);
    }

    protected void collectMisconfigurations(List<ProcessMisconfiguration> misconfigurations) {
        if (this.maxCorrelatedCpePerArtifact < -1) {
            misconfigurations.add(new ProcessMisconfiguration("maxCorrelatedCpePerArtifact", "Must be greater or equal to -1"));
        }
        try {
            NvdCpeApiVendorProductIndexQuery.TermsLimiter.fromJson(new JSONArray(this.requireSecondaryIndicationTermsLimiters));
        }
        catch (Exception e) {
            misconfigurations.add(new ProcessMisconfiguration("requireSecondaryIndicationTermsLimiters", "Must be a list of valid terms limiters: " + e.getMessage()));
        }
    }

    public int getMaxCorrelatedCpePerArtifact() {
        return this.maxCorrelatedCpePerArtifact;
    }

    public boolean isAddDetailedMatchingInformation() {
        return this.addDetailedMatchingInformation;
    }
}

