/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.configurations;

import com.metaeffekt.artifact.enrichment.configurations.VulnerabilitiesFromCpeEnrichmentConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.metaeffekt.core.inventory.processor.configuration.ProcessMisconfiguration;

public class CustomVulnerabilitiesFromCpeEnrichmentConfiguration
extends VulnerabilitiesFromCpeEnrichmentConfiguration {
    private final List<File> vulnerabilityFiles = new ArrayList<File>();

    public CustomVulnerabilitiesFromCpeEnrichmentConfiguration addVulnerabilityFile(File vulnerabilityFile) {
        this.vulnerabilityFiles.add(vulnerabilityFile);
        return this;
    }

    public CustomVulnerabilitiesFromCpeEnrichmentConfiguration addVulnerabilityFiles(List<File> vulnerabilityFiles) {
        this.vulnerabilityFiles.addAll(vulnerabilityFiles);
        return this;
    }

    public CustomVulnerabilitiesFromCpeEnrichmentConfiguration setVulnerabilityFiles(List<File> vulnerabilityFiles) {
        this.vulnerabilityFiles.clear();
        this.vulnerabilityFiles.addAll(vulnerabilityFiles);
        return this;
    }

    public List<File> getVulnerabilityFiles() {
        return this.vulnerabilityFiles;
    }

    @Override
    public LinkedHashMap<String, Object> getProperties() {
        LinkedHashMap<String, Object> configuration = super.getProperties();
        configuration.put("vulnerabilityFiles", this.vulnerabilityFiles.stream().filter(Objects::nonNull).map(File::getAbsoluteFile).collect(Collectors.toList()));
        return configuration;
    }

    @Override
    protected void collectMisconfigurations(List<ProcessMisconfiguration> misconfigurations) {
        super.collectMisconfigurations(misconfigurations);
        if (this.vulnerabilityFiles.isEmpty()) {
            misconfigurations.add(new ProcessMisconfiguration("vulnerabilityFiles", "Must not be empty, set enricher to inactive to avoid exception"));
        }
        if (this.vulnerabilityFiles.stream().anyMatch(Objects::isNull)) {
            misconfigurations.add(new ProcessMisconfiguration("vulnerabilityFiles", "Must not contain null values"));
        }
    }
}

