/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.configurations;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter.FilterAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatus;
import com.metaeffekt.artifact.enrichment.configurations.AdvisorPeriodicEnrichmentConfiguration;
import com.metaeffekt.artifact.enrichment.configurations.VadDetailLevelConfiguration;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeIdentifier;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.configuration.ProcessConfiguration;
import org.metaeffekt.core.inventory.processor.configuration.ProcessMisconfiguration;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VulnerabilityAssessmentDashboardEnrichmentConfiguration
extends ProcessConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(VulnerabilityAssessmentDashboardEnrichmentConfiguration.class);
    private int maximumVulnerabilitiesPerDashboardCount = Integer.MAX_VALUE;
    private String vulnerabilityIncludeFilter = null;
    private FilterAttribute vulnerabilityIncludeFilterAttribute = null;
    private int maximumCpeForTimelinesPerVulnerability = Integer.MAX_VALUE;
    private int maximumVulnerabilitiesPerTimeline = Integer.MAX_VALUE;
    private int maximumVersionsPerTimeline = Integer.MAX_VALUE;
    private int maximumTimeSpentOnTimelines = Integer.MAX_VALUE;
    private int maximumTimeSpentPerTimeline = Integer.MAX_VALUE;
    private boolean vulnerabilityTimelinesGlobalEnabled = true;
    private boolean vulnerabilityTimelineHideIrrelevantVersions = true;
    private boolean failOnVulnerabilityWithoutSpecifiedRisk = true;
    private boolean failOnUnreviewedAdvisories = true;
    private File svgDirectory;
    private VulnerabilityCvssSvgChartInterpolationMethod vulnerabilitySvgChartInterpolationMethod = VulnerabilityCvssSvgChartInterpolationMethod.BASE_METRICS;
    private final List<VadDetailLevelConfiguration> detailLevels = new ArrayList<VadDetailLevelConfiguration>();
    private String failOnUnreviewedAdvisoriesTypes = new JSONArray().toString();
    private File outputDashboardFile = null;

    @Deprecated
    public VulnerabilityAssessmentDashboardEnrichmentConfiguration setMinimumVulnerabilityIncludeScore(double minimumVulnerabilityIncludeScore) {
        LOG.warn("The minimumVulnerabilityIncludeScore [{}] is deprecated. Please use the security configuration includeScoreThreshold instead.", (Object)minimumVulnerabilityIncludeScore);
        return this;
    }

    @Deprecated
    public VulnerabilityAssessmentDashboardEnrichmentConfiguration setInsignificantThreshold(double insignificantThreshold) {
        LOG.error("The insignificantThreshold [{}] is deprecated. Please use the security configuration insignificantThreshold instead.", (Object)insignificantThreshold);
        return this;
    }

    public VulnerabilityAssessmentDashboardEnrichmentConfiguration setMaximumVulnerabilitiesPerDashboardCount(int maximumVulnerabilitiesPerDashboardCount) {
        this.maximumVulnerabilitiesPerDashboardCount = maximumVulnerabilitiesPerDashboardCount;
        return this;
    }

    public FilterAttribute getVulnerabilityIncludeFilterAttribute() {
        if (this.vulnerabilityIncludeFilterAttribute == null && StringUtils.hasText(this.vulnerabilityIncludeFilter)) {
            this.vulnerabilityIncludeFilterAttribute = FilterAttribute.fromString(this.vulnerabilityIncludeFilter);
        }
        return this.vulnerabilityIncludeFilterAttribute;
    }

    public VulnerabilityAssessmentDashboardEnrichmentConfiguration setVulnerabilityIncludeFilter(String vulnerabilityIncludeFilter) {
        this.vulnerabilityIncludeFilter = vulnerabilityIncludeFilter;
        if (this.vulnerabilityIncludeFilterAttribute == null && StringUtils.hasText(this.vulnerabilityIncludeFilter)) {
            this.vulnerabilityIncludeFilterAttribute = FilterAttribute.fromString(this.vulnerabilityIncludeFilter);
        }
        return this;
    }

    public VulnerabilityAssessmentDashboardEnrichmentConfiguration setMaximumCpeForTimelinesPerVulnerability(int maximumCpeForTimelinesPerVulnerability) {
        this.maximumCpeForTimelinesPerVulnerability = maximumCpeForTimelinesPerVulnerability;
        return this;
    }

    public VulnerabilityAssessmentDashboardEnrichmentConfiguration setMaximumVulnerabilitiesPerTimeline(int maximumVulnerabilitiesPerTimeline) {
        this.maximumVulnerabilitiesPerTimeline = maximumVulnerabilitiesPerTimeline;
        return this;
    }

    public VulnerabilityAssessmentDashboardEnrichmentConfiguration setMaximumVersionsPerTimeline(int maximumVersionsPerTimeline) {
        this.maximumVersionsPerTimeline = maximumVersionsPerTimeline;
        return this;
    }

    public VulnerabilityAssessmentDashboardEnrichmentConfiguration setMaximumTimeSpentOnTimelines(int maximumTimeSpentOnTimelines) {
        this.maximumTimeSpentOnTimelines = maximumTimeSpentOnTimelines;
        return this;
    }

    public VulnerabilityAssessmentDashboardEnrichmentConfiguration setMaximumTimeSpentPerTimeline(int maximumTimeSpentPerTimeline) {
        this.maximumTimeSpentPerTimeline = maximumTimeSpentPerTimeline;
        return this;
    }

    public VulnerabilityAssessmentDashboardEnrichmentConfiguration setVulnerabilityTimelinesGlobalEnabled(boolean vulnerabilityTimelinesGlobalEnabled) {
        this.vulnerabilityTimelinesGlobalEnabled = vulnerabilityTimelinesGlobalEnabled;
        return this;
    }

    public VulnerabilityAssessmentDashboardEnrichmentConfiguration setVulnerabilityTimelineHideIrrelevantVersions(boolean vulnerabilityTimelineHideIrrelevantVersions) {
        this.vulnerabilityTimelineHideIrrelevantVersions = vulnerabilityTimelineHideIrrelevantVersions;
        return this;
    }

    public VulnerabilityAssessmentDashboardEnrichmentConfiguration setFailOnVulnerabilityWithoutSpecifiedRisk(boolean failOnVulnerabilityWithoutSpecifiedRisk) {
        this.failOnVulnerabilityWithoutSpecifiedRisk = failOnVulnerabilityWithoutSpecifiedRisk;
        return this;
    }

    public VulnerabilityAssessmentDashboardEnrichmentConfiguration setFailOnUnreviewedAdvisories(boolean failOnUnreviewedAdvisories) {
        this.failOnUnreviewedAdvisories = failOnUnreviewedAdvisories;
        return this;
    }

    public List<AdvisoryTypeIdentifier<?>> getFailOnUnreviewedAdvisoriesTypes() {
        return AdvisorPeriodicEnrichmentConfiguration.parseAdvisoryProviders(this.failOnUnreviewedAdvisoriesTypes);
    }

    public VulnerabilityAssessmentDashboardEnrichmentConfiguration setFailOnUnreviewedAdvisoriesTypes(JSONArray failOnUnreviewedAdvisoriesTypes) {
        this.failOnUnreviewedAdvisoriesTypes = failOnUnreviewedAdvisoriesTypes.toString();
        return this;
    }

    public VulnerabilityAssessmentDashboardEnrichmentConfiguration setFailOnUnreviewedAdvisoriesTypes(Map<String, String> failOnUnreviewedAdvisoriesTypes) {
        JSONArray failOnUnreviewedAdvisoriesTypesArray = new JSONArray();
        failOnUnreviewedAdvisoriesTypes.forEach((name, implementation) -> failOnUnreviewedAdvisoriesTypesArray.put((Object)new JSONObject().put("name", name).put("implementation", (Object)(StringUtils.hasText(implementation) ? implementation : name))));
        this.failOnUnreviewedAdvisoriesTypes = failOnUnreviewedAdvisoriesTypesArray.toString();
        return this;
    }

    public VulnerabilityAssessmentDashboardEnrichmentConfiguration setFailOnUnreviewedAdvisoriesTypes(List<AdvisoryTypeIdentifier<?>> failOnUnreviewedAdvisoriesTypes) {
        JSONArray failOnUnreviewedAdvisoriesTypesArray = new JSONArray();
        failOnUnreviewedAdvisoriesTypes.forEach(advisoryTypeIdentifier -> failOnUnreviewedAdvisoriesTypesArray.put((Object)new JSONObject().put("name", (Object)advisoryTypeIdentifier.getName()).put("implementation", (Object)advisoryTypeIdentifier.getImplementation())));
        this.failOnUnreviewedAdvisoriesTypes = failOnUnreviewedAdvisoriesTypesArray.toString();
        return this;
    }

    public VulnerabilityAssessmentDashboardEnrichmentConfiguration addFailOnUnreviewedAdvisoriesType(AdvisoryTypeIdentifier<?> failOnUnreviewedAdvisoriesType) {
        JSONObject advisoryType = new JSONObject().put("name", (Object)failOnUnreviewedAdvisoriesType.getName()).put("implementation", (Object)failOnUnreviewedAdvisoriesType.getImplementation());
        this.failOnUnreviewedAdvisoriesTypes = new JSONArray(this.failOnUnreviewedAdvisoriesTypes).put((Object)advisoryType).toString();
        return this;
    }

    public VulnerabilityAssessmentDashboardEnrichmentConfiguration setOutputDashboardFile(File outputDashboardFile) {
        this.outputDashboardFile = outputDashboardFile;
        return this;
    }

    public VulnerabilityAssessmentDashboardEnrichmentConfiguration setSvgDirectory(File svgDirectory) {
        this.svgDirectory = svgDirectory;
        return this;
    }

    public List<VadDetailLevelConfiguration> getDetailLevels(Vulnerability vulnerability, VulnerabilityStatus status, Set<Artifact> artifacts) {
        return this.detailLevels.stream().filter(detailLevel -> detailLevel.getMatcher().matches(vulnerability, status, artifacts)).collect(Collectors.toList());
    }

    public VulnerabilityAssessmentDashboardEnrichmentConfiguration addDetailLevel(VadDetailLevelConfiguration detailLevel) {
        this.detailLevels.add(detailLevel);
        return this;
    }

    public VulnerabilityAssessmentDashboardEnrichmentConfiguration setDetailLevels(List<VadDetailLevelConfiguration> detailLevels) {
        this.detailLevels.clear();
        this.detailLevels.addAll(detailLevels);
        return this;
    }

    public VulnerabilityAssessmentDashboardEnrichmentConfiguration setVulnerabilitySvgChartInterpolationMethod(VulnerabilityCvssSvgChartInterpolationMethod vulnerabilitySvgChartInterpolationMethod) {
        this.vulnerabilitySvgChartInterpolationMethod = vulnerabilitySvgChartInterpolationMethod;
        return this;
    }

    public LinkedHashMap<String, Object> getProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("maximumVulnerabilitiesPerDashboardCount", this.maximumVulnerabilitiesPerDashboardCount);
        properties.put("vulnerabilityIncludeFilter", this.vulnerabilityIncludeFilter);
        properties.put("vulnerabilityIncludeFilterAttribute", this.vulnerabilityIncludeFilterAttribute);
        properties.put("maximumCpeForTimelinesPerVulnerability", this.maximumCpeForTimelinesPerVulnerability);
        properties.put("maximumVulnerabilitiesPerTimeline", this.maximumVulnerabilitiesPerTimeline);
        properties.put("maximumVersionsPerTimeline", this.maximumVersionsPerTimeline);
        properties.put("maximumTimeSpentOnTimelines", this.maximumTimeSpentOnTimelines);
        properties.put("maximumTimeSpentPerTimeline", this.maximumTimeSpentPerTimeline);
        properties.put("vulnerabilityTimelinesGlobalEnabled", this.vulnerabilityTimelinesGlobalEnabled);
        properties.put("vulnerabilityTimelineHideIrrelevantVersions", this.vulnerabilityTimelineHideIrrelevantVersions);
        properties.put("failOnVulnerabilityWithoutSpecifiedRisk", this.failOnVulnerabilityWithoutSpecifiedRisk);
        properties.put("failOnUnreviewedAdvisories", this.failOnUnreviewedAdvisories);
        properties.put("failOnUnreviewedAdvisoriesTypes", this.failOnUnreviewedAdvisoriesTypes);
        properties.put("outputDashboardFile", this.outputDashboardFile);
        properties.put("svgDirectory", this.svgDirectory);
        properties.put("vulnerabilitySvgChartInterpolationMethod", (Object)this.vulnerabilitySvgChartInterpolationMethod);
        properties.put("detailLevels", this.detailLevels.stream().map(VadDetailLevelConfiguration::getProperties).collect(Collectors.toList()));
        return properties;
    }

    public void setProperties(LinkedHashMap<String, Object> properties) {
        super.loadIntegerProperty(properties, "maximumVulnerabilitiesPerDashboardCount", this::setMaximumVulnerabilitiesPerDashboardCount);
        super.loadStringProperty(properties, "vulnerabilityIncludeFilter", this::setVulnerabilityIncludeFilter);
        super.loadIntegerProperty(properties, "maximumCpeForTimelinesPerVulnerability", this::setMaximumCpeForTimelinesPerVulnerability);
        super.loadIntegerProperty(properties, "maximumVulnerabilitiesPerTimeline", this::setMaximumVulnerabilitiesPerTimeline);
        super.loadIntegerProperty(properties, "maximumVersionsPerTimeline", this::setMaximumVersionsPerTimeline);
        super.loadIntegerProperty(properties, "maximumTimeSpentOnTimelines", this::setMaximumTimeSpentOnTimelines);
        super.loadIntegerProperty(properties, "maximumTimeSpentPerTimeline", this::setMaximumTimeSpentPerTimeline);
        super.loadBooleanProperty(properties, "vulnerabilityTimelinesGlobalEnabled", this::setVulnerabilityTimelinesGlobalEnabled);
        super.loadBooleanProperty(properties, "vulnerabilityTimelineHideIrrelevantVersions", this::setVulnerabilityTimelineHideIrrelevantVersions);
        super.loadBooleanProperty(properties, "failOnVulnerabilityWithoutSpecifiedRisk", this::setFailOnVulnerabilityWithoutSpecifiedRisk);
        super.loadBooleanProperty(properties, "failOnUnreviewedAdvisories", this::setFailOnUnreviewedAdvisories);
        super.loadJsonArrayProperty(properties, "failOnUnreviewedAdvisoriesTypes", this::setFailOnUnreviewedAdvisoriesTypes);
        super.loadProperty(properties, "vulnerabilitySvgChartInterpolationMethod", obj -> VulnerabilityCvssSvgChartInterpolationMethod.valueOf(String.valueOf(obj)), this::setVulnerabilitySvgChartInterpolationMethod);
        super.loadProperty(properties, "outputDashboardFile", obj -> new File(String.valueOf(obj)), this::setOutputDashboardFile);
        super.loadProperty(properties, "svgDirectory", obj -> new File(String.valueOf(obj)), this::setSvgDirectory);
        super.loadSubConfigurations(properties, "detailLevels", VadDetailLevelConfiguration::new, this::setDetailLevels);
    }

    protected void collectMisconfigurations(List<ProcessMisconfiguration> misconfigurations) {
        for (VadDetailLevelConfiguration config : this.detailLevels) {
            config.collectMisconfigurations(misconfigurations);
        }
        if (this.maximumVulnerabilitiesPerDashboardCount < 1) {
            misconfigurations.add(new ProcessMisconfiguration("maximumVulnerabilitiesPerDashboardCount", "must be greater than 0"));
        }
        if (this.maximumCpeForTimelinesPerVulnerability < -1) {
            misconfigurations.add(new ProcessMisconfiguration("maximumCpeForTimelinesPerVulnerability", "must be greater or equal to -1"));
        }
        if (this.maximumVulnerabilitiesPerTimeline < -1) {
            misconfigurations.add(new ProcessMisconfiguration("maximumVulnerabilitiesPerTimeline", "must be greater or equal to -1"));
        }
        if (this.maximumVersionsPerTimeline < -1) {
            misconfigurations.add(new ProcessMisconfiguration("maximumVersionsPerTimeline", "must be greater or equal to -1"));
        }
        if (this.maximumTimeSpentOnTimelines < 0) {
            misconfigurations.add(new ProcessMisconfiguration("maximumTimeSpentOnTimelines", "must be greater or equal to 0"));
        }
        if (this.maximumTimeSpentPerTimeline < 0) {
            misconfigurations.add(new ProcessMisconfiguration("maximumTimeSpentPerTimeline", "must be greater or equal to 0"));
        }
        if (this.outputDashboardFile == null) {
            misconfigurations.add(new ProcessMisconfiguration("outputDashboardFile", "must be specified"));
        }
    }

    public int getMaximumVulnerabilitiesPerDashboardCount() {
        return this.maximumVulnerabilitiesPerDashboardCount;
    }

    public int getMaximumCpeForTimelinesPerVulnerability() {
        return this.maximumCpeForTimelinesPerVulnerability;
    }

    public int getMaximumVulnerabilitiesPerTimeline() {
        return this.maximumVulnerabilitiesPerTimeline;
    }

    public int getMaximumVersionsPerTimeline() {
        return this.maximumVersionsPerTimeline;
    }

    public int getMaximumTimeSpentOnTimelines() {
        return this.maximumTimeSpentOnTimelines;
    }

    public int getMaximumTimeSpentPerTimeline() {
        return this.maximumTimeSpentPerTimeline;
    }

    public boolean isVulnerabilityTimelinesGlobalEnabled() {
        return this.vulnerabilityTimelinesGlobalEnabled;
    }

    public boolean isVulnerabilityTimelineHideIrrelevantVersions() {
        return this.vulnerabilityTimelineHideIrrelevantVersions;
    }

    public boolean isFailOnVulnerabilityWithoutSpecifiedRisk() {
        return this.failOnVulnerabilityWithoutSpecifiedRisk;
    }

    public boolean isFailOnUnreviewedAdvisories() {
        return this.failOnUnreviewedAdvisories;
    }

    public File getSvgDirectory() {
        return this.svgDirectory;
    }

    public VulnerabilityCvssSvgChartInterpolationMethod getVulnerabilitySvgChartInterpolationMethod() {
        return this.vulnerabilitySvgChartInterpolationMethod;
    }

    public List<VadDetailLevelConfiguration> getDetailLevels() {
        return this.detailLevels;
    }

    public File getOutputDashboardFile() {
        return this.outputDashboardFile;
    }

    public static enum VulnerabilityCvssSvgChartInterpolationMethod {
        LINEAR,
        BASE_METRICS;

    }
}

