/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.details;

import com.metaeffekt.artifact.analysis.utils.LazySupplier;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.enrichment.configurations.details.DetailsFillingAdvisorCertEuInventoryEnrichmentConfiguration;
import com.metaeffekt.artifact.enrichment.details.DetailsFillingEnrichment;
import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.advisory.CertEuAdvisorEntry;
import com.metaeffekt.mirror.contents.base.DataSourceIndicator;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeStore;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import com.metaeffekt.mirror.query.CertEuAdvisorIndexQuery;
import java.io.File;
import java.util.List;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnricherMetadata(name="CERT-EU Advisor Details", phase=InventoryEnrichmentPhase.SECURITY_ADVISORY_MATCHING, intermediateFileSuffix="details-advisor-cert-eu", mavenPropertyName="certEuAdvisorEnrichment", explicitConfiguration=DetailsFillingAdvisorCertEuInventoryEnrichmentConfiguration.class)
public class DetailsFillingEnrichmentCertEu
extends DetailsFillingEnrichment<DetailsFillingAdvisorCertEuInventoryEnrichmentConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(DetailsFillingEnrichmentCertEu.class);
    private final LazySupplier<CertEuAdvisorIndexQuery> certEuAdvisorQuery = new LazySupplier<CertEuAdvisorIndexQuery>(() -> new CertEuAdvisorIndexQuery(baseMirrorDirectory));

    public DetailsFillingEnrichmentCertEu(File baseMirrorDirectory) {
        this.setConfiguration(new DetailsFillingAdvisorCertEuInventoryEnrichmentConfiguration());
    }

    @Override
    protected boolean isApplicable(Vulnerability vulnerability) {
        return !vulnerability.getRelatedAdvisorsTypes().contains(AdvisoryTypeStore.CERT_EU);
    }

    @Override
    protected boolean isApplicable(AdvisoryEntry advisory) {
        return advisory.getSourceIdentifier() == AdvisoryTypeStore.CERT_EU && StringUtils.isEmpty(advisory.getSummary()) && advisory.getDescription().isEmpty();
    }

    @Override
    protected void fillDetailsOnVulnerability(Inventory inventory, VulnerabilityContextInventory vInventory, Vulnerability queryVulnerability) {
        List advisorEntries = ((CertEuAdvisorIndexQuery)this.certEuAdvisorQuery.get()).findByReferencedId(queryVulnerability.getId());
        if (advisorEntries.isEmpty()) {
            return;
        }
        for (CertEuAdvisorEntry advisoryEntry : advisorEntries) {
            AdvisoryEntry constructedAdvisory = vInventory.findOrCreateAdvisoryEntryByName(advisoryEntry.getId(), CertEuAdvisorEntry::new);
            constructedAdvisory.addMatchingSource(DataSourceIndicator.vulnerability(queryVulnerability));
            queryVulnerability.addSecurityAdvisory(constructedAdvisory);
        }
    }

    @Override
    protected void fillDetailsOnAdvisory(Inventory inventory, VulnerabilityContextInventory vInventory, AdvisoryEntry queryAdvisory) {
        CertEuAdvisorEntry foundAdvisory = (CertEuAdvisorEntry)((CertEuAdvisorIndexQuery)this.certEuAdvisorQuery.get()).findById(queryAdvisory.getId());
        if (foundAdvisory != null) {
            queryAdvisory.appendFromDataClass(foundAdvisory);
        }
    }
}

