/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.matching;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.version.AllCategorizedPartsVersionImpl;
import com.metaeffekt.artifact.analysis.version.Version;
import com.metaeffekt.artifact.analysis.version.curation.VersionContext;
import com.metaeffekt.artifact.analysis.vulnerability.CommonEnumerationUtil;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.warnings.InventoryWarningEntry;
import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import com.metaeffekt.artifact.enrichment.configurations.VulnerabilitiesFromCpeEnrichmentConfiguration;
import com.metaeffekt.mirror.contents.base.AmbDataClass;
import com.metaeffekt.mirror.contents.base.DataSourceIndicator;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.store.ContentIdentifierStore;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeIdentifier;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.contents.vulnerability.VulnerableSoftwareVersionRangeCpe;
import com.metaeffekt.mirror.query.VulnerabilityIndexQuery;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.exceptions.CpeValidationException;

public abstract class VulnerabilitiesFromCpeEnrichment
extends InventoryEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(VulnerabilitiesFromCpeEnrichment.class);
    protected VulnerabilitiesFromCpeEnrichmentConfiguration configuration;

    public VulnerabilitiesFromCpeEnrichment(VulnerabilitiesFromCpeEnrichmentConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setConfiguration(VulnerabilitiesFromCpeEnrichmentConfiguration configuration) {
        this.configuration = configuration;
    }

    protected abstract VulnerabilityIndexQuery getVulnerabilityQuery();

    protected abstract ContentIdentifierStore.ContentIdentifier getVulnerabilitySource();

    protected void enrichVulnerabilitiesForCpe(VulnerabilityContextInventory vInventory, Artifact artifact) {
        Map<Cpe, List<Vulnerability>> vulnerabilitiesForCpes = this.queryVulnerabilitiesForArtifact(vInventory, artifact);
        HashSet matchedCpes = new HashSet();
        vulnerabilitiesForCpes.keySet().forEach(cpe -> matchedCpes.add(CommonEnumerationUtil.toCpe22UriOrFallbackToCpe23FS(cpe)));
        if (!matchedCpes.isEmpty()) {
            artifact.set((AbstractModelBase.Attribute)InventoryAttribute.MATCHED_CPES, matchedCpes.stream().filter(cpe -> cpe != null && !cpe.equals("null")).collect(Collectors.joining(", ")));
        } else {
            artifact.set((AbstractModelBase.Attribute)InventoryAttribute.MATCHED_CPES, null);
        }
    }

    public Map<Cpe, List<Vulnerability>> queryVulnerabilitiesForArtifact(VulnerabilityContextInventory vInventory, Artifact artifact) {
        LinkedHashMap<Cpe, List<Vulnerability>> aggregatedVulnerabilitiesForCpes = new LinkedHashMap<Cpe, List<Vulnerability>>();
        HashSet aggregatedVulnerabilities = new HashSet();
        List<Cpe> artifactCpes = CommonEnumerationUtil.parseEffectiveCpe(artifact);
        for (Cpe cpe : artifactCpes) {
            try {
                Optional<Cpe> optionalQueryCpe = VulnerabilitiesFromCpeEnrichment.deriveQueryCpe(vInventory, this.getEnrichmentName(), artifact, cpe);
                if (!optionalQueryCpe.isPresent()) continue;
                Cpe queryCpe = optionalQueryCpe.get();
                Map<Vulnerability, VulnerableSoftwareVersionRangeCpe> vulnerabilitiesWithSources = this.getVulnerabilityQuery().findVulnerabilitiesByFlatAffectedConfigurationRetainSource(queryCpe);
                List vulnerabilitiesForCpes = vulnerabilitiesWithSources.keySet().stream().map(AmbDataClass::getId).map(vInventory::findOrCreateVulnerabilityByName).collect(Collectors.toList());
                if (!vulnerabilitiesForCpes.isEmpty()) {
                    for (Vulnerability vulnerability : vulnerabilitiesForCpes) {
                        VulnerableSoftwareVersionRangeCpe affectedConfiguration = vulnerabilitiesWithSources.get(vulnerability);
                        DataSourceIndicator matchingSource = DataSourceIndicator.cpe(artifact, this.getVulnerabilitySource(), queryCpe, affectedConfiguration != null ? affectedConfiguration.toString() : null);
                        vulnerability.addMatchingSource(matchingSource);
                    }
                }
                aggregatedVulnerabilities.addAll(vulnerabilitiesForCpes.stream().map(AmbDataClass::getId).collect(Collectors.toSet()));
                aggregatedVulnerabilitiesForCpes.put(cpe, vulnerabilitiesForCpes);
                if (aggregatedVulnerabilities.size() <= this.configuration.getMaxCorrelatedVulnerabilitiesPerArtifact()) continue;
                break;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to query vulnerabilities for artifact [" + artifact.getId() + "] on CPE [" + CommonEnumerationUtil.toCpe22UriOrFallbackToCpe23FS(cpe) + "]: " + e.getMessage(), e);
            }
        }
        if (aggregatedVulnerabilities.size() > this.configuration.getMaxCorrelatedVulnerabilitiesPerArtifact()) {
            LOG.warn("Found [{}] vulnerabilities for artifact [{}] but only the first [{}] will be considered.", new Object[]{aggregatedVulnerabilities.size(), artifact.getId(), this.configuration.getMaxCorrelatedVulnerabilitiesPerArtifact()});
            vInventory.getInventoryWarnings().addArtifactWarning(new InventoryWarningEntry<Artifact>(artifact, "Found " + aggregatedVulnerabilities.size() + " vulnerabilities but only the first " + this.configuration.getMaxCorrelatedVulnerabilitiesPerArtifact() + " will be considered.", this.getEnrichmentName()));
            int count = 0;
            boolean clearAll = false;
            for (Map.Entry entry : aggregatedVulnerabilitiesForCpes.entrySet()) {
                List vulnerabilities = (List)entry.getValue();
                if ((count += vulnerabilities.size()) <= this.configuration.getMaxCorrelatedVulnerabilitiesPerArtifact()) continue;
                if (clearAll) {
                    vulnerabilities.clear();
                    continue;
                }
                int removeCount = count - this.configuration.getMaxCorrelatedVulnerabilitiesPerArtifact();
                vulnerabilities.subList(vulnerabilities.size() - removeCount, vulnerabilities.size()).clear();
                clearAll = true;
            }
        }
        VulnerabilityTypeIdentifier<?> vulnerabilityIdentifier = this.getVulnerabilityQuery().getVulnerabilityType();
        for (List vulnerabilities : aggregatedVulnerabilitiesForCpes.values()) {
            for (Vulnerability vulnerability : vulnerabilities) {
                vulnerability.setSourceIdentifier(vulnerabilityIdentifier);
            }
        }
        return aggregatedVulnerabilitiesForCpes;
    }

    public static Optional<Cpe> deriveQueryCpe(VulnerabilityContextInventory vInventory, String enrichmentName, Artifact artifact, Cpe cpe) {
        Version queryVersion = VulnerabilitiesFromCpeEnrichment.deriveQueryVersion(artifact, cpe);
        try {
            return Optional.of(CommonEnumerationUtil.builder().from(cpe).version(VulnerabilitiesFromCpeEnrichment.replaceIfNotNull(queryVersion.getVersion(), " ", "_")).update(VulnerabilitiesFromCpeEnrichment.replaceIfNotNull(queryVersion.getUpdate(), " ", "_")).build());
        }
        catch (CpeValidationException e) {
            LOG.warn("Failed to build CPE for querying vulnerability data: [{}] [{}]: {}", new Object[]{cpe, queryVersion, e.getMessage()});
            if (vInventory != null) {
                vInventory.getInventoryWarnings().addArtifactWarning(new InventoryWarningEntry<Artifact>(artifact, "Failed to build CPE for querying vulnerability data: " + cpe + " " + queryVersion + ": " + e.getMessage(), enrichmentName != null ? enrichmentName : VulnerabilitiesFromCpeEnrichment.class.getName()));
            }
            return Optional.empty();
        }
    }

    private static String replaceIfNotNull(String str, String value, String replacement) {
        if (str != null) {
            return str.replace(value, replacement);
        }
        return null;
    }

    public static Version deriveQueryVersion(Artifact artifact, Cpe cpe) {
        Version artifactVersion = VulnerabilitiesFromCpeEnrichment.deriveArtifactVersion(artifact);
        Version cpeVersion = Version.of(cpe.getVersion(), cpe.getUpdate(), VersionContext.fromCpe(cpe));
        Version modulateVersion = VulnerabilitiesFromCpeEnrichment.modulateVersions(artifactVersion, cpeVersion);
        if (!artifactVersion.toString().equals(modulateVersion.toString())) {
            LOG.info("Derived query version for artifact [{}] and CPE [{}]: [{}] + [{}] = [{}]", new Object[]{artifact.getId(), CommonEnumerationUtil.toCpe22UriOrFallbackToCpe23FS(cpe), artifactVersion, cpeVersion, modulateVersion});
        }
        return modulateVersion;
    }

    public static Version deriveArtifactVersion(Artifact artifact) {
        String version = VulnerabilitiesFromCpeEnrichment.extractCpeVersion(artifact);
        String update = null;
        Pattern compile = Pattern.compile("^.*p[0-9]+$");
        Matcher matcher = compile.matcher(version);
        if (matcher.matches()) {
            int pIndex = version.lastIndexOf("p");
            update = version.substring(pIndex);
            version = version.substring(0, pIndex);
        }
        return Version.of(version, update, VersionContext.fromArtifact(artifact));
    }

    private static Version modulateVersions(Version artifactVersion, Version cpeQueryVersion) {
        if (artifactVersion instanceof AllCategorizedPartsVersionImpl && (cpeQueryVersion == null || cpeQueryVersion instanceof AllCategorizedPartsVersionImpl)) {
            AllCategorizedPartsVersionImpl artifactVersionImpl = (AllCategorizedPartsVersionImpl)artifactVersion;
            AllCategorizedPartsVersionImpl cpeQueryVersionImpl = (AllCategorizedPartsVersionImpl)cpeQueryVersion;
            String artifactVersionPart = artifactVersionImpl.toStringPreModifierPart();
            String artifactUpdatePart = artifactVersionImpl.toStringModifierPart();
            if (cpeQueryVersionImpl == null) {
                return Version.of(artifactVersionPart, artifactUpdatePart);
            }
            String cpeQueryVersionPart = cpeQueryVersionImpl.toStringPreModifierPart();
            String cpeQueryUpdatePart = cpeQueryVersionImpl.toStringModifierPart();
            String effectiveVersion = !"*".equals(cpeQueryVersion.getVersion()) && StringUtils.hasText(cpeQueryVersion.getVersion()) && StringUtils.hasText(cpeQueryVersionPart) ? cpeQueryVersionPart : artifactVersionPart;
            String effectiveUpdate = !"*".equals(cpeQueryVersionImpl.getUpdate()) && StringUtils.hasText(cpeQueryVersion.getUpdate()) && StringUtils.hasText(cpeQueryUpdatePart) ? cpeQueryUpdatePart : artifactUpdatePart;
            if (StringUtils.hasText(effectiveVersion) && StringUtils.hasText(effectiveUpdate)) {
                return Version.of(effectiveVersion, effectiveUpdate);
            }
            if (StringUtils.hasText(effectiveVersion)) {
                return Version.of(effectiveVersion, artifactVersion.getUpdate());
            }
            return Version.of(artifactVersion.getVersion(), artifactVersion.getUpdate());
        }
        LOG.warn("Using old implementation for version modulation. Please update to the new implementation [{}] [{}]", (Object)artifactVersion, (Object)cpeQueryVersion);
        String version = artifactVersion.getVersion();
        String update = artifactVersion.getUpdate();
        if (cpeQueryVersion == null) {
            return artifactVersion;
        }
        if (!"*".equals(cpeQueryVersion.getVersion())) {
            version = cpeQueryVersion.getVersion();
            if (!"*".equals(cpeQueryVersion.getUpdate())) {
                update = cpeQueryVersion.getUpdate();
            }
        }
        return Version.of(version, update);
    }

    public static String extractCpeVersion(Artifact artifact) {
        String strippedVersion;
        String string = strippedVersion = StringUtils.isEmpty(artifact.getVersion()) ? "*" : artifact.getVersion().trim();
        if (strippedVersion.equalsIgnoreCase("unspecific") || strippedVersion.equalsIgnoreCase("undefined")) {
            return "*";
        }
        if (strippedVersion.contains(":")) {
            return strippedVersion.substring(strippedVersion.indexOf(":") + 1);
        }
        if (strippedVersion.contains("+")) {
            return strippedVersion.substring(0, strippedVersion.indexOf("+"));
        }
        if (strippedVersion.contains("~")) {
            return strippedVersion.substring(0, strippedVersion.indexOf("~"));
        }
        if (strippedVersion.contains("-")) {
            return strippedVersion.substring(0, strippedVersion.indexOf("-"));
        }
        if (strippedVersion.contains(".RELEASE")) {
            return strippedVersion.substring(0, strippedVersion.indexOf(".RELEASE"));
        }
        if (strippedVersion.contains(".FINAL")) {
            return strippedVersion.substring(0, strippedVersion.indexOf(".FINAL"));
        }
        if (strippedVersion.contains(".Release")) {
            return strippedVersion.substring(0, strippedVersion.indexOf(".Release"));
        }
        if (strippedVersion.contains(".Final")) {
            return strippedVersion.substring(0, strippedVersion.indexOf(".Final"));
        }
        return strippedVersion;
    }
}

