/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.other.vad;

import com.metaeffekt.artifact.analysis.dashboard.Sheet;
import com.metaeffekt.artifact.analysis.dashboard.SheetParagraph;
import com.metaeffekt.artifact.analysis.dashboard.SvgIcon;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.keywords.KeywordSet;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.score.VulnerabilityPriorityCalculator;
import com.metaeffekt.artifact.enrichment.other.vad.VulnerabilityAssessmentDashboard;
import com.metaeffekt.mirror.contents.eol.EolCycle;
import com.metaeffekt.mirror.contents.eol.export.CycleStateExtendedSupportInformationNotPresent;
import com.metaeffekt.mirror.contents.eol.export.CycleStateExtendedSupportInformationPresent;
import com.metaeffekt.mirror.contents.eol.export.CycleStateScenario;
import com.metaeffekt.mirror.contents.eol.export.ExportedCycleState;
import com.metaeffekt.mirror.contents.kev.KevData;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.SpanTag;
import j2html.tags.specialized.TableTag;
import j2html.tags.specialized.TrTag;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import org.apache.commons.lang3.tuple.Triple;
import org.metaeffekt.core.security.cvss.CvssSeverityRanges;
import org.metaeffekt.core.util.ColorScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VadPriorityScoreSection {
    private static final Logger log = LoggerFactory.getLogger(VadPriorityScoreSection.class);

    public SheetParagraph createParagraphPriority(VulnerabilityAssessmentDashboard dashboard, Vulnerability vulnerability, Sheet vulnerabilitySheet) {
        VulnerabilityPriorityCalculator.PriorityScoreResult priorityScoreResult = vulnerability.calculatePriorityScore(dashboard.getSecurityPolicyConfiguration());
        SheetParagraph priorityParagraph = new SheetParagraph();
        priorityParagraph.setTitle("Vulnerability Prioritization");
        priorityParagraph.setIdentifier("Vulnerability Prioritization");
        DomContent cvssReasoning = VadPriorityScoreSection.getCvssReasoning(priorityScoreResult);
        DomContent keywordReasoning = VadPriorityScoreSection.getKeywordReasoning(dashboard, priorityScoreResult);
        DomContent epssReasoning = VadPriorityScoreSection.getEpssReasoning(dashboard, priorityScoreResult);
        DomContent kevReasoning = VadPriorityScoreSection.getKevReasoning(dashboard, priorityScoreResult);
        DomContent eolReasoning = VadPriorityScoreSection.getEolReasoning(dashboard, priorityScoreResult);
        DomContent vulnerabilityStatusReasoning = VadPriorityScoreSection.getVulnerabilityStatusReasoning(dashboard, priorityScoreResult);
        List<Triple> scoresAndReasoning = Arrays.asList(Triple.of((Object)"CVSS Overall", (Object)cvssReasoning, (Object)priorityScoreResult.getCvssScore()), Triple.of((Object)"Keywords", (Object)keywordReasoning, (Object)priorityScoreResult.getKeywordScore()), Triple.of((Object)"EPSS (Exploit Probability Scoring System)", (Object)epssReasoning, (Object)priorityScoreResult.getEpssScore()), Triple.of((Object)"KEV (Known Exploited Vulnerabilities)", (Object)kevReasoning, (Object)priorityScoreResult.getKevScore()), Triple.of((Object)"EOL (End of Life)", (Object)eolReasoning, (Object)priorityScoreResult.getEolScore()), Triple.of((Object)"Vulnerability Assessment", (Object)vulnerabilityStatusReasoning, (Object)priorityScoreResult.getVulnerabilityStatusScore()));
        TableTag table = (TableTag)TagCreator.table().withClass("basic-table");
        priorityParagraph.with(new DomContent[]{table});
        table.with((DomContent)TagCreator.tr().with(new DomContent[]{TagCreator.th((String)"Score"), TagCreator.th((String)"Criteria")}));
        for (Triple scoreAndReasoning : scoresAndReasoning) {
            String title = (String)scoreAndReasoning.getLeft();
            DomContent reasoning = (DomContent)scoreAndReasoning.getMiddle();
            VulnerabilityPriorityCalculator.PriorityScoreResult.ScoreContributor score = (VulnerabilityPriorityCalculator.PriorityScoreResult.ScoreContributor)scoreAndReasoning.getRight();
            boolean isCvssSection = "CVSS Overall".equals(title);
            boolean shouldBeGenerallyHighlighted = score.hasEffect();
            boolean titleShouldBeHighlighted = shouldBeGenerallyHighlighted && !isCvssSection;
            table.with((DomContent)TagCreator.tr().with(new DomContent[]{TagCreator.td((String)String.valueOf(score)).withCondStyle(shouldBeGenerallyHighlighted, "color:var(--" + ColorScheme.STRONG_LIGHT_ORANGE.getCssRootName() + ");"), TagCreator.td((DomContent[])new DomContent[]{TagCreator.h3((DomContent[])new DomContent[]{titleShouldBeHighlighted ? TagCreator.span((DomContent[])new DomContent[]{SvgIcon.EXCLAMATION_TRIANGLE_FILL.getTag(13)}).withStyle("color:var(--" + ColorScheme.STRONG_YELLOW.getCssRootName() + ");") : TagCreator.text((String)""), ((SpanTag)TagCreator.span((String)(" " + title)).withCondStyle(titleShouldBeHighlighted, "color:var(--" + ColorScheme.STRONG_LIGHT_ORANGE.getCssRootName() + ");")).withCondStyle(isCvssSection, "color:var(--" + ColorScheme.STRONG_YELLOW.getCssRootName() + ");")}).withStyle("margin-top:.7rem;margin-bottom:.5rem;"), reasoning}).withStyle("padding-bottom:.5rem;padding-left:.7rem;")}));
        }
        CvssSeverityRanges.SeverityRange priorityScoreSeverityRange = dashboard.getSecurityPolicyConfiguration().getPriorityScoreSeverityRanges().getRange(priorityScoreResult.getResultingScore());
        table.with(new DomContent[]{TagCreator.tr().with(new DomContent[]{TagCreator.td(), TagCreator.td()}), ((TrTag)TagCreator.tr().with(new DomContent[]{TagCreator.td((DomContent[])new DomContent[]{TagCreator.b((String)String.valueOf(priorityScoreResult.getResultingScore()))}), (DomContent)TagCreator.iffElse((boolean)priorityScoreResult.isElevated(), (Object)TagCreator.td((DomContent[])new DomContent[]{TagCreator.text((String)"Priority: "), TagCreator.b((String)priorityScoreSeverityRange.getName())}), (Object)TagCreator.td((DomContent[])new DomContent[]{TagCreator.text((String)"Priority not further elevated.")}))})).withStyle("color:var(--" + priorityScoreSeverityRange.getColor().getCssRootName() + ");")});
        vulnerabilitySheet.addNavigationEntry(VulnerabilityAssessmentDashboard.NavigationHeaders.NAVIGATION_PRIORITY_SCORE.getTitle(), priorityScoreResult.getResultingScore(), (Object)(priorityScoreResult.isElevated() ? null : "override_gray"));
        if (priorityScoreResult.isElevated()) {
            vulnerabilitySheet.addNavigationEntry(VulnerabilityAssessmentDashboard.NavigationHeaders.NAVIGATION_PRIORITY_SCORE_LABEL.getTitle(), priorityScoreSeverityRange.getName());
        } else {
            vulnerabilitySheet.addNavigationEntry(VulnerabilityAssessmentDashboard.NavigationHeaders.NAVIGATION_PRIORITY_SCORE_LABEL.getTitle(), "");
        }
        return priorityParagraph;
    }

    private static DomContent getCvssReasoning(VulnerabilityPriorityCalculator.PriorityScoreResult priorityScoreResult) {
        if (priorityScoreResult.getCalculator().getBaseCvssVector() == null) {
            return TagCreator.text((String)"There is no CVSS vector available to serve as base priority score.");
        }
        return TagCreator.join((Object[])new Object[]{TagCreator.b((String)priorityScoreResult.getCalculator().getBaseCvssVector().getCombinedCvssSource(true)), TagCreator.text((String)"provides the vector:"), TagCreator.br(), ((ATag)TagCreator.a((String)priorityScoreResult.getCalculator().getBaseCvssVector().toString()).withHref(priorityScoreResult.getCalculator().getBaseCvssVector().getAeUniversalWebEditorLink().generateOptimizedLink())).withTarget(VulnerabilityAssessmentDashboard.HrefTargets.TARGET_CVSS_DETAILS.getTarget())});
    }

    private static DomContent getKeywordReasoning(VulnerabilityAssessmentDashboard dashboard, VulnerabilityPriorityCalculator.PriorityScoreResult priorityScoreResult) {
        if (priorityScoreResult.getCalculator().getKeywords() == null || priorityScoreResult.getCalculator().getKeywords().getKeywordSets().isEmpty()) {
            return TagCreator.text((String)"No keyword sets were matched.");
        }
        List<KeywordSet> matchedKeywords = priorityScoreResult.getCalculator().getKeywords().getKeywordSets();
        DivTag keywordListTag = TagCreator.div();
        for (KeywordSet keywordEntry : matchedKeywords) {
            keywordListTag.with(new DomContent[]{TagCreator.span().with(new DomContent[]{(DomContent)TagCreator.iff((keywordEntry.getCategory() != null ? 1 : 0) != 0, (Object)dashboard.makeBadge(keywordEntry.getCategory(), "primary")), (DomContent)TagCreator.iff((keywordEntry.getScore() != null ? 1 : 0) != 0, (Object)dashboard.makeBadge(String.valueOf(keywordEntry.getScore()), "primary")), (DomContent)TagCreator.iff((keywordEntry.getName() != null ? 1 : 0) != 0, (Object)TagCreator.b((String)keywordEntry.getName())), (DomContent)TagCreator.iff((keywordEntry.getNotes() != null && !keywordEntry.getNotes().isEmpty() ? 1 : 0) != 0, (Object)TagCreator.join((Object[])new Object[]{":", TagCreator.br(), TagCreator.span((String)keywordEntry.getNotes()).withStyle("padding-left:1rem;")}))}), (DomContent)TagCreator.iff((matchedKeywords.indexOf(keywordEntry) < matchedKeywords.size() - 1 ? 1 : 0) != 0, (Object)TagCreator.br())});
        }
        return keywordListTag;
    }

    private static DomContent getEpssReasoning(VulnerabilityAssessmentDashboard dashboard, VulnerabilityPriorityCalculator.PriorityScoreResult priorityScoreResult) {
        if (priorityScoreResult.getCalculator().getEpssData() == null) {
            return TagCreator.text((String)"No EPSS score is available.");
        }
        String scoreColor = "color: var(--" + dashboard.getEpssScoreColor(priorityScoreResult.getCalculator().getEpssData().getEpssScore()) + ");";
        float scorePercent = priorityScoreResult.getCalculator().getEpssData().getEpssScore() * 100.0f;
        return TagCreator.span((DomContent[])new DomContent[]{TagCreator.text((String)"This vulnerability has a "), TagCreator.b((String)String.format("%.2f", Float.valueOf(scorePercent))).withStyle(scoreColor), TagCreator.span((String)"%").withStyle(scoreColor), TagCreator.text((String)" chance of being exploited in the next 30 days according to FIRST. "), TagCreator.text((String)"It ranks in the top "), TagCreator.b((String)String.format("%.3f%%", Float.valueOf(100.0f - priorityScoreResult.getCalculator().getEpssData().getPercentile() * 100.0f))), TagCreator.text((String)" of all scored vulnerabilities."), TagCreator.br(), TagCreator.hr().withClass("half-br"), TagCreator.text((String)"The EPSS (Exploit Probability Scoring System) is a probabilistic scoring model, created by "), dashboard.makeHTMLLink("FIRST", "https://www.first.org/epss", VulnerabilityAssessmentDashboard.HrefTargets.TARGET_REFERENCE.getTarget()), TagCreator.text((String)" (Forum of Incident Response and Security Teams), for estimating the likelihood that a software vulnerability will be exploited in the wild.")});
    }

    private static DomContent getKevReasoning(VulnerabilityAssessmentDashboard dashboard, VulnerabilityPriorityCalculator.PriorityScoreResult priorityScoreResult) {
        if (priorityScoreResult.getCalculator().getKevData() == null) {
            return TagCreator.text((String)"This vulnerability has not been confirmed to have been exploited in the wild.");
        }
        KevData kevData = priorityScoreResult.getCalculator().getKevData();
        StringJoiner vendorProductBuilder = new StringJoiner(": ");
        if (kevData.getVendor() != null) {
            vendorProductBuilder.add(kevData.getVendor());
        }
        if (kevData.getProduct() != null) {
            vendorProductBuilder.add(kevData.getProduct());
        }
        return TagCreator.span((DomContent[])new DomContent[]{TagCreator.text((String)"This vulnerability, affecting "), TagCreator.b((String)vendorProductBuilder.toString()), TagCreator.text((String)", has been "), TagCreator.b((String)"confirmed to have been exploited in the wild").withStyle("color: var(--" + ColorScheme.STRONG_LIGHT_ORANGE.getCssRootName() + ");"), TagCreator.text((String)"."), TagCreator.br(), kevData.getRansomwareState() == KevData.RansomwareState.KNOWN ? TagCreator.join((Object[])new Object[]{TagCreator.text((String)"Furthermore, it has been "), TagCreator.b((String)"identified in ransomware campaigns").withStyle("color: var(--" + ColorScheme.STRONG_RED.getCssRootName() + ");"), TagCreator.text((String)"."), TagCreator.br()}) : null, TagCreator.hr().withClass("half-br"), TagCreator.div((DomContent[])new DomContent[]{kevData.getSummary() != null ? TagCreator.span((DomContent[])new DomContent[]{TagCreator.text((String)kevData.getSummary()), TagCreator.br()}).withStyle("text-decoration:underline;") : null, kevData.getRecommendation() != null ? TagCreator.span((DomContent[])new DomContent[]{dashboard.generateATagsForHyperlinks(kevData.getRecommendation(), VulnerabilityAssessmentDashboard.HrefTargets.TARGET_KEV.getTarget()), TagCreator.br()}) : null, kevData.getNotes() != null ? TagCreator.span((DomContent[])new DomContent[]{TagCreator.b((String)"Notes: "), dashboard.generateATagsForHyperlinks(kevData.getNotes(), VulnerabilityAssessmentDashboard.HrefTargets.TARGET_KEV.getTarget()), TagCreator.br()}) : null}).withStyle("padding-left:1rem"), TagCreator.hr().withClass("half-br"), kevData.getDueDate() != null ? TagCreator.span((DomContent[])new DomContent[]{TagCreator.b((String)"Due Date: "), TagCreator.text((String)TimeUtils.formatNormalizedDate(kevData.getDueDate())), TagCreator.br()}) : null, kevData.getPublishDate() != null ? TagCreator.span((DomContent[])new DomContent[]{TagCreator.b((String)"Publish Date: "), TagCreator.text((String)TimeUtils.formatNormalizedDate(kevData.getPublishDate())), TagCreator.br()}) : null, kevData.getExploitDate() != null ? TagCreator.span((DomContent[])new DomContent[]{TagCreator.b((String)"Exploit Date: "), TagCreator.text((String)TimeUtils.formatNormalizedDate(kevData.getExploitDate())), TagCreator.br()}) : null});
    }

    private static DomContent getEolReasoning(VulnerabilityAssessmentDashboard dashboard, VulnerabilityPriorityCalculator.PriorityScoreResult priorityScoreResult) {
        String supportStatus;
        if (priorityScoreResult.getCalculator().getEolData() == null || priorityScoreResult.getCalculator().getEolData().isEmpty() || priorityScoreResult.getSelectedEolData() == null) {
            return TagCreator.text((String)"No EOL information is available.");
        }
        ExportedCycleState cycleState = priorityScoreResult.getSelectedEolData();
        String product = cycleState.getCycle().getProduct();
        String version = cycleState.getCycle().getCycle();
        String regularSupportEndDate = EolCycle.formatTimeUntilOrAgo(cycleState.getSupportMillis());
        String extendedSupportEndDate = EolCycle.formatTimeUntilOrAgo(cycleState.getExtendedSupportMillis());
        if (cycleState.getCycleStateScenario() == CycleStateScenario.EXTENDED_SUPPORT_NOT_PRESENT) {
            CycleStateExtendedSupportInformationNotPresent info = cycleState.getCycleStateExtendedSupportInformationNotPresent();
            switch (info) {
                case SUPPORT_VALID: {
                    supportStatus = "is still supported by it's vendor";
                    break;
                }
                case SUPPORT_ENDING_SOON: {
                    supportStatus = "is still supported by it's vendor, but support will be ending soon";
                    break;
                }
                case SUPPORT_EXPIRED: {
                    supportStatus = "is no longer supported by it's vendor";
                    break;
                }
                default: {
                    supportStatus = "unknown";
                    break;
                }
            }
        } else {
            CycleStateExtendedSupportInformationPresent info = cycleState.getCycleStateExtendedSupportInformationPresent();
            switch (info) {
                case SUPPORT_VALID: {
                    supportStatus = "is still supported by it's vendor";
                    break;
                }
                case SUPPORT_ENDING_SOON: {
                    supportStatus = "is still supported by it's vendor, but regular support will be ending soon and extended support will be starting";
                    break;
                }
                case EXTENDED_SUPPORT_VALID: {
                    supportStatus = "is still supported by it's vendor with extended support";
                    break;
                }
                case EXTENDED_SUPPORT_ENDING_SOON: {
                    supportStatus = "is still supported by it's vendor with extended support, but extended support will be ending soon";
                    break;
                }
                case EXTENDED_SUPPORT_EXPIRED: {
                    supportStatus = "is no longer supported by it's vendor";
                    break;
                }
                default: {
                    supportStatus = "unknown";
                }
            }
        }
        return TagCreator.div((DomContent[])new DomContent[]{TagCreator.b((DomContent[])new DomContent[]{((ATag)TagCreator.a((String)product).withHref("https://endoflife.date/" + product)).withTarget(VulnerabilityAssessmentDashboard.HrefTargets.TARGET_EOL_DATE.getTarget()), TagCreator.text((String)(" (ver. " + version + ") "))}), TagCreator.text((String)(supportStatus + ".")), TagCreator.br(), TagCreator.text((String)("Support End Date: " + regularSupportEndDate)), TagCreator.br(), (DomContent)TagCreator.iffElse((cycleState.getCycleStateScenario() == CycleStateScenario.EXTENDED_SUPPORT_INFORMATION_PRESENT ? 1 : 0) != 0, (Object)TagCreator.text((String)("Extended Support End Date: " + extendedSupportEndDate)), (Object)TagCreator.text((String)"Vendor does not provide extended support for this product."))});
    }

    public static DomContent getVulnerabilityStatusReasoning(VulnerabilityAssessmentDashboard dashboard, VulnerabilityPriorityCalculator.PriorityScoreResult priorityScoreResult) {
        if (priorityScoreResult.getCalculator().getVulnerabilityStatus() == null || StringUtils.isEmpty(priorityScoreResult.getCalculator().getVulnerabilityStatus().getStatus())) {
            return TagCreator.text((String)"No status information is available.");
        }
        String status = priorityScoreResult.getCalculator().getVulnerabilityStatus().getStatus();
        return TagCreator.span((DomContent[])new DomContent[]{TagCreator.text((String)"This vulnerability is in status: "), TagCreator.b((String)status), TagCreator.text((String)".")});
    }
}

