/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.validation.reason;

import com.metaeffekt.artifact.enrichment.validation.reason.ReasonIdentifier;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;

public class InventoryValidationReason {
    private final AbstractModelBase source;
    private final String text;
    private final ReasonIdentifier reason;

    public InventoryValidationReason(AbstractModelBase source, ReasonIdentifier reason, String text) {
        this.source = source;
        this.text = text;
        this.reason = reason;
    }

    public InventoryValidationReason(ReasonIdentifier reason, String text) {
        this(null, reason, text);
    }

    public String getText() {
        return this.text;
    }

    public ReasonIdentifier getReason() {
        return this.reason;
    }

    public AbstractModelBase getSource() {
        return this.source;
    }

    private String getSourceName() {
        if (this.source == null) {
            return null;
        }
        if (this.source instanceof Artifact) {
            return "Id=" + ((Artifact)this.source).get(Artifact.Attribute.ID);
        }
        if (this.source instanceof VulnerabilityMetaData) {
            return "Name=" + ((VulnerabilityMetaData)this.source).get(VulnerabilityMetaData.Attribute.NAME);
        }
        return "class=" + this.source.getClass().getSimpleName();
    }

    public String toString() {
        String sourceName;
        StringBuilder sb = new StringBuilder();
        if (this.reason.getLongDescription() != null) {
            sb.append("[").append(this.reason.ordinal()).append("] ");
        }
        if (this.reason.getShortDescription() != null) {
            sb.append(this.reason.getShortDescription());
        }
        if ((sourceName = this.getSourceName()) != null) {
            sb.append(" [").append(sourceName).append("]:\n");
        } else {
            sb.append(":\n");
        }
        sb.append(this.text);
        return sb.toString();
    }
}

