/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.validation.reason;

import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;

public enum ReasonIdentifier {
    ADDITIONAL_CPE_NOT_EFFECTIVE("'" + InventoryAttribute.ADDITIONAL_CPE.getKey() + "' is not effective", "The artifact has at least one '" + InventoryAttribute.ADDITIONAL_CPE.getKey() + "' that does not appear in the effective CPE URIs.\nThis is most likely an error in a correlation file, where an '" + InventoryAttribute.INAPPLICABLE_CPE.getKey() + "' is specified on the same artifact that removes the CPE."),
    VULNERABILITY_HAS_MULTIPLE_ARTIFACT_VERSIONS("Vulnerability has multiple artifact versions", "The vulnerability has multiple artifact versions. In many cases, this is fine. Check manually however, if this is a problem."),
    ARTIFACT_AND_CPE_VERSIONS_DIFFER_GREATLY("Artifact and CPE versions differ greatly", "Possible version mismatch: Please ensure that the artifact versions are correct and compatible with the version range specified in the associated CPEs.\nIf there is a discrepancy, consider adjusting the artifact version or removing an incompatible CPE entry.\nKeep in mind that the CPE data from NVD may not always be up-to-date, which can sometimes lead to compatibility issues. This is therefore one of the validators that produces the most output."),
    VULNERABILITY_CONTAINS_ILLEGAL_CHARACTER("Vulnerability contains illegal character", "The vulnerability name contains an illegal character.\nFind the vulnerability identifier and trace it back to the source.\nCheck your status-, correlation- and custom vulnerability-files or even vulnerability providers.");

    private final String shortDescription;
    private final String longDescription;

    private ReasonIdentifier(String shortDescription, String longDescription) {
        this.shortDescription = shortDescription;
        this.longDescription = longDescription;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }
}

