/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.validation.validators;

import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import com.metaeffekt.artifact.enrichment.validation.VulnerabilityInventoryValidator;
import com.metaeffekt.artifact.enrichment.validation.reason.InventoryValidationReason;
import com.metaeffekt.artifact.enrichment.validation.reason.ReasonIdentifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleArtifactsAndVersionsOnVulnerabilityInventoryValidator
extends VulnerabilityInventoryValidator {
    private static final Logger log = LoggerFactory.getLogger(MultipleArtifactsAndVersionsOnVulnerabilityInventoryValidator.class);
    private String versionLevel = "patch";

    public void setVersionLevel(String versionLevel) {
        if (!("major".equals(versionLevel) || "minor".equals(versionLevel) || "patch".equals(versionLevel))) {
            throw new IllegalArgumentException("Unknown version level: " + versionLevel);
        }
        this.versionLevel = versionLevel;
    }

    public void setVersionLevel(VersionLevel versionLevel) {
        this.versionLevel = versionLevel.name().toLowerCase();
    }

    public String getVersionLevel() {
        return this.versionLevel;
    }

    @Override
    public List<InventoryValidationReason> validate(Inventory inventory, VulnerabilityMetaData vmd) {
        this.setVersionLevel(this.getVersionLevel());
        ArrayList<InventoryValidationReason> validationFailReasons = new ArrayList<InventoryValidationReason>();
        List<Artifact> artifacts = this.getArtifacts(inventory, vmd);
        Set artifactVersions = artifacts.stream().map(Artifact::getVersion).map(this::getVersionOnLevel).collect(Collectors.toSet());
        if (artifactVersions.size() > 1) {
            validationFailReasons.add(new InventoryValidationReason((AbstractModelBase)vmd, ReasonIdentifier.VULNERABILITY_HAS_MULTIPLE_ARTIFACT_VERSIONS, "Vulnerability [" + vmd.get(VulnerabilityMetaData.Attribute.NAME) + "] has multiple artifact versions: " + artifactVersions));
        }
        return validationFailReasons;
    }

    private String getVersionOnLevel(String version) {
        if (version == null) {
            return null;
        }
        String[] split = version.split("\\D+");
        int[] versionNumbers = Arrays.stream(split).filter(s -> s.matches("\\d+")).mapToInt(Integer::parseInt).toArray();
        if (versionNumbers.length == 0) {
            log.warn("No numeric version numbers found in version string for comparison: {}", (Object)version);
            return null;
        }
        switch (this.versionLevel) {
            case "major": {
                return String.valueOf(versionNumbers[0]);
            }
            case "minor": {
                if (versionNumbers.length < 2) {
                    return versionNumbers[0] + ".0";
                }
                return versionNumbers[0] + "." + versionNumbers[1];
            }
            case "patch": {
                if (versionNumbers.length < 2) {
                    return versionNumbers[0] + ".0.0";
                }
                if (versionNumbers.length < 3) {
                    return versionNumbers[0] + "." + versionNumbers[1] + ".0";
                }
                return versionNumbers[0] + "." + versionNumbers[1] + "." + versionNumbers[2];
            }
        }
        throw new IllegalArgumentException("Unknown version level: " + this.versionLevel);
    }

    private List<Artifact> getArtifacts(Inventory inventory, VulnerabilityMetaData vmd) {
        return inventory.getArtifacts().stream().filter(artifact -> InventoryEnricher.splitVulnerabilitiesCsv(artifact.getVulnerability()).contains(vmd.get(VulnerabilityMetaData.Attribute.NAME))).collect(Collectors.toList());
    }

    @Override
    public String getValidatorName() {
        return "Multiple artifacts and versions on vulnerability";
    }

    @Override
    public LinkedHashMap<String, Object> getProperties() {
        LinkedHashMap<String, Object> properties = super.getProperties();
        properties.put("versionLevel", this.getVersionLevel());
        return properties;
    }

    @Override
    public void setProperties(LinkedHashMap<String, Object> properties) {
        if (properties.containsKey("versionLevel")) {
            this.setVersionLevel(String.valueOf(properties.get("versionLevel")));
        }
    }

    public static enum VersionLevel {
        MAJOR,
        MINOR,
        PATCH;

    }
}

