/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.vulnerability;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.warnings.InventoryWarningEntry;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.warnings.InventoryWarnings;
import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import com.metaeffekt.artifact.enrichment.configurations.CpeDerivationEnrichmentConfiguration;
import com.metaeffekt.artifact.enrichment.vulnerability.CpeDerivationUtilities;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnricherMetadata(name="CPE URI derivation", phase=InventoryEnrichmentPhase.PRODUCT_IDENTIFICATION, intermediateFileSuffix="cpe-derived", mavenPropertyName="cpeDerivationEnrichment")
public class CpeDerivationEnrichment
extends InventoryEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(CpeDerivationEnrichment.class);
    private CpeDerivationEnrichmentConfiguration configuration = new CpeDerivationEnrichmentConfiguration();
    private CpeDerivationUtilities cpeDerivationUtilities;

    public CpeDerivationEnrichment(File baseMirrorDirectory) {
        this.executor.setSize(16);
        this.cpeDerivationUtilities = new CpeDerivationUtilities(baseMirrorDirectory);
    }

    @Override
    public CpeDerivationEnrichmentConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    protected void performEnrichment(Inventory inventory) {
        AtomicInteger progress = new AtomicInteger(0);
        AtomicInteger skippedArtifacts = new AtomicInteger(0);
        this.cpeDerivationUtilities.setConfiguration(this.configuration);
        List artifacts = inventory.getArtifacts();
        final HashMap startTimes = new HashMap();
        for (Artifact artifact : artifacts) {
            if (!artifact.is(InventoryAttribute.ACTIVATE_CPE_URI_DERIVATION.getKey(), true)) {
                skippedArtifacts.incrementAndGet();
                continue;
            }
            if (!this.isValidForEnrichment(artifact)) {
                LOG.info("Missing required information on artifact [{}], skipping CPE URI derivation", (Object)artifact.getId());
                new InventoryWarnings(inventory).addArtifactWarning(new InventoryWarningEntry<Artifact>(artifact, "Cannot perform CPE URI derivation, missing required information.", this.getEnrichmentName()));
                skippedArtifacts.incrementAndGet();
                continue;
            }
            this.executor.submit(() -> {
                int currentElement = progress.incrementAndGet();
                if (currentElement % 100 == 0 && currentElement > 0) {
                    LOG.info("Deriving CPE URIs for artifact [{} / {}]", (Object)currentElement, (Object)inventory.getArtifacts().size());
                }
                Map map = startTimes;
                synchronized (map) {
                    startTimes.put(artifact, System.currentTimeMillis());
                }
                this.cpeDerivationUtilities.deriveCpeUris(inventory, artifact);
                map = startTimes;
                synchronized (map) {
                    startTimes.remove(artifact);
                }
            });
        }
        TimerTask checkArtifactTimerTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long currentTime = System.currentTimeMillis();
                Map map = startTimes;
                synchronized (map) {
                    List longRunningArtifacts = startTimes.entrySet().stream().filter(e -> currentTime - (Long)e.getValue() >= 30000L).sorted((o1, o2) -> ((Long)o2.getValue()).compareTo((Long)o1.getValue())).collect(Collectors.toList());
                    if (!longRunningArtifacts.isEmpty()) {
                        LOG.warn("CPE URI derivation is taking longer than 30 seconds for [{}] artifacts: {}", (Object)longRunningArtifacts.size(), (Object)longRunningArtifacts.stream().map(Map.Entry::getKey).map(Artifact::getId).collect(Collectors.joining(", ")));
                    }
                }
            }
        };
        Timer checkArtifactTimer = new Timer();
        checkArtifactTimer.schedule(checkArtifactTimerTask, 30000L, 30000L);
        this.executor.start();
        try {
            this.executor.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for CPE URI derivation to finish", e);
        }
        checkArtifactTimer.cancel();
        if (skippedArtifacts.get() > 0) {
            LOG.info("Skipped [{}] artifacts due to missing required information or deactivation via [{}]", (Object)skippedArtifacts.get(), (Object)InventoryAttribute.ACTIVATE_CPE_URI_DERIVATION.getKey());
        }
    }

    private boolean isValidForEnrichment(Artifact artifact) {
        return StringUtils.hasText(artifact.getId()) || StringUtils.hasText(artifact.getComponent()) || StringUtils.hasText(artifact.get("Organization")) || "*".equalsIgnoreCase(artifact.getVersion());
    }

    public void setConfiguration(CpeDerivationEnrichmentConfiguration configuration) {
        this.configuration = configuration;
    }
}

