/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.vulnerability;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.metaeffekt.artifact.analysis.dashboard.Dashboard;
import com.metaeffekt.artifact.analysis.utils.CustomCollectors;
import com.metaeffekt.artifact.analysis.utils.LazySupplier;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.vulnerability.CommonEnumerationUtil;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.warnings.InventoryWarningEntry;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.warnings.InventoryWarnings;
import com.metaeffekt.artifact.enrichment.configurations.CpeDerivationEnrichmentConfiguration;
import com.metaeffekt.mirror.query.NvdCpeApiIndexQuery;
import com.metaeffekt.mirror.query.NvdCpeApiVendorProductIndexQuery;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.values.Part;

public class CpeDerivationUtilities {
    private static final Logger log = LoggerFactory.getLogger(CpeDerivationUtilities.class);
    private static final Set<String> UNSPECIFIC_PRODUCTS;
    private final LazySupplier<NvdCpeApiIndexQuery> cpeDictionary;
    private final LazySupplier<NvdCpeApiVendorProductIndexQuery> cpeDictionaryVendorProduct;
    private CpeDerivationEnrichmentConfiguration configuration = new CpeDerivationEnrichmentConfiguration();
    private Set<String> topVpTerms = new HashSet<String>();
    private long topVpTermsHash = 0L;
    private final List<Function<Collection<Alias>, List<AliasMatchingResultsVendorProducts>>> VENDOR_PRODUCT_MATCHING_FUNCTIONS_FALLBACK_ORDER = Arrays.asList(this::matchVendorProductsFromAliases, this::matchProductsFromAliasesIgnoreUnderscoreRemoveUnspecific, this::matchVendorProductsFuzzyFromAliases);

    public CpeDerivationUtilities(File baseMirrorDirectory) {
        this.cpeDictionary = new LazySupplier<NvdCpeApiIndexQuery>(() -> new NvdCpeApiIndexQuery(baseMirrorDirectory));
        this.cpeDictionaryVendorProduct = new LazySupplier<NvdCpeApiVendorProductIndexQuery>(() -> new NvdCpeApiVendorProductIndexQuery(baseMirrorDirectory));
    }

    public void deriveCpeUris(Artifact artifact) {
        this.deriveCpeUris(null, artifact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deriveCpeUris(Inventory inventory, Artifact artifact) {
        Set<String> set = this.topVpTerms;
        synchronized (set) {
            if (this.topVpTerms.isEmpty() || this.topVpTermsHash != (long)this.configuration.getRequireSecondaryIndicationTermsLimiters().hashCode()) {
                this.topVpTerms = ((NvdCpeApiVendorProductIndexQuery)this.cpeDictionaryVendorProduct.get()).findTopVpTerms(this.configuration.getRequireSecondaryIndicationTermsLimiters()).keySet();
                this.topVpTermsHash = this.configuration.getRequireSecondaryIndicationTermsLimiters().hashCode();
            }
        }
        boolean isHardware = artifact.isHardware();
        List<Alias> aliases = this.deriveArtifactAliases(artifact);
        List<AliasMatchingResultsVendorProducts> matchedVendorProducts = this.matchAliasesToVendorProducts(aliases);
        Set<Cpe> derivedCpeUris = this.findVersionSpecificCpeUrisFromVendorProducts(matchedVendorProducts, isHardware, cpes -> {
            log.warn("Max correlated CPE URIs limit reached on [{} : {}], limiting to [{}]", new Object[]{artifact.getId(), artifact.getComponent(), this.configuration.getMaxCorrelatedCpePerArtifact()});
            if (inventory != null) {
                this.addInventoryWarningAboutTooManyCpeUris(inventory, artifact, (Collection<Cpe>)cpes);
            }
        });
        List sortedDerivedCpeUris = derivedCpeUris.stream().sorted(Cpe::compareTo).collect(Collectors.toList());
        String finalCpeString = sortedDerivedCpeUris.stream().limit(this.configuration.getMaxCorrelatedCpePerArtifact()).map(CommonEnumerationUtil::toCpe22UriOrFallbackToCpe23FS).collect(Collectors.joining(", "));
        if (!finalCpeString.isEmpty()) {
            artifact.set(InventoryAttribute.DERIVED_CPE_URIS.getKey(), finalCpeString);
        } else {
            artifact.set(InventoryAttribute.DERIVED_CPE_URIS.getKey(), null);
        }
        if (this.configuration.isAddDetailedMatchingInformation()) {
            artifact.set(InventoryAttribute.DERIVED_CPE_URIS_MATCHING_DETAILS.getKey(), matchedVendorProducts.stream().map(AliasMatchingResultsVendorProducts::toJson).collect(CustomCollectors.toJsonArray()).toString());
        } else {
            artifact.set(InventoryAttribute.DERIVED_CPE_URIS_MATCHING_DETAILS.getKey(), null);
        }
    }

    private void addInventoryWarningAboutTooManyCpeUris(Inventory inventory, Artifact artifact, Collection<Cpe> sortedDerivedCpeUris) {
        if (sortedDerivedCpeUris.size() > this.configuration.getMaxCorrelatedCpePerArtifact()) {
            log.warn("Max correlated CPE URIs limit reached, reducing [{}] CPEs to [{}]", (Object)sortedDerivedCpeUris.size(), (Object)this.configuration.getMaxCorrelatedCpePerArtifact());
            if (inventory != null) {
                new InventoryWarnings(inventory).addArtifactWarning(new InventoryWarningEntry<Artifact>(artifact, String.format("Max correlated CPE URIs limit reached, reducing [%d] CPEs to [%d]", sortedDerivedCpeUris.size(), this.configuration.getMaxCorrelatedCpePerArtifact()), "CPE URI derivation"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Alias> deriveArtifactAliases(Artifact artifact) {
        HashSet<Alias> aliases = new HashSet<Alias>();
        for (Map.Entry<String, String> entry : this.fetchArtifactValues(artifact, Arrays.asList(Artifact.Attribute.COMPONENT.getKey(), Artifact.Attribute.GROUPID.getKey(), Artifact.Attribute.ID.getKey(), "Organization")).entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            aliases.addAll(Alias.toAliases(this.deriveProductAliases(this.preprocessProduct(value)), key, value));
            aliases.add(new Alias(value, key, value));
        }
        aliases.addAll(Alias.toAliases(this.deriveProductAliases(this.preprocessProduct(artifact.getArtifactId())), "artifact-id", artifact.getArtifactId()));
        aliases.addAll(Alias.toAliases(this.deriveAliasesFromPurl(artifact.get(InventoryAttribute.PURL.getKey())), InventoryAttribute.PURL.getKey(), artifact.get(InventoryAttribute.PURL.getKey())));
        aliases.addAll(Alias.toAliases(this.deriveAliasesFromPurl(artifact.get(InventoryAttribute.DT_PURL_FINDINGS.getKey())), InventoryAttribute.DT_PURL_FINDINGS.getKey(), artifact.get(InventoryAttribute.DT_PURL_FINDINGS.getKey())));
        aliases.removeIf(this::isInvalidQueryAlias);
        Set<String> set = this.topVpTerms;
        synchronized (set) {
            for (Alias alias : aliases) {
                if (!this.topVpTerms.contains(alias.getAlias()) && !this.topVpTerms.contains(alias.getAlias().toLowerCase())) continue;
                alias.setRequireOtherIndication(true);
            }
        }
        return aliases.stream().sorted().collect(Collectors.toList());
    }

    private Map<String, String> fetchArtifactValues(Artifact artifact, List<String> keys) {
        HashMap<String, String> values = new HashMap<String, String>();
        for (String key : keys) {
            String value = artifact.get(key);
            if (!StringUtils.hasText(value)) continue;
            values.put(key, value);
        }
        return values;
    }

    private boolean isInvalidQueryAlias(Alias a) {
        String alias = a.getAlias();
        if (StringUtils.isEmpty(alias)) {
            return true;
        }
        if (org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)alias)) {
            return true;
        }
        return alias.contains("\\");
    }

    protected Set<String> deriveAliasesFromPurl(String purl) {
        HashSet<String> aliases = new HashSet<String>();
        if (StringUtils.isEmpty(purl)) {
            return aliases;
        }
        try {
            PackageURL packageURL = new PackageURL(purl);
            if (StringUtils.hasText(packageURL.getName())) {
                aliases.add(packageURL.getName());
            }
        }
        catch (MalformedPackageURLException e) {
            log.warn("Could not parse PURL [{}]", (Object)purl);
        }
        return aliases;
    }

    protected Set<String> deriveProductAliases(String product) {
        int doubleUnderscoreIndex;
        if (product == null) {
            return Collections.emptySet();
        }
        HashSet<String> productAliases = new HashSet<String>();
        productAliases.add(product);
        productAliases.add(product.replace('-', '_'));
        productAliases.add(product.replace('_', '-'));
        productAliases.add(product.replace('_', ' '));
        productAliases.add(product.replace("_", ""));
        productAliases.add(product.replace("-", ""));
        productAliases.add(product.replace(' ', '_'));
        productAliases.add(product.replace(' ', '-'));
        productAliases.add(product.replace(" ", ""));
        productAliases.addAll(productAliases.stream().map(productAlias -> productAlias.replaceAll("[ _.-]?(x64|dll|jar)", "")).collect(Collectors.toSet()));
        productAliases.addAll(productAliases.stream().map(productAlias -> productAlias.replaceAll("[ _.-]?libs?", "")).collect(Collectors.toSet()));
        productAliases.addAll(productAliases.stream().map(productAlias -> productAlias.replaceAll("([ _.-]){2,}", "$1")).collect(Collectors.toSet()));
        productAliases.addAll(productAliases.stream().map(productAlias -> productAlias.replaceAll("(\\d|[ _.-])+$", "")).collect(Collectors.toSet()));
        productAliases.addAll(productAliases.stream().map(productAlias -> productAlias.replaceAll("[ _.-]*$", "")).collect(Collectors.toSet()));
        int dashIndex = product.indexOf("-");
        if (dashIndex > 3) {
            productAliases.addAll(this.deriveProductAliases(product.substring(0, dashIndex)));
        }
        if ((doubleUnderscoreIndex = product.indexOf("__")) > 3) {
            productAliases.addAll(this.deriveProductAliases(product.substring(0, doubleUnderscoreIndex)));
        }
        return productAliases;
    }

    protected String preprocessProduct(String product) {
        if (product == null) {
            return null;
        }
        product = product.trim().toLowerCase();
        String result = product.replace("-base", "");
        result = result.replace("-minimal", "");
        result = result.replace(".class", "");
        result = result.replace("\\$[0-9]*.class", "");
        result = result.replaceAll("-", "_");
        result = result.replaceAll("\\d*\\.[\\d._]+\\d+", "");
        result = result.replaceAll("\\[0-9\\._]*", "");
        result = result.replaceAll("_\\.v[\\d._]?.*", "");
        result = result.replaceAll("\\.", "_");
        while (result.endsWith(".") || result.endsWith("_") || result.endsWith("-")) {
            result = result.substring(0, result.length() - 1);
        }
        return result.trim();
    }

    private List<AliasMatchingResultsVendorProducts> matchAliasesToVendorProducts(Collection<Alias> aliases) {
        for (Function<Collection<Alias>, List<AliasMatchingResultsVendorProducts>> function : this.VENDOR_PRODUCT_MATCHING_FUNCTIONS_FALLBACK_ORDER) {
            List<AliasMatchingResultsVendorProducts> matchedVendorProducts = function.apply(aliases);
            if (matchedVendorProducts.isEmpty()) continue;
            return matchedVendorProducts;
        }
        return Collections.emptyList();
    }

    protected List<AliasMatchingResultsVendorProducts> matchVendorProductsFromAliases(Collection<Alias> aliases) {
        ArrayList<AliasMatchingResultsVendorProducts> vendorProductPairs = new ArrayList<AliasMatchingResultsVendorProducts>();
        NvdCpeApiVendorProductIndexQuery cpeDictionaryVendorProduct = (NvdCpeApiVendorProductIndexQuery)this.cpeDictionaryVendorProduct.get();
        AliasRequireOtherMatcher aliasRequireOtherMatcher = new AliasRequireOtherMatcher();
        for (Alias candidate : aliases) {
            String alias = candidate.getAlias();
            Set<String> vendorsForProduct = cpeDictionaryVendorProduct.findVendorsForProduct(alias);
            Set<String> productsForVendor = cpeDictionaryVendorProduct.findProductsForVendor(alias);
            if (vendorsForProduct.isEmpty() && productsForVendor.isEmpty() || !aliasRequireOtherMatcher.isMatching(candidate)) continue;
            for (String vendor : vendorsForProduct) {
                AliasMatchingResultsVendorProducts.addVendor(vendorProductPairs, vendor).addProduct(alias).addAlias(candidate, 0);
            }
            for (String product : productsForVendor) {
                AliasMatchingResultsVendorProducts.addVendor(vendorProductPairs, alias).addProduct(product).addAlias(candidate, 0);
            }
        }
        return vendorProductPairs;
    }

    protected List<AliasMatchingResultsVendorProducts> matchProductsFromAliasesIgnoreUnderscoreRemoveUnspecific(Collection<Alias> aliases) {
        ArrayList<AliasMatchingResultsVendorProducts> vendorProductPairs = new ArrayList<AliasMatchingResultsVendorProducts>();
        NvdCpeApiVendorProductIndexQuery cpeDictionaryVendorProduct = (NvdCpeApiVendorProductIndexQuery)this.cpeDictionaryVendorProduct.get();
        AliasRequireOtherMatcher aliasRequireOtherMatcher = new AliasRequireOtherMatcher();
        for (Alias candidate : aliases) {
            String alias = candidate.getAlias();
            for (Map.Entry<String, Set<String>> productVendors : cpeDictionaryVendorProduct.getProductVendorsMap().entrySet()) {
                String product = productVendors.getKey();
                if (UNSPECIFIC_PRODUCTS.contains(product) || !alias.equalsIgnoreCase(product) && !alias.startsWith(product + "_") && !alias.contains("_" + product + "_") && !alias.endsWith("_" + product)) continue;
                for (String vendor : productVendors.getValue()) {
                    if (UNSPECIFIC_PRODUCTS.contains(vendor) || !alias.equalsIgnoreCase(vendor) && !alias.startsWith(vendor + "_") && !alias.contains("_" + vendor + "_") && !alias.endsWith("_" + vendor) || !aliasRequireOtherMatcher.isMatching(candidate)) continue;
                    AliasMatchingResultsVendorProducts.addVendor(vendorProductPairs, vendor).addProduct(product).addAlias(candidate, 1);
                }
            }
        }
        return vendorProductPairs;
    }

    protected List<AliasMatchingResultsVendorProducts> matchVendorProductsFuzzyFromAliases(Collection<Alias> aliases) {
        Pair<String, List<AliasMatchingResultsProduct>> minAliasProducts;
        int totalProducts;
        int attemptRemovalCount;
        ArrayList<AliasMatchingResultsVendorProducts> vendorProductPairs = new ArrayList<AliasMatchingResultsVendorProducts>();
        NvdCpeApiVendorProductIndexQuery cpeDictionaryVendorProduct = (NvdCpeApiVendorProductIndexQuery)this.cpeDictionaryVendorProduct.get();
        AliasRequireOtherMatcher aliasRequireOtherMatcher = new AliasRequireOtherMatcher();
        for (Alias candidate : aliases) {
            String alias = candidate.getAlias();
            if (alias.trim().length() <= 4) continue;
            for (String vendor : this.findFirstVendorContainsAlias(cpeDictionaryVendorProduct, alias)) {
                if (UNSPECIFIC_PRODUCTS.contains(vendor)) continue;
                for (String product : cpeDictionaryVendorProduct.findProductsForVendor(vendor)) {
                    if (UNSPECIFIC_PRODUCTS.contains(product) || !aliasRequireOtherMatcher.isMatching(candidate)) continue;
                    AliasMatchingResultsVendorProducts.addVendor(vendorProductPairs, vendor).addProduct(product).addAlias(candidate, 2);
                }
            }
            for (String product : this.findFirstProductContainsAlias(cpeDictionaryVendorProduct, alias)) {
                if (UNSPECIFIC_PRODUCTS.contains(product)) continue;
                for (String vendor : cpeDictionaryVendorProduct.findVendorsForProduct(product)) {
                    if (UNSPECIFIC_PRODUCTS.contains(vendor) || !aliasRequireOtherMatcher.isMatching(candidate)) continue;
                    AliasMatchingResultsVendorProducts.addVendor(vendorProductPairs, vendor).addProduct(product).addAlias(candidate, 2);
                }
            }
        }
        int maxVendorProductPairs = 10;
        ArrayList<String> reducedVendors = new ArrayList<String>();
        while ((attemptRemovalCount = (totalProducts = vendorProductPairs.stream().mapToInt(vp -> vp.getProducts().size()).sum()) - 10) > 0 && !StringUtils.isEmpty((String)(minAliasProducts = CpeDerivationUtilities.fuzzyFromAliasGetMinCountResults(vendorProductPairs, reducedVendors)).getKey())) {
            reducedVendors.add((String)minAliasProducts.getKey());
            Map<AliasMatchingResultsProduct, Integer> distances = CpeDerivationUtilities.fuzzyFromAliasFindProductDistancesToAliasesLevenshtein((List)minAliasProducts.getValue(), vendorProductPairs);
            List orderedRemovalPriority = distances.entrySet().stream().sorted((o1, o2) -> Integer.compare((Integer)o2.getValue(), (Integer)o1.getValue())).limit(attemptRemovalCount).map(Map.Entry::getKey).collect(Collectors.toList());
            if (orderedRemovalPriority.isEmpty()) {
                log.warn("Could not find a vendor/product pair to remove, even though the limit was reached");
                break;
            }
            AliasMatchingResultsVendorProducts removeFrom = vendorProductPairs.stream().filter(vp -> vp.getVendor().equals(minAliasProducts.getKey())).findFirst().get();
            for (AliasMatchingResultsProduct toRemoveProduct : orderedRemovalPriority) {
                removeFrom.getProducts().removeIf(p -> p.getProduct().equals(toRemoveProduct.getProduct()));
                log.debug("Removed vendor/product pair [{} : {}] due to alias limit", (Object)removeFrom.getVendor(), (Object)toRemoveProduct.getProduct());
            }
        }
        return vendorProductPairs;
    }

    private static Pair<String, List<AliasMatchingResultsProduct>> fuzzyFromAliasGetMinCountResults(List<AliasMatchingResultsVendorProducts> vendorProductPairs, List<String> exclude) {
        int minAliases = Integer.MAX_VALUE;
        ArrayList<AliasMatchingResultsProduct> minAliasProducts = new ArrayList<AliasMatchingResultsProduct>();
        String vendor = null;
        for (AliasMatchingResultsVendorProducts pair : vendorProductPairs) {
            if (exclude.contains(pair.getVendor())) continue;
            for (AliasMatchingResultsProduct product : pair.getProducts()) {
                int aliasCount = product.getAliases().size();
                if (aliasCount < minAliases) {
                    minAliases = aliasCount;
                    minAliasProducts.clear();
                    minAliasProducts.add(product);
                    vendor = pair.getVendor();
                    continue;
                }
                if (aliasCount != minAliases) continue;
                minAliasProducts.add(product);
            }
        }
        if (minAliases == Integer.MAX_VALUE) {
            minAliasProducts = new ArrayList();
        }
        return Pair.of(vendor, minAliasProducts);
    }

    private static Map<AliasMatchingResultsProduct, Integer> fuzzyFromAliasFindProductDistancesToAliasesLevenshtein(List<AliasMatchingResultsProduct> minAliasProducts, List<AliasMatchingResultsVendorProducts> vendorProductPairs) {
        HashMap<AliasMatchingResultsProduct, Integer> distances = new HashMap<AliasMatchingResultsProduct, Integer>();
        for (AliasMatchingResultsProduct product : minAliasProducts) {
            int minDistance = Integer.MAX_VALUE;
            String lookupVendor = vendorProductPairs.stream().filter(vp -> vp.getProducts().contains(product)).map(AliasMatchingResultsVendorProducts::getVendor).findFirst().orElse(null);
            if (lookupVendor != null) {
                minDistance = Math.min(minDistance, LevenshteinDistance.getDefaultInstance().apply((CharSequence)lookupVendor, (CharSequence)product.getProduct()));
            }
            for (Pair<Alias, Integer> alias : product.getAliases()) {
                int distance = LevenshteinDistance.getDefaultInstance().apply((CharSequence)((Alias)alias.getKey()).getAlias(), (CharSequence)product.getProduct());
                if (distance >= minDistance) continue;
                minDistance = distance;
            }
            distances.put(product, minDistance);
        }
        return distances;
    }

    private Set<String> findFirstVendorContainsAlias(NvdCpeApiVendorProductIndexQuery cpeDictionaryVendorProduct, String alias) {
        return cpeDictionaryVendorProduct.findVendorsFuzzy(alias);
    }

    private Set<String> findFirstProductContainsAlias(NvdCpeApiVendorProductIndexQuery cpeDictionaryVendorProduct, String alias) {
        return cpeDictionaryVendorProduct.findProductsFuzzy(alias);
    }

    private Set<Cpe> findVersionSpecificCpeUrisFromVendorProducts(List<AliasMatchingResultsVendorProducts> vendorProductPairs, boolean isComponentHardware, Consumer<Set<Cpe>> maxCorrelatedCpePerArtifactReachedCallback) {
        HashSet<Cpe> derivedCpeUris = new HashSet<Cpe>();
        NvdCpeApiIndexQuery cpeDictionary = (NvdCpeApiIndexQuery)this.cpeDictionary.get();
        for (AliasMatchingResultsVendorProducts vendorProducts : vendorProductPairs) {
            String vendor = vendorProducts.getVendor();
            for (String product : vendorProducts.getRawProducts()) {
                List<Cpe> cpeByVendorProduct = cpeDictionary.findCpeByVendorProduct(vendor, product);
                if (cpeByVendorProduct.isEmpty()) {
                    log.warn("No CPEs found for vendor/product pair [{} : {}]", (Object)vendor, (Object)product);
                    continue;
                }
                cpeByVendorProduct.stream().filter(cpe -> CpeDerivationUtilities.hardwareCheck(isComponentHardware, cpe)).map(CommonEnumerationUtil::keepOnlyPartVendorProduct).filter(Optional::isPresent).map(Optional::get).forEach(derivedCpeUris::add);
                if (derivedCpeUris.size() < this.configuration.getMaxCorrelatedCpePerArtifact()) continue;
                maxCorrelatedCpePerArtifactReachedCallback.accept(derivedCpeUris);
                return derivedCpeUris;
            }
        }
        return derivedCpeUris;
    }

    private static boolean hardwareCheck(boolean isComponentHardware, Cpe cpe) {
        return cpe.getPart() != Part.HARDWARE_DEVICE || isComponentHardware;
    }

    public void setConfiguration(CpeDerivationEnrichmentConfiguration configuration) {
        this.configuration = configuration;
    }

    public CpeDerivationEnrichmentConfiguration getConfiguration() {
        return this.configuration;
    }

    static {
        try {
            UNSPECIFIC_PRODUCTS = Dashboard.readResourceAsStringList(CpeDerivationUtilities.class, "enrichment/cpe-derivation/unspecific-products.txt").stream().filter(StringUtils::hasText).filter(str -> !str.startsWith("#")).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load unspecific products for CPE derivation from classpath resource [enrichment/cpe-derivation/unspecific-products.txt]", e);
        }
    }

    protected static class AliasRequireOtherMatcher {
        private Alias matchingAlias;

        public boolean isMatching(Alias candidate) {
            if (candidate.isRequireOtherIndication()) {
                if (this.matchingAlias == null) {
                    this.matchingAlias = candidate;
                    return false;
                }
                return this.matchingAlias != candidate;
            }
            return true;
        }

        public Alias getMatchingAlias() {
            return this.matchingAlias;
        }

        public void setMatchingAlias(Alias matchingAlias) {
            this.matchingAlias = matchingAlias;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AliasRequireOtherMatcher)) {
                return false;
            }
            AliasRequireOtherMatcher other = (AliasRequireOtherMatcher)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Alias this$matchingAlias = this.getMatchingAlias();
            Alias other$matchingAlias = other.getMatchingAlias();
            return !(this$matchingAlias == null ? other$matchingAlias != null : !((Object)this$matchingAlias).equals(other$matchingAlias));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AliasRequireOtherMatcher;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Alias $matchingAlias = this.getMatchingAlias();
            result = result * 59 + ($matchingAlias == null ? 43 : ((Object)$matchingAlias).hashCode());
            return result;
        }

        public String toString() {
            return "CpeDerivationUtilities.AliasRequireOtherMatcher(matchingAlias=" + this.getMatchingAlias() + ")";
        }
    }

    public static class Alias
    implements Comparable<Alias> {
        private final String alias;
        private final String sourceAttribute;
        private final String sourceValue;
        private boolean requireOtherIndication = false;

        private JSONObject toJson() {
            return new JSONObject().put("alias", (Object)this.alias).put("sourceAttribute", (Object)this.sourceAttribute).put("sourceValue", (Object)this.sourceValue).put("requireOtherIndication", this.requireOtherIndication);
        }

        public String toString() {
            return this.toJson().toString();
        }

        @Override
        public int compareTo(Alias o) {
            if (o == null) {
                return 1;
            }
            if (this.alias == null) {
                return -1;
            }
            if (o.alias == null) {
                return 1;
            }
            return this.alias.compareTo(o.alias);
        }

        public static Set<Alias> toAliases(Collection<String> aliases, String sourceAttribute, String sourceValue) {
            return aliases.stream().map(alias -> new Alias((String)alias, sourceAttribute, sourceValue)).collect(Collectors.toSet());
        }

        public Alias(String alias, String sourceAttribute, String sourceValue) {
            this.alias = alias;
            this.sourceAttribute = sourceAttribute;
            this.sourceValue = sourceValue;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getSourceAttribute() {
            return this.sourceAttribute;
        }

        public String getSourceValue() {
            return this.sourceValue;
        }

        public boolean isRequireOtherIndication() {
            return this.requireOtherIndication;
        }

        public void setRequireOtherIndication(boolean requireOtherIndication) {
            this.requireOtherIndication = requireOtherIndication;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Alias)) {
                return false;
            }
            Alias other = (Alias)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$alias = this.getAlias();
            String other$alias = other.getAlias();
            return !(this$alias == null ? other$alias != null : !this$alias.equals(other$alias));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Alias;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
            return result;
        }
    }

    public static class AliasMatchingResultsProduct {
        private final String product;
        private final List<Pair<Alias, Integer>> aliases;

        public AliasMatchingResultsProduct(String product) {
            this.product = product;
            this.aliases = new ArrayList<Pair<Alias, Integer>>();
        }

        public void addAlias(Alias alias, int method) {
            if (this.aliases.stream().noneMatch(p -> ((Alias)p.getKey()).equals(alias))) {
                this.aliases.add((Pair<Alias, Integer>)Pair.of((Object)alias, (Object)method));
            }
        }

        public JSONObject toJson() {
            return new JSONObject().put("aliases", (Collection)this.aliases.stream().map(p -> new JSONObject().put("alias", (Object)((Alias)p.getKey()).getAlias()).put("source", (Object)new JSONObject().put("value", (Object)((Alias)p.getKey()).getSourceValue()).put("attribute", (Object)((Alias)p.getKey()).getSourceAttribute())).put("requireOtherIndication", ((Alias)p.getKey()).isRequireOtherIndication()).put("method", p.getValue())).collect(Collectors.toList()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AliasMatchingResultsProduct that = (AliasMatchingResultsProduct)o;
            return Objects.equals(this.product, that.product);
        }

        public int hashCode() {
            return Objects.hashCode(this.product);
        }

        public String getProduct() {
            return this.product;
        }

        public List<Pair<Alias, Integer>> getAliases() {
            return this.aliases;
        }

        public String toString() {
            return "CpeDerivationUtilities.AliasMatchingResultsProduct(product=" + this.getProduct() + ", aliases=" + this.getAliases() + ")";
        }
    }

    public static class AliasMatchingResultsVendorProducts {
        private final String vendor;
        private final Set<AliasMatchingResultsProduct> products;

        public AliasMatchingResultsVendorProducts(String vendor) {
            this.vendor = vendor;
            this.products = new LinkedHashSet<AliasMatchingResultsProduct>();
        }

        public Set<String> getRawProducts() {
            return this.products.stream().map(AliasMatchingResultsProduct::getProduct).collect(Collectors.toSet());
        }

        public AliasMatchingResultsProduct addProduct(String product) {
            return this.products.stream().filter(p -> p.getProduct().equals(product)).findFirst().orElseGet(() -> {
                AliasMatchingResultsProduct newProduct = new AliasMatchingResultsProduct(product);
                this.products.add(newProduct);
                return newProduct;
            });
        }

        public static AliasMatchingResultsVendorProducts addVendor(List<AliasMatchingResultsVendorProducts> vendorProducts, String vendor) {
            return vendorProducts.stream().filter(vp -> vp.getVendor().equals(vendor)).findFirst().orElseGet(() -> {
                AliasMatchingResultsVendorProducts newVendorProducts = new AliasMatchingResultsVendorProducts(vendor);
                vendorProducts.add(newVendorProducts);
                return newVendorProducts;
            });
        }

        public JSONObject toJson() {
            JSONObject json = new JSONObject().put("vendor", (Object)this.vendor);
            JSONObject productsJson = new JSONObject();
            for (AliasMatchingResultsProduct product : this.products) {
                productsJson.put(product.getProduct(), (Object)product.toJson());
            }
            json.put("products", (Object)productsJson);
            return json;
        }

        public String getVendor() {
            return this.vendor;
        }

        public Set<AliasMatchingResultsProduct> getProducts() {
            return this.products;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AliasMatchingResultsVendorProducts)) {
                return false;
            }
            AliasMatchingResultsVendorProducts other = (AliasMatchingResultsVendorProducts)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$vendor = this.getVendor();
            String other$vendor = other.getVendor();
            if (this$vendor == null ? other$vendor != null : !this$vendor.equals(other$vendor)) {
                return false;
            }
            Set<AliasMatchingResultsProduct> this$products = this.getProducts();
            Set<AliasMatchingResultsProduct> other$products = other.getProducts();
            return !(this$products == null ? other$products != null : !((Object)this$products).equals(other$products));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AliasMatchingResultsVendorProducts;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $vendor = this.getVendor();
            result = result * 59 + ($vendor == null ? 43 : $vendor.hashCode());
            Set<AliasMatchingResultsProduct> $products = this.getProducts();
            result = result * 59 + ($products == null ? 43 : ((Object)$products).hashCode());
            return result;
        }

        public String toString() {
            return "CpeDerivationUtilities.AliasMatchingResultsVendorProducts(vendor=" + this.getVendor() + ", products=" + this.getProducts() + ")";
        }
    }
}

