/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.vulnerability.ghsa;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.version.Version;
import com.metaeffekt.artifact.analysis.version.curation.VersionContext;
import com.metaeffekt.artifact.enrichment.vulnerability.ghsa.GhsaArtifactVulnerabilityMatcher;
import com.metaeffekt.artifact.enrichment.vulnerability.ghsa.GhsaEcosystem;
import com.metaeffekt.mirror.contents.advisory.GhsaAdvisorEntry;
import com.metaeffekt.mirror.contents.base.DataSourceIndicator;
import com.metaeffekt.mirror.query.GhsaAdvisorIndexQuery;
import java.util.Map;
import org.metaeffekt.core.inventory.processor.model.Artifact;

public abstract class ArtifactIdVersionGhsaMatcher
extends GhsaArtifactVulnerabilityMatcher {
    public ArtifactIdVersionGhsaMatcher(GhsaAdvisorIndexQuery ghsaQuery, boolean githubReviewed) {
        super(ghsaQuery, githubReviewed);
    }

    protected abstract GhsaEcosystem getEcosystem();

    @Override
    public Map<GhsaAdvisorEntry, DataSourceIndicator> match(Artifact artifact) {
        artifact.deriveArtifactId();
        String artifactId = artifact.getArtifactId();
        Version version = Version.of(artifact.getVersion(), VersionContext.fromArtifact(artifact));
        return this.ghsaQuery.findByArtifactIdAndVersionInEcosystem(artifact, this.getEcosystem(), artifactId, version, this.githubReviewed);
    }

    @Override
    public boolean mayMatch(Artifact artifact) {
        return StringUtils.hasText(artifact.getId()) && StringUtils.hasText(artifact.getVersion());
    }
}

