/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.vulnerability.ghsa;

import com.metaeffekt.artifact.enrichment.vulnerability.ghsa.GhsaArtifactVulnerabilityMatcher;
import com.metaeffekt.artifact.enrichment.vulnerability.ghsa.matchers.CratesIoGhsaMatcher;
import com.metaeffekt.artifact.enrichment.vulnerability.ghsa.matchers.HexGhsaMatcher;
import com.metaeffekt.artifact.enrichment.vulnerability.ghsa.matchers.MavenGhsaMatcher;
import com.metaeffekt.artifact.enrichment.vulnerability.ghsa.matchers.NopGhsaMatcher;
import com.metaeffekt.artifact.enrichment.vulnerability.ghsa.matchers.NpmGhsaMatcher;
import com.metaeffekt.artifact.enrichment.vulnerability.ghsa.matchers.NuGetGhsaMatcher;
import com.metaeffekt.artifact.enrichment.vulnerability.ghsa.matchers.PythonPipGhsaMatcher;
import com.metaeffekt.artifact.enrichment.vulnerability.ghsa.matchers.RubyGemGhsaMatcher;
import com.metaeffekt.mirror.query.GhsaAdvisorIndexQuery;

public enum GhsaEcosystem {
    MAVEN("Maven", "java", MavenGhsaMatcher.class),
    NPM("npm", "javascript", NpmGhsaMatcher.class),
    RUBY_GEMS("RubyGems", "ruby", RubyGemGhsaMatcher.class),
    PY_PI("PyPI", "python", PythonPipGhsaMatcher.class),
    PACKAGIST("Packagist", "php", NopGhsaMatcher.class),
    GIT_HUB_ACTIONS("GitHub Actions", "github actions", NopGhsaMatcher.class),
    PURL_TYPE_SWIFT("purl-type:swift", "swift", NopGhsaMatcher.class),
    GO("Go", "go", NopGhsaMatcher.class),
    HEX("Hex", "erlang", HexGhsaMatcher.class),
    CRATES_IO("crates.io", "rust", CratesIoGhsaMatcher.class),
    PUB("Pub", "dart", NopGhsaMatcher.class),
    NU_GET("NuGet", ".net", NuGetGhsaMatcher.class);

    private final String name;
    private final String programmingLanguage;
    private final Class<? extends GhsaArtifactVulnerabilityMatcher> matcherClass;

    private GhsaEcosystem(String name, String programmingLanguage, Class<? extends GhsaArtifactVulnerabilityMatcher> matcherClass) {
        this.name = name;
        this.programmingLanguage = programmingLanguage;
        this.matcherClass = matcherClass;
    }

    public String getName() {
        return this.name;
    }

    public String getProgrammingLanguage() {
        return this.programmingLanguage;
    }

    public Class<? extends GhsaArtifactVulnerabilityMatcher> getMatcherClass() {
        return this.matcherClass;
    }

    public <T extends GhsaArtifactVulnerabilityMatcher> T createInstance(GhsaAdvisorIndexQuery query, Boolean githubReviewed) {
        try {
            return (T)this.matcherClass.getConstructor(GhsaAdvisorIndexQuery.class, Boolean.TYPE).newInstance(query, githubReviewed);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static GhsaEcosystem fromName(String name) {
        for (GhsaEcosystem ecosystem : GhsaEcosystem.values()) {
            if (!ecosystem.getName().equals(name)) continue;
            return ecosystem;
        }
        throw new IllegalArgumentException("No " + GhsaEcosystem.class.getSimpleName() + " with name " + name);
    }

    public String toString() {
        return this.name + " (" + this.programmingLanguage + ")";
    }
}

