/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.vulnerability.ghsa;

import com.metaeffekt.artifact.analysis.utils.LazySupplier;
import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import com.metaeffekt.artifact.enrichment.configurations.GhsaVulnerabilitiesEnrichmentConfiguration;
import com.metaeffekt.artifact.enrichment.vulnerability.ghsa.GhsaArtifactVulnerabilityMatcher;
import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.advisory.GhsaAdvisorEntry;
import com.metaeffekt.mirror.contents.base.DataSourceIndicator;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeStore;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import com.metaeffekt.mirror.query.GhsaAdvisorIndexQuery;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnricherMetadata(name="GHSA Vulnerabilities", phase=InventoryEnrichmentPhase.VULNERABILITY_MATCHING, intermediateFileSuffix="ghsa-cve", mavenPropertyName="ghsaVulnerabilitiesEnrichment")
public class GhsaVulnerabilitiesEnrichment
extends InventoryEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(GhsaVulnerabilitiesEnrichment.class);
    private final LazySupplier<GhsaAdvisorIndexQuery> ghsaAdvisorQuery;
    private GhsaVulnerabilitiesEnrichmentConfiguration configuration = new GhsaVulnerabilitiesEnrichmentConfiguration();

    public GhsaVulnerabilitiesEnrichment(File baseMirrorDirectory) {
        this.ghsaAdvisorQuery = new LazySupplier<GhsaAdvisorIndexQuery>(() -> new GhsaAdvisorIndexQuery(baseMirrorDirectory));
    }

    public void setConfiguration(GhsaVulnerabilitiesEnrichmentConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public GhsaVulnerabilitiesEnrichmentConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    protected void performEnrichment(Inventory inventory) {
        List<GhsaArtifactVulnerabilityMatcher> matchers = this.configuration.buildMatchers((GhsaAdvisorIndexQuery)this.ghsaAdvisorQuery.get());
        VulnerabilityContextInventory vInventory = VulnerabilityContextInventory.fromInventory(inventory);
        LOG.info("Matching GHSA vulnerabilities for [{}] artifacts using [{}] matcher{}", new Object[]{inventory.getArtifacts().size(), matchers.size(), matchers.size() > 1 ? "s" : ""});
        for (Artifact artifact : inventory.getArtifacts()) {
            for (GhsaArtifactVulnerabilityMatcher matcher : matchers) {
                if (!matcher.mayMatch(artifact)) continue;
                Map<GhsaAdvisorEntry, DataSourceIndicator> ghsaAdvisorEntries = matcher.match(artifact);
                for (Map.Entry<GhsaAdvisorEntry, DataSourceIndicator> matchedEntry : ghsaAdvisorEntries.entrySet()) {
                    GhsaAdvisorEntry ghsaAdvisorEntry = matchedEntry.getKey();
                    DataSourceIndicator dataSourceIndicator = matchedEntry.getValue();
                    Set<String> entryCves = ghsaAdvisorEntry.getReferencedVulnerabilities(VulnerabilityTypeStore.CVE);
                    if (entryCves.isEmpty()) {
                        vInventory.add((AdvisoryEntry)vInventory.findOrCreateAdvisoryEntryByName(ghsaAdvisorEntry.getId(), GhsaAdvisorEntry::new).addMatchingSource(dataSourceIndicator));
                        continue;
                    }
                    for (String entryCve : entryCves) {
                        Vulnerability vulnerability = (Vulnerability)vInventory.findOrCreateVulnerabilityByName(entryCve).addMatchingSource(dataSourceIndicator);
                        vulnerability.setSourceIdentifier(VulnerabilityTypeStore.CVE);
                        vInventory.add(vulnerability);
                    }
                }
            }
        }
        vInventory.writeBack(true);
    }
}

