/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.vulnerability.ghsa.matchers;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.artifact.enrichment.vulnerability.ghsa.ArtifactIdVersionGhsaMatcher;
import com.metaeffekt.artifact.enrichment.vulnerability.ghsa.GhsaEcosystem;
import com.metaeffekt.mirror.query.GhsaAdvisorIndexQuery;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NpmGhsaMatcher
extends ArtifactIdVersionGhsaMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(NpmGhsaMatcher.class);

    public NpmGhsaMatcher(GhsaAdvisorIndexQuery ghsaQuery, boolean githubReviewed) {
        super(ghsaQuery, githubReviewed);
    }

    @Override
    protected GhsaEcosystem getEcosystem() {
        return GhsaEcosystem.NPM;
    }

    @Override
    public boolean mayMatch(Artifact artifact) {
        return super.mayMatch(artifact) && this.isNpmModuleOrAlike(artifact);
    }

    private boolean isNpmModuleOrAlike(Artifact artifact) {
        String type = artifact.get("Type");
        return this.isTypeMatch(type) || this.isNpmPurl(artifact) || this.isNpmEcosystem(artifact);
    }

    private boolean isNpmEcosystem(Artifact artifact) {
        boolean isNpmEcosystem = false;
        String ecosystem = artifact.get((AbstractModelBase.Attribute)InventoryAttribute.ECOSYSTEM);
        if (StringUtils.hasText(ecosystem)) {
            isNpmEcosystem = "npm".equalsIgnoreCase(ecosystem);
        }
        return isNpmEcosystem;
    }

    private boolean isNpmPurl(Artifact artifact) {
        boolean isNpmPurl = false;
        String purlString = artifact.get(Artifact.Attribute.PURL);
        if (StringUtils.hasText(purlString)) {
            try {
                PackageURL purl = new PackageURL(purlString);
                isNpmPurl = "npm".equalsIgnoreCase(purl.getType());
            }
            catch (MalformedPackageURLException e) {
                LOG.debug("Cannot extract package url from [{}].", (Object)purlString);
            }
        }
        return isNpmPurl;
    }

    private boolean isTypeMatch(String type) {
        boolean isTypeMatch = "nodejs-module".equalsIgnoreCase(type) || "web-module".equalsIgnoreCase(type);
        return isTypeMatch;
    }
}

