/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.extractors.configuration;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.extractors.configuration.AbstractExtractorConfiguration;
import java.io.File;
import java.io.IOException;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.reader.InventoryReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageExtractorConfiguration
extends AbstractExtractorConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(PackageExtractorConfiguration.class);
    private final File packageDocBaseDir;
    private final File packageLicenseBaseDir;

    protected PackageExtractorConfiguration(String id, File inventoryFile) {
        super(id, inventoryFile);
        this.packageDocBaseDir = null;
        this.packageLicenseBaseDir = null;
    }

    public PackageExtractorConfiguration(String id, File inventoryFile, File analysisDir) {
        super(id, inventoryFile);
        this.packageDocBaseDir = this.exist(new File(analysisDir, "usr-share-doc"));
        this.packageLicenseBaseDir = this.exist(new File(analysisDir, "usr-share-licenses"));
    }

    @Override
    public void validate() {
        FileUtils.validateExists((File)this.getResultInventoryFile());
    }

    @Override
    public void contribute(File targetDir, Inventory aggregatedInventory) throws IOException {
        Inventory inventory = new InventoryReader().readInventory(this.getResultInventoryFile());
        int i = 0;
        int size = inventory.getArtifacts().size();
        File tmpFolder = new File(targetDir.getParentFile(), ".tmp");
        if (tmpFolder.exists()) {
            FileUtils.deleteDirectoryQuietly((File)tmpFolder);
        }
        FileUtils.forceMkDirQuietly(tmpFolder);
        for (Artifact artifact : inventory.getArtifacts()) {
            String specificDir;
            File generalDir;
            artifact.deriveArtifactId();
            ++i;
            String artifactType = artifact.get("Type");
            if (!"package".equals(artifactType)) continue;
            LOG.info("Compressing [{}], {}/{}", new Object[]{artifact.getId(), i, size});
            File tmpAggregationFolder = new File(tmpFolder, "content_" + artifact.getId());
            if (this.packageDocBaseDir != null && this.packageDocBaseDir.exists()) {
                generalDir = new File(this.packageDocBaseDir, artifact.getArtifactId());
                specificDir = artifact.get("Package Documentation Path");
                this.contributeDirectory(artifact, generalDir, specificDir, "[doc]", tmpAggregationFolder);
            }
            if (this.packageLicenseBaseDir != null && this.packageLicenseBaseDir.exists()) {
                generalDir = new File(this.packageLicenseBaseDir, artifact.getArtifactId());
                specificDir = artifact.get("Package License Path");
                this.contributeDirectory(artifact, generalDir, specificDir, "[license]", tmpAggregationFolder);
            }
            PackageExtractorConfiguration.createArchiveFromAggregationFolder(artifact, tmpAggregationFolder, targetDir, tmpFolder);
        }
        this.addToInventory(inventory, aggregatedInventory);
    }

    static void createArchiveFromAggregationFolder(Artifact artifact, File tmpAggregationFolder, File targetDir, File tmpFolder) throws IOException {
        if (tmpAggregationFolder.exists() && tmpAggregationFolder.isDirectory()) {
            File contentChecksumFile = new File(tmpFolder, artifact.getArtifactId() + ".content.md5");
            FileUtils.createDirectoryContentChecksumFile((File)tmpAggregationFolder, (File)contentChecksumFile);
            String contentChecksum = FileUtils.computeChecksum((File)contentChecksumFile);
            artifact.set("Content Checksum", contentChecksum);
            File targetZipFile = new File(targetDir, String.format("%s-%s.zip", artifact.getArtifactId(), contentChecksum));
            FileUtils.zipAnt(tmpAggregationFolder, targetZipFile);
            artifact.set("Archive Path", targetZipFile.getAbsolutePath());
            artifact.set("Analysis Path", null);
        }
    }

    private void contributeDirectory(Artifact artifact, File generalDir, String specificDir, String context, File tmpAggregationFolder) {
        File sourceDirCandidate;
        if (StringUtils.notEmpty(specificDir) && (sourceDirCandidate = new File(specificDir)).exists() && sourceDirCandidate.isDirectory()) {
            generalDir = sourceDirCandidate;
        }
        if (generalDir.exists()) {
            File targetChildFolder = new File(tmpAggregationFolder, context);
            FileUtils.forceMkDirQuietly(targetChildFolder);
            try {
                FileUtils.copyDirectory((File)generalDir, (File)targetChildFolder);
            }
            catch (Exception e) {
                LOG.error("Cannot contribute directory {}. {}", (Object)generalDir, (Object)e.getMessage());
                artifact.append("Errors", "Directory " + generalDir + " was not copied.", "\n");
            }
        }
    }
}

