/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.extractors.flow;

import com.metaeffekt.artifact.extractors.configuration.ExtractorConfiguration;
import com.metaeffekt.artifact.extractors.flow.ExtractorParam;
import com.metaeffekt.artifact.extractors.flow.ExtractorResult;
import com.metaeffekt.flow.common.AbstractFlow;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.metaeffekt.core.inventory.processor.model.Inventory;

public class ExtractorFlow
extends AbstractFlow {
    public ExtractorResult extract(ExtractorParam extractorParam) throws IOException {
        List<ExtractorConfiguration> extractorConfigurationList = extractorParam.getExtractorConfigurationList();
        Validate.notNull(extractorConfigurationList);
        File archiveTargetDir = extractorParam.getArchiveTargetDir();
        Inventory aggregatedInventory = new Inventory();
        for (ExtractorConfiguration extractorConfiguration : extractorConfigurationList) {
            extractorConfiguration.validate();
            extractorConfiguration.contribute(archiveTargetDir, aggregatedInventory);
        }
        return new ExtractorResult().fromInventory(aggregatedInventory).withArchivesIn(archiveTargetDir);
    }
}

