/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.terms.model;

import com.metaeffekt.artifact.analysis.utils.StringStats;
import com.metaeffekt.artifact.terms.model.MatchPreprocessor;
import com.metaeffekt.artifact.terms.model.ScanResultPart;
import org.json.JSONArray;

public class FileSegment {
    private final String markedContent;
    private final StringStats normalizedContent;
    private ScanResultPart normalizedSRP;
    private JSONArray licenseVariables;
    private final MatchPreprocessor matchPreprocessor;

    public FileSegment(String markedSegmentContent, MatchPreprocessor matchPreprocessor) {
        this.matchPreprocessor = matchPreprocessor;
        this.markedContent = markedSegmentContent;
        String markerFreeContent = matchPreprocessor.removeMarkers(markedSegmentContent);
        StringStats normalizedContent = StringStats.normalize(markerFreeContent, false);
        matchPreprocessor.getNormalizationMetaData().applyMasks(normalizedContent);
        this.normalizedContent = normalizedContent;
    }

    public String getContent() {
        return this.matchPreprocessor.removeMarkersForReadability(this.markedContent).trim();
    }

    public String getMarkedContent() {
        return this.markedContent;
    }

    public StringStats getNormalizedContent() {
        return this.normalizedContent;
    }

    public ScanResultPart getNormalizedSRP() {
        return this.normalizedSRP;
    }

    public void setNormalizedSRP(ScanResultPart normalizedSRP) {
        this.normalizedSRP = normalizedSRP;
    }

    public void setLicenseVariables(JSONArray licenseVariables) {
        this.licenseVariables = licenseVariables;
    }

    public JSONArray getLicenseVariables() {
        return this.licenseVariables;
    }
}

