/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.terms.model;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.terms.model.LicenseTextEntry;
import com.metaeffekt.artifact.terms.model.LicenseTextProvider;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.artifact.terms.model.ResolverUtils;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTermsMetaDataLicenseTextProvider
implements LicenseTextProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LocalTermsMetaDataLicenseTextProvider.class);
    private final NormalizationMetaData normalizationMetaData;

    public LocalTermsMetaDataLicenseTextProvider(NormalizationMetaData normalizationMetaData) {
        this.normalizationMetaData = normalizationMetaData;
    }

    @Override
    public Map<String, LicenseTextEntry> resolve(Collection<String> canonicalNames) {
        HashMap<String, LicenseTextEntry> map = new HashMap<String, LicenseTextEntry>();
        for (String canonicalName : canonicalNames) {
            File licenseFile;
            TermsMetaData tmd = this.normalizationMetaData.getTermsMetaData(canonicalName);
            if (tmd == null) {
                LOG.debug("Trying to find name [{}] in history.", (Object)canonicalName);
                tmd = this.normalizationMetaData.findUsingCanonicalNameInHistory(canonicalName);
            }
            if (tmd == null || (licenseFile = ResolverUtils.findLicenseFor(tmd, this.normalizationMetaData)) == null || !licenseFile.exists()) continue;
            try {
                LicenseTextEntry licenseTextEntry = new LicenseTextEntry(tmd.getCanonicalName(), licenseFile.getAbsolutePath(), FileUtils.readFileToString((File)licenseFile, (String)"UTF-8"));
                map.put(canonicalName, licenseTextEntry);
            }
            catch (IOException e) {
                LOG.error("Could not read license text for tmd [{}] (tmd [{}]) from path [{}].", new Object[]{canonicalName, tmd.getCanonicalName(), licenseFile.getPath()});
            }
        }
        return map;
    }
}

