/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import com.metaeffekt.mirror.PropertyFileAccess;
import com.metaeffekt.mirror.download.Download;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Mirror {
    private static final Logger LOG = LoggerFactory.getLogger(Mirror.class);
    protected final File baseMirrorDirectory;
    protected final String mirrorIdentifier;
    protected final PropertyFileAccess propertyFiles = new PropertyFileAccess("mirror");
    private final List<String> lockedFiles = new ArrayList<String>();

    protected Mirror(File baseMirrorDirectory, String mirrorIdentifier) {
        this.baseMirrorDirectory = baseMirrorDirectory;
        this.mirrorIdentifier = mirrorIdentifier;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            for (int i = this.lockedFiles.size() - 1; i >= 0; --i) {
                this.unlockFile(new File(this.lockedFiles.get(i)));
            }
        }));
        if (this.getClass().isAnnotationPresent(MirrorMetadata.class)) {
            MirrorMetadata annotation = this.getClass().getAnnotation(MirrorMetadata.class);
            boolean isDeprecated = annotation.deprecated();
            String dirName = annotation.directoryName();
            String mavenName = annotation.mavenPropertyName();
            if (isDeprecated) {
                LOG.warn("The mirror [{}] [{}] [{}] is deprecated.", new Object[]{this.getClass().getSimpleName(), dirName, mavenName});
            }
        }
    }

    protected boolean isUpdatedAgeOlderThan(long lastModifiedTimestamp, long maxAge) {
        if (lastModifiedTimestamp > 0L) {
            long currentTime = TimeUtils.utcNow();
            long ageDifference = currentTime - lastModifiedTimestamp;
            return ageDifference > maxAge;
        }
        return true;
    }

    protected void lockFile(File file) {
        File directoryToPlaceLockIn = Mirror.getParentIfDirectory(file);
        this.propertyFiles.addCsv(directoryToPlaceLockIn, "lock", InfoFileAttributes.LOCK_LOCKED_FILE.getKey(), file.getAbsolutePath());
        this.propertyFiles.set(directoryToPlaceLockIn, "lock", InfoFileAttributes.LOCK_LOCKED_SINCE.getKey(), TimeUtils.utcNow());
        this.lockedFiles.add(file.getAbsolutePath());
        this.propertyFiles.flushCachedAePropertyFiles();
        LOG.info("Locked file {}", (Object)file.getAbsolutePath());
    }

    protected void unlockFile(File file) {
        File directoryToPlaceLockIn = Mirror.getParentIfDirectory(file);
        List<String> lockedFiles = this.propertyFiles.getCsv(directoryToPlaceLockIn, "lock", InfoFileAttributes.LOCK_LOCKED_FILE.getKey());
        lockedFiles.remove(file.getAbsolutePath());
        this.propertyFiles.set(directoryToPlaceLockIn, "lock", InfoFileAttributes.LOCK_LOCKED_FILE.getKey(), lockedFiles);
        if (lockedFiles.size() == 0) {
            this.propertyFiles.remove(directoryToPlaceLockIn, "lock", InfoFileAttributes.LOCK_LOCKED_SINCE.getKey());
        } else {
            this.propertyFiles.set(directoryToPlaceLockIn, "lock", InfoFileAttributes.LOCK_LOCKED_SINCE.getKey(), TimeUtils.utcNow());
        }
        this.lockedFiles.remove(file.getAbsolutePath());
        this.propertyFiles.flushCachedAePropertyFiles();
        LOG.info("Unlocked file {}", (Object)file.getAbsolutePath());
    }

    protected void waitForFileUnlockIfLocked(File file, long timeout) {
        this.propertyFiles.flushCachedAePropertyFiles();
        if (!this.isFileLocked(file, timeout)) {
            return;
        }
        LOG.info("File is locked, waiting for unlock or timeout of [{}]: {}", (Object)this.formatMilliseconds(timeout), (Object)file.getAbsolutePath());
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.isFileLocked(file, timeout));
        LOG.info("File has been unlocked: {}", (Object)file.getAbsolutePath());
    }

    private boolean isFileLocked(File file, long timeout) {
        File directoryToPlaceLockIn = Mirror.getParentIfDirectory(file);
        this.propertyFiles.discardCachedChangesForFileType("lock");
        List<String> lockedFiles = this.propertyFiles.getCsv(directoryToPlaceLockIn, "lock", InfoFileAttributes.LOCK_LOCKED_FILE.getKey());
        boolean fileIsIncludedInLock = lockedFiles.contains(file.getAbsolutePath());
        if (!fileIsIncludedInLock) {
            return false;
        }
        long lockedSince = this.propertyFiles.getLong(directoryToPlaceLockIn, "lock", InfoFileAttributes.LOCK_LOCKED_SINCE.getKey()).orElse(0L);
        return lockedSince == 0L || TimeUtils.utcNow() - lockedSince <= timeout;
    }

    private static File getParentIfDirectory(File file) {
        return file.isFile() ? file.getParentFile() : file;
    }

    protected String formatMilliseconds(long ms) {
        long hours = TimeUnit.MILLISECONDS.toHours(ms);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(ms - TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(ms - TimeUnit.HOURS.toMillis(hours) - TimeUnit.MINUTES.toMillis(minutes));
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    protected void logTitle(String status) {
        String type = this instanceof Download ? "download" : "index";
        String dirName = this.getClass().isAnnotationPresent(MirrorMetadata.class) ? this.getClass().getAnnotation(MirrorMetadata.class).directoryName() : "Unknown";
        String mavenName = this.getClass().isAnnotationPresent(MirrorMetadata.class) ? this.getClass().getAnnotation(MirrorMetadata.class).mavenPropertyName() : "Unknown";
        String title = status + type + " [" + dirName + " / " + mavenName + "]";
        LOG.info(InventoryEnricher.formatLogHeader(title));
        if (StringUtils.hasText(status)) {
            LOG.info("");
        }
    }

    public String toString() {
        if (this.getClass().isAnnotationPresent(MirrorMetadata.class)) {
            MirrorMetadata mirrorMetadata = this.getClass().getAnnotation(MirrorMetadata.class);
            return mirrorMetadata.directoryName() + " / " + mirrorMetadata.mavenPropertyName();
        }
        return super.toString();
    }

    public MirrorMetadata getMirrorMetadata() {
        return this.getClass().getAnnotation(MirrorMetadata.class);
    }

    protected static enum InfoFileAttributes implements AbstractModelBase.Attribute
    {
        MIRROR_VERSION("mirror-version"),
        LAST_UPDATED("last-updated"),
        LAST_UPDATED_FORMATTED("last-updated-formatted"),
        LAST_CHECKED("last-checked"),
        LAST_CHECKED_FORMATTED("last-checked-formatted"),
        LAST_RESET("last-reset"),
        CERT_FR_PREFIX("cert-fr-"),
        CERT_SEI_PREFIX("cert-sei-"),
        CERT_EU_PREFIX("cert-eu-"),
        MSRC_PREFIX("msrc-"),
        CPE_DICTIONARY_PREFIX("cpe-dictionary-"),
        NVD_PREFIX("nvd-"),
        EPSS_PREFIX("epss-"),
        LOCK_LOCKED_FILE("locked-file"),
        LOCK_LOCKED_SINCE("locked-since"),
        DOWNLOAD_FAILED_FLAG("download-failed"),
        INDEX_FAILED_FLAG("index-failed");

        public final String key;

        private InfoFileAttributes(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

