/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFileAccess {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyFileAccess.class);
    private final String namespace;
    private final Map<File, Map<String, String>> cachedAePropertyFiles = new HashMap<File, Map<String, String>>();
    private final Timer flushCacheTimer = new Timer(180000, e -> this.flushCachedAePropertyFiles());

    public PropertyFileAccess(String namespace) {
        this.namespace = namespace;
        Runtime.getRuntime().addShutdownHook(new Thread(this::flushCachedAePropertyFiles));
    }

    public PropertyFileAccess() {
        this("properties");
    }

    private Map<String, String> readOrGetCachedAePropertyFile(File directory, String fileIdentifier) {
        File file = this.buildPropertyFilename(directory, fileIdentifier);
        if (this.cachedAePropertyFiles.containsKey(file)) {
            return this.cachedAePropertyFiles.get(file);
        }
        Map<String, String> contents = this.getAePropertyFileContents(file, fileIdentifier);
        this.cachedAePropertyFiles.put(file, contents);
        return contents;
    }

    public void set(File directory, String fileIdentifier, String key, Object value) {
        Map<String, String> contents = this.readOrGetCachedAePropertyFile(directory, fileIdentifier);
        String valueString = value == null ? "" : (value instanceof List || value instanceof Set ? ((Collection)value).stream().map(Object::toString).map(this::escapeValue).collect(Collectors.joining(",")) : String.valueOf(value));
        if (valueString.length() == 0) {
            contents.remove(key);
            LOG.info("Clearing key [{}] in {} / {}", new Object[]{key, directory.getName(), fileIdentifier});
        } else {
            contents.put(key, valueString);
            LOG.info("Setting [{}] to [{}] in {} / {}", new Object[]{key, valueString, directory.getName(), fileIdentifier});
        }
        this.refreshFlushCacheTimer();
    }

    public void addCsv(File directory, String fileIdentifier, String key, String value) {
        Map<String, String> contents = this.readOrGetCachedAePropertyFile(directory, fileIdentifier);
        contents.merge(key, value, (a, b) -> a + ", " + this.escapeValue((String)b));
        this.refreshFlushCacheTimer();
    }

    public void remove(File directory, String fileIdentifier, String key) {
        Map<String, String> contents = this.readOrGetCachedAePropertyFile(directory, fileIdentifier);
        contents.remove(key);
    }

    public Optional<String> getString(File directory, String fileIdentifier, String key) {
        Map<String, String> contents = this.readOrGetCachedAePropertyFile(directory, fileIdentifier);
        return Optional.ofNullable(this.unescapeValue(contents.get(key)));
    }

    public List<String> getCsv(File directory, String fileIdentifier, String key) {
        Map<String, String> contents = this.readOrGetCachedAePropertyFile(directory, fileIdentifier);
        String value = contents.get(key);
        if (value == null) {
            return new ArrayList<String>();
        }
        return Arrays.stream(value.split(", ?")).map(this::unescapeValue).collect(Collectors.toList());
    }

    public Optional<Boolean> getBoolean(File directory, String fileIdentifier, String key) {
        Map<String, String> contents = this.readOrGetCachedAePropertyFile(directory, fileIdentifier);
        String value = contents.get(key);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(Boolean.parseBoolean(value));
    }

    public Optional<Long> getLong(File directory, String fileIdentifier, String key) {
        Map<String, String> contents = this.readOrGetCachedAePropertyFile(directory, fileIdentifier);
        String value = contents.get(key);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(Long.parseLong(value));
    }

    public void flushCachedAePropertyFiles() {
        this.clearFlushCacheTimer();
        for (Map.Entry<File, Map<String, String>> propertyFile : this.cachedAePropertyFiles.entrySet()) {
            this.writePropertyMapToFile(propertyFile.getKey(), propertyFile.getValue());
        }
        this.cachedAePropertyFiles.clear();
    }

    public void discardCachedChangesForFileType(String fileIdentifier) {
        String searchString = ".ae-" + this.namespace + "-" + fileIdentifier;
        this.cachedAePropertyFiles.entrySet().removeIf(entry -> ((File)entry.getKey()).getName().contains(searchString));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFlushCacheTimer() {
        Timer timer = this.flushCacheTimer;
        synchronized (timer) {
            this.flushCacheTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshFlushCacheTimer() {
        Timer timer = this.flushCacheTimer;
        synchronized (timer) {
            this.flushCacheTimer.restart();
        }
    }

    private String escapeKey(String key) {
        return key.replace("#", "ESC_HASH").replace("=", "ESC_EQUAL");
    }

    private String unescapeKey(String key) {
        return key.replace("ESC_HASH", "#").replace("ESC_EQUAL", "=");
    }

    private String escapeValue(String value) {
        if (value == null) {
            return null;
        }
        return value.replace(",", "ESC_COMMA");
    }

    private String unescapeValue(String value) {
        if (value == null) {
            return null;
        }
        return value.replace("ESC_COMMA", ",");
    }

    private void writePropertyMapToFile(File file, Map<String, String> propertyMap) {
        if (propertyMap.size() == 0) {
            file.delete();
        } else {
            ArrayList<String> lines = new ArrayList<String>();
            for (Map.Entry<String, String> property : propertyMap.entrySet()) {
                lines.add(this.escapeKey(property.getKey()) + "=" + property.getValue().replace("ESC_COMMA", ","));
            }
            try {
                FileUtils.writeLines((File)file, lines);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not write property file " + file.getAbsolutePath(), e);
            }
        }
    }

    private Map<String, String> getAePropertyFileContents(File file, String fileIdentifier) {
        HashMap<String, String> contents = new HashMap<String, String>();
        if (file.exists()) {
            try {
                List lines = FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8);
                for (String line : lines) {
                    String[] keyValue = line.split("=", 2);
                    if (keyValue.length != 2) continue;
                    contents.put(this.unescapeKey(keyValue[0]), keyValue[1]);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read property file " + file.getAbsolutePath(), e);
            }
        } else {
            LOG.debug("Creating new property file [{}] for [{}]", (Object)file.getAbsolutePath(), (Object)fileIdentifier);
        }
        return contents;
    }

    private File buildPropertyFilename(File directory, String fileIdentifier) {
        return new File(directory, ".ae-" + this.namespace + "-" + fileIdentifier);
    }
}

