/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.advisory;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.base.DescriptionParagraph;
import com.metaeffekt.mirror.contents.base.Reference;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeStore;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeStore;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.AdvisoryMetaData;
import org.metaeffekt.core.inventory.processor.report.model.AdvisoryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertEuAdvisorEntry
extends AdvisoryEntry {
    private static final Logger LOG = LoggerFactory.getLogger(CertEuAdvisorEntry.class);
    protected static final Set<String> CONVERSION_KEYS_AMB = new HashSet<String>(AdvisoryEntry.CONVERSION_KEYS_AMB){};
    protected static final Set<String> CONVERSION_KEYS_MAP = new HashSet<String>(AdvisoryEntry.CONVERSION_KEYS_MAP){};
    private static final Map<String, Set<String>> CHAPTER_TITLE_NORMALIZATION = new HashMap<String, Set<String>>();

    public CertEuAdvisorEntry() {
        super(AdvisoryTypeStore.CERT_EU);
    }

    public CertEuAdvisorEntry(String id) {
        super(AdvisoryTypeStore.CERT_EU, id);
    }

    @Override
    public String getUrl() {
        return "https://cert.europa.eu/publications/security-advisories/" + this.id.replace("CERT-EU-", "");
    }

    @Override
    public String getType() {
        return AdvisoryUtils.normalizeType((String)"alert");
    }

    @Override
    protected Set<String> conversionKeysAmb() {
        return CONVERSION_KEYS_AMB;
    }

    @Override
    protected Set<String> conversionKeysMap() {
        return CONVERSION_KEYS_MAP;
    }

    @Override
    public CertEuAdvisorEntry constructDataClass() {
        return new CertEuAdvisorEntry();
    }

    public static CertEuAdvisorEntry fromAdvisoryMetaData(AdvisoryMetaData amd) {
        return AdvisoryEntry.fromAdvisoryMetaData(amd, CertEuAdvisorEntry::new);
    }

    public static CertEuAdvisorEntry fromInputMap(Map<String, Object> map) {
        return AdvisoryEntry.fromInputMap(map, CertEuAdvisorEntry::new);
    }

    public static CertEuAdvisorEntry fromJson(JSONObject json) {
        return AdvisoryEntry.fromJson(json, CertEuAdvisorEntry::new);
    }

    public static CertEuAdvisorEntry fromDocument(Document document) {
        return AdvisoryEntry.fromDocument(document, CertEuAdvisorEntry::new);
    }

    @Override
    public void appendFromBaseModel(AdvisoryMetaData amd) {
        super.appendFromBaseModel(amd);
    }

    @Override
    public void appendToBaseModel(AdvisoryMetaData amd) {
        super.appendToBaseModel(amd);
    }

    @Override
    public void appendFromMap(Map<String, Object> map) {
        super.appendFromMap(map);
    }

    @Override
    public void appendToJson(JSONObject json) {
        super.appendToJson(json);
    }

    @Override
    public void appendFromDocument(Document document) {
        super.appendFromDocument(document);
    }

    @Override
    public void appendToDocument(Document document) {
        super.appendToDocument(document);
    }

    public static CertEuAdvisorEntry fromDownloadJson(JSONObject json) {
        CertEuAdvisorEntry certEuAdvisorEntry = new CertEuAdvisorEntry();
        certEuAdvisorEntry.setId("CERT-EU-" + json.getString("serial_number"));
        certEuAdvisorEntry.setSummary(json.optString("title", null));
        if (json.has("description") && json.get("description") != JSONObject.NULL) {
            certEuAdvisorEntry.addDescription(DescriptionParagraph.fromTitleAndContent("description", json.getString("description")));
            CertEuAdvisorEntry.extractReferenceIdsFromStringIfPresent(json.getString("description"), (AdvisoryEntry)certEuAdvisorEntry, VulnerabilityTypeStore.CVE);
        }
        if (json.has("content_markdown") && json.get("content_markdown") != JSONObject.NULL) {
            CertEuAdvisorEntry.extractMarkdownChaptersContent(json.getString("content_markdown"), certEuAdvisorEntry);
            CertEuAdvisorEntry.extractReferenceIdsFromStringIfPresent(json.getString("content_markdown"), (AdvisoryEntry)certEuAdvisorEntry, VulnerabilityTypeStore.CVE);
        }
        if (json.has("content_html") && json.get("content_html") != JSONObject.NULL) {
            certEuAdvisorEntry.addDescription(DescriptionParagraph.fromTitleAndContent("content_html", json.getString("content_html")));
            CertEuAdvisorEntry.extractReferenceIdsFromStringIfPresent(json.getString("content_html"), (AdvisoryEntry)certEuAdvisorEntry, VulnerabilityTypeStore.CVE);
        }
        try {
            long createDate = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").parse(json.getString("publish_date")).getTime();
            certEuAdvisorEntry.setCreateDate(createDate);
            certEuAdvisorEntry.setUpdateDate(createDate);
        }
        catch (ParseException e) {
            LOG.error("Unable to parse date from JSON: {}", (Object)json.getString("publish_date"));
        }
        return certEuAdvisorEntry;
    }

    private static void extractMarkdownChaptersContent(String markdownContent, CertEuAdvisorEntry certEuAdvisorEntry) {
        String[] lines = markdownContent.split("\n");
        LinkedHashMap<String, StringJoiner> chapterSections = new LinkedHashMap<String, StringJoiner>();
        String currentChapterTitle = null;
        boolean lastWasTitle = false;
        for (String line : lines) {
            if (line.startsWith("# ")) {
                currentChapterTitle = line.substring(2).trim();
                for (Map.Entry<String, Set<String>> entry : CHAPTER_TITLE_NORMALIZATION.entrySet()) {
                    if (!entry.getValue().contains(currentChapterTitle.toLowerCase())) continue;
                    currentChapterTitle = entry.getKey();
                    break;
                }
                lastWasTitle = true;
                continue;
            }
            if (lastWasTitle) {
                lastWasTitle = false;
                if (StringUtils.isEmpty(line)) continue;
            }
            if (currentChapterTitle == null) continue;
            if (currentChapterTitle.equals("References")) {
                String referenceUrl;
                String[] parts;
                if (!line.startsWith("[")) continue;
                String trimmedLine = line.trim();
                if (trimmedLine.contains(" --- ")) {
                    Pattern urlExtractionPattern;
                    Matcher matcher;
                    parts = trimmedLine.split(" --- ", 2);
                    String urlTitle = parts[0].trim();
                    referenceUrl = parts[1].startsWith("<") && parts[1].endsWith(">") ? parts[1].substring(1, parts[1].length() - 1) : ((matcher = (urlExtractionPattern = Pattern.compile("\\[([^]]+)]\\(([^)]+)\\)")).matcher(parts[1])).find() ? matcher.group(2) : parts[1]);
                    certEuAdvisorEntry.addReference(Reference.fromTitleAndUrl(urlTitle, referenceUrl));
                    continue;
                }
                parts = trimmedLine.split(" ", 2);
                if (parts.length == 1) continue;
                if (parts[1].startsWith("<")) {
                    String[] urlParts = parts[1].split(">", 2);
                    referenceUrl = urlParts[0].substring(1);
                    Reference reference = Reference.fromUrl(referenceUrl);
                    if (urlParts.length > 1 && !urlParts[1].trim().isEmpty()) {
                        reference.addTag(urlParts[1].trim());
                    }
                    certEuAdvisorEntry.addReference(reference);
                    continue;
                }
                certEuAdvisorEntry.addReference(Reference.fromUrl(parts[1]));
                continue;
            }
            chapterSections.computeIfAbsent(currentChapterTitle, k -> new StringJoiner("\n")).add(line);
        }
        DescriptionParagraph descriptionParagraph = certEuAdvisorEntry.getDescription("description");
        boolean hasDescriptionChapter = descriptionParagraph != null;
        for (Map.Entry chapter : chapterSections.entrySet()) {
            String title = (String)chapter.getKey();
            String content = ((StringJoiner)chapter.getValue()).toString();
            if (hasDescriptionChapter && "Summary".equals(chapter.getKey())) {
                certEuAdvisorEntry.getDescription().remove(descriptionParagraph);
                certEuAdvisorEntry.addDescription(DescriptionParagraph.fromTitleAndContent("description", content));
                continue;
            }
            if ("recommendations".equalsIgnoreCase(title)) {
                certEuAdvisorEntry.setRecommendations(content);
                continue;
            }
            if ("workarounds".equalsIgnoreCase(title)) {
                certEuAdvisorEntry.setWorkarounds(content);
                continue;
            }
            if ("exploitation".equalsIgnoreCase(title)) {
                certEuAdvisorEntry.setThreat(content);
                continue;
            }
            certEuAdvisorEntry.addDescription(DescriptionParagraph.fromTitleAndContent((String)chapter.getKey(), content));
        }
    }

    static {
        CHAPTER_TITLE_NORMALIZATION.put("Affected Products", new HashSet<String>(Arrays.asList("products affected", "affected products", "**[update]** affected products", "products affected by sunburst", "products affected by supernova", "products and versions affected", "versions affected", "vulnerable systems")));
        CHAPTER_TITLE_NORMALIZATION.put("Unaffected Products", new HashSet<String>(Arrays.asList("unaffected products", "non affected versions")));
        CHAPTER_TITLE_NORMALIZATION.put("Affected/Fixed Versions", new HashSet<String>(Arrays.asList("affected products and fixed versions", "affected products and fixed release", "affected products and fixed releases")));
        CHAPTER_TITLE_NORMALIZATION.put("Recommendations", new HashSet<String>(Arrays.asList("recommendations and workarounds", "recommendations and mitigations", "recommendation", "**[update]** recommendations", "recommandations")));
        CHAPTER_TITLE_NORMALIZATION.put("Workarounds", new HashSet<String>(Arrays.asList("workaround:", "workaround", "workarounds", "mitigations", "remediation", "mitigation and workarounds", "workaround and mitigation")));
        CHAPTER_TITLE_NORMALIZATION.put("Exploitation", new HashSet<String>(Arrays.asList("exploitation", "exploits")));
        CHAPTER_TITLE_NORMALIZATION.put("Technical Details", new HashSet<String>(Arrays.asList("technical details", "technical details", "technical detail", "details")));
    }
}

