/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.advisory;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.base.DescriptionParagraph;
import com.metaeffekt.mirror.contents.base.Reference;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeStore;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeStore;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.lucene.document.Document;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.AdvisoryMetaData;
import org.metaeffekt.core.inventory.processor.report.model.AdvisoryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertFrAdvisorEntry
extends AdvisoryEntry {
    private static final Logger LOG = LoggerFactory.getLogger(CertFrAdvisorEntry.class);
    protected static final Set<String> CONVERSION_KEYS_AMB = new HashSet<String>(AdvisoryEntry.CONVERSION_KEYS_AMB){};
    protected static final Set<String> CONVERSION_KEYS_MAP = new HashSet<String>(AdvisoryEntry.CONVERSION_KEYS_MAP){};
    protected static final String CERT_FR_BASE_URL = "https://www.cert.ssi.gouv.fr/";
    private static final Pattern[] CERT_FR_IGNORE_LINE_PATTERNS = new Pattern[]{Pattern.compile(".*BULLETIN D'ACTUALIT\u00c9 DU CERT-FR.*"), Pattern.compile(".*PREMIER MINISTRE.*"), Pattern.compile(".*Paris, le.*"), Pattern.compile(".*N\u00b0.*"), Pattern.compile(".*S \\. G \\. D \\. S \\. N.*"), Pattern.compile(".*Agence nationale.*"), Pattern.compile(".*de la s\u00e9curit\u00e9 des.*"), Pattern.compile(".*syst\u00e8mes d'information.*"), Pattern.compile(".*Affaire suivie par.*"), Pattern.compile(".*AVIS DU CERT-FR.*"), Pattern.compile(".*Une gestion de version d\u00e9taill\u00e9e se trouve \u00e0 la fin de ce document\\..*"), Pattern.compile("\\d{5,10}"), Pattern.compile("Secr\u00e9tariat g\u00e9n\u00e9ral de la d\u00e9fense et de la s\u00e9curit\u00e9 nationale \u2013 ANSSI \u2013 CERT-FR"), Pattern.compile("51, bd de La Tour-Maubourg"), Pattern.compile("75700 Paris 07 SP"), Pattern.compile("T\u00e9l\\.: {2}\\+33 1 71 75 84 68"), Pattern.compile("Fax: {2}\\+33 1 84 82 40 70"), Pattern.compile("Web: {2}https://www.cert.ssi.gouv.fr"), Pattern.compile("M\u00e9l: {2}cert-fr.cossi@ssi.gouv.fr"), Pattern.compile("Page \\d+ / \\d+"), Pattern.compile("Ce bulletin d\u2019actualit\u00e9 du CERT-FR revient sur les vuln\u00e9rabilit\u00e9s.+"), Pattern.compile("Toutes les vuln\u00e9rabilit\u00e9s \u00e9voqu\u00e9es dans les avis.+"), Pattern.compile("Veuillez-vous r\u00e9f\u00e9rer aux avis des \u00e9diteurs pour obtenir les correctifs.+")};
    private static final String[][] CERT_FR_PARAGRAPH_HEADERS = new String[][]{{"Syst\u00e8mes affect\u00e9s", "Affected systems"}, {"R\u00e9sum\u00e9", "Summary"}, {"Risque\\(s\\)", "Risques", "Risque", "Risk"}, {"Solution", "Solutions", "Solution"}, {"Recommandations", "Recommendations"}, {"Documentation", "Documentations", "Documentation"}, {"Contournement provisoire", "Temporary bypass"}, {"Description", "Description"}, {"Rappel des avis \u00e9mis", "Rappel des avis et des mises \u00e0 jour \u00e9mis", "Rappel des avis et mises \u00e0 jour \u00e9mis", "Reminder of notices issued"}, {"^\\d{1,2} .+", null}, {"^##+ .+", null}};

    public CertFrAdvisorEntry() {
        super(AdvisoryTypeStore.CERT_FR);
    }

    public CertFrAdvisorEntry(String id) {
        super(AdvisoryTypeStore.CERT_FR, id);
    }

    protected String getBaseType() {
        if (this.id == null) {
            return null;
        }
        String[] parts = this.id.split("-");
        if (parts.length < 4) {
            return null;
        }
        switch (parts[2]) {
            case "AVI": {
                return "avis";
            }
            case "ALE": {
                return "alerte";
            }
            case "IOC": {
                return "ioc";
            }
            case "DUR": {
                return "dur";
            }
            case "ACT": {
                return "actualite";
            }
            case "CTI": {
                return "cti";
            }
            case "REC": 
            case "INF": {
                return "information";
            }
        }
        return null;
    }

    @Override
    public String getType() {
        return AdvisoryUtils.normalizeType((String)this.getBaseType());
    }

    @Override
    public String getUrl() {
        if (this.id == null) {
            return CERT_FR_BASE_URL;
        }
        String[] parts = this.id.split("-");
        if (parts.length < 4) {
            return CERT_FR_BASE_URL;
        }
        StringJoiner onlineCertFr = new StringJoiner("-");
        for (int i = 0; i < parts.length; ++i) {
            if (i >= 4) continue;
            if (i == 3 && parts[i].matches("\\d+") && parts[i].length() == 2) {
                parts[i] = "0" + parts[i];
            }
            onlineCertFr.add(parts[i]);
        }
        String type = this.getBaseType();
        if (type == null) {
            return CERT_FR_BASE_URL;
        }
        return CERT_FR_BASE_URL + type + "/" + onlineCertFr;
    }

    @Override
    protected Set<String> conversionKeysAmb() {
        return CONVERSION_KEYS_AMB;
    }

    @Override
    protected Set<String> conversionKeysMap() {
        return CONVERSION_KEYS_MAP;
    }

    @Override
    public CertFrAdvisorEntry constructDataClass() {
        return new CertFrAdvisorEntry();
    }

    public static CertFrAdvisorEntry fromAdvisoryMetaData(AdvisoryMetaData amd) {
        return AdvisoryEntry.fromAdvisoryMetaData(amd, CertFrAdvisorEntry::new);
    }

    public static CertFrAdvisorEntry fromInputMap(Map<String, Object> map) {
        return AdvisoryEntry.fromInputMap(map, CertFrAdvisorEntry::new);
    }

    public static CertFrAdvisorEntry fromJson(JSONObject json) {
        return AdvisoryEntry.fromJson(json, CertFrAdvisorEntry::new);
    }

    public static CertFrAdvisorEntry fromJson(File file) throws IOException {
        return AdvisoryEntry.fromJson(file, CertFrAdvisorEntry::new);
    }

    public static CertFrAdvisorEntry fromDocument(Document document) {
        return AdvisoryEntry.fromDocument(document, CertFrAdvisorEntry::new);
    }

    @Override
    public void appendFromBaseModel(AdvisoryMetaData amd) {
        super.appendFromBaseModel(amd);
    }

    @Override
    public void appendToBaseModel(AdvisoryMetaData amd) {
        super.appendToBaseModel(amd);
    }

    @Override
    public void appendFromMap(Map<String, Object> map) {
        super.appendFromMap(map);
    }

    @Override
    public void appendToJson(JSONObject json) {
        super.appendToJson(json);
    }

    @Override
    public void appendFromDocument(Document document) {
        super.appendFromDocument(document);
    }

    @Override
    public void appendToDocument(Document document) {
        super.appendToDocument(document);
    }

    public static CertFrAdvisorEntry fromDownloadText(List<String> lines) {
        CertFrAdvisorEntry entry = new CertFrAdvisorEntry();
        if (lines.isEmpty()) {
            throw new IllegalArgumentException("No data found in file");
        }
        lines = lines.stream().map(l -> l.replace("\f", "")).map(l -> l.replace("(cid:160)", "")).map(String::trim).filter(l -> Arrays.stream(CERT_FR_IGNORE_LINE_PATTERNS).noneMatch(ignoreLine -> ignoreLine.matcher((CharSequence)l).matches())).collect(Collectors.toList());
        ArrayList<String> reducedMappedLines = new ArrayList<String>();
        boolean lastLineEmpty = false;
        for (String line : lines) {
            if (lastLineEmpty && line.isEmpty()) continue;
            reducedMappedLines.add(line);
            lastLineEmpty = line.isEmpty();
        }
        HashMap<String, StringJoiner> furtherContent = new HashMap<String, StringJoiner>();
        int maxHeaderNumber = 0;
        for (int i = 0; i < reducedMappedLines.size(); ++i) {
            String line = (String)reducedMappedLines.get(i);
            if (line.startsWith("Objet:")) {
                entry.setSummary(line.replace("Objet: ", ""));
                continue;
            }
            if (line.equals("Gestion du document")) {
                ArrayList<String> tableContent = new ArrayList<String>();
                line = (String)reducedMappedLines.get(++i);
                while (!line.contains("Tableau") && !line.contains("TAB") || line.contains("Electric")) {
                    tableContent.add(line);
                    if (++i >= reducedMappedLines.size()) break;
                    line = (String)reducedMappedLines.get(i);
                }
                CertFrAdvisorEntry.certFrExtractContentsFromTable(entry, tableContent);
                continue;
            }
            if (line.equals("Gestion d\u00e9taill\u00e9e du document")) break;
            if (!CertFrAdvisorEntry.certFrIsHeader(line, maxHeaderNumber, reducedMappedLines, i)) continue;
            String header = CertFrAdvisorEntry.certFrNormalizeHeaderText(line);
            maxHeaderNumber = CertFrAdvisorEntry.certFrExtractHeaderNumber(line, maxHeaderNumber);
            ArrayList<String> contents = new ArrayList<String>();
            if (++i >= lines.size()) break;
            line = (String)reducedMappedLines.get(i);
            while (!CertFrAdvisorEntry.certFrIsHeader(line, maxHeaderNumber, reducedMappedLines, i) && !line.equals("Gestion d\u00e9taill\u00e9e du document")) {
                contents.add(line);
                if (++i >= reducedMappedLines.size()) break;
                line = (String)reducedMappedLines.get(i);
            }
            furtherContent.computeIfAbsent(header, h -> new StringJoiner("\n")).add(String.join((CharSequence)"\n", contents));
            --i;
        }
        Map<String, String> trimmedFurtherContent = furtherContent.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> CertFrAdvisorEntry.trimNewlines(((StringJoiner)e.getValue()).toString().trim()).trim()));
        StringJoiner recommendationBuilder = new StringJoiner("\n\n");
        if (trimmedFurtherContent.containsKey("Recommendations")) {
            recommendationBuilder.add(trimmedFurtherContent.remove("Recommendations"));
        }
        if (trimmedFurtherContent.containsKey("Solution")) {
            recommendationBuilder.add(trimmedFurtherContent.remove("Solution"));
        }
        if (recommendationBuilder.length() > 0) {
            entry.setRecommendations(recommendationBuilder.toString());
        }
        entry.setThreat(trimmedFurtherContent.remove("Risk"));
        entry.setWorkarounds(trimmedFurtherContent.remove("Temporary bypass"));
        if (trimmedFurtherContent.containsKey("Documentation")) {
            String[] documentationLines = trimmedFurtherContent.remove("Documentation").split("\n");
            for (int i = 0; i < documentationLines.length - 1; i += 2) {
                Reference ref = Reference.fromTitleAndUrl(documentationLines[i], documentationLines[i + 1]);
                entry.getReferences().add(ref);
            }
            entry.clearDescription();
        } else {
            String sourcesDescription = entry.getTextDescription();
            entry.setDescription(DescriptionParagraph.fromTitleAndContent("Sources", sourcesDescription));
        }
        if (trimmedFurtherContent.containsKey("Description")) {
            entry.addDescription(DescriptionParagraph.fromTitleAndContent("Description", trimmedFurtherContent.remove("Description")));
        }
        for (String header : trimmedFurtherContent.keySet()) {
            entry.addDescription(DescriptionParagraph.fromTitleAndContent(header, trimmedFurtherContent.get(header)));
        }
        String inputAsOneLine = String.join((CharSequence)"", reducedMappedLines);
        CertFrAdvisorEntry.extractReferenceIdsFromStringIfPresent(inputAsOneLine, (AdvisoryEntry)entry, AdvisoryTypeStore.CERT_FR);
        CertFrAdvisorEntry.extractReferenceIdsFromStringIfPresent(inputAsOneLine, (AdvisoryEntry)entry, VulnerabilityTypeStore.CVE);
        if (!StringUtils.hasText(entry.getId())) {
            LOG.error("Unable to detect CERT-FR identifier in document: {}", (Object)entry.toJson());
        } else {
            entry.removeReferencedSecurityAdvisory(AdvisoryTypeStore.CERT_FR, entry.getId());
        }
        if (entry.getCreateDate() == null) {
            LOG.warn("Missing create date on {}", (Object)entry.getId());
        }
        if (entry.getUpdateDate() == null) {
            LOG.warn("Missing update date on {}", (Object)entry.getId());
        }
        return entry;
    }

    private static void certFrExtractContentsFromTable(CertFrAdvisorEntry entry, List<String> tableContent) {
        entry.setId(null);
        entry.setCreateDate(null);
        entry.setUpdateDate(null);
        StringBuilder title = new StringBuilder();
        StringBuilder sources = new StringBuilder();
        boolean updateAndCreateDateFound = false;
        int tableSize = tableContent.size();
        for (int i = 0; i < tableSize; ++i) {
            String line = tableContent.get(i);
            if (line.isEmpty()) continue;
            if (line.matches("(?:\\d+)?(?:CERTFR|CERTA)-.+")) {
                if (line.matches("\\d+.+")) {
                    line = line.replaceAll("\\d+(.+)", "$1");
                }
                line = line.toUpperCase(Locale.ENGLISH).trim();
                entry.setId(line);
            } else if (line.matches("Date de la premi\u00e8re version .+")) {
                entry.setCreateDate(TimeUtils.tryParse(line.replaceAll("Date de la premi\u00e8re version (.+)", "$1")));
            } else if (line.matches("Date de la derni\u00e8re version .+")) {
                entry.setUpdateDate(TimeUtils.tryParse(line.replaceAll("Date de la derni\u00e8re version (.+)", "$1")));
            } else if (entry.getCreateDate() == null && line.matches("\\d{1,2} [^ ]+ \\d{4}(?: \u00e0 \\d{2}h\\d{2})?")) {
                entry.setCreateDate(TimeUtils.tryParse(line));
            } else if (entry.getUpdateDate() == null && line.matches("\\d{1,2} [^ ]+ \\d{4}(?: \u00e0 \\d{2}h\\d{2})?")) {
                entry.setUpdateDate(TimeUtils.tryParse(line));
            } else if (CertFrAdvisorEntry.certFrIsNotTableRowIdentifier(line) && (title.length() == 0 || !updateAndCreateDateFound)) {
                title.append(" ").append(line.trim());
            } else if (CertFrAdvisorEntry.certFrIsNotTableRowIdentifier(line) && sources.length() == 0) {
                boolean first = true;
                StringBuilder sourcesBuilder = new StringBuilder();
                do {
                    if (!first) {
                        if (sources.length() > 0 || sourcesBuilder.length() > 0) {
                            sourcesBuilder.append("\n");
                        }
                        sourcesBuilder.append(line);
                        continue;
                    }
                    first = false;
                } while (CertFrAdvisorEntry.certFrIsNotTableRowIdentifier(line = tableContent.get(i)) && ++i < tableSize && !line.equals("Aucune(s)") && !line.equals("Aucune"));
                sources.append(CertFrAdvisorEntry.certFrPrepareSources(sourcesBuilder.toString()));
                if (i >= tableSize) break;
                --i;
            }
            if (entry.getCreateDate() == null || entry.getUpdateDate() == null) continue;
            updateAndCreateDateFound = true;
        }
        if (sources.length() > 0) {
            entry.setDescription(DescriptionParagraph.fromContent(sources.toString()));
        }
    }

    private static boolean certFrIsNotTableRowIdentifier(String s) {
        return !s.contains("version") && !s.contains("Date de la") && !s.equals("R\u00e9f\u00e9rence") && !s.equals("Titre") && !s.equals("Source(s)") && !s.equals("Pi\u00e8ce(s) jointe(s)");
    }

    private static boolean certFrIsHeader(String line, int largestHeader, List<String> allLines, int i) {
        String[][] stringArray = CERT_FR_PARAGRAPH_HEADERS;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String[] headers;
            for (String header : headers = stringArray[j]) {
                if (header == null || !line.matches(header)) continue;
                if (line.matches("^\\d+ .+")) {
                    int headerNumber = CertFrAdvisorEntry.certFrExtractHeaderNumber(line, largestHeader);
                    if (headerNumber <= largestHeader + 2) {
                        if (i > 0 && allLines.get(i - 1).isEmpty() && i < allLines.size() - 1 && allLines.get(i + 1).isEmpty()) {
                            if (!line.matches("^\\d+ - ?\\.\\d+.+")) {
                                return true;
                            }
                            LOG.debug("Skipping header [{}] because it has -. behind it", (Object)line);
                            return false;
                        }
                        LOG.debug("Skipping header [{}] because it is not surrounded by empty lines", (Object)line);
                        return false;
                    }
                    LOG.debug("Skipping header [{}] because it is too large [{} | {}]", new Object[]{line, headerNumber, largestHeader});
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static int certFrExtractHeaderNumber(String line, int defaultValue) {
        if (line == null) {
            return defaultValue;
        }
        if (line.matches("^\\d+ .+")) {
            return Integer.parseInt(line.replaceAll("^(\\d+) .+", "$1"));
        }
        return defaultValue;
    }

    private static String certFrNormalizeHeaderText(String line) {
        String[][] stringArray = CERT_FR_PARAGRAPH_HEADERS;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] headers;
            for (String header : headers = stringArray[i]) {
                if (header == null || !line.matches(header)) continue;
                if (headers[headers.length - 1] == null) {
                    return CertFrAdvisorEntry.certFrNormalizeHeaderText(line.replaceAll("^(?:\\d{1,2}|##+) (.+)$", "$1").replace("\u2013 ", ""));
                }
                return headers[headers.length - 1];
            }
        }
        return line;
    }

    private static String certFrPrepareSources(String sources) {
        return sources.replaceAll("(JANVIER|F\u00c9VRIER|MARSAVRIL|MAI|JUIN|JUILLET|AO\u00dbT|SEPTEMBRE|OCTOBRE|NOVEMBRE|D\u00c9CEMBRE|janvier|f\u00e9vrier|mars|avril|mai|juin|juillet|ao\u00fbt|septembre|octobre|novembre|d\u00e9cembre)\n", " $1 ").replaceAll("((?<!\\d)\\d{2})\n", " $1 ").replace("\n ?Bulletin", " Bulletin ").replace("  ", " ").replace(" \n", "\n").replace("\n ", "\n");
    }

    public static CertFrAdvisorEntry fromApiJson(JSONObject documentJson) {
        JSONArray vendorAdvisories;
        JSONArray cves;
        JSONArray links;
        JSONArray risks;
        JSONArray revisions;
        CertFrAdvisorEntry entry = new CertFrAdvisorEntry();
        String id = documentJson.optString("reference");
        if (id.matches("\\d+.+")) {
            id = id.replaceAll("\\d+(.+)", "$1");
        }
        id = id.toUpperCase(Locale.ENGLISH).trim();
        entry.setId(id);
        entry.setSummary(documentJson.optString("title", null));
        String contentField = documentJson.optString("content", null);
        if (StringUtils.hasText(contentField)) {
            Map<String, String> trimmedFurtherContent;
            List<String> lines = Arrays.asList(contentField.split("\n"));
            HashMap<String, StringJoiner> furtherContent = new HashMap<String, StringJoiner>();
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                if (!CertFrAdvisorEntry.certFrIsHeader(line, 1, lines, i)) continue;
                String header = CertFrAdvisorEntry.certFrNormalizeHeaderText(line);
                ArrayList<String> contents = new ArrayList<String>();
                if (++i >= lines.size()) break;
                line = lines.get(i);
                while (!CertFrAdvisorEntry.certFrIsHeader(line, 1, lines, i) && !line.equals("Gestion d\u00e9taill\u00e9e du document")) {
                    contents.add(line);
                    if (++i >= lines.size()) break;
                    line = lines.get(i);
                }
                furtherContent.computeIfAbsent(header, h -> new StringJoiner("\n")).add(String.join((CharSequence)"\n", contents));
                --i;
            }
            if ((trimmedFurtherContent = furtherContent.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> CertFrAdvisorEntry.trimNewlines(((StringJoiner)e.getValue()).toString().trim()).trim()))).containsKey("Temporary bypass")) {
                entry.setWorkarounds(trimmedFurtherContent.remove("Temporary bypass"));
            }
            if (trimmedFurtherContent.containsKey("Solution") || trimmedFurtherContent.containsKey("Recommendations")) {
                StringJoiner recommendationsBuilder = new StringJoiner("\n\n");
                if (trimmedFurtherContent.containsKey("Solution")) {
                    recommendationsBuilder.add(trimmedFurtherContent.remove("Solution"));
                }
                if (trimmedFurtherContent.containsKey("Recommendations")) {
                    recommendationsBuilder.add(trimmedFurtherContent.remove("Recommendations"));
                }
                entry.setRecommendations(recommendationsBuilder.toString());
            }
            if (trimmedFurtherContent.containsKey("Documentation")) {
                String[] documentationLines = trimmedFurtherContent.remove("Documentation").split("\n");
                for (int i = 0; i < documentationLines.length - 1; i += 2) {
                    Reference ref = Reference.fromTitleAndUrl(documentationLines[i], documentationLines[i + 1]);
                    entry.getReferences().add(ref);
                }
            }
            for (String header : trimmedFurtherContent.keySet()) {
                entry.addDescription(DescriptionParagraph.fromTitleAndContent(header, trimmedFurtherContent.get(header)));
            }
        }
        if (StringUtils.hasText(documentJson.optString("summary", null))) {
            entry.addDescription(DescriptionParagraph.fromTitleAndContent("Summary", documentJson.getString("summary").replace("\n\n\u00a0", "").replaceAll("\n+$", "")));
        }
        if ((revisions = documentJson.optJSONArray("revisions")) != null && !revisions.isEmpty()) {
            JSONObject firstRevision = revisions.getJSONObject(0);
            entry.setCreateDate(TimeUtils.tryParse(firstRevision.optString("revision_date", null)));
            JSONObject lastRevision = revisions.getJSONObject(revisions.length() - 1);
            entry.setUpdateDate(TimeUtils.tryParse(lastRevision.optString("revision_date", null)));
        }
        if ((risks = documentJson.optJSONArray("risks")) != null && !risks.isEmpty()) {
            StringJoiner riskJoiner = new StringJoiner("\n");
            for (int i = 0; i < risks.length(); ++i) {
                String risk = risks.getJSONObject(i).optString("description", null);
                if (risk == null) continue;
                riskJoiner.add(risk);
            }
            entry.setThreat(riskJoiner.toString());
        }
        ArrayList<String> affectedSystems = new ArrayList<String>();
        JSONArray affectedSystemsArray = documentJson.optJSONArray("affected_systems");
        if (affectedSystemsArray != null) {
            for (int i = 0; i < affectedSystemsArray.length(); ++i) {
                JSONObject affectedSystem = affectedSystemsArray.getJSONObject(i);
                String affectedSystemDescription = affectedSystem.getString("description");
                if (affectedSystem.optJSONObject("product") != null) {
                    String productName = affectedSystem.getJSONObject("product").getString("name");
                    if (StringUtils.hasText(productName) && !productName.equals("N/A")) {
                        affectedSystems.add(productName + ": " + affectedSystemDescription);
                        continue;
                    }
                    affectedSystems.add(affectedSystemDescription);
                    continue;
                }
                affectedSystems.add(affectedSystemDescription);
            }
        }
        if (documentJson.optString("affected_systems_content", null) != null) {
            affectedSystems.add(documentJson.getString("affected_systems_content"));
        }
        if (!affectedSystems.isEmpty()) {
            entry.addDescription("Affected systems", affectedSystems.stream().sorted().collect(Collectors.joining("\n")));
        }
        if ((links = documentJson.optJSONArray("links")) != null && !links.isEmpty()) {
            for (int i = 0; i < links.length(); ++i) {
                JSONObject link = links.optJSONObject(i);
                if (link == null) continue;
                entry.addReference(Reference.fromTitleAndUrl(link.getString("title"), link.getString("url")));
            }
        }
        if ((cves = documentJson.optJSONArray("cves")) != null && !cves.isEmpty()) {
            for (int i = 0; i < cves.length(); ++i) {
                JSONObject cve = cves.optJSONObject(i);
                if (cve == null) continue;
                entry.addReferencedVulnerability(VulnerabilityTypeStore.CVE, cve.getString("name"));
            }
        }
        if ((vendorAdvisories = documentJson.optJSONArray("vendor_advisories")) != null && !vendorAdvisories.isEmpty()) {
            for (int i = 0; i < vendorAdvisories.length(); ++i) {
                String url;
                JSONObject vendorAdvisory = vendorAdvisories.optJSONObject(i);
                if (vendorAdvisory == null || (url = vendorAdvisory.optString("url", null)) == null) continue;
                Reference reference = Reference.fromTitleAndUrl(vendorAdvisory.optString("title", null), url);
                if (vendorAdvisory.optString("published_at", null) != null) {
                    reference.addTag(vendorAdvisory.getString("published_at"));
                }
                entry.addReference(reference);
            }
        }
        AdvisoryEntry.extractReferenceIdsFromStringIfPresent(entry.getTextDescription(), (AdvisoryEntry)entry, AdvisoryTypeStore.CERT_FR);
        AdvisoryEntry.extractReferenceIdsFromStringIfPresent(entry.getTextDescription(), (AdvisoryEntry)entry, VulnerabilityTypeStore.CVE);
        AdvisoryEntry.extractReferenceIdsFromStringIfPresent(entry.getReferences().stream().map(Reference::toString).collect(Collectors.joining(", ")), (AdvisoryEntry)entry, AdvisoryTypeStore.CERT_FR);
        return entry;
    }

    public static CertFrAdvisorEntry fromApiJson(File jsonFile) throws IOException {
        return CertFrAdvisorEntry.fromApiJson(new JSONObject(FileUtils.readFileToString((File)jsonFile, (Charset)StandardCharsets.UTF_8)));
    }

    public String toCertFrArchiveLegacyTextFormat() {
        String recommendations;
        String temporaryBypass;
        StringJoiner textFormatJoiner = new StringJoiner("\n");
        textFormatJoiner.add("PREMIER MINISTRE").add("").add("Paris, le 07 juin 2021").add("N\u00b0 " + this.id).add("").add("S . G . D . S . N").add("Agence nationale").add("de la s\u00e9curit\u00e9 des").add("").add("syst\u00e8mes d'information").add("").add("Affaire suivie par: CERT-FR").add("").add("BULLETIN D'ALERTE DU CERT-FR").add("").add("Objet: " + this.summary).add("").add("Gestion du document").add("").add("R\u00e9f\u00e9rence").add("").add("Titre").add("").add(this.id).add("").add(this.summary).add("").add("Date de la premi\u00e8re version " + (this.createDate != null ? Long.valueOf(this.createDate.getTime()) : "")).add("").add("Date de la derni\u00e8re version " + (this.updateDate != null ? Long.valueOf(this.updateDate.getTime()) : "")).add("").add("Source(s)").add("").add("Aucune(s)").add("").add("Pi\u00e8ce(s) jointe(s)").add("").add("Aucune(s)").add("").add("Tableau 1: Gestion du document").add("").add("Une gestion de version d\u00e9taill\u00e9e se trouve \u00e0 la fin de ce document.").add("");
        if (this.threat != null) {
            textFormatJoiner.add("Risque(s)").add("").add(this.threat);
        }
        textFormatJoiner.add("");
        if (this.getDescription("Affected systems") != null) {
            textFormatJoiner.add("Syst\u00e8mes affect\u00e9s").add("");
            textFormatJoiner.add(this.getDescription("Affected systems").getContent()).add("");
        }
        if (this.getDescription("Summary") != null) {
            textFormatJoiner.add("R\u00e9sum\u00e9").add("");
            textFormatJoiner.add(this.getDescription("Summary").getContent()).add("");
        }
        if ((temporaryBypass = (String)ObjectUtils.firstNonNull((Object[])new String[]{this.getDescriptionContent("Temporary bypass"), this.getWorkarounds()})) != null) {
            textFormatJoiner.add("Contournement provisoire").add("");
            textFormatJoiner.add(temporaryBypass).add("");
        }
        if ((recommendations = (String)ObjectUtils.firstNonNull((Object[])new String[]{this.getDescriptionContent("Solution"), this.getRecommendations()})) != null) {
            textFormatJoiner.add("Solution").add("");
            textFormatJoiner.add(recommendations).add("");
        }
        for (DescriptionParagraph description : this.getDescription()) {
            if (description.getHeader() == null || description.getHeader().isEmpty() || description.getHeader().equals("Summary") || description.getHeader().equals("Affected systems") || description.getHeader().equals("Temporary bypass") || description.getHeader().equals("Solution")) continue;
            textFormatJoiner.add(description.getHeader()).add("");
            textFormatJoiner.add(description.getContent()).add("");
        }
        if (!this.references.isEmpty()) {
            textFormatJoiner.add("Documentation").add("");
            for (Reference reference : this.references) {
                if (reference.getTitle() != null) {
                    String title = reference.getTitle().startsWith("CERTFR-") || reference.getTitle().startsWith("CERTA-") ? "; " + reference.getTitle() : reference.getTitle();
                    textFormatJoiner.add(title + (reference.getTags().isEmpty() ? "" : " (" + String.join((CharSequence)", ", reference.getTags()) + ")")).add(reference.getUrl());
                    continue;
                }
                textFormatJoiner.add("Reference").add(reference.getUrl());
            }
            textFormatJoiner.add("");
        }
        return textFormatJoiner.toString();
    }
}

