/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.base;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.AdvisoryMetaData;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;

public abstract class AmbDataClass<AMB extends AbstractModelBase, DC extends AmbDataClass<AMB, DC>>
implements Comparable<AmbDataClass<AMB, DC>> {
    protected static final Set<String> CONVERSION_KEYS_AMB = new HashSet<String>(Arrays.asList(Artifact.Attribute.ID.getKey(), VulnerabilityMetaData.Attribute.NAME.getKey(), AdvisoryMetaData.Attribute.NAME.getKey()));
    protected static final Set<String> CONVERSION_KEYS_MAP = new HashSet<String>(Arrays.asList("id"));
    protected String id;
    protected Map<String, String> additionalAttributes = new LinkedHashMap<String, String>();

    public Map<String, String> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public void setAdditionalAttribute(String key, String value) {
        if (value == null) {
            this.additionalAttributes.remove(key);
        } else {
            this.additionalAttributes.put(key, value);
        }
    }

    public <T extends AbstractModelBase.Attribute> void setAdditionalAttribute(T key, String value) {
        if (value == null) {
            this.additionalAttributes.remove(key.getKey());
        } else {
            this.additionalAttributes.put(key.getKey(), value);
        }
    }

    public String getAdditionalAttribute(String key) {
        return this.additionalAttributes.get(key);
    }

    public <T extends AbstractModelBase.Attribute> String getAdditionalAttribute(T key) {
        return this.additionalAttributes.get(key.getKey());
    }

    public String getId() {
        return this.id;
    }

    public DC setId(String id) {
        this.id = id;
        return (DC)this;
    }

    public abstract AMB constructBaseModel();

    public abstract DC constructDataClass();

    protected abstract Set<String> conversionKeysAmb();

    protected abstract Set<String> conversionKeysMap();

    public void appendFromDataClass(DC dataClass) {
        this.additionalAttributes.putAll(((AmbDataClass)dataClass).getAdditionalAttributes());
        this.setId(((AmbDataClass)dataClass).getId());
    }

    protected void appendToBaseModel(AMB baseModel) {
        for (Map.Entry<String, String> attributes : this.additionalAttributes.entrySet()) {
            baseModel.set(attributes.getKey(), attributes.getValue());
        }
        if (baseModel instanceof VulnerabilityMetaData) {
            baseModel.set(VulnerabilityMetaData.Attribute.NAME.getKey(), this.getId());
        } else if (baseModel instanceof AdvisoryMetaData) {
            baseModel.set(AdvisoryMetaData.Attribute.NAME.getKey(), this.getId());
        } else if (baseModel instanceof Artifact) {
            baseModel.set(Artifact.Attribute.ID.getKey(), this.getId());
        } else {
            baseModel.set("Id", this.getId());
        }
    }

    protected void appendFromBaseModel(AMB baseModel) {
        Set<String> modelKeys = this.conversionKeysAmb();
        baseModel.getAttributes().stream().filter(a -> !modelKeys.contains(a)).forEach(a -> this.getAdditionalAttributes().put((String)a, baseModel.get(a)));
        if (baseModel instanceof VulnerabilityMetaData) {
            this.setId(baseModel.get((AbstractModelBase.Attribute)VulnerabilityMetaData.Attribute.NAME));
        } else if (baseModel instanceof AdvisoryMetaData) {
            this.setId(baseModel.get((AbstractModelBase.Attribute)AdvisoryMetaData.Attribute.NAME));
        } else if (baseModel instanceof Artifact) {
            this.setId(baseModel.get((AbstractModelBase.Attribute)Artifact.Attribute.ID));
        } else {
            this.setId(baseModel.get("Id"));
        }
    }

    protected void appendToJson(JSONObject json) {
        for (Map.Entry<String, String> attributes : this.additionalAttributes.entrySet()) {
            json.put(attributes.getKey(), (Object)attributes.getValue());
        }
        json.put("id", (Object)this.getId());
    }

    protected void appendFromMap(Map<String, Object> map) {
        Set<String> modelKeys = this.conversionKeysMap();
        map.keySet().stream().filter(a -> !modelKeys.contains(a)).forEach(a -> this.getAdditionalAttributes().put((String)a, String.valueOf(map.get(a))));
        if (map.containsKey("id")) {
            this.setId(String.valueOf(map.get("id")));
        }
    }

    protected void appendToDocument(Document document) {
        if (this.getId() == null) {
            throw new IllegalStateException("The ID of an advisory entry must not be null when converting to a lucene document.");
        }
        document.add((IndexableField)new TextField("id", this.getId(), Field.Store.YES));
    }

    protected void appendFromDocument(Document document) {
        this.setId(document.get("id"));
    }

    public AMB toBaseModel() {
        AMB amb = this.constructBaseModel();
        this.appendToBaseModel(amb);
        return amb;
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        this.appendToJson(json);
        return json;
    }

    public Document toDocument() {
        Document document = new Document();
        this.appendToDocument(document);
        return document;
    }

    public <T> T performAction(Consumer<T> action) {
        action.accept(this);
        return (T)this;
    }

    @Override
    public int compareTo(AmbDataClass<AMB, DC> o) {
        if (this.getId() == null && o.getId() == null) {
            return 0;
        }
        if (this.getId() == null) {
            return -1;
        }
        if (o.getId() == null) {
            return 1;
        }
        return String.CASE_INSENSITIVE_ORDER.compare(this.getId(), o.getId());
    }
}

