/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.base;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.base.AmbDataClass;
import com.metaeffekt.mirror.contents.base.DataSourceIndicator;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeIdentifier;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeStore;
import com.metaeffekt.mirror.contents.store.ContentIdentifierStore;
import com.metaeffekt.mirror.contents.store.OtherTypeIdentifier;
import com.metaeffekt.mirror.contents.store.OtherTypeStore;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeIdentifier;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeStore;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.AdvisoryMetaData;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MatchableDetailsAmbDataClass<AMB extends AbstractModelBase, DC extends MatchableDetailsAmbDataClass<AMB, DC>>
extends AmbDataClass<AMB, DC> {
    private static final Logger LOG = LoggerFactory.getLogger(MatchableDetailsAmbDataClass.class);
    protected static final Set<String> CONVERSION_KEYS_AMB = new HashSet<String>(AmbDataClass.CONVERSION_KEYS_AMB){
        {
            this.add(AdvisoryMetaData.Attribute.MATCHING_SOURCE.getKey());
            this.add(AdvisoryMetaData.Attribute.DATA_SOURCE.getKey());
            this.add(AdvisoryMetaData.Attribute.REFERENCED_IDS.getKey());
            this.add(InventoryAttribute.VULNERABILITY_REFERENCED_CONTENT_IDS.getKey());
            this.add(AdvisoryMetaData.Attribute.REFERENCED_SECURITY_ADVISORIES.getKey());
            this.add(VulnerabilityMetaData.Attribute.REFERENCED_SECURITY_ADVISORIES.getKey());
            this.add(AdvisoryMetaData.Attribute.REFERENCED_VULNERABILITIES.getKey());
            this.add(VulnerabilityMetaData.Attribute.REFERENCED_VULNERABILITIES.getKey());
            this.add(AdvisoryMetaData.Attribute.REFERENCED_OTHER.getKey());
            this.add(VulnerabilityMetaData.Attribute.REFERENCED_OTHER.getKey());
        }
    };
    protected static final Set<String> CONVERSION_KEYS_MAP = new HashSet<String>(AmbDataClass.CONVERSION_KEYS_MAP){
        {
            this.add("source");
            this.add("sourceImplementation");
            this.add("dataFillingSources");
            this.add("matchingSources");
            this.add("referencedIds");
            this.add("referencedSecurityAdvisories");
            this.add("referencedVulnerabilities");
            this.add("referencedOtherIds");
        }
    };
    protected final Map<VulnerabilityTypeIdentifier<?>, Set<String>> referencedVulnerabilities = new HashMap();
    protected final Map<AdvisoryTypeIdentifier<?>, Set<String>> referencedSecurityAdvisories = new HashMap();
    protected final Map<OtherTypeIdentifier, Set<String>> referencedOtherIds = new HashMap<OtherTypeIdentifier, Set<String>>();
    protected final List<DataSourceIndicator> matchingSources = new ArrayList<DataSourceIndicator>();
    protected final Set<ContentIdentifierStore.ContentIdentifier> dataSources = new HashSet<ContentIdentifierStore.ContentIdentifier>();
    protected final Map<String, Set<Artifact>> affectedArtifacts = new HashMap<String, Set<Artifact>>();

    public abstract ContentIdentifierStore.ContentIdentifier getSourceIdentifier();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DC addMatchingSource(DataSourceIndicator matchingSource) {
        try {
            DataSourceIndicator.ArtifactReason artifactReason;
            if (matchingSource == null) {
                LOG.warn("Attempted to add null matching source to {}", (Object)this.getClass().getSimpleName());
                return (DC)this;
            }
            List<DataSourceIndicator> list = this.matchingSources;
            synchronized (list) {
                this.matchingSources.add(matchingSource);
            }
            if (matchingSource.getMatchReason() instanceof DataSourceIndicator.ArtifactReason && (artifactReason = (DataSourceIndicator.ArtifactReason)matchingSource.getMatchReason()).hasArtifact()) {
                this.manuallyAffectsArtifact(Artifact.Attribute.VULNERABILITY.getKey(), artifactReason.getArtifact());
            }
            return (DC)this;
        }
        catch (Exception e) {
            LOG.error("Error while adding matching source [{}] to [{}]: {}", new Object[]{matchingSource, this.getClass().getSimpleName(), this.getId(), e});
            return (DC)this;
        }
    }

    public DC addDataSource(ContentIdentifierStore.ContentIdentifier dataSource) {
        this.dataSources.add(dataSource);
        return (DC)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Artifact> getAffectedArtifactsByKey(String key) {
        Map<String, Set<Artifact>> map = this.affectedArtifacts;
        synchronized (map) {
            return this.affectedArtifacts.getOrDefault(key, Collections.emptySet());
        }
    }

    public Set<Artifact> getAffectedArtifactsByDefaultKey() {
        return this.getAffectedArtifactsByKey(Artifact.Attribute.VULNERABILITY.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DC manuallyAffectsArtifact(String key, Artifact artifact) {
        if (artifact != null) {
            Map<String, Set<Artifact>> map = this.affectedArtifacts;
            synchronized (map) {
                this.affectedArtifacts.computeIfAbsent(key, k -> new HashSet()).add(artifact);
            }
            if (!Artifact.Attribute.VULNERABILITY.getKey().equals(key)) {
                String presentVulnerabilities = artifact.get(key);
                HashSet<String> vulnerabilities = StringUtils.hasText(presentVulnerabilities) ? Arrays.stream(presentVulnerabilities.split(", ")).collect(Collectors.toSet()) : new HashSet<String>();
                vulnerabilities.add(this.getId());
                artifact.set(key, String.join((CharSequence)", ", vulnerabilities));
            }
        }
        return (DC)this;
    }

    public DC manuallyAffectsArtifact(AbstractModelBase.Attribute key, Artifact artifact) {
        return this.manuallyAffectsArtifact(key.getKey(), artifact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DC removeAffectsArtifact(String key, Artifact artifact) {
        if (artifact != null) {
            Map<String, Set<Artifact>> map = this.affectedArtifacts;
            synchronized (map) {
                this.affectedArtifacts.computeIfAbsent(key, k -> new HashSet()).remove(artifact);
            }
            String presentVulnerabilities = artifact.get(key);
            HashSet vulnerabilities = StringUtils.hasText(presentVulnerabilities) ? Arrays.stream(presentVulnerabilities.split(", ")).collect(Collectors.toSet()) : new HashSet();
            vulnerabilities.remove(this.getId());
            artifact.set(key, String.join((CharSequence)", ", vulnerabilities));
        }
        return (DC)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReferencedSecurityAdvisory(AdvisoryTypeIdentifier<?> source, String id) {
        if (source == null || id == null) {
            LOG.warn("Cannot add referenced security advisory with null source or id on advisory [{}]", (Object)this.id);
            return;
        }
        Map<AdvisoryTypeIdentifier<?>, Set<String>> map = this.referencedSecurityAdvisories;
        synchronized (map) {
            this.referencedSecurityAdvisories.computeIfAbsent(source, k -> new LinkedHashSet()).add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReferencedSecurityAdvisories(Map<AdvisoryTypeIdentifier<?>, Set<String>> referencedSecurityAdvisories) {
        Map<AdvisoryTypeIdentifier<?>, Set<String>> map = this.referencedSecurityAdvisories;
        synchronized (map) {
            for (Map.Entry<AdvisoryTypeIdentifier<?>, Set<String>> entry : referencedSecurityAdvisories.entrySet()) {
                this.referencedSecurityAdvisories.computeIfAbsent(entry.getKey(), k -> new LinkedHashSet()).addAll((Collection)entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReferencedSecurityAdvisories(AdvisoryTypeIdentifier<?> source, Set<String> referencedSecurityAdvisories) {
        Map<AdvisoryTypeIdentifier<?>, Set<String>> map = this.referencedSecurityAdvisories;
        synchronized (map) {
            this.referencedSecurityAdvisories.computeIfAbsent(source, k -> new LinkedHashSet()).addAll(referencedSecurityAdvisories);
        }
    }

    public void addReferencedSecurityAdvisory(AdvisoryEntry advisory) {
        if (advisory == null) {
            LOG.warn("Cannot add referenced security advisory with null advisory on advisory [{}]", (Object)this.id);
            return;
        }
        this.addReferencedSecurityAdvisory((AdvisoryTypeIdentifier<?>)advisory.getSourceIdentifier(), advisory.getId());
    }

    public void addReferencedSecurityAdvisories(Collection<AdvisoryEntry> advisories) {
        advisories.forEach(this::addReferencedSecurityAdvisory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReferencedSecurityAdvisory(AdvisoryTypeIdentifier<?> source, String id) {
        Map<AdvisoryTypeIdentifier<?>, Set<String>> map = this.referencedSecurityAdvisories;
        synchronized (map) {
            this.referencedSecurityAdvisories.computeIfPresent(source, (k, v) -> {
                v.remove(id);
                return v;
            });
            if (this.referencedSecurityAdvisories.get(source) == null || this.referencedSecurityAdvisories.get(source).isEmpty()) {
                this.referencedSecurityAdvisories.remove(source);
            }
        }
    }

    public void removeReferencedSecurityAdvisory(AdvisoryEntry advisory) {
        if (advisory == null) {
            LOG.warn("Cannot remove referenced security advisory with null advisory on advisory [{}]", (Object)this.id);
            return;
        }
        this.removeReferencedSecurityAdvisory((AdvisoryTypeIdentifier<?>)advisory.getSourceIdentifier(), advisory.getId());
    }

    public void removeReferencedSecurityAdvisories(Collection<AdvisoryEntry> advisories) {
        advisories.forEach(this::removeReferencedSecurityAdvisory);
    }

    public void addReferencedVulnerability(VulnerabilityTypeIdentifier<?> source, String id) {
        if (source == null || id == null) {
            LOG.warn("Cannot add referenced vulnerability with null source or id on advisory [{}]", (Object)this.id);
            return;
        }
        this.referencedVulnerabilities.computeIfAbsent(source, k -> new LinkedHashSet()).add(id);
    }

    public void addReferencedVulnerabilities(Map<VulnerabilityTypeIdentifier<?>, Set<String>> referencedVulnerabilities) {
        for (Map.Entry<VulnerabilityTypeIdentifier<?>, Set<String>> entry : referencedVulnerabilities.entrySet()) {
            this.referencedVulnerabilities.computeIfAbsent(entry.getKey(), k -> new LinkedHashSet()).addAll((Collection)entry.getValue());
        }
    }

    public void addReferencedVulnerabilities(VulnerabilityTypeIdentifier<?> source, Collection<String> referencedVulnerabilities) {
        this.referencedVulnerabilities.computeIfAbsent(source, k -> new LinkedHashSet()).addAll(referencedVulnerabilities);
    }

    public void addReferencedVulnerability(Vulnerability vulnerability) {
        if (vulnerability == null) {
            LOG.warn("Cannot add referenced vulnerability with null vulnerability on advisory [{}]", (Object)this.id);
            return;
        }
        this.addReferencedVulnerability((VulnerabilityTypeIdentifier<?>)vulnerability.getSourceIdentifier(), vulnerability.getId());
    }

    public void addReferencedVulnerabilities(Collection<Vulnerability> vulnerabilities) {
        vulnerabilities.forEach(this::addReferencedVulnerability);
    }

    public void removeReferencedVulnerability(VulnerabilityTypeIdentifier<?> source, String id) {
        this.referencedVulnerabilities.computeIfPresent(source, (k, v) -> {
            v.remove(id);
            return v;
        });
        if (this.referencedVulnerabilities.get(source) == null || this.referencedVulnerabilities.get(source).isEmpty()) {
            this.referencedVulnerabilities.remove(source);
        }
    }

    public void removeReferencedVulnerability(Vulnerability vulnerability) {
        if (vulnerability == null) {
            LOG.warn("Cannot remove referenced vulnerability with null vulnerability on advisory [{}]", (Object)this.id);
            return;
        }
        this.removeReferencedVulnerability((VulnerabilityTypeIdentifier<?>)vulnerability.getSourceIdentifier(), vulnerability.getId());
    }

    public void removeReferencedVulnerabilities(Collection<Vulnerability> vulnerabilities) {
        vulnerabilities.forEach(this::removeReferencedVulnerability);
    }

    public void addOtherReferencedId(OtherTypeIdentifier source, String id) {
        if (source == null || id == null) {
            LOG.warn("Cannot add other referenced id with null source or id on advisory [{}]", (Object)this.id);
            return;
        }
        this.referencedOtherIds.computeIfAbsent(source, k -> new LinkedHashSet()).add(id);
    }

    public void addOtherReferencedIds(Map<OtherTypeIdentifier, Set<String>> referencedOtherIds) {
        for (Map.Entry<OtherTypeIdentifier, Set<String>> entry : referencedOtherIds.entrySet()) {
            this.referencedOtherIds.computeIfAbsent(entry.getKey(), k -> new LinkedHashSet()).addAll((Collection)entry.getValue());
        }
    }

    public void addOtherReferencedIds(OtherTypeIdentifier source, Collection<String> referencedOtherIds) {
        this.referencedOtherIds.computeIfAbsent(source, k -> new LinkedHashSet()).addAll(referencedOtherIds);
    }

    public void removeOtherReferencedId(OtherTypeIdentifier source, String id) {
        this.referencedOtherIds.computeIfPresent(source, (k, v) -> {
            v.remove(id);
            return v;
        });
        if (this.referencedOtherIds.get(source) == null || this.referencedOtherIds.get(source).isEmpty()) {
            this.referencedOtherIds.remove(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getReferencedSecurityAdvisories(AdvisoryTypeIdentifier<?> source) {
        Map<AdvisoryTypeIdentifier<?>, Set<String>> map = this.referencedSecurityAdvisories;
        synchronized (map) {
            return this.referencedSecurityAdvisories.getOrDefault(source, Collections.emptySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getReferencedVulnerabilities(VulnerabilityTypeIdentifier<?> source) {
        Map<VulnerabilityTypeIdentifier<?>, Set<String>> map = this.referencedVulnerabilities;
        synchronized (map) {
            return this.referencedVulnerabilities.getOrDefault(source, Collections.emptySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getReferencedOtherIds(OtherTypeIdentifier source) {
        Map<OtherTypeIdentifier, Set<String>> map = this.referencedOtherIds;
        synchronized (map) {
            return this.referencedOtherIds.getOrDefault(source, Collections.emptySet());
        }
    }

    @Override
    public void appendFromBaseModel(AMB amb) {
        String dataFillingSources;
        String matchingSource;
        String legacyReferencedIds;
        String referencedSecurityAdvisories;
        super.appendFromBaseModel(amb);
        String referencedVulnerabilities = amb.get((AbstractModelBase.Attribute)AdvisoryMetaData.Attribute.REFERENCED_VULNERABILITIES);
        if (referencedVulnerabilities != null) {
            this.addReferencedVulnerabilities(VulnerabilityTypeStore.get().fromJsonMultipleReferencedIds(new JSONArray(referencedVulnerabilities)));
        }
        if ((referencedSecurityAdvisories = amb.get((AbstractModelBase.Attribute)AdvisoryMetaData.Attribute.REFERENCED_SECURITY_ADVISORIES)) != null) {
            this.addReferencedSecurityAdvisories(AdvisoryTypeStore.get().fromJsonMultipleReferencedIds(new JSONArray(referencedSecurityAdvisories)));
        }
        if ((legacyReferencedIds = amb.get((AbstractModelBase.Attribute)AdvisoryMetaData.Attribute.REFERENCED_IDS)) != null) {
            this.appendLegacyReferencedIds(ContentIdentifierStore.parseLegacyJsonReferencedIds(new JSONObject(legacyReferencedIds)));
        }
        if ((legacyReferencedIds = amb.get((AbstractModelBase.Attribute)InventoryAttribute.VULNERABILITY_REFERENCED_CONTENT_IDS)) != null) {
            this.appendLegacyReferencedIds(ContentIdentifierStore.parseLegacyJsonReferencedIds(new JSONObject(legacyReferencedIds)));
        }
        if ((matchingSource = amb.get((AbstractModelBase.Attribute)AdvisoryMetaData.Attribute.MATCHING_SOURCE)) != null) {
            DataSourceIndicator.fromJson(new JSONArray(matchingSource)).forEach(this::addMatchingSource);
        }
        if ((dataFillingSources = amb.get((AbstractModelBase.Attribute)AdvisoryMetaData.Attribute.DATA_SOURCE)) != null) {
            Arrays.stream(dataFillingSources.split(", ?")).filter(StringUtils::hasText).distinct().forEach(this::addDataSourceFromSourceString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendToBaseModel(AMB modelBase) {
        String sourceImplementationKey;
        super.appendToBaseModel(modelBase);
        Map<ContentIdentifierStore.ContentIdentifier, Set<String>> map = this.referencedVulnerabilities;
        synchronized (map) {
            if (!this.referencedVulnerabilities.isEmpty()) {
                modelBase.set(AdvisoryMetaData.Attribute.REFERENCED_VULNERABILITIES.getKey(), ContentIdentifierStore.toJson(this.referencedVulnerabilities).toString());
            } else {
                modelBase.set(AdvisoryMetaData.Attribute.REFERENCED_VULNERABILITIES.getKey(), null);
            }
        }
        map = this.referencedSecurityAdvisories;
        synchronized (map) {
            if (!this.referencedSecurityAdvisories.isEmpty()) {
                modelBase.set(AdvisoryMetaData.Attribute.REFERENCED_SECURITY_ADVISORIES.getKey(), ContentIdentifierStore.toJson(this.referencedSecurityAdvisories).toString());
            } else {
                modelBase.set(AdvisoryMetaData.Attribute.REFERENCED_SECURITY_ADVISORIES.getKey(), null);
            }
        }
        if (!this.referencedOtherIds.isEmpty()) {
            modelBase.set(AdvisoryMetaData.Attribute.REFERENCED_OTHER.getKey(), ContentIdentifierStore.toJson(this.referencedOtherIds).toString());
        } else {
            modelBase.set(AdvisoryMetaData.Attribute.REFERENCED_OTHER.getKey(), null);
        }
        ContentIdentifierStore.ContentIdentifier sourceIdentifier = this.getSourceIdentifier();
        String sourceKey = modelBase instanceof VulnerabilityMetaData ? VulnerabilityMetaData.Attribute.SOURCE.getKey() : AdvisoryMetaData.Attribute.SOURCE.getKey();
        String string = sourceImplementationKey = modelBase instanceof VulnerabilityMetaData ? VulnerabilityMetaData.Attribute.SOURCE_IMPLEMENTATION.getKey() : AdvisoryMetaData.Attribute.SOURCE_IMPLEMENTATION.getKey();
        if (sourceIdentifier != null) {
            modelBase.set(sourceKey, sourceIdentifier.getName());
            modelBase.set(sourceImplementationKey, sourceIdentifier.getImplementation());
        } else {
            LOG.warn("[{}] does not have source to write into [{}] when converting to [{}]", new Object[]{this.getId(), sourceKey, modelBase.getClass().getSimpleName()});
            modelBase.set(sourceKey, null);
            modelBase.set(sourceImplementationKey, null);
        }
        JSONObject legacyReferencedIds = ContentIdentifierStore.mergeIntoLegacyJson(Arrays.asList(this.referencedVulnerabilities, this.referencedSecurityAdvisories, this.referencedOtherIds));
        if (!legacyReferencedIds.isEmpty()) {
            modelBase.set(InventoryAttribute.VULNERABILITY_REFERENCED_CONTENT_IDS.getKey(), legacyReferencedIds.toString());
            modelBase.set(AdvisoryMetaData.Attribute.REFERENCED_IDS.getKey(), legacyReferencedIds.toString());
        } else {
            modelBase.set(InventoryAttribute.VULNERABILITY_REFERENCED_CONTENT_IDS.getKey(), null);
            modelBase.set(AdvisoryMetaData.Attribute.REFERENCED_IDS.getKey(), null);
        }
        List<DataSourceIndicator> list = this.matchingSources;
        synchronized (list) {
            block26: {
                if (!this.matchingSources.isEmpty()) {
                    modelBase.set(AdvisoryMetaData.Attribute.MATCHING_SOURCE.getKey(), DataSourceIndicator.toJson(this.matchingSources).toString());
                    try {
                        Set productUris = this.matchingSources.stream().filter(Objects::nonNull).map(DataSourceIndicator::getMatchReason).filter(s -> s instanceof DataSourceIndicator.ArtifactCpeReason).map(s -> ((DataSourceIndicator.ArtifactCpeReason)s).getCpe()).collect(Collectors.toSet());
                        if (!productUris.isEmpty()) {
                            modelBase.set(VulnerabilityMetaData.Attribute.PRODUCT_URIS.getKey(), String.join((CharSequence)", ", productUris));
                            break block26;
                        }
                        modelBase.set(VulnerabilityMetaData.Attribute.PRODUCT_URIS.getKey(), null);
                    }
                    catch (Exception e) {
                        LOG.error("Error while converting to [{}] while extracting product URIs from CPE sources for [{}]: {}", new Object[]{modelBase.getClass().getSimpleName(), this.getId(), this.matchingSources, e});
                    }
                } else {
                    modelBase.set(AdvisoryMetaData.Attribute.MATCHING_SOURCE.getKey(), null);
                }
            }
        }
        if (!this.dataSources.isEmpty()) {
            modelBase.set(AdvisoryMetaData.Attribute.DATA_SOURCE.getKey(), this.dataSources.stream().map(ContentIdentifierStore.ContentIdentifier::getName).collect(Collectors.joining(", ")));
        } else {
            modelBase.set(AdvisoryMetaData.Attribute.DATA_SOURCE.getKey(), null);
        }
    }

    @Override
    public void appendFromDataClass(DC dataClass) {
        super.appendFromDataClass(dataClass);
        this.addReferencedVulnerabilities(((MatchableDetailsAmbDataClass)dataClass).getReferencedVulnerabilities());
        this.addReferencedSecurityAdvisories(((MatchableDetailsAmbDataClass)dataClass).getReferencedSecurityAdvisories());
        this.addOtherReferencedIds(((MatchableDetailsAmbDataClass)dataClass).getReferencedOtherIds());
        this.matchingSources.addAll(((MatchableDetailsAmbDataClass)dataClass).getMatchingSources());
        this.dataSources.addAll(((MatchableDetailsAmbDataClass)dataClass).getDataSources());
    }

    @Override
    public void appendFromMap(Map<String, Object> input) {
        String sources;
        super.appendFromMap(input);
        if (input.containsKey("referencedVulnerabilities") && input.get("referencedVulnerabilities") instanceof List) {
            this.addReferencedVulnerabilities(VulnerabilityTypeStore.get().fromListMultipleReferencedIds((List)input.get("referencedVulnerabilities")));
        }
        if (input.containsKey("referencedSecurityAdvisories") && input.get("referencedSecurityAdvisories") instanceof List) {
            this.addReferencedSecurityAdvisories(AdvisoryTypeStore.get().fromListMultipleReferencedIds((List)input.get("referencedSecurityAdvisories")));
        }
        if (input.containsKey("referencedOtherIds") && input.get("referencedOtherIds") instanceof List) {
            this.addOtherReferencedIds(OtherTypeStore.get().fromListMultipleReferencedIds((List)input.get("referencedOtherIds")));
        }
        if (input.containsKey("referencedIds") && input.get("referencedIds") instanceof Map) {
            this.appendLegacyReferencedIds(ContentIdentifierStore.parseLegacyJsonReferencedIds((Map)input.get("referencedIds")));
        }
        if (input.containsKey("dataSources") && StringUtils.hasText(sources = input.get("dataSources").toString())) {
            for (String source : sources.split(", ?")) {
                this.addDataSourceFromSourceString(source);
            }
        }
        if (input.containsKey("matchingSources")) {
            sources = input.get("matchingSources").toString();
            DataSourceIndicator.fromJson(new JSONArray(sources)).forEach(this::addMatchingSource);
        }
    }

    @Override
    public void appendToJson(JSONObject json) {
        JSONObject legacyReferencedIds;
        super.appendToJson(json);
        ContentIdentifierStore.ContentIdentifier sourceIdentifier = this.getSourceIdentifier();
        if (sourceIdentifier != null) {
            json.put("source", (Object)sourceIdentifier.getName());
            json.put("sourceImplementation", (Object)sourceIdentifier.getImplementation());
        }
        if (!this.referencedVulnerabilities.isEmpty()) {
            json.put("referencedVulnerabilities", (Object)ContentIdentifierStore.toJson(this.referencedVulnerabilities));
        }
        if (!this.referencedSecurityAdvisories.isEmpty()) {
            json.put("referencedSecurityAdvisories", (Object)ContentIdentifierStore.toJson(this.referencedSecurityAdvisories));
        }
        if (!this.referencedOtherIds.isEmpty()) {
            json.put("referencedOtherIds", (Object)ContentIdentifierStore.toJson(this.referencedOtherIds));
        }
        if (!(legacyReferencedIds = ContentIdentifierStore.mergeIntoLegacyJson(Arrays.asList(this.referencedVulnerabilities, this.referencedSecurityAdvisories))).isEmpty()) {
            json.put("referencedIds", (Object)legacyReferencedIds);
        }
        json.put("dataSources", (Object)this.getDataSources().stream().map(ContentIdentifierStore.ContentIdentifier::getName).collect(Collectors.joining(", ")));
        json.put("matchingSources", (Object)DataSourceIndicator.toJson(this.getMatchingSources()).toString());
    }

    @Override
    public void appendFromDocument(Document document) {
        super.appendFromDocument(document);
        if (document.get("sources") != null) {
            for (String source : document.get("sources").split(", ?")) {
                this.addDataSourceFromSourceString(source);
            }
        }
        if (document.get("referencedVulnerabilities") != null) {
            this.addReferencedVulnerabilities(VulnerabilityTypeStore.get().fromJsonMultipleReferencedIds(new JSONArray(document.get("referencedVulnerabilities"))));
        }
        if (document.get("referencedSecurityAdvisories") != null) {
            this.addReferencedSecurityAdvisories(AdvisoryTypeStore.get().fromJsonMultipleReferencedIds(new JSONArray(document.get("referencedSecurityAdvisories"))));
        }
        if (document.get("referencedOtherIds") != null) {
            this.addOtherReferencedIds(OtherTypeStore.get().fromJsonMultipleReferencedIds(new JSONArray(document.get("referencedOtherIds"))));
        }
        if (document.get("referencedIds") != null) {
            this.appendLegacyReferencedIds(ContentIdentifierStore.parseLegacyJsonReferencedIds(new JSONObject(document.get("referencedIds"))));
        }
    }

    private void addDataSourceFromSourceString(String source) {
        ContentIdentifierStore.ContentIdentifier dataSource = this.findDataSourceFromSourceString(source);
        if (dataSource != null) {
            this.addDataSource(dataSource);
        }
    }

    private ContentIdentifierStore.ContentIdentifier findDataSourceFromSourceString(String source) {
        VulnerabilityTypeIdentifier vulnerabilityTypeIdentifier = (VulnerabilityTypeIdentifier)VulnerabilityTypeStore.get().fromNameWithoutCreation(source);
        AdvisoryTypeIdentifier advisoryTypeIdentifier = (AdvisoryTypeIdentifier)AdvisoryTypeStore.get().fromNameWithoutCreation(source);
        if (vulnerabilityTypeIdentifier != null) {
            return vulnerabilityTypeIdentifier;
        }
        if (advisoryTypeIdentifier != null) {
            return advisoryTypeIdentifier;
        }
        if (!"NVD".equals(source)) {
            LOG.warn("Could not find source identifier for [{}] on [{}]", (Object)source, (Object)this.getId());
        }
        return null;
    }

    @Override
    public void appendToDocument(Document doc) {
        JSONObject legacyReferencedIds;
        super.appendToDocument(doc);
        ContentIdentifierStore.ContentIdentifier sourceIdentifier = this.getSourceIdentifier();
        if (sourceIdentifier != null) {
            doc.add((IndexableField)new TextField("source", sourceIdentifier.getName(), Field.Store.YES));
            doc.add((IndexableField)new TextField("sourceImplementation", sourceIdentifier.getImplementation(), Field.Store.YES));
            doc.add((IndexableField)new TextField("sources", sourceIdentifier.getName(), Field.Store.YES));
        }
        if (!this.referencedVulnerabilities.isEmpty()) {
            doc.add((IndexableField)new TextField("referencedVulnerabilities", ContentIdentifierStore.toJson(this.referencedVulnerabilities).toString(), Field.Store.YES));
        }
        if (!this.referencedSecurityAdvisories.isEmpty()) {
            doc.add((IndexableField)new TextField("referencedSecurityAdvisories", ContentIdentifierStore.toJson(this.referencedSecurityAdvisories).toString(), Field.Store.YES));
        }
        if (!this.referencedOtherIds.isEmpty()) {
            doc.add((IndexableField)new TextField("referencedOtherIds", ContentIdentifierStore.toJson(this.referencedOtherIds).toString(), Field.Store.YES));
        }
        if (!(legacyReferencedIds = ContentIdentifierStore.mergeIntoLegacyJson(Arrays.asList(this.referencedVulnerabilities, this.referencedSecurityAdvisories))).isEmpty()) {
            doc.add((IndexableField)new TextField("referencedIds", legacyReferencedIds.toString(), Field.Store.YES));
        }
    }

    private void appendLegacyReferencedIds(Map<ContentIdentifierStore.ContentIdentifier, Set<String>> legacyReferencedIds) {
        this.addReferencedVulnerabilities(legacyReferencedIds.entrySet().stream().filter(e -> e.getKey() instanceof VulnerabilityTypeIdentifier).collect(Collectors.toMap(e -> (VulnerabilityTypeIdentifier)e.getKey(), Map.Entry::getValue)));
        this.addReferencedSecurityAdvisories(legacyReferencedIds.entrySet().stream().filter(e -> e.getKey() instanceof AdvisoryTypeIdentifier).collect(Collectors.toMap(e -> (AdvisoryTypeIdentifier)e.getKey(), Map.Entry::getValue)));
        this.addOtherReferencedIds(legacyReferencedIds.entrySet().stream().filter(e -> e.getKey() instanceof OtherTypeIdentifier).collect(Collectors.toMap(e -> (OtherTypeIdentifier)e.getKey(), Map.Entry::getValue)));
    }

    public Map<VulnerabilityTypeIdentifier<?>, Set<String>> getReferencedVulnerabilities() {
        return this.referencedVulnerabilities;
    }

    public Map<AdvisoryTypeIdentifier<?>, Set<String>> getReferencedSecurityAdvisories() {
        return this.referencedSecurityAdvisories;
    }

    public Map<OtherTypeIdentifier, Set<String>> getReferencedOtherIds() {
        return this.referencedOtherIds;
    }

    public List<DataSourceIndicator> getMatchingSources() {
        return this.matchingSources;
    }

    public Set<ContentIdentifierStore.ContentIdentifier> getDataSources() {
        return this.dataSources;
    }

    public Map<String, Set<Artifact>> getAffectedArtifacts() {
        return this.affectedArtifacts;
    }
}

