/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.eol;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.version.Version;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.VersionComparator;
import com.metaeffekt.mirror.contents.eol.EolCycle;
import com.metaeffekt.mirror.contents.eol.state.LtsState;
import com.metaeffekt.mirror.contents.eol.state.SupportState;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EolLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(EolLifecycle.class);
    private final String product;
    private final List<EolCycle> cycles;

    public EolLifecycle(String product, List<EolCycle> cycles) {
        this.product = product;
        this.cycles = cycles;
    }

    public EolLifecycle(String product) {
        this.product = product;
        this.cycles = new ArrayList<EolCycle>();
    }

    public String getProduct() {
        return this.product;
    }

    public List<EolCycle> getCycles() {
        return this.cycles;
    }

    public List<EolCycle> getOrderedCycles() {
        try {
            return this.cycles.stream().sorted(Comparator.comparing(o -> Version.of(o.getCycle()))).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOG.debug("Error sorting cycles for product [{}], returning unordered list: {}", new Object[]{this.product, this.cycles, e});
            return this.cycles;
        }
    }

    public void addCycle(EolCycle cycle) {
        this.cycles.add(cycle);
    }

    public EolCycle findCycleFromVersion(String cycleQueryVersion) {
        if (cycleQueryVersion == null) {
            return null;
        }
        return this.cycles.stream().max(Comparator.comparingInt(o -> o.matchVersion(cycleQueryVersion))).orElse(null);
    }

    public EolCycle findCycleFromCycle(String cycle) {
        if (cycle == null) {
            return null;
        }
        return this.cycles.stream().filter(c -> c.getCycle().equals(cycle)).findFirst().orElse(null);
    }

    public List<EolCycle> findCyclesAfter(EolCycle cycle) {
        if (cycle == null) {
            return null;
        }
        ArrayList<EolCycle> result = new ArrayList<EolCycle>();
        boolean found = false;
        for (EolCycle c : this.cycles) {
            if (found) {
                result.add(c);
            }
            if (!c.equals(cycle)) continue;
            found = true;
        }
        return result;
    }

    public List<EolCycle> findCyclesBefore(EolCycle cycle) {
        if (cycle == null) {
            return null;
        }
        ArrayList<EolCycle> result = new ArrayList<EolCycle>();
        boolean found = false;
        for (EolCycle c : this.cycles) {
            if (c.equals(cycle)) {
                found = true;
            }
            if (found) continue;
            result.add(c);
        }
        return result;
    }

    public EolCycle findNextSupportedCycle(EolCycle cycle) {
        if (cycle == null) {
            return null;
        }
        List<EolCycle> cyclesAfter = this.findCyclesAfter(cycle);
        if (cyclesAfter.isEmpty()) {
            return null;
        }
        for (EolCycle c : cyclesAfter) {
            SupportState supportState = c.getSupportState();
            if (supportState != SupportState.SUPPORT && supportState != SupportState.UPCOMING_SUPPORT_END_DATE && supportState != SupportState.DISTANT_SUPPORT_END_DATE) continue;
            return c;
        }
        return null;
    }

    public EolCycle findNextExtendedSupportCycle(EolCycle cycle) {
        if (cycle == null) {
            return null;
        }
        List<EolCycle> cyclesAfter = this.findCyclesAfter(cycle);
        if (cyclesAfter.isEmpty()) {
            return null;
        }
        for (EolCycle c : cyclesAfter) {
            SupportState supportState = c.getExtendedSupportState();
            if (supportState != SupportState.SUPPORT && supportState != SupportState.UPCOMING_SUPPORT_END_DATE && supportState != SupportState.DISTANT_SUPPORT_END_DATE) continue;
            return c;
        }
        return null;
    }

    public EolCycle findClosestActiveLtsVersionCycle(EolCycle cycle) {
        if (cycle == null) {
            return null;
        }
        LtsState ltsState = cycle.getLtsState();
        if (ltsState == LtsState.LTS || ltsState == LtsState.LTS_DATE_REACHED) {
            return cycle;
        }
        List<EolCycle> cyclesAfter = this.findCyclesAfter(cycle);
        for (EolCycle c : cyclesAfter) {
            LtsState ltsState2 = c.getLtsState();
            if (ltsState2 != LtsState.LTS && ltsState2 != LtsState.LTS_DATE_REACHED) continue;
            return c;
        }
        List<EolCycle> cyclesBefore = this.findCyclesBefore(cycle);
        for (int i = cyclesBefore.size() - 1; i >= 0; --i) {
            EolCycle c = cyclesBefore.get(i);
            LtsState ltsState3 = c.getLtsState();
            if (ltsState3 != LtsState.LTS && ltsState3 != LtsState.LTS_DATE_REACHED) continue;
            return c;
        }
        return null;
    }

    public EolCycle findLatestActiveLtsVersionCycle(EolCycle cycle) {
        if (cycle == null) {
            return null;
        }
        List<EolCycle> cyclesAfter = this.findCyclesAfter(cycle);
        for (int i = cyclesAfter.size() - 1; i >= 0; --i) {
            EolCycle c = cyclesAfter.get(i);
            LtsState ltsState = c.getLtsState();
            if (ltsState != LtsState.LTS && ltsState != LtsState.LTS_DATE_REACHED) continue;
            return c;
        }
        return null;
    }

    public JSONArray toJson() {
        JSONArray json = new JSONArray();
        for (EolCycle cycle : this.cycles) {
            json.put((Object)cycle.toJson());
        }
        return json;
    }

    public List<Document> toDocuments() {
        ArrayList<Document> documents = new ArrayList<Document>();
        for (EolCycle cycle : this.cycles) {
            documents.add(cycle.toDocument());
        }
        return documents;
    }

    public static EolLifecycle fromJson(String product, JSONArray json) {
        EolLifecycle productInfo = new EolLifecycle(product);
        for (int i = 0; i < json.length(); ++i) {
            EolCycle cycle = EolCycle.fromJson(json.getJSONObject(i));
            cycle.setProduct(product);
            productInfo.addCycle(cycle);
        }
        return productInfo;
    }

    public void writeToDirectory(File dir) throws IOException {
        File file = new File(dir, this.product + ".json");
        FileUtils.write((File)file, (CharSequence)this.toJson().toString(), (Charset)StandardCharsets.UTF_8);
    }

    public String toLink() {
        return "https://endoflife.date/" + this.product;
    }

    public String toString() {
        return this.toJson().toString();
    }

    public String getLatestVersion() {
        return this.cycles.stream().map(EolCycle::getLatest).peek(cycle -> {
            if (cycle == null) {
                LOG.warn("Cycle is null for product, will filter out: {}", (Object)this.product);
                LOG.warn("                                  All data: {}", (Object)this);
            }
        }).filter(Objects::nonNull).max(VersionComparator.INSTANCE).orElse(null);
    }
}

