/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.eol;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import java.util.Date;
import java.util.function.Supplier;

public class StateMapping<T> {
    private static Supplier<Date> NOW = Date::new;
    private final T notState;
    private final T state;
    private final T onDateState;
    private final T upcomingState;
    private final T closeUpcomingState;
    private final boolean nullMeansSupported;
    private final String stateName;

    public StateMapping(T notState, T state, T onDateState, T upcomingState, boolean nullMeansSupported, String stateName) {
        this(notState, state, onDateState, upcomingState, upcomingState, nullMeansSupported, stateName);
    }

    public StateMapping(T notState, T state, T onDateState, T upcomingState, T closeUpcomingState, boolean nullMeansSupported, String stateName) {
        this.notState = notState;
        this.state = state;
        this.onDateState = onDateState;
        this.upcomingState = upcomingState;
        this.closeUpcomingState = closeUpcomingState;
        this.nullMeansSupported = nullMeansSupported;
        this.stateName = stateName;
    }

    public static void setNOW(Supplier<Date> NOW) {
        StateMapping.NOW = NOW;
    }

    public static Date getNOW() {
        return NOW.get();
    }

    public static void resetNOW() {
        NOW = Date::new;
    }

    public T getState(String stateString, long millisUntilCloseUpcoming) {
        boolean isEmpty = StringUtils.isEmpty(stateString);
        if (isEmpty) {
            if (this.nullMeansSupported) {
                return this.state;
            }
            return this.notState;
        }
        if (stateString.equals("true") || stateString.equals(this.stateName)) {
            return this.state;
        }
        if (stateString.equals("false")) {
            return this.notState;
        }
        Date stateDate = TimeUtils.tryParse(stateString);
        if (stateDate == null) {
            return this.notState;
        }
        long distanceFromNowToDate = stateDate.getTime() - NOW.get().getTime();
        if (distanceFromNowToDate <= 0L) {
            return this.onDateState;
        }
        if (distanceFromNowToDate <= millisUntilCloseUpcoming) {
            return this.closeUpcomingState;
        }
        return this.upcomingState;
    }
}

