/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.eol.export;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.version.Version;
import com.metaeffekt.artifact.analysis.version.curation.VersionContext;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.mirror.contents.eol.EolCycle;
import com.metaeffekt.mirror.contents.eol.EolLifecycle;
import com.metaeffekt.mirror.contents.eol.export.CycleStateExtendedSupportInformationNotPresent;
import com.metaeffekt.mirror.contents.eol.export.CycleStateExtendedSupportInformationPresent;
import com.metaeffekt.mirror.contents.eol.export.CycleStateScenario;
import com.metaeffekt.mirror.contents.eol.state.DiscontinuedState;
import com.metaeffekt.mirror.contents.eol.state.EolState;
import com.metaeffekt.mirror.contents.eol.state.LtsState;
import com.metaeffekt.mirror.contents.eol.state.SupportState;
import com.metaeffekt.mirror.contents.eol.state.TechnicalGuidanceState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.BiFunction;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;

public class ExportedCycleState {
    private final Artifact artifact;
    private final EolCycle cycle;
    private final String eol;
    private final EolState eolState;
    private final long eolMillis;
    private final String lts;
    private final LtsState ltsState;
    private final long ltsMillis;
    private final String discontinued;
    private final DiscontinuedState discontinuedState;
    private final long discontinuedMillis;
    private final String support;
    private final SupportState supportState;
    private final long supportMillis;
    private final String extendedSupport;
    private final SupportState extendedSupportState;
    private final long extendedSupportMillis;
    private final String technicalGuidance;
    private final TechnicalGuidanceState technicalGuidanceState;
    private final long technicalGuidanceMillis;
    private final CycleStateScenario cycleStateScenario;
    private final CycleStateExtendedSupportInformationNotPresent cycleStateExtendedSupportInformationNotPresent;
    private final CycleStateExtendedSupportInformationPresent cycleStateExtendedSupportInformationPresent;
    private final boolean isAlreadyLatestCycleVersion;
    private final boolean isAlreadyLatestVersion;
    private final String latestCycleVersion;
    private final String latestLifecycleVersion;
    private final String nextSupportedVersion;
    private final String nextSupportedExtendedVersion;
    private final String closestActiveLtsVersion;
    private final String latestActiveLtsVersion;

    public ExportedCycleState(Artifact artifact, EolCycle cycle, String eol, EolState eolState, long eolMillis, String lts, LtsState ltsState, long ltsMillis, String discontinued, DiscontinuedState discontinuedState, long discontinuedMillis, String support, SupportState supportState, long supportMillis, String extendedSupport, SupportState extendedSupportState, long extendedSupportMillis, String technicalGuidance, TechnicalGuidanceState technicalGuidanceState, long technicalGuidanceMillis, CycleStateScenario cycleStateScenario, CycleStateExtendedSupportInformationNotPresent cycleStateExtendedSupportInformationNotPresent, CycleStateExtendedSupportInformationPresent cycleStateExtendedSupportInformationPresent, boolean isAlreadyLatestCycleVersion, boolean isAlreadyLatestVersion, String latestCycleVersion, String latestLifecycleVersion, String nextSupportedVersion, String nextSupportedExtendedVersion, String closestActiveLtsVersion, String latestActiveLtsVersion) {
        this.artifact = artifact;
        this.cycle = cycle;
        this.eol = eol;
        this.eolState = eolState;
        this.eolMillis = eolMillis;
        this.lts = lts;
        this.ltsState = ltsState;
        this.ltsMillis = ltsMillis;
        this.discontinued = discontinued;
        this.discontinuedState = discontinuedState;
        this.discontinuedMillis = discontinuedMillis;
        this.support = support;
        this.supportState = supportState;
        this.supportMillis = supportMillis;
        this.extendedSupport = extendedSupport;
        this.extendedSupportState = extendedSupportState;
        this.extendedSupportMillis = extendedSupportMillis;
        this.technicalGuidance = technicalGuidance;
        this.technicalGuidanceState = technicalGuidanceState;
        this.technicalGuidanceMillis = technicalGuidanceMillis;
        this.cycleStateScenario = cycleStateScenario;
        this.cycleStateExtendedSupportInformationNotPresent = cycleStateExtendedSupportInformationNotPresent;
        this.cycleStateExtendedSupportInformationPresent = cycleStateExtendedSupportInformationPresent;
        this.isAlreadyLatestCycleVersion = isAlreadyLatestCycleVersion;
        this.isAlreadyLatestVersion = isAlreadyLatestVersion;
        this.latestCycleVersion = latestCycleVersion;
        this.latestLifecycleVersion = latestLifecycleVersion;
        this.nextSupportedVersion = nextSupportedVersion;
        this.nextSupportedExtendedVersion = nextSupportedExtendedVersion;
        this.closestActiveLtsVersion = closestActiveLtsVersion;
        this.latestActiveLtsVersion = latestActiveLtsVersion;
    }

    public CycleStateExtendedSupportInformationPresent getCycleStateExtendedSupportAvailable() {
        return this.cycleStateExtendedSupportInformationPresent;
    }

    public CycleStateExtendedSupportInformationNotPresent getCycleStateExtendedSupportUnavailable() {
        return this.cycleStateExtendedSupportInformationNotPresent;
    }

    public boolean isLts() {
        return this.ltsState == LtsState.LTS || this.ltsState == LtsState.LTS_DATE_REACHED;
    }

    public boolean isEol() {
        return this.eolState == EolState.EOL || this.eolState == EolState.EOL_DATE_REACHED;
    }

    public boolean isDiscontinued() {
        return this.discontinuedState == DiscontinuedState.DISCONTINUED || this.discontinuedState == DiscontinuedState.DISCONTINUED_DATE_REACHED;
    }

    public boolean isSupport() {
        return this.supportState == SupportState.SUPPORT || this.supportState == SupportState.UPCOMING_SUPPORT_END_DATE || this.supportState == SupportState.DISTANT_SUPPORT_END_DATE;
    }

    public boolean isExtendedSupport() {
        return this.extendedSupportState == SupportState.SUPPORT || this.extendedSupportState == SupportState.UPCOMING_SUPPORT_END_DATE || this.extendedSupportState == SupportState.DISTANT_SUPPORT_END_DATE;
    }

    public boolean isTechnicalGuidance() {
        return this.technicalGuidanceState == TechnicalGuidanceState.TECHNICAL_GUIDANCE || this.technicalGuidanceState == TechnicalGuidanceState.UPCOMING_END_OF_TECHNICAL_GUIDANCE_DATE;
    }

    public static ExportedCycleState from(EolCycle cycle, Artifact artifact, String latestVersionQueryVersion, EolLifecycle lifecycle, long millisUntilSupportEndWarning, long millisUntilExtendedSupportEndWarning) {
        String latestVersionString;
        boolean isAlreadyLatestVersion;
        String latestCycleVersionString;
        boolean isAlreadyLatestCycleVersion;
        CycleStateExtendedSupportInformationNotPresent unavailableState;
        CycleStateExtendedSupportInformationPresent availableState;
        CycleStateScenario eolCycleStateScenario;
        if (latestVersionQueryVersion == null) {
            latestVersionQueryVersion = artifact.getVersion();
        }
        if ((eolCycleStateScenario = CycleStateScenario.from(cycle)) == CycleStateScenario.EXTENDED_SUPPORT_INFORMATION_PRESENT) {
            availableState = CycleStateExtendedSupportInformationPresent.from(cycle, millisUntilSupportEndWarning, millisUntilExtendedSupportEndWarning);
            unavailableState = null;
        } else if (eolCycleStateScenario == CycleStateScenario.EXTENDED_SUPPORT_NOT_PRESENT) {
            availableState = null;
            unavailableState = CycleStateExtendedSupportInformationNotPresent.from(cycle, millisUntilSupportEndWarning);
        } else {
            availableState = null;
            unavailableState = null;
        }
        if (StringUtils.hasText(cycle.getLatest())) {
            Version artifactVersion = Version.of(latestVersionQueryVersion, VersionContext.fromArtifact(artifact));
            Version latestVersion = Version.of(cycle.getLatest(), VersionContext.fromEolId(cycle.getProduct()));
            isAlreadyLatestCycleVersion = artifactVersion.matchesVersionOf(latestVersion);
            latestCycleVersionString = cycle.getLatest();
        } else {
            isAlreadyLatestCycleVersion = false;
            latestCycleVersionString = null;
        }
        if (lifecycle != null && StringUtils.hasText(lifecycle.getLatestVersion())) {
            Version artifactVersion = Version.of(latestVersionQueryVersion, VersionContext.fromArtifact(artifact));
            Version latestVersion = Version.of(lifecycle.getLatestVersion(), VersionContext.fromEolId(cycle.getProduct()));
            isAlreadyLatestVersion = artifactVersion.matchesVersionOf(latestVersion);
            latestVersionString = lifecycle.getLatestVersion();
        } else {
            isAlreadyLatestVersion = false;
            latestVersionString = null;
        }
        String nextSupportedVersion = ExportedCycleState.getLatestFromFilteredLifecycleOrNull(lifecycle, cycle, EolLifecycle::findNextSupportedCycle);
        String nextSupportedExtendedVersion = ExportedCycleState.getLatestFromFilteredLifecycleOrNull(lifecycle, cycle, EolLifecycle::findNextExtendedSupportCycle);
        String closestActiveLtsVersion = ExportedCycleState.getLatestFromFilteredLifecycleOrNull(lifecycle, cycle, EolLifecycle::findClosestActiveLtsVersionCycle);
        String latestActiveLtsVersion = ExportedCycleState.getLatestFromFilteredLifecycleOrNull(lifecycle, cycle, EolLifecycle::findLatestActiveLtsVersionCycle);
        return new ExportedCycleState(artifact, cycle, cycle.getEol(), cycle.getEolState(), cycle.getTimeUntilEol(), cycle.getLts(), cycle.getLtsState(), cycle.getTimeUntilLtsStart(), cycle.getDiscontinued(), cycle.getDiscontinuedState(), cycle.getTimeUntilDiscontinued(), cycle.getSupport(), cycle.getSupportState(millisUntilSupportEndWarning), cycle.getTimeUntilSupportEnd(), cycle.getExtendedSupport(), cycle.getExtendedSupportState(millisUntilExtendedSupportEndWarning), cycle.getTimeUntilExtendedSupportEnd(), cycle.getTechnicalGuidance(), cycle.getTechnicalGuidanceState(), cycle.getTimeUntilTechnicalGuidanceEnd(), eolCycleStateScenario, unavailableState, availableState, isAlreadyLatestCycleVersion, isAlreadyLatestVersion, latestCycleVersionString, latestVersionString, nextSupportedVersion, nextSupportedExtendedVersion, closestActiveLtsVersion, latestActiveLtsVersion);
    }

    private static String getLatestFromFilteredLifecycleOrNull(EolLifecycle lifecycle, EolCycle current, BiFunction<EolLifecycle, EolCycle, EolCycle> converter) {
        if (lifecycle == null) {
            return null;
        }
        EolCycle cycle = converter.apply(lifecycle, current);
        if (cycle != null) {
            return cycle.getLatest();
        }
        return null;
    }

    public static Map<String, List<ExportedCycleState>> parseAndSortByProduct(Collection<Artifact> artifacts) {
        TreeMap<String, List<ExportedCycleState>> statesByProducts = new TreeMap<String, List<ExportedCycleState>>();
        for (Artifact artifact : artifacts) {
            ExportedCycleState.fromArtifact(artifact).ifPresent(cycleStates -> {
                if (cycleStates.isEmpty()) {
                    return;
                }
                for (ExportedCycleState cycleState : cycleStates) {
                    String productName = cycleState.getCycle().getProduct();
                    statesByProducts.computeIfAbsent(productName, p -> new ArrayList()).add(cycleState);
                }
            });
        }
        return statesByProducts;
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("artifact", (Object)new JSONObject().put("id", (Object)this.artifact.getId()).put("version", (Object)this.artifact.getVersion()));
        json.put("cycle", (Object)this.cycle.toJson());
        json.put("eol", (Object)new JSONObject().put("date", (Object)this.eol).put("state", (Object)this.eolState.name()).put("millisTillEol", this.eolMillis).put("formattedMillisTillEol", (Object)EolCycle.formatTimeUntilOrAgo(this.eolMillis)).put("active", this.isEol()));
        json.put("lts", (Object)new JSONObject().put("date", (Object)this.lts).put("state", (Object)this.ltsState.name()).put("millisTillLts", this.ltsMillis).put("formattedMillisTillLts", (Object)EolCycle.formatTimeUntilOrAgo(this.ltsMillis)).put("active", this.isLts()));
        json.put("discontinued", (Object)new JSONObject().put("date", (Object)this.discontinued).put("state", (Object)this.discontinuedState.name()).put("millisTillDiscontinued", this.discontinuedMillis).put("formattedMillisTillDiscontinued", (Object)EolCycle.formatTimeUntilOrAgo(this.discontinuedMillis)).put("active", this.isDiscontinued()));
        json.put("support", (Object)new JSONObject().put("date", (Object)this.support).put("state", (Object)this.supportState.name()).put("millisTillSupportEnd", this.supportMillis).put("formattedMillisTillSupportEnd", (Object)EolCycle.formatTimeUntilOrAgo(this.supportMillis)).put("active", this.isSupport()));
        json.put("extendedSupport", (Object)new JSONObject().put("date", (Object)this.extendedSupport).put("state", (Object)this.extendedSupportState.name()).put("millisTillExtendedSupportEnd", this.extendedSupportMillis).put("formattedMillisTillExtendedSupportEnd", (Object)EolCycle.formatTimeUntilOrAgo(this.extendedSupportMillis)).put("active", this.isExtendedSupport()));
        json.put("technicalGuidance", (Object)new JSONObject().put("date", (Object)this.technicalGuidance).put("state", (Object)this.technicalGuidanceState.name()).put("millisTillTechnicalGuidanceEnd", this.technicalGuidanceMillis).put("formattedMillisTillTechnicalGuidanceEnd", (Object)EolCycle.formatTimeUntilOrAgo(this.technicalGuidanceMillis)).put("active", this.isTechnicalGuidance()));
        json.put("state", (Object)new JSONObject().put("scenario", (Object)this.cycleStateScenario.getKey()).put("extendedSupportAvailable", this.cycleStateExtendedSupportInformationPresent != null ? this.cycleStateExtendedSupportInformationPresent.toJson() : null).put("extendedSupportUnavailable", this.cycleStateExtendedSupportInformationNotPresent != null ? this.cycleStateExtendedSupportInformationNotPresent.toJson() : null));
        json.put("versionRecommendation", (Object)new JSONObject().put("cycle", (Object)new JSONObject().put("alreadyActive", this.isAlreadyLatestCycleVersion).put("latest", (Object)this.latestCycleVersion)).put("lifecycle", (Object)new JSONObject().put("alreadyActive", this.isAlreadyLatestVersion).put("latest", (Object)this.latestLifecycleVersion)).put("nextSupported", (Object)this.nextSupportedVersion).put("nextSupportedExtended", (Object)this.nextSupportedExtendedVersion).put("closestActiveLtsVersion", (Object)this.closestActiveLtsVersion).put("latestActiveLtsVersion", (Object)this.latestActiveLtsVersion));
        return json;
    }

    public static Optional<List<ExportedCycleState>> fromArtifact(Artifact artifact) {
        if (StringUtils.hasText(artifact.get(InventoryAttribute.EOL_FULL_STATE.getKey()))) {
            return Optional.of(ExportedCycleState.fromJson(artifact, new JSONArray(artifact.get(InventoryAttribute.EOL_FULL_STATE.getKey()))));
        }
        return Optional.empty();
    }

    public static ExportedCycleState fromJson(Inventory inventory, JSONObject json) {
        JSONObject artifactJson = json.getJSONObject("artifact");
        Artifact artifact = inventory.findArtifact(artifactJson.optString("id", null));
        return ExportedCycleState.fromJson(artifact, json);
    }

    public static List<ExportedCycleState> fromJson(Artifact artifact) {
        if (artifact.get(InventoryAttribute.EOL_FULL_STATE.getKey()) == null) {
            return new ArrayList<ExportedCycleState>();
        }
        return ExportedCycleState.fromJson(artifact, new JSONArray(artifact.get(InventoryAttribute.EOL_FULL_STATE.getKey())));
    }

    public static List<ExportedCycleState> fromJson(Artifact artifact, JSONArray json) {
        ArrayList<ExportedCycleState> states = new ArrayList<ExportedCycleState>();
        for (int i = 0; i < json.length(); ++i) {
            states.add(ExportedCycleState.fromJson(artifact, json.getJSONObject(i)));
        }
        return states;
    }

    public static ExportedCycleState fromJson(Artifact artifact, JSONObject json) {
        EolCycle cycle = EolCycle.fromJson(json.getJSONObject("cycle"));
        JSONObject eolJson = json.getJSONObject("eol");
        String eol = eolJson.optString("date", null);
        EolState eolState = EolState.valueOf(eolJson.getString("state"));
        long eolMillis = eolJson.getLong("millisTillEol");
        JSONObject ltsJson = json.getJSONObject("lts");
        String lts = ltsJson.optString("date", null);
        LtsState ltsState = LtsState.valueOf(ltsJson.getString("state"));
        long ltsMillis = ltsJson.getLong("millisTillLts");
        JSONObject discontinuedJson = json.getJSONObject("discontinued");
        String discontinued = discontinuedJson.optString("date", null);
        DiscontinuedState discontinuedState = DiscontinuedState.valueOf(discontinuedJson.getString("state"));
        long discontinuedMillis = discontinuedJson.getLong("millisTillDiscontinued");
        JSONObject supportJson = json.getJSONObject("support");
        String support = supportJson.optString("date", null);
        SupportState supportState = SupportState.valueOf(supportJson.getString("state"));
        long supportMillis = supportJson.getLong("millisTillSupportEnd");
        JSONObject extendedSupportJson = json.getJSONObject("extendedSupport");
        String extendedSupport = extendedSupportJson.optString("date", null);
        SupportState extendedSupportState = SupportState.valueOf(extendedSupportJson.getString("state"));
        long extendedSupportMillis = extendedSupportJson.getLong("millisTillExtendedSupportEnd");
        JSONObject technicalGuidanceJson = json.getJSONObject("technicalGuidance");
        String technicalGuidance = technicalGuidanceJson.optString("date", null);
        TechnicalGuidanceState technicalGuidanceState = TechnicalGuidanceState.valueOf(technicalGuidanceJson.getString("state"));
        long technicalGuidanceMillis = technicalGuidanceJson.getLong("millisTillTechnicalGuidanceEnd");
        CycleStateScenario cycleStateScenario = CycleStateScenario.fromKey(json.getJSONObject("state").getString("scenario"));
        JSONObject extendedSupportAvailableJson = json.getJSONObject("state").optJSONObject("extendedSupportAvailable");
        CycleStateExtendedSupportInformationPresent extendedSupportAvailable = extendedSupportAvailableJson != null ? CycleStateExtendedSupportInformationPresent.fromJson(extendedSupportAvailableJson) : null;
        JSONObject extendedSupportUnavailableJson = json.getJSONObject("state").optJSONObject("extendedSupportUnavailable");
        CycleStateExtendedSupportInformationNotPresent extendedSupportUnavailable = extendedSupportUnavailableJson != null ? CycleStateExtendedSupportInformationNotPresent.fromJson(extendedSupportUnavailableJson) : null;
        JSONObject versionRecommendationJson = json.getJSONObject("versionRecommendation");
        JSONObject cycleVersionJson = versionRecommendationJson.getJSONObject("cycle");
        boolean isAlreadyLatestCycleVersion = cycleVersionJson.getBoolean("alreadyActive");
        String latestCycleVersion = cycleVersionJson.optString("latest", null);
        JSONObject lifecycleJson = versionRecommendationJson.getJSONObject("lifecycle");
        boolean isAlreadyLatestVersion = lifecycleJson.getBoolean("alreadyActive");
        String latestVersion = lifecycleJson.optString("latest", null);
        String nextSupportedVersion = versionRecommendationJson.optString("nextSupported", null);
        String nextSupportedExtendedVersion = versionRecommendationJson.optString("nextSupportedExtended", null);
        String closestActiveLtsVersion = versionRecommendationJson.optString("closestActiveLtsVersion", null);
        String latestActiveLtsVersion = versionRecommendationJson.optString("latestActiveLtsVersion", null);
        return new ExportedCycleState(artifact, cycle, eol, eolState, eolMillis, lts, ltsState, ltsMillis, discontinued, discontinuedState, discontinuedMillis, support, supportState, supportMillis, extendedSupport, extendedSupportState, extendedSupportMillis, technicalGuidance, technicalGuidanceState, technicalGuidanceMillis, cycleStateScenario, extendedSupportUnavailable, extendedSupportAvailable, isAlreadyLatestCycleVersion, isAlreadyLatestVersion, latestCycleVersion, latestVersion, nextSupportedVersion, nextSupportedExtendedVersion, closestActiveLtsVersion, latestActiveLtsVersion);
    }

    public String toString() {
        return this.toJson().toString();
    }

    public static Map<String, List<ExportedCycleState>> groupByArtifactVersion(Collection<ExportedCycleState> states) {
        LinkedHashMap<String, List<ExportedCycleState>> grouped = new LinkedHashMap<String, List<ExportedCycleState>>();
        for (ExportedCycleState state : states) {
            if (state.getArtifact().getVersion() == null) {
                grouped.computeIfAbsent("", k -> new ArrayList()).add(state);
                continue;
            }
            grouped.computeIfAbsent(state.getArtifact().getVersion(), k -> new ArrayList()).add(state);
        }
        return grouped;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public EolCycle getCycle() {
        return this.cycle;
    }

    public String getEol() {
        return this.eol;
    }

    public EolState getEolState() {
        return this.eolState;
    }

    public long getEolMillis() {
        return this.eolMillis;
    }

    public String getLts() {
        return this.lts;
    }

    public LtsState getLtsState() {
        return this.ltsState;
    }

    public long getLtsMillis() {
        return this.ltsMillis;
    }

    public String getDiscontinued() {
        return this.discontinued;
    }

    public DiscontinuedState getDiscontinuedState() {
        return this.discontinuedState;
    }

    public long getDiscontinuedMillis() {
        return this.discontinuedMillis;
    }

    public String getSupport() {
        return this.support;
    }

    public SupportState getSupportState() {
        return this.supportState;
    }

    public long getSupportMillis() {
        return this.supportMillis;
    }

    public String getExtendedSupport() {
        return this.extendedSupport;
    }

    public SupportState getExtendedSupportState() {
        return this.extendedSupportState;
    }

    public long getExtendedSupportMillis() {
        return this.extendedSupportMillis;
    }

    public String getTechnicalGuidance() {
        return this.technicalGuidance;
    }

    public TechnicalGuidanceState getTechnicalGuidanceState() {
        return this.technicalGuidanceState;
    }

    public long getTechnicalGuidanceMillis() {
        return this.technicalGuidanceMillis;
    }

    public CycleStateScenario getCycleStateScenario() {
        return this.cycleStateScenario;
    }

    public CycleStateExtendedSupportInformationNotPresent getCycleStateExtendedSupportInformationNotPresent() {
        return this.cycleStateExtendedSupportInformationNotPresent;
    }

    public CycleStateExtendedSupportInformationPresent getCycleStateExtendedSupportInformationPresent() {
        return this.cycleStateExtendedSupportInformationPresent;
    }

    public boolean isAlreadyLatestCycleVersion() {
        return this.isAlreadyLatestCycleVersion;
    }

    public boolean isAlreadyLatestVersion() {
        return this.isAlreadyLatestVersion;
    }

    public String getLatestCycleVersion() {
        return this.latestCycleVersion;
    }

    public String getLatestLifecycleVersion() {
        return this.latestLifecycleVersion;
    }

    public String getNextSupportedVersion() {
        return this.nextSupportedVersion;
    }

    public String getNextSupportedExtendedVersion() {
        return this.nextSupportedExtendedVersion;
    }

    public String getClosestActiveLtsVersion() {
        return this.closestActiveLtsVersion;
    }

    public String getLatestActiveLtsVersion() {
        return this.latestActiveLtsVersion;
    }
}

