/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.eol.state;

import com.metaeffekt.artifact.analysis.dashboard.SvgIcon;
import com.metaeffekt.mirror.contents.eol.state.EolState;
import org.metaeffekt.core.util.ColorScheme;

public enum SupportState {
    NO_SUPPORT(SvgIcon.X_OCTAGON_FILL, "No support", ColorScheme.STRONG_RED),
    SUPPORT(SvgIcon.CHECK_CIRCLE_FILL, "Support available", ColorScheme.STRONG_DARK_GREEN),
    SUPPORT_END_DATE_REACHED(SvgIcon.X_OCTAGON_FILL, "Support end reached", ColorScheme.STRONG_RED),
    DISTANT_SUPPORT_END_DATE(SvgIcon.CHECK_CIRCLE_FILL, "Upcoming support end", ColorScheme.STRONG_DARK_GREEN),
    UPCOMING_SUPPORT_END_DATE(SvgIcon.EXCLAMATION_TRIANGLE_FILL, "Upcoming support end", ColorScheme.STRONG_YELLOW);

    private final SvgIcon icon;
    private final String shortDescription;
    private final ColorScheme color;

    private SupportState(SvgIcon icon, String shortDescription, ColorScheme color) {
        this.icon = icon;
        this.shortDescription = shortDescription;
        this.color = color;
    }

    public SvgIcon getIcon() {
        return this.icon;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public static SupportState fromEolState(EolState eolState) {
        switch (eolState) {
            case NOT_EOL: {
                return SUPPORT;
            }
            case EOL: {
                return NO_SUPPORT;
            }
            case EOL_DATE_REACHED: {
                return SUPPORT_END_DATE_REACHED;
            }
            case DISTANT_EOL_DATE: {
                return DISTANT_SUPPORT_END_DATE;
            }
            case UPCOMING_EOL_DATE: {
                return UPCOMING_SUPPORT_END_DATE;
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)eolState));
    }

    public ColorScheme getColor() {
        return this.color;
    }
}

