/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.store;

import com.metaeffekt.mirror.contents.store.ContentIdentifierStore;
import com.metaeffekt.mirror.contents.store.OtherTypeIdentifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtherTypeStore
extends ContentIdentifierStore<OtherTypeIdentifier> {
    private static final Logger log = LoggerFactory.getLogger(OtherTypeStore.class);
    public static final OtherTypeIdentifier CWE = new OtherTypeIdentifier("CWE", "CWE", "", Pattern.compile("(CWE-\\d+)", 2));
    public static final OtherTypeIdentifier CPE = new OtherTypeIdentifier("CPE", "CPE", "", Pattern.compile("UNDEFINED", 2));
    public static final OtherTypeIdentifier NVD = new OtherTypeIdentifier("NVD", "NVD", "", Pattern.compile("UNDEFINED", 2));
    public static final OtherTypeIdentifier ASSESSMENT_STATUS = new OtherTypeIdentifier("ASSESSMENT_STATUS", "Assessment Status", "", Pattern.compile("UNDEFINED", 2));
    private static final OtherTypeStore INSTANCE = new OtherTypeStore();

    public static OtherTypeStore get() {
        return INSTANCE;
    }

    protected OtherTypeStore() {
    }

    @Override
    protected OtherTypeIdentifier createIdentifier(@NonNull String name, @NonNull String implementation) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (implementation == null) {
            throw new NullPointerException("implementation is marked non-null but is null");
        }
        return new OtherTypeIdentifier(name, ContentIdentifierStore.ContentIdentifier.deriveWellFormedName(name), implementation, Pattern.compile("UNKNOWN", 2));
    }

    @Override
    protected Collection<OtherTypeIdentifier> createDefaultIdentifiers() {
        return Arrays.asList(CWE, CPE, NVD, ASSESSMENT_STATUS);
    }

    public String toString() {
        return "OtherTypeStore()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OtherTypeStore)) {
            return false;
        }
        OtherTypeStore other = (OtherTypeStore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof OtherTypeStore;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

