/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.vulnerability;

import com.metaeffekt.artifact.analysis.version.curation.VersionContext;
import com.metaeffekt.artifact.analysis.vulnerability.CommonEnumerationUtil;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.contents.vulnerability.VulnerableSoftwareVersionRangeCpe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.commons.lang3.ObjectUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.exceptions.CpeValidationException;

public class VulnerableSoftwareTreeNode {
    private static final Logger LOG = LoggerFactory.getLogger(Vulnerability.class);
    private final List<VulnerableSoftwareTreeNode> childNodes = new ArrayList<VulnerableSoftwareTreeNode>();
    private final List<VulnerableSoftwareVersionRangeCpe> nodes = new ArrayList<VulnerableSoftwareVersionRangeCpe>();
    private final String operator;

    public VulnerableSoftwareTreeNode(String operator) {
        this.operator = operator;
    }

    public void addChildNode(VulnerableSoftwareTreeNode node) {
        this.childNodes.add(node);
    }

    public void addNode(VulnerableSoftwareVersionRangeCpe software) {
        this.nodes.add(software);
    }

    public List<VulnerableSoftwareVersionRangeCpe> getNodes() {
        return this.nodes;
    }

    public List<VulnerableSoftwareTreeNode> getChildNodes() {
        return this.childNodes;
    }

    public String getOperator() {
        return this.operator;
    }

    public boolean isAffected(Set<Cpe> cpes, Cpe specificCheckCpe) {
        throw new RuntimeException("Not implemented");
    }

    public boolean isAffectedFlat(Cpe cpe) {
        VulnerableSoftwareVersionRangeCpe flatAffectedNode = this.getFlatAffectedNode(cpe);
        return flatAffectedNode != null;
    }

    public VulnerableSoftwareVersionRangeCpe getFlatAffectedNode(Cpe cpe) {
        switch (this.operator) {
            case "OR": {
                return this.isNodesFlatAffected(cpe);
            }
            case "AND": {
                if (!this.childNodes.isEmpty()) {
                    return this.isChildNodesFlatAffected(cpe);
                }
                return this.isNodesFlatAffected(cpe);
            }
        }
        throw new RuntimeException("Unknown operator in vulnerable software tree node: " + this.operator);
    }

    private VulnerableSoftwareVersionRangeCpe isChildNodesFlatAffected(Cpe cpe) {
        for (VulnerableSoftwareTreeNode childNode : this.childNodes) {
            VulnerableSoftwareVersionRangeCpe flatAffectedNode = childNode.getFlatAffectedNode(cpe);
            if (flatAffectedNode == null) continue;
            return flatAffectedNode;
        }
        return null;
    }

    private VulnerableSoftwareVersionRangeCpe isNodesFlatAffected(Cpe cpe) {
        for (VulnerableSoftwareVersionRangeCpe node : this.nodes) {
            if (!node.isVulnerable() || !node.matches(cpe)) continue;
            return node;
        }
        return null;
    }

    public List<VulnerableSoftwareVersionRangeCpe> getAllCpes() {
        ArrayList<VulnerableSoftwareVersionRangeCpe> cpes = new ArrayList<VulnerableSoftwareVersionRangeCpe>(this.nodes);
        for (VulnerableSoftwareTreeNode childNode : this.childNodes) {
            cpes.addAll(childNode.getAllCpes());
        }
        return cpes;
    }

    public static List<VulnerableSoftwareVersionRangeCpe> getAllCpes(Collection<VulnerableSoftwareTreeNode> configurations) {
        ArrayList<VulnerableSoftwareVersionRangeCpe> cpes = new ArrayList<VulnerableSoftwareVersionRangeCpe>();
        for (VulnerableSoftwareTreeNode configuration : configurations) {
            cpes.addAll(configuration.getAllCpes());
        }
        return cpes;
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        JSONArray cpeMatch = new JSONArray();
        for (VulnerableSoftwareVersionRangeCpe vulnerableSoftware : this.nodes) {
            JSONObject vulnerableSoftwareJson = vulnerableSoftware.toJson();
            cpeMatch.put((Object)vulnerableSoftwareJson);
        }
        JSONArray children = new JSONArray();
        for (VulnerableSoftwareTreeNode child : this.childNodes) {
            children.put((Object)child.toJson());
        }
        json.put("cpe_match", (Object)cpeMatch);
        json.put("children", (Object)children);
        json.put("operator", (Object)this.operator);
        return json;
    }

    public static VulnerableSoftwareTreeNode fromJson(JSONObject json) throws CpeValidationException {
        int i;
        JSONArray cpeMatch = (JSONArray)ObjectUtils.firstNonNull((Object[])new JSONArray[]{json.optJSONArray("cpeMatch"), json.optJSONArray("cpe_match")});
        JSONArray children = json.optJSONArray("children");
        String operator = json.getString("operator");
        VulnerableSoftwareTreeNode root = new VulnerableSoftwareTreeNode(operator);
        if (cpeMatch != null) {
            for (i = 0; i < cpeMatch.length(); ++i) {
                JSONObject cpeMatchJson = cpeMatch.getJSONObject(i);
                boolean vulnerable = cpeMatchJson.optBoolean("vulnerable", true);
                String versionEndExcluding = cpeMatchJson.optString("versionEndExcluding", null);
                String versionEndIncluding = cpeMatchJson.optString("versionEndIncluding", null);
                String versionStartExcluding = cpeMatchJson.optString("versionStartExcluding", null);
                String versionStartIncluding = cpeMatchJson.optString("versionStartIncluding", null);
                String cpeString = (String)ObjectUtils.firstNonNull((Object[])new String[]{cpeMatchJson.optString("criteria", null), cpeMatchJson.optString("cpe23Uri", null)});
                try {
                    Cpe cpe = CommonEnumerationUtil.parseCpe(cpeString).get();
                    VulnerableSoftwareVersionRangeCpe node = new VulnerableSoftwareVersionRangeCpe(cpe, versionStartExcluding, versionStartIncluding, versionEndIncluding, versionEndExcluding, VersionContext.fromCpe(cpe), vulnerable);
                    root.nodes.add(node);
                    continue;
                }
                catch (Exception e) {
                    LOG.error("Failed to parse CPE URI on vulnerable software [{}]", (Object)cpeString);
                    throw new CpeValidationException(e.getMessage());
                }
            }
        }
        if (children != null) {
            for (i = 0; i < children.length(); ++i) {
                VulnerableSoftwareTreeNode child = VulnerableSoftwareTreeNode.fromJson(children.getJSONObject(i));
                root.childNodes.add(child);
            }
        }
        return root;
    }

    public static List<VulnerableSoftwareTreeNode> fromJson(JSONArray json) throws CpeValidationException {
        ArrayList<VulnerableSoftwareTreeNode> nodes = new ArrayList<VulnerableSoftwareTreeNode>();
        for (int i = 0; i < json.length(); ++i) {
            VulnerableSoftwareTreeNode node = VulnerableSoftwareTreeNode.fromJson(json.getJSONObject(i));
            nodes.add(node);
        }
        return nodes;
    }

    public String toString() {
        StringJoiner sb;
        block4: {
            block3: {
                sb = new StringJoiner(" " + this.operator + " ");
                if (this.childNodes.isEmpty()) break block3;
                for (VulnerableSoftwareTreeNode node : this.childNodes) {
                    if (node.getNodes().size() == 1) {
                        sb.add(node.toString());
                        continue;
                    }
                    sb.add("{" + node + "}");
                }
                break block4;
            }
            if (this.nodes.isEmpty()) break block4;
            for (VulnerableSoftwareVersionRangeCpe node : this.nodes) {
                sb.add(node.toString());
            }
        }
        return sb.toString();
    }
}

