/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.vulnerability;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.version.Version;
import com.metaeffekt.artifact.analysis.version.curation.VersionContext;
import org.json.JSONObject;

public class VulnerableSoftwareVersionRange {
    protected final String version;
    protected final String update;
    protected final String versionEndExcluding;
    protected final String versionEndIncluding;
    protected final String versionStartExcluding;
    protected final String versionStartIncluding;
    protected final boolean vulnerable;
    protected final VersionContext context;

    public VulnerableSoftwareVersionRange(String version, String update, String versionStartExcluding, String versionStartIncluding, String versionEndIncluding, String versionEndExcluding, VersionContext context, boolean vulnerable) {
        this.version = version;
        this.update = update;
        this.versionEndExcluding = versionEndExcluding;
        this.versionEndIncluding = versionEndIncluding;
        this.versionStartExcluding = versionStartExcluding;
        this.versionStartIncluding = versionStartIncluding;
        this.context = context == null ? VersionContext.EMPTY : context;
        this.vulnerable = vulnerable;
    }

    public String getVersionEndExcluding() {
        return this.versionEndExcluding;
    }

    public String getVersionEndIncluding() {
        return this.versionEndIncluding;
    }

    public String getVersionStartExcluding() {
        return this.versionStartExcluding;
    }

    public String getVersionStartIncluding() {
        return this.versionStartIncluding;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUpdate() {
        return this.update;
    }

    public VersionContext getContext() {
        return this.context;
    }

    public boolean isVulnerable() {
        return this.vulnerable;
    }

    protected boolean isVersionRangeSpecified() {
        return this.versionEndExcluding != null || this.versionEndIncluding != null || this.versionStartExcluding != null || this.versionStartIncluding != null;
    }

    public boolean matches(Version version) {
        return version.matchesVersionOf(this);
    }

    public JSONObject toJson() {
        return new JSONObject().put("version", (Object)this.version).put("update", (Object)this.update).put("versionEndExcluding", (Object)this.versionEndExcluding).put("versionEndIncluding", (Object)this.versionEndIncluding).put("versionStartExcluding", (Object)this.versionStartExcluding).put("versionStartIncluding", (Object)this.versionStartIncluding).put("vulnerable", this.vulnerable).put("context", (Object)this.context.toJson());
    }

    public String toString() {
        boolean isNotBothAny;
        StringBuilder sb = new StringBuilder();
        boolean versionSpecified = StringUtils.hasText(this.version);
        boolean updateSpecified = StringUtils.hasText(this.update);
        boolean versionAny = versionSpecified && this.version.equals("*");
        boolean updateAny = updateSpecified && this.update.equals("*");
        boolean bl = isNotBothAny = !versionAny || !updateAny;
        if (isNotBothAny) {
            if (versionSpecified) {
                sb.append(this.version);
            }
            if (updateSpecified) {
                sb.append(" (").append(this.update).append(")");
            }
        }
        if (this.isVersionRangeSpecified()) {
            if (this.versionStartExcluding != null) {
                sb.append("(").append(this.versionStartExcluding).append(", ");
            } else if (this.versionStartIncluding != null) {
                sb.append("[").append(this.versionStartIncluding).append(", ");
            } else {
                sb.append("[, ");
            }
            if (this.versionEndExcluding != null) {
                sb.append(this.versionEndExcluding).append(")");
            } else if (this.versionEndIncluding != null) {
                sb.append(this.versionEndIncluding).append("]");
            } else {
                sb.append(", ]");
            }
        }
        if (!this.vulnerable) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("(not vulnerable)");
        }
        return sb.toString();
    }
}

