/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.vulnerability;

import com.metaeffekt.artifact.analysis.version.Version;
import com.metaeffekt.artifact.analysis.version.curation.VersionContext;
import com.metaeffekt.artifact.analysis.vulnerability.CommonEnumerationUtil;
import com.metaeffekt.mirror.contents.vulnerability.VulnerableSoftwareVersionRange;
import org.json.JSONObject;
import us.springett.parsers.cpe.Cpe;

public class VulnerableSoftwareVersionRangeCpe
extends VulnerableSoftwareVersionRange {
    private final Cpe cpe;

    public VulnerableSoftwareVersionRangeCpe(Cpe cpe, String versionStartExcluding, String versionStartIncluding, String versionEndIncluding, String versionEndExcluding, VersionContext context, boolean vulnerable) {
        super(cpe.getVersion(), cpe.getUpdate(), versionStartExcluding, versionStartIncluding, versionEndIncluding, versionEndExcluding, context, vulnerable);
        this.cpe = cpe;
    }

    public Cpe getCpe() {
        return this.cpe;
    }

    public boolean matches(Cpe cpe) {
        if (!CommonEnumerationUtil.compareCpeUsingWildcardsIgnoreVersionUpdate(cpe, this.cpe)) {
            return false;
        }
        return super.matches(Version.of(cpe.getVersion(), cpe.getUpdate(), VersionContext.fromCpe(cpe)));
    }

    @Override
    public JSONObject toJson() {
        return super.toJson().put("criteria", (Object)CommonEnumerationUtil.toCpe22UriOrFallbackToCpe23FS(this.cpe));
    }

    @Override
    public String toString() {
        return CommonEnumerationUtil.toCpe22UriOrFallbackToCpe23FS(this.cpe) + " " + super.toString();
    }
}

