/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.download;

import com.metaeffekt.artifact.analysis.utils.ArchiveUtils;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.mirror.download.Download;
import com.metaeffekt.mirror.download.documentation.DocRelevantMethods;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GitRepositoryDownload
extends Download {
    private static final Logger LOG = LoggerFactory.getLogger(GitRepositoryDownload.class);
    private boolean useGitCommand = false;

    public GitRepositoryDownload(File baseMirrorDirectory, Class<? extends Download> downloadClass) {
        super(baseMirrorDirectory, downloadClass);
    }

    public GitRepositoryDownload setUseGitCommand(boolean useGitCommand) {
        this.useGitCommand = useGitCommand;
        return this;
    }

    @Override
    @DocRelevantMethods(value={"GitRepositoryDownload#performGitDownload", "GitRepositoryDownload#performZipDownload"})
    protected void performDownload() {
        if (!this.getDownloadIntoDirectory().exists()) {
            this.getDownloadIntoDirectory().mkdirs();
        }
        File dir = new File(this.getDownloadIntoDirectory(), this.getRepositoryName());
        if (this.useGitCommand) {
            LOG.info("Using git command to clone repository");
            this.performGitDownload(dir);
        } else {
            LOG.info("Using zip download to download repository");
            this.performZipDownload(dir);
        }
        LOG.info("Repository updated");
    }

    private void performZipDownload(File dir) {
        File zipFile = new File(this.getDownloadIntoDirectory(), this.getRepositoryName() + ".zip");
        LOG.info("[long operation] Downloading [{}] into [{}]", (Object)this.getZipDownloadUrl(), (Object)zipFile.getAbsolutePath());
        this.downloader.fetchResponseBodyFromUrlToFile(this.getZipDownloadUrl(), zipFile);
        if (dir.exists()) {
            LOG.info("[long operation] Deleting existing directory: {}", (Object)dir.getAbsolutePath());
            try {
                FileUtils.deleteDirectory((File)dir);
            }
            catch (IOException e) {
                try {
                    Thread.sleep(1000L);
                    FileUtils.deleteDirectory((File)dir);
                }
                catch (IOException | InterruptedException ex) {
                    throw new RuntimeException("Failed to delete previous download in " + dir.getAbsolutePath(), e);
                }
            }
        }
        if (!zipFile.exists()) {
            throw new RuntimeException("Failed to download " + this.getZipDownloadUrl() + " into " + zipFile.getAbsolutePath());
        }
        LOG.info("[long operation] Unpacking [{}] into [{}]", (Object)zipFile.getAbsolutePath(), (Object)dir.getParentFile().getAbsolutePath());
        ArchiveUtils.unpackIfPossible(zipFile, dir.getParentFile(), new ArrayList<String>());
        File[] files = dir.getParentFile().listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory() || !file.getName().startsWith(this.getRepositoryName())) continue;
                LOG.info("Renaming [{}] to [{}]", (Object)file.getAbsolutePath(), (Object)dir.getAbsolutePath());
                file.renameTo(dir);
                break;
            }
        }
        if (!dir.exists()) {
            throw new RuntimeException("Failed to unpack " + zipFile.getAbsolutePath() + " into " + dir.getAbsolutePath());
        }
        LOG.info("Deleting [{}]", (Object)zipFile.getAbsolutePath());
        zipFile.delete();
    }

    private void performGitDownload(File dir) {
        boolean gitLogExists = new File(dir, ".git").exists();
        if (gitLogExists) {
            try {
                LOG.info("Updating repository from {} into {}", (Object)this.getRepositoryUrl(), (Object)dir.getAbsolutePath());
                this.git.pull(dir);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to pull repository updates from " + this.getRepositoryUrl() + " into " + dir.getAbsolutePath(), e);
            }
        }
        try {
            LOG.info("Cloning repository from {} into {}", (Object)this.getRepositoryUrl(), (Object)dir.getAbsolutePath());
            this.git.cloneRemote(dir, this.getRepositoryUrl(), null);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to clone repository from " + this.getRepositoryUrl() + " into " + dir.getAbsolutePath(), e);
        }
    }

    @Override
    protected boolean additionalIsDownloadRequired() {
        return this.useGitCommand;
    }

    public abstract String getRepositoryUrl();

    public abstract URL getZipDownloadUrl();

    private String getRepositoryName() {
        return this.getRepositoryUrl().substring(this.getRepositoryUrl().lastIndexOf("/") + 1);
    }
}

