/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.download.advisor;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.mirror.Mirror;
import com.metaeffekt.mirror.Retry;
import com.metaeffekt.mirror.download.Download;
import com.metaeffekt.mirror.download.ResourceLocation;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MirrorMetadata(directoryName="certsei", mavenPropertyName="certSeiDownload")
public class CertSeiDownload
extends Download {
    private static final Logger LOG = LoggerFactory.getLogger(CertSeiDownload.class);
    private final List<Integer> availableArchiveYears = Collections.unmodifiableList(IntStream.range(2000, Calendar.getInstance().get(1) + 1).boxed().collect(Collectors.toList()));
    private Map<Integer, List<String>> cachedChangedYearlySummaryVUIDs;

    public CertSeiDownload(File baseMirrorDirectory) {
        super(baseMirrorDirectory, CertSeiDownload.class);
    }

    @Override
    protected void performDownload() {
        if (this.cachedChangedYearlySummaryVUIDs == null) {
            this.cachedChangedYearlySummaryVUIDs = this.fetchChangedYearlySummaryVUIDs();
        }
        for (Map.Entry<Integer, List<String>> yearVUIDs : this.cachedChangedYearlySummaryVUIDs.entrySet()) {
            int year = yearVUIDs.getKey();
            File yearDirectory = new File(this.downloadIntoDirectory, String.valueOf(yearVUIDs.getKey()));
            for (String note : yearVUIDs.getValue().stream().sorted().collect(Collectors.toList())) {
                this.executor.submit(() -> {
                    String idNumber = note.replace("VU#", "");
                    URL requestUrl = this.getRemoteResourceLocationUrl(ResourceLocationCertSei.NOTES_API_URL, idNumber);
                    File noteFile = new File(yearDirectory, note + ".json");
                    long remoteFileSize = this.downloader.fetchFileSizeFromUrl(requestUrl);
                    if (!noteFile.exists() || noteFile.length() != remoteFileSize) {
                        LOG.info("Fetching note [{}] for year [{}]", (Object)note, yearVUIDs.getKey());
                        new Retry<Object>(() -> this.downloader.fetchResponseBodyFromUrlToFile(requestUrl, noteFile)).withValidator(result -> {
                            if (!noteFile.exists()) {
                                LOG.warn("Note file does not exist: {}", (Object)noteFile.getAbsolutePath());
                                return false;
                            }
                            try {
                                return ((String)FileUtils.readLines((File)noteFile, (Charset)StandardCharsets.UTF_8).get(0)).startsWith("{");
                            }
                            catch (Exception e) {
                                LOG.warn("Content of note file is not valid JSON: {}", (Object)noteFile.getAbsolutePath());
                                return false;
                            }
                        }).onException(Exception.class).withDelay(5000).retryCount(10).run();
                    } else {
                        LOG.info("Note [{}] for year [{}] is already up-to-date", (Object)note, yearVUIDs.getKey());
                    }
                });
            }
            URL requestUrl = this.getRemoteResourceLocationUrl(ResourceLocationCertSei.SUMMARY_API_URL, year);
            long remoteFileSize = this.downloader.fetchFileSizeFromUrl(requestUrl);
            this.propertyFiles.set(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.CERT_SEI_PREFIX.getKey() + "summary-" + year, remoteFileSize);
        }
        this.executor.setDelay(5L);
        this.executor.start();
        try {
            this.executor.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to wait for executor to finish", e);
        }
        this.cachedChangedYearlySummaryVUIDs = null;
    }

    @Override
    protected boolean additionalIsDownloadRequired() {
        this.cachedChangedYearlySummaryVUIDs = this.fetchChangedYearlySummaryVUIDs();
        if (this.cachedChangedYearlySummaryVUIDs.size() > 0) {
            LOG.info("Found [{}] changed yearly summary VUIDs, download required", (Object)this.cachedChangedYearlySummaryVUIDs.size());
            return true;
        }
        return false;
    }

    private Map<Integer, List<String>> fetchChangedYearlySummaryVUIDs() {
        Map<Integer, List<String>> yearlyNotes = Collections.synchronizedMap(new LinkedHashMap());
        for (Integer year : this.availableArchiveYears) {
            this.executor.submit(() -> {
                boolean shouldFetchYear;
                long previousFileSize = this.propertyFiles.getLong(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.CERT_SEI_PREFIX.getKey() + "summary-" + year).orElse(0L);
                URL requestUrl = this.getRemoteResourceLocationUrl(ResourceLocationCertSei.SUMMARY_API_URL, year);
                long remoteFileSize = this.downloader.fetchFileSizeFromUrl(requestUrl);
                if (previousFileSize == 0L) {
                    shouldFetchYear = true;
                } else {
                    boolean bl = shouldFetchYear = remoteFileSize != previousFileSize;
                }
                if (shouldFetchYear) {
                    List<String> notesListJsonString = this.downloader.fetchResponseBodyFromUrlAsList(requestUrl);
                    if (notesListJsonString.isEmpty() || notesListJsonString.get(0).charAt(0) != '{') {
                        throw new RuntimeException("Invalid response from CERT-SEI summary API: " + notesListJsonString.get(0));
                    }
                    JSONObject notesListJson = new JSONObject(String.join((CharSequence)"", notesListJsonString));
                    LOG.info("Year [{}] has changed, contains [{}] notes", (Object)year, (Object)notesListJson.optString("count", "unknown"));
                    List noteAppender = yearlyNotes.computeIfAbsent(year, k -> new ArrayList());
                    notesListJson.getJSONArray("notes").toList().stream().map(String::valueOf).forEach(noteAppender::add);
                }
            });
        }
        this.executor.start();
        try {
            this.executor.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to wait for executor to finish", e);
        }
        return yearlyNotes;
    }

    @Override
    public void setRemoteResourceLocation(String location, String url) {
        super.setRemoteResourceLocation(ResourceLocationCertSei.valueOf(location), url);
    }

    public static enum ResourceLocationCertSei implements ResourceLocation
    {
        SUMMARY_API_URL("https://kb.cert.org/vuls/api/%d/summary/"),
        NOTES_API_URL("https://kb.cert.org/vuls/api/%s/");

        private final String defaultValue;

        private ResourceLocationCertSei(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public String getDefault() {
            return this.defaultValue;
        }
    }
}

