/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.download.advisor;

import com.metaeffekt.mirror.download.GitRepositoryDownload;
import com.metaeffekt.mirror.download.ResourceLocation;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import java.io.File;
import java.net.URL;

@MirrorMetadata(directoryName="github-advisory-database", mavenPropertyName="githubAdvisorDownload")
public class GhsaDownload
extends GitRepositoryDownload {
    public GhsaDownload(File baseMirrorDirectory) {
        super(baseMirrorDirectory, GhsaDownload.class);
        this.maxAgeBeforeReset = 7257600000L;
    }

    @Override
    public String getRepositoryUrl() {
        return this.getRemoteResourceLocation(ResourceLocationGHSA.GHSA_GIT_URL);
    }

    @Override
    public URL getZipDownloadUrl() {
        return this.getRemoteResourceLocationUrl(ResourceLocationGHSA.GHSA_GIT_ZIP_DOWNLOAD_URL, new Object[0]);
    }

    @Override
    public void setRemoteResourceLocation(String location, String url) {
        super.setRemoteResourceLocation(ResourceLocationGHSA.valueOf(location), url);
    }

    public static enum ResourceLocationGHSA implements ResourceLocation
    {
        GHSA_GIT_URL("https://github.com/github/advisory-database"),
        GHSA_GIT_ZIP_DOWNLOAD_URL("https://github.com/github/advisory-database/archive/refs/heads/main.zip");

        private final String defaultValue;

        private ResourceLocationGHSA(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public String getDefault() {
            return this.defaultValue;
        }
    }
}

