/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.download.advisor;

import com.metaeffekt.mirror.Mirror;
import com.metaeffekt.mirror.download.Download;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import java.io.File;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@MirrorMetadata(directoryName="msrc-csv", mavenPropertyName="msrcCsvDownload")
public class MsrcManualCsvDownload
extends Download {
    private static final Logger LOG = LoggerFactory.getLogger(MsrcManualCsvDownload.class);

    public MsrcManualCsvDownload(File baseMirrorDirectory) {
        super(baseMirrorDirectory, MsrcManualCsvDownload.class);
    }

    @Override
    protected void performDownload() {
        int fileCount;
        File[] files = this.downloadIntoDirectory.listFiles();
        int n = fileCount = files == null ? 0 : (int)Arrays.stream(files).filter(file -> file.getName().endsWith(".csv")).count();
        if (fileCount == 0) {
            LOG.error("No files found in {}", (Object)this.downloadIntoDirectory);
            LOG.error("No files found for [msrc-csv]. Visit https://msrc.microsoft.com/update-guide/vulnerability to manually download the CSV files into {}", (Object)this.downloadIntoDirectory);
            this.setCsvCount(0);
        } else {
            LOG.info("Found {} files in {}. Assuming download was successful.", (Object)fileCount, (Object)this.downloadIntoDirectory);
            this.setCsvCount(fileCount);
        }
    }

    private void setCsvCount(int count) {
        this.propertyFiles.set(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.MSRC_PREFIX.getKey() + "csv-count", String.valueOf(count));
    }

    private int getCsvCount() {
        return Integer.parseInt(this.propertyFiles.getString(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.MSRC_PREFIX.getKey() + "csv-count").orElse("0"));
    }

    @Override
    protected boolean isResetRequired() {
        return false;
    }

    @Override
    protected boolean additionalIsDownloadRequired() {
        long lastModified = super.getDownloadDirectoryLastModified();
        File[] files = this.downloadIntoDirectory.listFiles();
        int count = 0;
        if (files != null) {
            for (File file : files) {
                if (!file.getName().endsWith(".csv")) continue;
                ++count;
                if (file.lastModified() <= lastModified) continue;
                LOG.info("Download is required: File {} has been updated {} > {}", new Object[]{file.getName(), file.lastModified(), lastModified});
                return true;
            }
        }
        if (count != this.getCsvCount()) {
            LOG.info("Download is required: CSV count has changed {} != {}", (Object)count, (Object)this.getCsvCount());
            return true;
        }
        LOG.info("Download is not required: CSV count has not changed {} == {}", (Object)count, (Object)this.getCsvCount());
        return false;
    }

    @Override
    public void setRemoteResourceLocation(String location, String url) {
    }
}

