/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.download.nvd;

import com.metaeffekt.artifact.analysis.utils.ArchiveUtils;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.mirror.Mirror;
import com.metaeffekt.mirror.download.Download;
import com.metaeffekt.mirror.download.ResourceLocation;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@MirrorMetadata(directoryName="cpe-dict", mavenPropertyName="cpeDictionaryDownload", deprecated=true)
public class CpeDictionaryDownload
extends Download {
    private static final Logger LOG = LoggerFactory.getLogger(CpeDictionaryDownload.class);

    public CpeDictionaryDownload(File baseMirrorDirectory) {
        super(baseMirrorDirectory, CpeDictionaryDownload.class);
    }

    @Override
    protected void performDownload() {
        this.executor.submit(() -> {
            try {
                this.fetchZippedFile(ResourceLocationCpeDictionary.CPE_DICTIONARY_URL, "cpe-dict.xml", "official-cpe-dictionary_v2.2.xml");
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to download and extract CPE Dictionary from " + ResourceLocationCpeDictionary.CPE_DICTIONARY_URL, e);
            }
        });
        this.executor.submit(() -> {
            try {
                this.fetchZippedFile(ResourceLocationCpeDictionary.CPE_MATCH_URL, "cpe-match.json", "nvdcpematch-1.0.json");
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to download and extract CPE Match from " + ResourceLocationCpeDictionary.CPE_MATCH_URL, e);
            }
        });
        this.executor.start();
        try {
            this.executor.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to wait for download threads to finish.", e);
        }
    }

    private void fetchZippedFile(ResourceLocationCpeDictionary cpeDictionaryUrl, String downloadToFilename, String downloadFilename) throws IOException {
        URL requestUrl = this.getRemoteResourceLocationUrl(cpeDictionaryUrl, new Object[0]);
        File downloadDestinationFile = new File(this.downloadIntoDirectory, downloadToFilename + ".zip");
        this.downloader.fetchResponseBodyFromUrlToFile(requestUrl, downloadDestinationFile);
        long fileSize = downloadDestinationFile.length();
        File unzipDirectory = new File(this.downloadIntoDirectory, downloadToFilename + "_unzipped");
        if (unzipDirectory.exists()) {
            FileUtils.deleteDir(unzipDirectory);
        }
        ArchiveUtils.unpackIfPossible(downloadDestinationFile, unzipDirectory, new ArrayList<String>());
        downloadDestinationFile.delete();
        File destinationFile = new File(this.downloadIntoDirectory, downloadToFilename);
        if (destinationFile.exists()) {
            destinationFile.delete();
        }
        File unzippedFile = new File(unzipDirectory, downloadFilename);
        FileUtils.moveFile((File)unzippedFile, (File)destinationFile);
        if (unzipDirectory.exists()) {
            FileUtils.deleteDir(unzipDirectory);
        }
        if (downloadToFilename.contains("cpe-dict")) {
            this.propertyFiles.set(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.CPE_DICTIONARY_PREFIX.getKey() + "cpe-dict-size", fileSize);
        } else if (downloadToFilename.contains("cpe-match")) {
            this.propertyFiles.set(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.CPE_DICTIONARY_PREFIX.getKey() + "cpe-match-size", fileSize);
        }
    }

    @Override
    protected boolean additionalIsDownloadRequired() {
        File unzipFileCpeDictionary = new File(this.downloadIntoDirectory, "cpe-dict.xml");
        File unzipFileCpeMatch = new File(this.downloadIntoDirectory, "cpe-match.json");
        if (!unzipFileCpeDictionary.exists() || !unzipFileCpeMatch.exists()) {
            LOG.info("CPE Dictionary and/or CPE Match files are not present, download required");
            return true;
        }
        long lastCpeDictSize = this.propertyFiles.getLong(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.CPE_DICTIONARY_PREFIX.getKey() + "cpe-dict-size").orElse(0L);
        if (lastCpeDictSize == 0L) {
            LOG.info("CPE Dictionary size has not been set yet, download required");
            return true;
        }
        URL cpeDictRequestUrl = this.getRemoteResourceLocationUrl(ResourceLocationCpeDictionary.CPE_DICTIONARY_URL, new Object[0]);
        long currentCpeDictSize = this.downloader.fetchFileSizeFromUrl(cpeDictRequestUrl);
        if (lastCpeDictSize != currentCpeDictSize) {
            LOG.info("CPE Dictionary size has changed. Old size: [{}] New size: [{}], download required", (Object)lastCpeDictSize, (Object)currentCpeDictSize);
            return true;
        }
        long lastCpeMatchSize = this.propertyFiles.getLong(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.CPE_DICTIONARY_PREFIX.getKey() + "cpe-match-size").orElse(0L);
        if (lastCpeMatchSize == 0L) {
            LOG.info("CPE Match size has not been set yet, download required");
            return true;
        }
        URL cpeMatchRequestUrl = this.getRemoteResourceLocationUrl(ResourceLocationCpeDictionary.CPE_MATCH_URL, new Object[0]);
        long currentCpeMatchSize = this.downloader.fetchFileSizeFromUrl(cpeMatchRequestUrl);
        if (lastCpeMatchSize != currentCpeMatchSize) {
            LOG.info("CPE Match size has changed. Old size: [{}] New size: [{}], download required", (Object)lastCpeMatchSize, (Object)currentCpeMatchSize);
            return true;
        }
        return false;
    }

    @Override
    public void setRemoteResourceLocation(String location, String url) {
        super.setRemoteResourceLocation(ResourceLocationCpeDictionary.valueOf(location), url);
    }

    public static enum ResourceLocationCpeDictionary implements ResourceLocation
    {
        CPE_DICTIONARY_URL("https://nvd.nist.gov/feeds/xml/cpe/dictionary/official-cpe-dictionary_v2.2.xml.zip"),
        CPE_MATCH_URL("https://nvd.nist.gov/feeds/json/cpematch/1.0/nvdcpematch-1.0.json.zip");

        private final String defaultValue;

        private ResourceLocationCpeDictionary(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public String getDefault() {
            return this.defaultValue;
        }
    }
}

