/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.download.nvd;

import com.metaeffekt.artifact.analysis.utils.ArchiveUtils;
import com.metaeffekt.mirror.Mirror;
import com.metaeffekt.mirror.Retry;
import com.metaeffekt.mirror.download.Download;
import com.metaeffekt.mirror.download.ResourceLocation;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@MirrorMetadata(directoryName="nvd", mavenPropertyName="nvdLegacyDownload", deprecated=true)
public class NvdDownload
extends Download {
    private static final Logger LOG = LoggerFactory.getLogger(NvdDownload.class);
    private final List<Integer> availableArchiveYears = Collections.unmodifiableList(IntStream.range(2002, Calendar.getInstance().get(1) + 1).boxed().collect(Collectors.toList()));
    private Map<Integer, String> cachedChangedYearlyArchives;
    private static final int META_FILE_YEAR_PLACEHOLDER = 1;

    public NvdDownload(File baseMirrorDirectory) {
        super(baseMirrorDirectory, NvdDownload.class);
    }

    @Override
    protected boolean additionalIsDownloadRequired() {
        Map<Integer, String> changedArchiveYears = this.fetchChangedArchiveYears();
        if (this.cachedChangedYearlyArchives == null) {
            this.cachedChangedYearlyArchives = changedArchiveYears;
        }
        return changedArchiveYears.size() > 0;
    }

    @Override
    protected void performDownload() {
        Map<Integer, String> changedArchiveYears;
        if (this.cachedChangedYearlyArchives == null) {
            changedArchiveYears = this.fetchChangedArchiveYears();
        } else {
            changedArchiveYears = this.cachedChangedYearlyArchives;
            this.cachedChangedYearlyArchives = null;
        }
        LOG.info("Starting downloads for years {}", changedArchiveYears.keySet());
        for (Map.Entry<Integer, String> changedYearEntry : changedArchiveYears.entrySet()) {
            this.executor.submit(() -> new Retry(() -> {
                String propertyName;
                File targetFile;
                File archiveFile;
                URL requestUrl;
                Integer year = (Integer)changedYearEntry.getKey();
                String lastModifiedDate = (String)changedYearEntry.getValue();
                if (year == 1) {
                    requestUrl = this.getRemoteResourceLocationUrl(ResourceLocationNvd.CVE_MODIFIED_URL, new Object[0]);
                    archiveFile = new File(this.downloadIntoDirectory, "nvd-modified.json.gz");
                    targetFile = new File(this.downloadIntoDirectory, "nvd-modified.json");
                    propertyName = Mirror.InfoFileAttributes.NVD_PREFIX.getKey() + "last-modified-meta";
                } else {
                    requestUrl = this.getRemoteResourceLocationUrl(ResourceLocationNvd.CVE_YEAR_BASE_URL, year);
                    archiveFile = new File(this.downloadIntoDirectory, "nvd-" + year + ".json.gz");
                    targetFile = new File(this.downloadIntoDirectory, "nvd-" + year + ".json");
                    propertyName = Mirror.InfoFileAttributes.NVD_PREFIX.getKey() + "last-modified-" + year;
                }
                if (targetFile.exists()) {
                    targetFile.delete();
                }
                if (archiveFile.exists()) {
                    archiveFile.delete();
                }
                this.downloader.fetchResponseBodyFromUrlToFile(requestUrl, archiveFile);
                ArchiveUtils.unpackIfPossible(archiveFile, this.downloadIntoDirectory, new ArrayList<String>());
                archiveFile.delete();
                this.propertyFiles.set(this.downloadIntoDirectory, "info", propertyName, lastModifiedDate);
            }).onException(Exception.class).retryCount(5).run());
        }
        this.executor.start();
        try {
            this.executor.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to wait for download threads to finish.", e);
        }
    }

    private Map<Integer, String> fetchChangedArchiveYears() {
        HashMap<Integer, String> changedYearsWithLastModifiedDate = new HashMap<Integer, String>();
        for (Integer year : this.availableArchiveYears) {
            this.executor.submit(() -> {
                String previousLastModifiedDate = this.propertyFiles.getString(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.NVD_PREFIX.getKey() + "last-modified-" + year).orElse("");
                URL requestUrl = this.getRemoteResourceLocationUrl(ResourceLocationNvd.CVE_YEAR_META_URL, year);
                String currentLastModifiedDate = this.fetchLastModifiedDateFromMetaFile(requestUrl);
                File targetFile = new File(this.downloadIntoDirectory, "nvd-" + year + ".json");
                if (currentLastModifiedDate.length() == 0) {
                    LOG.warn("Meta file did not contain lastModifiedDate for year [{}], download required", (Object)year);
                    changedYearsWithLastModifiedDate.put(year, currentLastModifiedDate);
                } else if (!targetFile.exists() || previousLastModifiedDate.length() == 0) {
                    LOG.info("Archive year [{}] does not yet exist, download required", (Object)year);
                    changedYearsWithLastModifiedDate.put(year, currentLastModifiedDate);
                } else if (!previousLastModifiedDate.equals(currentLastModifiedDate)) {
                    LOG.info("Archive year [{}] is not up-to-date, download required [{}] -> [{}]", new Object[]{year, previousLastModifiedDate, currentLastModifiedDate});
                    changedYearsWithLastModifiedDate.put(year, currentLastModifiedDate);
                }
            });
        }
        this.executor.submit(() -> {
            String previousLastModifiedDate = this.propertyFiles.getString(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.NVD_PREFIX.getKey() + "last-modified-meta").orElse("");
            URL requestUrl = this.getRemoteResourceLocationUrl(ResourceLocationNvd.CVE_MODIFIED_META_URL, new Object[0]);
            String currentLastModifiedDate = this.fetchLastModifiedDateFromMetaFile(requestUrl);
            File targetFile = new File(this.downloadIntoDirectory, "nvd-modified.json");
            if (currentLastModifiedDate.length() == 0) {
                LOG.warn("Meta file did not contain lastModifiedDate for meta, download required");
                changedYearsWithLastModifiedDate.put(1, currentLastModifiedDate);
            } else if (!targetFile.exists() || previousLastModifiedDate.length() == 0) {
                LOG.info("Meta archive does not yet exist, download required");
                changedYearsWithLastModifiedDate.put(1, currentLastModifiedDate);
            } else if (!previousLastModifiedDate.equals(currentLastModifiedDate)) {
                LOG.info("Meta archive is not up-to-date, download required [{}] -> [{}]", (Object)previousLastModifiedDate, (Object)currentLastModifiedDate);
                changedYearsWithLastModifiedDate.put(1, currentLastModifiedDate);
            }
        });
        this.executor.start();
        try {
            this.executor.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to wait for download threads to finish.", e);
        }
        return changedYearsWithLastModifiedDate;
    }

    private String fetchLastModifiedDateFromMetaFile(URL requestUrl) {
        AtomicReference lastModifiedDate = new AtomicReference();
        new Retry(() -> {
            List<String> metaProperties = this.downloader.fetchResponseBodyFromUrlAsList(requestUrl);
            lastModifiedDate.set(metaProperties.stream().filter(e -> e.contains(":")).map(e -> e.split(":", 2)).filter(e -> e[0].equals("lastModifiedDate")).map(e -> e[1]).findFirst().orElse(""));
        }).onException(Exception.class).withValidator(result -> lastModifiedDate.get() != null && ((String)lastModifiedDate.get()).length() > 0).retryCount(5).run();
        return (String)lastModifiedDate.get();
    }

    @Override
    public void setRemoteResourceLocation(String location, String url) {
        super.setRemoteResourceLocation(ResourceLocationNvd.valueOf(location), url);
    }

    public static enum ResourceLocationNvd implements ResourceLocation
    {
        CVE_MODIFIED_URL("https://nvd.nist.gov/feeds/json/cve/1.1/nvdcve-1.1-modified.json.gz"),
        CVE_MODIFIED_META_URL("https://nvd.nist.gov/feeds/json/cve/1.1/nvdcve-1.1-modified.meta"),
        CVE_YEAR_BASE_URL("https://nvd.nist.gov/feeds/json/cve/1.1/nvdcve-1.1-%d.json.gz"),
        CVE_YEAR_META_URL("https://nvd.nist.gov/feeds/json/cve/1.1/nvdcve-1.1-%d.meta");

        private final String defaultValue;

        private ResourceLocationNvd(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public String getDefault() {
            return this.defaultValue;
        }
    }
}

